// Code generated by running "go generate". DO NOT EDIT.

// Copyright 2017 The Wuffs Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package data

const BaseAllImplC = "" +
	"#ifndef WUFFS_INCLUDE_GUARD__BASE\n#define WUFFS_INCLUDE_GUARD__BASE\n\n#if defined(WUFFS_IMPLEMENTATION) && !defined(WUFFS_CONFIG__MODULES)\n#define WUFFS_CONFIG__MODULES\n#define WUFFS_CONFIG__MODULE__BASE\n#endif\n\n// !! WUFFS MONOLITHIC RELEASE DISCARDS EVERYTHING ABOVE.\n\n// !! INSERT base/copyright\n\n#include <stdbool.h>\n#include <stdint.h>\n#include <stdlib.h>\n#include <string.h>\n\n// Note that Clang also defines __GNUC__.\n#ifdef __cplusplus\n#if __cplusplus >= 201103L\n#include <memory>\n#elif defined(__GNUC__)\n#warning \"Wuffs' C++ code expects -std=c++11 or later\"\n#elif defined(_MSC_VER)\n#pragma message(\"Wuffs' C++ code expects C++11 or later\")\n#endif\n\nextern \"C\" {\n#endif\n\n// !! INSERT base/all-public.h.\n\n// !! INSERT InterfaceDeclarations.\n\n" +
	"" +
	"// ----------------\n\n#ifdef __cplusplus\n}  // extern \"C\"\n#endif\n\n// WUFFS C HEADER ENDS HERE.\n#ifdef WUFFS_IMPLEMENTATION\n\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n// !! INSERT base/all-private.h.\n\n" +
	"" +
	"// ----------------\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__BASE) || \\\n    defined(WUFFS_CONFIG__MODULE__BASE__CORE)\n\nconst uint8_t wuffs_base__low_bits_mask__u8[9] = {\n    0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF,\n};\n\nconst uint16_t wuffs_base__low_bits_mask__u16[17] = {\n    0x0000, 0x0001, 0x0003, 0x0007, 0x000F, 0x001F, 0x003F, 0x007F, 0x00FF,\n    0x01FF, 0x03FF, 0x07FF, 0x0FFF, 0x1FFF, 0x3FFF, 0x7FFF, 0xFFFF,\n};\n\nconst uint32_t wuffs_base__low_bits_mask__u32[33] = {\n    0x00000000, 0x00000001, 0x00000003, 0x00000007, 0x0000000F, 0x0000001F,\n    0x0000003F, 0x0000007F, 0x000000FF, 0x000001FF, 0x000003FF, 0x000007FF,\n    0x00000FFF, 0x00001FFF, 0x00003FFF, 0x00007FFF, 0x0000FFFF, 0x0001FFFF,\n    0x0003FFFF, 0x0007FFFF, 0x000FFFFF, 0x001FFFFF, 0x003FFFFF, 0x007FFFFF,\n    0x00FFFFFF, 0x01FFFFFF, 0x03FFFFFF, 0x07FFFFFF, 0x0FFFFFFF, 0x1FFFFFFF,\n    0x3FFFFFFF, 0x7FFFFFFF, 0xFFFFFFFF,\n};\n\nconst uint64_t wuffs_base__low_bits_mask__u64[65] = {\n    0x0000000000000000, 0x000" +
	"0000000000001, 0x0000000000000003,\n    0x0000000000000007, 0x000000000000000F, 0x000000000000001F,\n    0x000000000000003F, 0x000000000000007F, 0x00000000000000FF,\n    0x00000000000001FF, 0x00000000000003FF, 0x00000000000007FF,\n    0x0000000000000FFF, 0x0000000000001FFF, 0x0000000000003FFF,\n    0x0000000000007FFF, 0x000000000000FFFF, 0x000000000001FFFF,\n    0x000000000003FFFF, 0x000000000007FFFF, 0x00000000000FFFFF,\n    0x00000000001FFFFF, 0x00000000003FFFFF, 0x00000000007FFFFF,\n    0x0000000000FFFFFF, 0x0000000001FFFFFF, 0x0000000003FFFFFF,\n    0x0000000007FFFFFF, 0x000000000FFFFFFF, 0x000000001FFFFFFF,\n    0x000000003FFFFFFF, 0x000000007FFFFFFF, 0x00000000FFFFFFFF,\n    0x00000001FFFFFFFF, 0x00000003FFFFFFFF, 0x00000007FFFFFFFF,\n    0x0000000FFFFFFFFF, 0x0000001FFFFFFFFF, 0x0000003FFFFFFFFF,\n    0x0000007FFFFFFFFF, 0x000000FFFFFFFFFF, 0x000001FFFFFFFFFF,\n    0x000003FFFFFFFFFF, 0x000007FFFFFFFFFF, 0x00000FFFFFFFFFFF,\n    0x00001FFFFFFFFFFF, 0x00003FFFFFFFFFFF, 0x00007FFFFFFFFFFF,\n    0x0000FFFFFFFFFFFF, 0x000" +
	"1FFFFFFFFFFFF, 0x0003FFFFFFFFFFFF,\n    0x0007FFFFFFFFFFFF, 0x000FFFFFFFFFFFFF, 0x001FFFFFFFFFFFFF,\n    0x003FFFFFFFFFFFFF, 0x007FFFFFFFFFFFFF, 0x00FFFFFFFFFFFFFF,\n    0x01FFFFFFFFFFFFFF, 0x03FFFFFFFFFFFFFF, 0x07FFFFFFFFFFFFFF,\n    0x0FFFFFFFFFFFFFFF, 0x1FFFFFFFFFFFFFFF, 0x3FFFFFFFFFFFFFFF,\n    0x7FFFFFFFFFFFFFFF, 0xFFFFFFFFFFFFFFFF,\n};\n\nconst uint32_t wuffs_base__pixel_format__bits_per_channel[16] = {\n    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,\n    0x08, 0x0A, 0x0C, 0x10, 0x18, 0x20, 0x30, 0x40,\n};\n\n// !! INSERT wuffs_base__status strings.\n\n// !! INSERT vtable names.\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE)  ||\n        // defined(WUFFS_CONFIG__MODULE__BASE__CORE)\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__BASE) || \\\n    defined(WUFFS_CONFIG__MODULE__BASE__INTERFACES)\n\n// !! INSERT InterfaceDefinitions.\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE) ||\n        // defined(WUFFS_" +
	"CONFIG__MODULE__BASE__INTERFACES)\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__BASE) || \\\n    defined(WUFFS_CONFIG__MODULE__BASE__FLOATCONV)\n\n// !! INSERT base/floatconv-submodule.c.\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE__FLOATCONV)\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__BASE) || \\\n    defined(WUFFS_CONFIG__MODULE__BASE__INTCONV)\n\n// !! INSERT base/intconv-submodule.c.\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE__INTCONV)\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__BASE) || \\\n    defined(WUFFS_CONFIG__MODULE__BASE__PIXCONV)\n\n// !! INSERT base/pixconv-submodule.c.\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE__PIXCONV)\n\n#if !defined(W" +
	"UFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__BASE) || \\\n    defined(WUFFS_CONFIG__MODULE__BASE__UTF8)\n\n// !! INSERT base/utf8-submodule.c.\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE) ||\n        // defined(WUFFS_CONFIG__MODULE__BASE__UTF8)\n\n#ifdef __cplusplus\n}  // extern \"C\"\n#endif\n\n#endif  // WUFFS_IMPLEMENTATION\n\n// !! WUFFS MONOLITHIC RELEASE DISCARDS EVERYTHING BELOW.\n\n#endif  // WUFFS_INCLUDE_GUARD__BASE\n" +
	""

const BaseFundamentalPrivateH = "" +
	"// ---------------- Fundamentals\n\n// WUFFS_BASE__MAGIC is a magic number to check that initializers are called.\n// It's not foolproof, given C doesn't automatically zero memory before use,\n// but it should catch 99.99% of cases.\n//\n// Its (non-zero) value is arbitrary, based on md5sum(\"wuffs\").\n#define WUFFS_BASE__MAGIC ((uint32_t)0x3CCB6C71)\n\n// WUFFS_BASE__DISABLED is a magic number to indicate that a non-recoverable\n// error was previously encountered.\n//\n// Its (non-zero) value is arbitrary, based on md5sum(\"disabled\").\n#define WUFFS_BASE__DISABLED ((uint32_t)0x075AE3D2)\n\n// Denote intentional fallthroughs for -Wimplicit-fallthrough.\n//\n// The order matters here. Clang also defines \"__GNUC__\".\n#if defined(__clang__) && defined(__cplusplus) && (__cplusplus >= 201103L)\n#define WUFFS_BASE__FALLTHROUGH [[clang::fallthrough]]\n#elif !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 7)\n#define WUFFS_BASE__FALLTHROUGH __attribute__((fallthrough))\n#else\n#define WUFFS_BASE__FALLTHROUGH\n#endif\n\n// Use switch " +
	"cases for coroutine suspension points, similar to the technique\n// in https://www.chiark.greenend.org.uk/~sgtatham/coroutines.html\n//\n// We use trivial macros instead of an explicit assignment and case statement\n// so that clang-format doesn't get confused by the unusual \"case\"s.\n#define WUFFS_BASE__COROUTINE_SUSPENSION_POINT_0 case 0:;\n#define WUFFS_BASE__COROUTINE_SUSPENSION_POINT(n) \\\n  coro_susp_point = n;                            \\\n  WUFFS_BASE__FALLTHROUGH;                        \\\n  case n:;\n\n#define WUFFS_BASE__COROUTINE_SUSPENSION_POINT_MAYBE_SUSPEND(n) \\\n  if (!status.repr) {                                           \\\n    goto ok;                                                    \\\n  } else if (*status.repr != '$') {                             \\\n    goto exit;                                                  \\\n  }                                                             \\\n  coro_susp_point = n;                                          \\\n  goto suspend;                                        " +
	"         \\\n  case n:;\n\n// Clang also defines \"__GNUC__\".\n#if defined(__GNUC__)\n#define WUFFS_BASE__LIKELY(expr) (__builtin_expect(!!(expr), 1))\n#define WUFFS_BASE__UNLIKELY(expr) (__builtin_expect(!!(expr), 0))\n#else\n#define WUFFS_BASE__LIKELY(expr) (expr)\n#define WUFFS_BASE__UNLIKELY(expr) (expr)\n#endif\n\n" +
	"" +
	"// --------\n\nstatic inline wuffs_base__empty_struct  //\nwuffs_base__ignore_status(wuffs_base__status z) {\n  return wuffs_base__make_empty_struct();\n}\n\nstatic inline wuffs_base__status  //\nwuffs_base__status__ensure_not_a_suspension(wuffs_base__status z) {\n  if (z.repr && (*z.repr == '$')) {\n    z.repr = wuffs_base__error__cannot_return_a_suspension;\n  }\n  return z;\n}\n\n" +
	"" +
	"// ---------------- Numeric Types\n\nextern const uint8_t wuffs_base__low_bits_mask__u8[9];\nextern const uint16_t wuffs_base__low_bits_mask__u16[17];\nextern const uint32_t wuffs_base__low_bits_mask__u32[33];\nextern const uint64_t wuffs_base__low_bits_mask__u64[65];\n\n#define WUFFS_BASE__LOW_BITS_MASK__U8(n) (wuffs_base__low_bits_mask__u8[n])\n#define WUFFS_BASE__LOW_BITS_MASK__U16(n) (wuffs_base__low_bits_mask__u16[n])\n#define WUFFS_BASE__LOW_BITS_MASK__U32(n) (wuffs_base__low_bits_mask__u32[n])\n#define WUFFS_BASE__LOW_BITS_MASK__U64(n) (wuffs_base__low_bits_mask__u64[n])\n\n" +
	"" +
	"// --------\n\nstatic inline void  //\nwuffs_base__u8__sat_add_indirect(uint8_t* x, uint8_t y) {\n  *x = wuffs_base__u8__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u8__sat_sub_indirect(uint8_t* x, uint8_t y) {\n  *x = wuffs_base__u8__sat_sub(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u16__sat_add_indirect(uint16_t* x, uint16_t y) {\n  *x = wuffs_base__u16__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u16__sat_sub_indirect(uint16_t* x, uint16_t y) {\n  *x = wuffs_base__u16__sat_sub(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u32__sat_add_indirect(uint32_t* x, uint32_t y) {\n  *x = wuffs_base__u32__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u32__sat_sub_indirect(uint32_t* x, uint32_t y) {\n  *x = wuffs_base__u32__sat_sub(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u64__sat_add_indirect(uint64_t* x, uint64_t y) {\n  *x = wuffs_base__u64__sat_add(*x, y);\n}\n\nstatic inline void  //\nwuffs_base__u64__sat_sub_indirect(uint64_t* x, uint64_t y) {\n  *x = wuffs_base__u64__sat_sub(*x, y);\n}\n\n" +
	"" +
	"// ---------------- Slices and Tables\n\n// wuffs_base__slice_u8__prefix returns up to the first up_to bytes of s.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__prefix(wuffs_base__slice_u8 s, uint64_t up_to) {\n  if ((uint64_t)(s.len) > up_to) {\n    s.len = up_to;\n  }\n  return s;\n}\n\n// wuffs_base__slice_u8__suffix returns up to the last up_to bytes of s.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__suffix(wuffs_base__slice_u8 s, uint64_t up_to) {\n  if ((uint64_t)(s.len) > up_to) {\n    s.ptr += (uint64_t)(s.len) - up_to;\n    s.len = up_to;\n  }\n  return s;\n}\n\n// wuffs_base__slice_u8__copy_from_slice calls memmove(dst.ptr, src.ptr, len)\n// where len is the minimum of dst.len and src.len.\n//\n// Passing a wuffs_base__slice_u8 with all fields NULL or zero (a valid, empty\n// slice) is valid and results in a no-op.\nstatic inline uint64_t  //\nwuffs_base__slice_u8__copy_from_slice(wuffs_base__slice_u8 dst,\n                                      wuffs_base__slice_u8 src) {\n  size_t len = dst.l" +
	"en < src.len ? dst.len : src.len;\n  if (len > 0) {\n    memmove(dst.ptr, src.ptr, len);\n  }\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__table_u8__row(wuffs_base__table_u8 t, uint32_t y) {\n  if (y < t.height) {\n    return wuffs_base__make_slice_u8(t.ptr + (t.stride * y), t.width);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\n" +
	"" +
	"// ---------------- Slices and Tables (Utility)\n\n#define wuffs_base__utility__empty_slice_u8 wuffs_base__empty_slice_u8\n" +
	""

const BaseFundamentalPublicH = "" +
	"// ---------------- Fundamentals\n\n// WUFFS_VERSION is the major.minor.patch version, as per https://semver.org/,\n// as a uint64_t. The major number is the high 32 bits. The minor number is the\n// middle 16 bits. The patch number is the low 16 bits. The pre-release label\n// and build metadata are part of the string representation (such as\n// \"1.2.3-beta+456.20181231\") but not the uint64_t representation.\n//\n// WUFFS_VERSION_PRE_RELEASE_LABEL (such as \"\", \"beta\" or \"rc.1\") being\n// non-empty denotes a developer preview, not a release version, and has no\n// backwards or forwards compatibility guarantees.\n//\n// WUFFS_VERSION_BUILD_METADATA_XXX, if non-zero, are the number of commits and\n// the last commit date in the repository used to build this library. Within\n// each major.minor branch, the commit count should increase monotonically.\n//\n// !! Some code generation programs can override WUFFS_VERSION.\n#define WUFFS_VERSION 0\n#define WUFFS_VERSION_MAJOR 0\n#define WUFFS_VERSION_MINOR 0\n#define WUFFS_VERSION_PATCH " +
	"0\n#define WUFFS_VERSION_PRE_RELEASE_LABEL \"work.in.progress\"\n#define WUFFS_VERSION_BUILD_METADATA_COMMIT_COUNT 0\n#define WUFFS_VERSION_BUILD_METADATA_COMMIT_DATE 0\n#define WUFFS_VERSION_STRING \"0.0.0+0.00000000\"\n\n// Define WUFFS_CONFIG__STATIC_FUNCTIONS to make all of Wuffs' functions have\n// static storage. The motivation is discussed in the \"ALLOW STATIC\n// IMPLEMENTATION\" section of\n// https://raw.githubusercontent.com/nothings/stb/master/docs/stb_howto.txt\n#ifdef WUFFS_CONFIG__STATIC_FUNCTIONS\n#define WUFFS_BASE__MAYBE_STATIC static\n#else\n#define WUFFS_BASE__MAYBE_STATIC\n#endif\n\n" +
	"" +
	"// --------\n\n// Wuffs assumes that:\n//  - converting a uint32_t to a size_t will never overflow.\n//  - converting a size_t to a uint64_t will never overflow.\n#ifdef __WORDSIZE\n#if (__WORDSIZE != 32) && (__WORDSIZE != 64)\n#error \"Wuffs requires a word size of either 32 or 64 bits\"\n#endif\n#endif\n\n#if defined(__clang__)\n#define WUFFS_BASE__POTENTIALLY_UNUSED_FIELD __attribute__((unused))\n#else\n#define WUFFS_BASE__POTENTIALLY_UNUSED_FIELD\n#endif\n\n// Clang also defines \"__GNUC__\".\n#if defined(__GNUC__)\n#define WUFFS_BASE__POTENTIALLY_UNUSED __attribute__((unused))\n#define WUFFS_BASE__WARN_UNUSED_RESULT __attribute__((warn_unused_result))\n#else\n#define WUFFS_BASE__POTENTIALLY_UNUSED\n#define WUFFS_BASE__WARN_UNUSED_RESULT\n#endif\n\n" +
	"" +
	"// --------\n\n// Options (bitwise or'ed together) for wuffs_foo__bar__initialize functions.\n\n#define WUFFS_INITIALIZE__DEFAULT_OPTIONS ((uint32_t)0x00000000)\n\n// WUFFS_INITIALIZE__ALREADY_ZEROED means that the \"self\" receiver struct value\n// has already been set to all zeroes.\n#define WUFFS_INITIALIZE__ALREADY_ZEROED ((uint32_t)0x00000001)\n\n// WUFFS_INITIALIZE__LEAVE_INTERNAL_BUFFERS_UNINITIALIZED means that, absent\n// WUFFS_INITIALIZE__ALREADY_ZEROED, only some of the \"self\" receiver struct\n// value will be set to all zeroes. Internal buffers, which tend to be a large\n// proportion of the struct's size, will be left uninitialized. Internal means\n// that the buffer is contained by the receiver struct, as opposed to being\n// passed as a separately allocated \"work buffer\".\n//\n// For more detail, see:\n// https://github.com/google/wuffs/blob/master/doc/note/initialization.md\n#define WUFFS_INITIALIZE__LEAVE_INTERNAL_BUFFERS_UNINITIALIZED \\\n  ((uint32_t)0x00000002)\n\n" +
	"" +
	"// --------\n\n// wuffs_base__empty_struct is used when a Wuffs function returns an empty\n// struct. In C, if a function f returns void, you can't say \"x = f()\", but in\n// Wuffs, if a function g returns empty, you can say \"y = g()\".\ntypedef struct {\n  // private_impl is a placeholder field. It isn't explicitly used, except that\n  // without it, the sizeof a struct with no fields can differ across C/C++\n  // compilers, and it is undefined behavior in C99. For example, gcc says that\n  // the sizeof an empty struct is 0, and g++ says that it is 1. This leads to\n  // ABI incompatibility if a Wuffs .c file is processed by one compiler and\n  // its .h file with another compiler.\n  //\n  // Instead, we explicitly insert an otherwise unused field, so that the\n  // sizeof this struct is always 1.\n  uint8_t private_impl;\n} wuffs_base__empty_struct;\n\nstatic inline wuffs_base__empty_struct  //\nwuffs_base__make_empty_struct() {\n  wuffs_base__empty_struct ret;\n  ret.private_impl = 0;\n  return ret;\n}\n\n// wuffs_base__utility is" +
	" a placeholder receiver type. It enables what Java\n// calls static methods, as opposed to regular methods.\ntypedef struct {\n  // private_impl is a placeholder field. It isn't explicitly used, except that\n  // without it, the sizeof a struct with no fields can differ across C/C++\n  // compilers, and it is undefined behavior in C99. For example, gcc says that\n  // the sizeof an empty struct is 0, and g++ says that it is 1. This leads to\n  // ABI incompatibility if a Wuffs .c file is processed by one compiler and\n  // its .h file with another compiler.\n  //\n  // Instead, we explicitly insert an otherwise unused field, so that the\n  // sizeof this struct is always 1.\n  uint8_t private_impl;\n} wuffs_base__utility;\n\ntypedef struct {\n  const char* vtable_name;\n  const void* function_pointers;\n} wuffs_base__vtable;\n\n" +
	"" +
	"// --------\n\n// See https://github.com/google/wuffs/blob/master/doc/note/statuses.md\ntypedef struct {\n  const char* repr;\n\n#ifdef __cplusplus\n  inline bool is_complete() const;\n  inline bool is_error() const;\n  inline bool is_note() const;\n  inline bool is_ok() const;\n  inline bool is_suspension() const;\n  inline const char* message() const;\n#endif  // __cplusplus\n\n} wuffs_base__status;\n\n// !! INSERT wuffs_base__status names.\n\nstatic inline wuffs_base__status  //\nwuffs_base__make_status(const char* repr) {\n  wuffs_base__status z;\n  z.repr = repr;\n  return z;\n}\n\nstatic inline bool  //\nwuffs_base__status__is_complete(const wuffs_base__status* z) {\n  return (z->repr == NULL) || ((*z->repr != '$') && (*z->repr != '#'));\n}\n\nstatic inline bool  //\nwuffs_base__status__is_error(const wuffs_base__status* z) {\n  return z->repr && (*z->repr == '#');\n}\n\nstatic inline bool  //\nwuffs_base__status__is_note(const wuffs_base__status* z) {\n  return z->repr && (*z->repr != '$') && (*z->repr != '#');\n}\n\nstatic inline bool  //\nwu" +
	"ffs_base__status__is_ok(const wuffs_base__status* z) {\n  return z->repr == NULL;\n}\n\nstatic inline bool  //\nwuffs_base__status__is_suspension(const wuffs_base__status* z) {\n  return z->repr && (*z->repr == '$');\n}\n\n// wuffs_base__status__message strips the leading '$', '#' or '@'.\nstatic inline const char*  //\nwuffs_base__status__message(const wuffs_base__status* z) {\n  if (z->repr) {\n    if ((*z->repr == '$') || (*z->repr == '#') || (*z->repr == '@')) {\n      return z->repr + 1;\n    }\n  }\n  return z->repr;\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__status::is_complete() const {\n  return wuffs_base__status__is_complete(this);\n}\n\ninline bool  //\nwuffs_base__status::is_error() const {\n  return wuffs_base__status__is_error(this);\n}\n\ninline bool  //\nwuffs_base__status::is_note() const {\n  return wuffs_base__status__is_note(this);\n}\n\ninline bool  //\nwuffs_base__status::is_ok() const {\n  return wuffs_base__status__is_ok(this);\n}\n\ninline bool  //\nwuffs_base__status::is_suspension() const {\n  return wuffs_base" +
	"__status__is_suspension(this);\n}\n\ninline const char*  //\nwuffs_base__status::message() const {\n  return wuffs_base__status__message(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\n// WUFFS_BASE__RESULT is a result type: either a status (an error) or a value.\n//\n// A result with all fields NULL or zero is as valid as a zero-valued T.\n#define WUFFS_BASE__RESULT(T)  \\\n  struct {                     \\\n    wuffs_base__status status; \\\n    T value;                   \\\n  }\n\ntypedef WUFFS_BASE__RESULT(double) wuffs_base__result_f64;\ntypedef WUFFS_BASE__RESULT(int64_t) wuffs_base__result_i64;\ntypedef WUFFS_BASE__RESULT(uint64_t) wuffs_base__result_u64;\n\n" +
	"" +
	"// --------\n\n// wuffs_base__transform__output is the result of transforming from a src slice\n// to a dst slice.\ntypedef struct {\n  wuffs_base__status status;\n  size_t num_dst;\n  size_t num_src;\n} wuffs_base__transform__output;\n\n" +
	"" +
	"// --------\n\n// FourCC constants.\n\n// !! INSERT FourCCs.\n\n" +
	"" +
	"// --------\n\n// Flicks are a unit of time. One flick (frame-tick) is 1 / 705_600_000 of a\n// second. See https://github.com/OculusVR/Flicks\ntypedef int64_t wuffs_base__flicks;\n\n#define WUFFS_BASE__FLICKS_PER_SECOND ((uint64_t)705600000)\n#define WUFFS_BASE__FLICKS_PER_MILLISECOND ((uint64_t)705600)\n\n" +
	"" +
	"// ---------------- Numeric Types\n\n// The helpers below are functions, instead of macros, because their arguments\n// can be an expression that we shouldn't evaluate more than once.\n//\n// They are static, so that linking multiple wuffs .o files won't complain about\n// duplicate function definitions.\n//\n// They are explicitly marked inline, even if modern compilers don't use the\n// inline attribute to guide optimizations such as inlining, to avoid the\n// -Wunused-function warning, and we like to compile with -Wall -Werror.\n\nstatic inline int8_t  //\nwuffs_base__i8__min(int8_t x, int8_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline int8_t  //\nwuffs_base__i8__max(int8_t x, int8_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline int16_t  //\nwuffs_base__i16__min(int16_t x, int16_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline int16_t  //\nwuffs_base__i16__max(int16_t x, int16_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline int32_t  //\nwuffs_base__i32__min(int32_t x, int32_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline " +
	"int32_t  //\nwuffs_base__i32__max(int32_t x, int32_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline int64_t  //\nwuffs_base__i64__min(int64_t x, int64_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline int64_t  //\nwuffs_base__i64__max(int64_t x, int64_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline uint8_t  //\nwuffs_base__u8__min(uint8_t x, uint8_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint8_t  //\nwuffs_base__u8__max(uint8_t x, uint8_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__min(uint16_t x, uint16_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__max(uint16_t x, uint16_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__min(uint32_t x, uint32_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__max(uint32_t x, uint32_t y) {\n  return x > y ? x : y;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__min(uint64_t x, uint64_t y) {\n  return x < y ? x : y;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__m" +
	"ax(uint64_t x, uint64_t y) {\n  return x > y ? x : y;\n}\n\n" +
	"" +
	"// --------\n\n// Saturating arithmetic (sat_add, sat_sub) branchless bit-twiddling algorithms\n// are per https://locklessinc.com/articles/sat_arithmetic/\n//\n// It is important that the underlying types are unsigned integers, as signed\n// integer arithmetic overflow is undefined behavior in C.\n\nstatic inline uint8_t  //\nwuffs_base__u8__sat_add(uint8_t x, uint8_t y) {\n  uint8_t res = (uint8_t)(x + y);\n  res |= (uint8_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint8_t  //\nwuffs_base__u8__sat_sub(uint8_t x, uint8_t y) {\n  uint8_t res = (uint8_t)(x - y);\n  res &= (uint8_t)(-(res <= x));\n  return res;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__sat_add(uint16_t x, uint16_t y) {\n  uint16_t res = (uint16_t)(x + y);\n  res |= (uint16_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint16_t  //\nwuffs_base__u16__sat_sub(uint16_t x, uint16_t y) {\n  uint16_t res = (uint16_t)(x - y);\n  res &= (uint16_t)(-(res <= x));\n  return res;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__sat_add(uint32_t x, uint32_t y) {\n  uint32" +
	"_t res = (uint32_t)(x + y);\n  res |= (uint32_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint32_t  //\nwuffs_base__u32__sat_sub(uint32_t x, uint32_t y) {\n  uint32_t res = (uint32_t)(x - y);\n  res &= (uint32_t)(-(res <= x));\n  return res;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__sat_add(uint64_t x, uint64_t y) {\n  uint64_t res = (uint64_t)(x + y);\n  res |= (uint64_t)(-(res < x));\n  return res;\n}\n\nstatic inline uint64_t  //\nwuffs_base__u64__sat_sub(uint64_t x, uint64_t y) {\n  uint64_t res = (uint64_t)(x - y);\n  res &= (uint64_t)(-(res <= x));\n  return res;\n}\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  uint64_t lo;\n  uint64_t hi;\n} wuffs_base__multiply_u64__output;\n\n// wuffs_base__multiply_u64 returns x*y as a 128-bit value.\n//\n// The maximum inclusive output hi_lo is 0xFFFFFFFFFFFFFFFE_0000000000000001.\nstatic inline wuffs_base__multiply_u64__output  //\nwuffs_base__multiply_u64(uint64_t x, uint64_t y) {\n#if defined(__SIZEOF_INT128__)\n  __uint128_t z = ((__uint128_t)x) * ((__uint128_t)y);\n  wuffs_base__multiply_u64__output o;\n  o.lo = ((uint64_t)(z));\n  o.hi = ((uint64_t)(z >> 64));\n  return o;\n#else\n  uint64_t x0 = x & 0xFFFFFFFF;\n  uint64_t x1 = x >> 32;\n  uint64_t y0 = y & 0xFFFFFFFF;\n  uint64_t y1 = y >> 32;\n  uint64_t w0 = x0 * y0;\n  uint64_t t = (x1 * y0) + (w0 >> 32);\n  uint64_t w1 = t & 0xFFFFFFFF;\n  uint64_t w2 = t >> 32;\n  w1 += x0 * y1;\n  wuffs_base__multiply_u64__output o;\n  o.lo = x * y;\n  o.hi = (x1 * y1) + w2 + (w1 >> 32);\n  return o;\n#endif\n}\n\n" +
	"" +
	"// --------\n\n#if defined(__GNUC__) && (__SIZEOF_LONG__ == 8)\n\nstatic inline uint32_t  //\nwuffs_base__count_leading_zeroes_u64(uint64_t u) {\n  return u ? ((uint32_t)(__builtin_clzl(u))) : 64u;\n}\n\n#else\n\nstatic inline uint32_t  //\nwuffs_base__count_leading_zeroes_u64(uint64_t u) {\n  if (u == 0) {\n    return 64;\n  }\n\n  uint32_t n = 0;\n  if ((u >> 32) == 0) {\n    n |= 32;\n    u <<= 32;\n  }\n  if ((u >> 48) == 0) {\n    n |= 16;\n    u <<= 16;\n  }\n  if ((u >> 56) == 0) {\n    n |= 8;\n    u <<= 8;\n  }\n  if ((u >> 60) == 0) {\n    n |= 4;\n    u <<= 4;\n  }\n  if ((u >> 62) == 0) {\n    n |= 2;\n    u <<= 2;\n  }\n  if ((u >> 63) == 0) {\n    n |= 1;\n    u <<= 1;\n  }\n  return n;\n}\n\n#endif  // defined(__GNUC__) && (__SIZEOF_LONG__ == 8)\n\n" +
	"" +
	"// --------\n\n#define wuffs_base__load_u8be__no_bounds_check \\\n  wuffs_base__load_u8__no_bounds_check\n#define wuffs_base__load_u8le__no_bounds_check \\\n  wuffs_base__load_u8__no_bounds_check\n\nstatic inline uint8_t  //\nwuffs_base__load_u8__no_bounds_check(const uint8_t* p) {\n  return p[0];\n}\n\nstatic inline uint16_t  //\nwuffs_base__load_u16be__no_bounds_check(const uint8_t* p) {\n  return (uint16_t)(((uint16_t)(p[0]) << 8) | ((uint16_t)(p[1]) << 0));\n}\n\nstatic inline uint16_t  //\nwuffs_base__load_u16le__no_bounds_check(const uint8_t* p) {\n  return (uint16_t)(((uint16_t)(p[0]) << 0) | ((uint16_t)(p[1]) << 8));\n}\n\nstatic inline uint32_t  //\nwuffs_base__load_u24be__no_bounds_check(const uint8_t* p) {\n  return ((uint32_t)(p[0]) << 16) | ((uint32_t)(p[1]) << 8) |\n         ((uint32_t)(p[2]) << 0);\n}\n\nstatic inline uint32_t  //\nwuffs_base__load_u24le__no_bounds_check(const uint8_t* p) {\n  return ((uint32_t)(p[0]) << 0) | ((uint32_t)(p[1]) << 8) |\n         ((uint32_t)(p[2]) << 16);\n}\n\nstatic inline uint32_t  //\nwuffs_base" +
	"__load_u32be__no_bounds_check(const uint8_t* p) {\n  return ((uint32_t)(p[0]) << 24) | ((uint32_t)(p[1]) << 16) |\n         ((uint32_t)(p[2]) << 8) | ((uint32_t)(p[3]) << 0);\n}\n\nstatic inline uint32_t  //\nwuffs_base__load_u32le__no_bounds_check(const uint8_t* p) {\n  return ((uint32_t)(p[0]) << 0) | ((uint32_t)(p[1]) << 8) |\n         ((uint32_t)(p[2]) << 16) | ((uint32_t)(p[3]) << 24);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u40be__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 32) | ((uint64_t)(p[1]) << 24) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 8) |\n         ((uint64_t)(p[4]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u40le__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u48be__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 40) | ((uint64_t)(p[" +
	"1]) << 32) |\n         ((uint64_t)(p[2]) << 24) | ((uint64_t)(p[3]) << 16) |\n         ((uint64_t)(p[4]) << 8) | ((uint64_t)(p[5]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u48le__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32) | ((uint64_t)(p[5]) << 40);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u56be__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 48) | ((uint64_t)(p[1]) << 40) |\n         ((uint64_t)(p[2]) << 32) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 16) | ((uint64_t)(p[5]) << 8) |\n         ((uint64_t)(p[6]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u56le__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32) | ((uint64_t)(p[5]) << 40) |\n         ((uint64_t)(p[" +
	"6]) << 48);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u64be__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 56) | ((uint64_t)(p[1]) << 48) |\n         ((uint64_t)(p[2]) << 40) | ((uint64_t)(p[3]) << 32) |\n         ((uint64_t)(p[4]) << 24) | ((uint64_t)(p[5]) << 16) |\n         ((uint64_t)(p[6]) << 8) | ((uint64_t)(p[7]) << 0);\n}\n\nstatic inline uint64_t  //\nwuffs_base__load_u64le__no_bounds_check(const uint8_t* p) {\n  return ((uint64_t)(p[0]) << 0) | ((uint64_t)(p[1]) << 8) |\n         ((uint64_t)(p[2]) << 16) | ((uint64_t)(p[3]) << 24) |\n         ((uint64_t)(p[4]) << 32) | ((uint64_t)(p[5]) << 40) |\n         ((uint64_t)(p[6]) << 48) | ((uint64_t)(p[7]) << 56);\n}\n\n" +
	"" +
	"// --------\n\n#define wuffs_base__store_u8be__no_bounds_check \\\n  wuffs_base__store_u8__no_bounds_check\n#define wuffs_base__store_u8le__no_bounds_check \\\n  wuffs_base__store_u8__no_bounds_check\n\nstatic inline void  //\nwuffs_base__store_u8__no_bounds_check(uint8_t* p, uint8_t x) {\n  p[0] = x;\n}\n\nstatic inline void  //\nwuffs_base__store_u16be__no_bounds_check(uint8_t* p, uint16_t x) {\n  p[0] = (uint8_t)(x >> 8);\n  p[1] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u16le__no_bounds_check(uint8_t* p, uint16_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n}\n\nstatic inline void  //\nwuffs_base__store_u24be__no_bounds_check(uint8_t* p, uint32_t x) {\n  p[0] = (uint8_t)(x >> 16);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u24le__no_bounds_check(uint8_t* p, uint32_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n}\n\nstatic inline void  //\nwuffs_base__store_u32be__no_bounds_check(uint8_t* p," +
	" uint32_t x) {\n  p[0] = (uint8_t)(x >> 24);\n  p[1] = (uint8_t)(x >> 16);\n  p[2] = (uint8_t)(x >> 8);\n  p[3] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u32le__no_bounds_check(uint8_t* p, uint32_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n}\n\nstatic inline void  //\nwuffs_base__store_u40be__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 32);\n  p[1] = (uint8_t)(x >> 24);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 8);\n  p[4] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u40le__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32);\n}\n\nstatic inline void  //\nwuffs_base__store_u48be__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 40);\n  p[1] = (uint8_t)(x >> 32);\n  p[2] = (uint8_t)(x >> 24);\n  p[3] = (uint8_t)(x >> 16);\n  p[4] " +
	"= (uint8_t)(x >> 8);\n  p[5] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u48le__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32);\n  p[5] = (uint8_t)(x >> 40);\n}\n\nstatic inline void  //\nwuffs_base__store_u56be__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 48);\n  p[1] = (uint8_t)(x >> 40);\n  p[2] = (uint8_t)(x >> 32);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 16);\n  p[5] = (uint8_t)(x >> 8);\n  p[6] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u56le__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32);\n  p[5] = (uint8_t)(x >> 40);\n  p[6] = (uint8_t)(x >> 48);\n}\n\nstatic inline void  //\nwuffs_base__store_u64be__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 56);\n" +
	"  p[1] = (uint8_t)(x >> 48);\n  p[2] = (uint8_t)(x >> 40);\n  p[3] = (uint8_t)(x >> 32);\n  p[4] = (uint8_t)(x >> 24);\n  p[5] = (uint8_t)(x >> 16);\n  p[6] = (uint8_t)(x >> 8);\n  p[7] = (uint8_t)(x >> 0);\n}\n\nstatic inline void  //\nwuffs_base__store_u64le__no_bounds_check(uint8_t* p, uint64_t x) {\n  p[0] = (uint8_t)(x >> 0);\n  p[1] = (uint8_t)(x >> 8);\n  p[2] = (uint8_t)(x >> 16);\n  p[3] = (uint8_t)(x >> 24);\n  p[4] = (uint8_t)(x >> 32);\n  p[5] = (uint8_t)(x >> 40);\n  p[6] = (uint8_t)(x >> 48);\n  p[7] = (uint8_t)(x >> 56);\n}\n\n" +
	"" +
	"// ---------------- Slices and Tables\n\n// WUFFS_BASE__SLICE is a 1-dimensional buffer.\n//\n// len measures a number of elements, not necessarily a size in bytes.\n//\n// A value with all fields NULL or zero is a valid, empty slice.\n#define WUFFS_BASE__SLICE(T) \\\n  struct {                   \\\n    T* ptr;                  \\\n    size_t len;              \\\n  }\n\n// WUFFS_BASE__TABLE is a 2-dimensional buffer.\n//\n// width height, and stride measure a number of elements, not necessarily a\n// size in bytes.\n//\n// A value with all fields NULL or zero is a valid, empty table.\n#define WUFFS_BASE__TABLE(T) \\\n  struct {                   \\\n    T* ptr;                  \\\n    size_t width;            \\\n    size_t height;           \\\n    size_t stride;           \\\n  }\n\ntypedef WUFFS_BASE__SLICE(uint8_t) wuffs_base__slice_u8;\ntypedef WUFFS_BASE__SLICE(uint16_t) wuffs_base__slice_u16;\ntypedef WUFFS_BASE__SLICE(uint32_t) wuffs_base__slice_u32;\ntypedef WUFFS_BASE__SLICE(uint64_t) wuffs_base__slice_u64;\n\ntypedef WUFFS_BASE__TABLE(u" +
	"int8_t) wuffs_base__table_u8;\ntypedef WUFFS_BASE__TABLE(uint16_t) wuffs_base__table_u16;\ntypedef WUFFS_BASE__TABLE(uint32_t) wuffs_base__table_u32;\ntypedef WUFFS_BASE__TABLE(uint64_t) wuffs_base__table_u64;\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__make_slice_u8(uint8_t* ptr, size_t len) {\n  wuffs_base__slice_u8 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u16  //\nwuffs_base__make_slice_u16(uint16_t* ptr, size_t len) {\n  wuffs_base__slice_u16 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u32  //\nwuffs_base__make_slice_u32(uint32_t* ptr, size_t len) {\n  wuffs_base__slice_u32 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u64  //\nwuffs_base__make_slice_u64(uint64_t* ptr, size_t len) {\n  wuffs_base__slice_u64 ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__empty_slice_u8() {\n  wuffs_base__slice_u8 ret;\n  ret.ptr = NULL;\n" +
	"  ret.len = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u16  //\nwuffs_base__empty_slice_u16() {\n  wuffs_base__slice_u16 ret;\n  ret.ptr = NULL;\n  ret.len = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u32  //\nwuffs_base__empty_slice_u32() {\n  wuffs_base__slice_u32 ret;\n  ret.ptr = NULL;\n  ret.len = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_u64  //\nwuffs_base__empty_slice_u64() {\n  wuffs_base__slice_u64 ret;\n  ret.ptr = NULL;\n  ret.len = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__table_u8  //\nwuffs_base__empty_table_u8() {\n  wuffs_base__table_u8 ret;\n  ret.ptr = NULL;\n  ret.width = 0;\n  ret.height = 0;\n  ret.stride = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__table_u16  //\nwuffs_base__empty_table_u16() {\n  wuffs_base__table_u16 ret;\n  ret.ptr = NULL;\n  ret.width = 0;\n  ret.height = 0;\n  ret.stride = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__table_u32  //\nwuffs_base__empty_table_u32() {\n  wuffs_base__table_u32 ret;\n  ret.ptr = NULL;\n  ret.width = 0;\n  ret.height = 0;\n  ret.stri" +
	"de = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__table_u64  //\nwuffs_base__empty_table_u64() {\n  wuffs_base__table_u64 ret;\n  ret.ptr = NULL;\n  ret.width = 0;\n  ret.height = 0;\n  ret.stride = 0;\n  return ret;\n}\n\n// wuffs_base__slice_u8__subslice_i returns s[i:].\n//\n// It returns an empty slice if i is out of bounds.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__subslice_i(wuffs_base__slice_u8 s, uint64_t i) {\n  if ((i <= SIZE_MAX) && (i <= s.len)) {\n    return wuffs_base__make_slice_u8(s.ptr + i, s.len - i);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\n// wuffs_base__slice_u8__subslice_j returns s[:j].\n//\n// It returns an empty slice if j is out of bounds.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__subslice_j(wuffs_base__slice_u8 s, uint64_t j) {\n  if ((j <= SIZE_MAX) && (j <= s.len)) {\n    return wuffs_base__make_slice_u8(s.ptr, j);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\n// wuffs_base__slice_u8__subslice_ij returns s[i:j].\n//\n// It returns an empty slice" +
	" if i or j is out of bounds.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__slice_u8__subslice_ij(wuffs_base__slice_u8 s,\n                                  uint64_t i,\n                                  uint64_t j) {\n  if ((i <= j) && (j <= SIZE_MAX) && (j <= s.len)) {\n    return wuffs_base__make_slice_u8(s.ptr + i, j - i);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n" +
	""

const BaseMemoryPrivateH = "" +
	"// ---------------- Memory Allocation\n" +
	""

const BaseMemoryPublicH = "" +
	"// ---------------- Memory Allocation\n\n// The memory allocation related functions in this section aren't used by Wuffs\n// per se, but they may be helpful to the code that uses Wuffs.\n\n// wuffs_base__malloc_slice_uxx wraps calling a malloc-like function, except\n// that it takes a uint64_t number of elements instead of a size_t size in\n// bytes, and it returns a slice (a pointer and a length) instead of just a\n// pointer.\n//\n// You can pass the C stdlib's malloc as the malloc_func.\n//\n// It returns an empty slice (containing a NULL ptr field) if (num_uxx *\n// sizeof(uintxx_t)) would overflow SIZE_MAX.\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__malloc_slice_u8(void* (*malloc_func)(size_t), uint64_t num_u8) {\n  if (malloc_func && (num_u8 <= (SIZE_MAX / sizeof(uint8_t)))) {\n    void* p = (*malloc_func)(num_u8 * sizeof(uint8_t));\n    if (p) {\n      return wuffs_base__make_slice_u8((uint8_t*)(p), num_u8);\n    }\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\nstatic inline wuffs_base__slice_u16  //\nwuffs" +
	"_base__malloc_slice_u16(void* (*malloc_func)(size_t), uint64_t num_u16) {\n  if (malloc_func && (num_u16 <= (SIZE_MAX / sizeof(uint16_t)))) {\n    void* p = (*malloc_func)(num_u16 * sizeof(uint16_t));\n    if (p) {\n      return wuffs_base__make_slice_u16((uint16_t*)(p), num_u16);\n    }\n  }\n  return wuffs_base__make_slice_u16(NULL, 0);\n}\n\nstatic inline wuffs_base__slice_u32  //\nwuffs_base__malloc_slice_u32(void* (*malloc_func)(size_t), uint64_t num_u32) {\n  if (malloc_func && (num_u32 <= (SIZE_MAX / sizeof(uint32_t)))) {\n    void* p = (*malloc_func)(num_u32 * sizeof(uint32_t));\n    if (p) {\n      return wuffs_base__make_slice_u32((uint32_t*)(p), num_u32);\n    }\n  }\n  return wuffs_base__make_slice_u32(NULL, 0);\n}\n\nstatic inline wuffs_base__slice_u64  //\nwuffs_base__malloc_slice_u64(void* (*malloc_func)(size_t), uint64_t num_u64) {\n  if (malloc_func && (num_u64 <= (SIZE_MAX / sizeof(uint64_t)))) {\n    void* p = (*malloc_func)(num_u64 * sizeof(uint64_t));\n    if (p) {\n      return wuffs_base__make_slice_u64((uint64_" +
	"t*)(p), num_u64);\n    }\n  }\n  return wuffs_base__make_slice_u64(NULL, 0);\n}\n" +
	""

const BaseImagePrivateH = "" +
	"// ---------------- Images\n\nWUFFS_BASE__MAYBE_STATIC uint64_t  //\nwuffs_base__pixel_swizzler__swizzle_interleaved_from_reader(\n    const wuffs_base__pixel_swizzler* p,\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    const uint8_t** ptr_iop_r,\n    const uint8_t* io2_r);\n\n" +
	"" +
	"// ---------------- Images (Utility)\n\n#define wuffs_base__utility__make_pixel_format wuffs_base__make_pixel_format\n" +
	""

const BaseImagePublicH = "" +
	"// ---------------- Images\n\n// wuffs_base__color_u32_argb_premul is an 8 bit per channel premultiplied\n// Alpha, Red, Green, Blue color, as a uint32_t value. Its value is always\n// 0xAARRGGBB (Alpha most significant, Blue least), regardless of endianness.\ntypedef uint32_t wuffs_base__color_u32_argb_premul;\n\nstatic inline uint16_t  //\nwuffs_base__color_u32_argb_premul__as__color_u16_rgb_565(\n    wuffs_base__color_u32_argb_premul c) {\n  uint32_t r5 = 0xF800 & (c >> 8);\n  uint32_t g6 = 0x07E0 & (c >> 5);\n  uint32_t b5 = 0x001F & (c >> 3);\n  return (uint16_t)(r5 | g6 | b5);\n}\n\nstatic inline wuffs_base__color_u32_argb_premul  //\nwuffs_base__color_u16_rgb_565__as__color_u32_argb_premul(uint16_t rgb_565) {\n  uint32_t b5 = 0x1F & (rgb_565 >> 0);\n  uint32_t b = (b5 << 3) | (b5 >> 2);\n  uint32_t g6 = 0x3F & (rgb_565 >> 5);\n  uint32_t g = (g6 << 2) | (g6 >> 4);\n  uint32_t r5 = 0x1F & (rgb_565 >> 11);\n  uint32_t r = (r5 << 3) | (r5 >> 2);\n  return 0xFF000000 | (r << 16) | (g << 8) | (b << 0);\n}\n\nstatic inline uint8_t  //" +
	"\nwuffs_base__color_u32_argb_premul__as__color_u8_gray(\n    wuffs_base__color_u32_argb_premul c) {\n  // Work in 16-bit color.\n  uint32_t cr = 0x101 * (0xFF & (c >> 16));\n  uint32_t cg = 0x101 * (0xFF & (c >> 8));\n  uint32_t cb = 0x101 * (0xFF & (c >> 0));\n\n  // These coefficients (the fractions 0.299, 0.587 and 0.114) are the same\n  // as those given by the JFIF specification.\n  //\n  // Note that 19595 + 38470 + 7471 equals 65536, also known as (1 << 16). We\n  // shift by 24, not just by 16, because the return value is 8-bit color, not\n  // 16-bit color.\n  uint32_t weighted_average = (19595 * cr) + (38470 * cg) + (7471 * cb) + 32768;\n  return (uint8_t)(weighted_average >> 24);\n}\n\n// wuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul converts\n// from non-premultiplied alpha to premultiplied alpha.\nstatic inline wuffs_base__color_u32_argb_premul  //\nwuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul(\n    uint32_t argb_nonpremul) {\n  // Multiplying by 0x101 (twice, once for alpha and onc" +
	"e for color) converts\n  // from 8-bit to 16-bit color. Shifting right by 8 undoes that.\n  //\n  // Working in the higher bit depth can produce slightly different (and\n  // arguably slightly more accurate) results. For example, given 8-bit blue\n  // and alpha of 0x80 and 0x81:\n  //\n  //  - ((0x80   * 0x81  ) / 0xFF  )      = 0x40        = 0x40\n  //  - ((0x8080 * 0x8181) / 0xFFFF) >> 8 = 0x4101 >> 8 = 0x41\n  uint32_t a = 0xFF & (argb_nonpremul >> 24);\n  uint32_t a16 = a * (0x101 * 0x101);\n\n  uint32_t r = 0xFF & (argb_nonpremul >> 16);\n  r = ((r * a16) / 0xFFFF) >> 8;\n  uint32_t g = 0xFF & (argb_nonpremul >> 8);\n  g = ((g * a16) / 0xFFFF) >> 8;\n  uint32_t b = 0xFF & (argb_nonpremul >> 0);\n  b = ((b * a16) / 0xFFFF) >> 8;\n\n  return (a << 24) | (r << 16) | (g << 8) | (b << 0);\n}\n\n// wuffs_base__color_u32_argb_premul__as__color_u32_argb_nonpremul converts\n// from premultiplied alpha to non-premultiplied alpha.\nstatic inline uint32_t  //\nwuffs_base__color_u32_argb_premul__as__color_u32_argb_nonpremul(\n    wuffs_base_" +
	"_color_u32_argb_premul c) {\n  uint32_t a = 0xFF & (c >> 24);\n  if (a == 0xFF) {\n    return c;\n  } else if (a == 0) {\n    return 0;\n  }\n  uint32_t a16 = a * 0x101;\n\n  uint32_t r = 0xFF & (c >> 16);\n  r = ((r * (0x101 * 0xFFFF)) / a16) >> 8;\n  uint32_t g = 0xFF & (c >> 8);\n  g = ((g * (0x101 * 0xFFFF)) / a16) >> 8;\n  uint32_t b = 0xFF & (c >> 0);\n  b = ((b * (0x101 * 0xFFFF)) / a16) >> 8;\n\n  return (a << 24) | (r << 16) | (g << 8) | (b << 0);\n}\n\n" +
	"" +
	"// --------\n\ntypedef uint8_t wuffs_base__pixel_blend;\n\n// wuffs_base__pixel_blend encodes how to blend source and destination pixels,\n// accounting for transparency. It encompasses the Porter-Duff compositing\n// operators as well as the other blending modes defined by PDF.\n//\n// TODO: implement the other modes.\n#define WUFFS_BASE__PIXEL_BLEND__SRC ((wuffs_base__pixel_blend)0)\n#define WUFFS_BASE__PIXEL_BLEND__SRC_OVER ((wuffs_base__pixel_blend)1)\n\n" +
	"" +
	"// --------\n\n// wuffs_base__pixel_alpha_transparency is a pixel format's alpha channel\n// model. It is a property of the pixel format in general, not of a specific\n// pixel. An RGBA pixel format (with alpha) can still have fully opaque pixels.\ntypedef uint32_t wuffs_base__pixel_alpha_transparency;\n\n#define WUFFS_BASE__PIXEL_ALPHA_TRANSPARENCY__OPAQUE 0\n#define WUFFS_BASE__PIXEL_ALPHA_TRANSPARENCY__NON_PREMULTIPLIED_ALPHA 1\n#define WUFFS_BASE__PIXEL_ALPHA_TRANSPARENCY__PREMULTIPLIED_ALPHA 2\n#define WUFFS_BASE__PIXEL_ALPHA_TRANSPARENCY__BINARY_ALPHA 3\n\n" +
	"" +
	"// --------\n\n#define WUFFS_BASE__PIXEL_FORMAT__NUM_PLANES_MAX 4\n\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__INDEX_PLANE 0\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__COLOR_PLANE 3\n\n// wuffs_base__pixel_format encodes the format of the bytes that constitute an\n// image frame's pixel data.\n//\n// See https://github.com/google/wuffs/blob/master/doc/note/pixel-formats.md\n//\n// Do not manipulate its bits directly; they are private implementation\n// details. Use methods such as wuffs_base__pixel_format__num_planes instead.\ntypedef struct {\n  uint32_t repr;\n\n#ifdef __cplusplus\n  inline bool is_valid() const;\n  inline uint32_t bits_per_pixel() const;\n  inline bool is_direct() const;\n  inline bool is_indexed() const;\n  inline bool is_interleaved() const;\n  inline bool is_planar() const;\n  inline uint32_t num_planes() const;\n  inline wuffs_base__pixel_alpha_transparency transparency() const;\n#endif  // __cplusplus\n\n} wuffs_base__pixel_format;\n\nstatic inline wuffs_base__pixel_format  //\nwuffs_base__make_pixel_format(uint3" +
	"2_t repr) {\n  wuffs_base__pixel_format f;\n  f.repr = repr;\n  return f;\n}\n\n// Common 8-bit-depth pixel formats. This list is not exhaustive; not all valid\n// wuffs_base__pixel_format values are present.\n\n#define WUFFS_BASE__PIXEL_FORMAT__INVALID 0x00000000\n\n#define WUFFS_BASE__PIXEL_FORMAT__A 0x02000008\n\n#define WUFFS_BASE__PIXEL_FORMAT__Y 0x20000008\n#define WUFFS_BASE__PIXEL_FORMAT__YA_NONPREMUL 0x21000008\n#define WUFFS_BASE__PIXEL_FORMAT__YA_PREMUL 0x22000008\n\n#define WUFFS_BASE__PIXEL_FORMAT__YCBCR 0x40020888\n#define WUFFS_BASE__PIXEL_FORMAT__YCBCRA_NONPREMUL 0x41038888\n#define WUFFS_BASE__PIXEL_FORMAT__YCBCRK 0x50038888\n\n#define WUFFS_BASE__PIXEL_FORMAT__YCOCG 0x60020888\n#define WUFFS_BASE__PIXEL_FORMAT__YCOCGA_NONPREMUL 0x61038888\n#define WUFFS_BASE__PIXEL_FORMAT__YCOCGK 0x70038888\n\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_NONPREMUL 0x81040008\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_PREMUL 0x82040008\n#define WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY 0x83040008\n\n#define WUFFS_BASE__PIXE" +
	"L_FORMAT__BGR_565 0x80000565\n#define WUFFS_BASE__PIXEL_FORMAT__BGR 0x80000888\n#define WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL 0x81008888\n#define WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL 0x82008888\n#define WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY 0x83008888\n#define WUFFS_BASE__PIXEL_FORMAT__BGRX 0x90008888\n\n#define WUFFS_BASE__PIXEL_FORMAT__RGB 0xA0000888\n#define WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL 0xA1008888\n#define WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL 0xA2008888\n#define WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY 0xA3008888\n#define WUFFS_BASE__PIXEL_FORMAT__RGBX 0xB0008888\n\n#define WUFFS_BASE__PIXEL_FORMAT__CMY 0xC0020888\n#define WUFFS_BASE__PIXEL_FORMAT__CMYK 0xD0038888\n\nextern const uint32_t wuffs_base__pixel_format__bits_per_channel[16];\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_valid(const wuffs_base__pixel_format* f) {\n  return f->repr != 0;\n}\n\n// wuffs_base__pixel_format__bits_per_pixel returns the number of bits per\n// pixel for interleaved pixel formats, and returns 0 for planar pixel formats.\n" +
	"static inline uint32_t  //\nwuffs_base__pixel_format__bits_per_pixel(const wuffs_base__pixel_format* f) {\n  if (((f->repr >> 16) & 0x03) != 0) {\n    return 0;\n  }\n  return wuffs_base__pixel_format__bits_per_channel[0x0F & (f->repr >> 0)] +\n         wuffs_base__pixel_format__bits_per_channel[0x0F & (f->repr >> 4)] +\n         wuffs_base__pixel_format__bits_per_channel[0x0F & (f->repr >> 8)] +\n         wuffs_base__pixel_format__bits_per_channel[0x0F & (f->repr >> 12)];\n}\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_direct(const wuffs_base__pixel_format* f) {\n  return ((f->repr >> 18) & 0x01) == 0;\n}\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_indexed(const wuffs_base__pixel_format* f) {\n  return ((f->repr >> 18) & 0x01) != 0;\n}\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_interleaved(const wuffs_base__pixel_format* f) {\n  return ((f->repr >> 16) & 0x03) == 0;\n}\n\nstatic inline bool  //\nwuffs_base__pixel_format__is_planar(const wuffs_base__pixel_format* f) {\n  return ((f->repr >> 16) & 0x03" +
	") != 0;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_format__num_planes(const wuffs_base__pixel_format* f) {\n  return ((f->repr >> 16) & 0x03) + 1;\n}\n\nstatic inline wuffs_base__pixel_alpha_transparency  //\nwuffs_base__pixel_format__transparency(const wuffs_base__pixel_format* f) {\n  return (wuffs_base__pixel_alpha_transparency)((f->repr >> 24) & 0x03);\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__pixel_format::is_valid() const {\n  return wuffs_base__pixel_format__is_valid(this);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_format::bits_per_pixel() const {\n  return wuffs_base__pixel_format__bits_per_pixel(this);\n}\n\ninline bool  //\nwuffs_base__pixel_format::is_direct() const {\n  return wuffs_base__pixel_format__is_direct(this);\n}\n\ninline bool  //\nwuffs_base__pixel_format::is_indexed() const {\n  return wuffs_base__pixel_format__is_indexed(this);\n}\n\ninline bool  //\nwuffs_base__pixel_format::is_interleaved() const {\n  return wuffs_base__pixel_format__is_interleaved(this);\n}\n\ninline bool  //\nwuffs_base__pixel_" +
	"format::is_planar() const {\n  return wuffs_base__pixel_format__is_planar(this);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_format::num_planes() const {\n  return wuffs_base__pixel_format__num_planes(this);\n}\n\ninline wuffs_base__pixel_alpha_transparency  //\nwuffs_base__pixel_format::transparency() const {\n  return wuffs_base__pixel_format__transparency(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\n// wuffs_base__pixel_subsampling encodes whether sample values cover one pixel\n// or cover multiple pixels.\n//\n// See https://github.com/google/wuffs/blob/master/doc/note/pixel-subsampling.md\n//\n// Do not manipulate its bits directly; they are private implementation\n// details. Use methods such as wuffs_base__pixel_subsampling__bias_x instead.\ntypedef struct {\n  uint32_t repr;\n\n#ifdef __cplusplus\n  inline uint32_t bias_x(uint32_t plane) const;\n  inline uint32_t denominator_x(uint32_t plane) const;\n  inline uint32_t bias_y(uint32_t plane) const;\n  inline uint32_t denominator_y(uint32_t plane) const;\n#endif  // __cplusplus\n\n} wuffs_base__pixel_subsampling;\n\nstatic inline wuffs_base__pixel_subsampling  //\nwuffs_base__make_pixel_subsampling(uint32_t repr) {\n  wuffs_base__pixel_subsampling s;\n  s.repr = repr;\n  return s;\n}\n\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__NONE 0x00000000\n\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__444 0x000000\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__440 0x010100\n#define WUFFS_BASE__" +
	"PIXEL_SUBSAMPLING__422 0x101000\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__420 0x111100\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__411 0x303000\n#define WUFFS_BASE__PIXEL_SUBSAMPLING__410 0x313100\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__bias_x(const wuffs_base__pixel_subsampling* s,\n                                      uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 6;\n  return (s->repr >> shift) & 0x03;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__denominator_x(\n    const wuffs_base__pixel_subsampling* s,\n    uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 4;\n  return ((s->repr >> shift) & 0x03) + 1;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__bias_y(const wuffs_base__pixel_subsampling* s,\n                                      uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 2;\n  return (s->repr >> shift) & 0x03;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_subsampling__denominator_y(\n    const wuffs_base__pixel_subsampling* s," +
	"\n    uint32_t plane) {\n  uint32_t shift = ((plane & 0x03) * 8) + 0;\n  return ((s->repr >> shift) & 0x03) + 1;\n}\n\n#ifdef __cplusplus\n\ninline uint32_t  //\nwuffs_base__pixel_subsampling::bias_x(uint32_t plane) const {\n  return wuffs_base__pixel_subsampling__bias_x(this, plane);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_subsampling::denominator_x(uint32_t plane) const {\n  return wuffs_base__pixel_subsampling__denominator_x(this, plane);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_subsampling::bias_y(uint32_t plane) const {\n  return wuffs_base__pixel_subsampling__bias_y(this, plane);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_subsampling::denominator_y(uint32_t plane) const {\n  return wuffs_base__pixel_subsampling__denominator_y(this, plane);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    wuffs_base__pixel_format pixfmt;\n    wuffs_base__pixel_subsampling pixsub;\n    uint32_t width;\n    uint32_t height;\n  } private_impl;\n\n#ifdef __cplusplus\n  inline void set(uint32_t pixfmt_repr,\n                  uint32_t pixsub_repr,\n                  uint32_t width,\n                  uint32_t height);\n  inline void invalidate();\n  inline bool is_valid() const;\n  inline wuffs_base__pixel_format pixel_format() const;\n  inline wuffs_base__pixel_subsampling pixel_subsampling() const;\n  inline wuffs_base__rect_ie_u32 bounds() const;\n  inline uint32_t width() const;\n  inline uint32_t height() const;\n  inline uint64_t pixbuf_len() const;\n#endif  // __cplusplus\n\n} wuffs_base__pixel_config;\n\nstatic inline wuffs_base__pixel_config  //\nwuffs_base__null_pixel_config() {\n  wuffs_base__pixel_config ret;\n  ret.private_impl.pixfmt.repr = 0;\n  ret.private" +
	"_impl.pixsub.repr = 0;\n  ret.private_impl.width = 0;\n  ret.private_impl.height = 0;\n  return ret;\n}\n\n// TODO: Should this function return bool? An error type?\nstatic inline void  //\nwuffs_base__pixel_config__set(wuffs_base__pixel_config* c,\n                              uint32_t pixfmt_repr,\n                              uint32_t pixsub_repr,\n                              uint32_t width,\n                              uint32_t height) {\n  if (!c) {\n    return;\n  }\n  if (pixfmt_repr) {\n    uint64_t wh = ((uint64_t)width) * ((uint64_t)height);\n    // TODO: handle things other than 1 byte per pixel.\n    if (wh <= ((uint64_t)SIZE_MAX)) {\n      c->private_impl.pixfmt.repr = pixfmt_repr;\n      c->private_impl.pixsub.repr = pixsub_repr;\n      c->private_impl.width = width;\n      c->private_impl.height = height;\n      return;\n    }\n  }\n\n  c->private_impl.pixfmt.repr = 0;\n  c->private_impl.pixsub.repr = 0;\n  c->private_impl.width = 0;\n  c->private_impl.height = 0;\n}\n\nstatic inline void  //\nwuffs_base__pixel_config__inv" +
	"alidate(wuffs_base__pixel_config* c) {\n  if (c) {\n    c->private_impl.pixfmt.repr = 0;\n    c->private_impl.pixsub.repr = 0;\n    c->private_impl.width = 0;\n    c->private_impl.height = 0;\n  }\n}\n\nstatic inline bool  //\nwuffs_base__pixel_config__is_valid(const wuffs_base__pixel_config* c) {\n  return c && c->private_impl.pixfmt.repr;\n}\n\nstatic inline wuffs_base__pixel_format  //\nwuffs_base__pixel_config__pixel_format(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.pixfmt : wuffs_base__make_pixel_format(0);\n}\n\nstatic inline wuffs_base__pixel_subsampling  //\nwuffs_base__pixel_config__pixel_subsampling(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.pixsub : wuffs_base__make_pixel_subsampling(0);\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__pixel_config__bounds(const wuffs_base__pixel_config* c) {\n  if (c) {\n    wuffs_base__rect_ie_u32 ret;\n    ret.min_incl_x = 0;\n    ret.min_incl_y = 0;\n    ret.max_excl_x = c->private_impl.width;\n    ret.max_excl_y = c->private_impl.h" +
	"eight;\n    return ret;\n  }\n\n  wuffs_base__rect_ie_u32 ret;\n  ret.min_incl_x = 0;\n  ret.min_incl_y = 0;\n  ret.max_excl_x = 0;\n  ret.max_excl_y = 0;\n  return ret;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_config__width(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.width : 0;\n}\n\nstatic inline uint32_t  //\nwuffs_base__pixel_config__height(const wuffs_base__pixel_config* c) {\n  return c ? c->private_impl.height : 0;\n}\n\n// TODO: this is the right API for planar (not interleaved) pixbufs? Should it\n// allow decoding into a color model different from the format's intrinsic one?\n// For example, decoding a JPEG image straight to RGBA instead of to YCbCr?\nstatic inline uint64_t  //\nwuffs_base__pixel_config__pixbuf_len(const wuffs_base__pixel_config* c) {\n  if (!c) {\n    return 0;\n  }\n  if (wuffs_base__pixel_format__is_planar(&c->private_impl.pixfmt)) {\n    // TODO: support planar pixel formats, concious of pixel subsampling.\n    return 0;\n  }\n  uint32_t bits_per_pixel =\n      wuffs_base__pixel_" +
	"format__bits_per_pixel(&c->private_impl.pixfmt);\n  if ((bits_per_pixel == 0) || ((bits_per_pixel % 8) != 0)) {\n    // TODO: support fraction-of-byte pixels, e.g. 1 bit per pixel?\n    return 0;\n  }\n  uint64_t bytes_per_pixel = bits_per_pixel / 8;\n\n  uint64_t n =\n      ((uint64_t)c->private_impl.width) * ((uint64_t)c->private_impl.height);\n  if (n > (UINT64_MAX / bytes_per_pixel)) {\n    return 0;\n  }\n  n *= bytes_per_pixel;\n\n  if (wuffs_base__pixel_format__is_indexed(&c->private_impl.pixfmt)) {\n    if (n > (UINT64_MAX - 1024)) {\n      return 0;\n    }\n    n += 1024;\n  }\n\n  return n;\n}\n\n#ifdef __cplusplus\n\ninline void  //\nwuffs_base__pixel_config::set(uint32_t pixfmt_repr,\n                              uint32_t pixsub_repr,\n                              uint32_t width,\n                              uint32_t height) {\n  wuffs_base__pixel_config__set(this, pixfmt_repr, pixsub_repr, width, height);\n}\n\ninline void  //\nwuffs_base__pixel_config::invalidate() {\n  wuffs_base__pixel_config__invalidate(this);\n}\n\ninline boo" +
	"l  //\nwuffs_base__pixel_config::is_valid() const {\n  return wuffs_base__pixel_config__is_valid(this);\n}\n\ninline wuffs_base__pixel_format  //\nwuffs_base__pixel_config::pixel_format() const {\n  return wuffs_base__pixel_config__pixel_format(this);\n}\n\ninline wuffs_base__pixel_subsampling  //\nwuffs_base__pixel_config::pixel_subsampling() const {\n  return wuffs_base__pixel_config__pixel_subsampling(this);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_base__pixel_config::bounds() const {\n  return wuffs_base__pixel_config__bounds(this);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_config::width() const {\n  return wuffs_base__pixel_config__width(this);\n}\n\ninline uint32_t  //\nwuffs_base__pixel_config::height() const {\n  return wuffs_base__pixel_config__height(this);\n}\n\ninline uint64_t  //\nwuffs_base__pixel_config::pixbuf_len() const {\n  return wuffs_base__pixel_config__pixbuf_len(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  wuffs_base__pixel_config pixcfg;\n\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    uint64_t first_frame_io_position;\n    bool first_frame_is_opaque;\n  } private_impl;\n\n#ifdef __cplusplus\n  inline void set(uint32_t pixfmt_repr,\n                  uint32_t pixsub_repr,\n                  uint32_t width,\n                  uint32_t height,\n                  uint64_t first_frame_io_position,\n                  bool first_frame_is_opaque);\n  inline void invalidate();\n  inline bool is_valid() const;\n  inline uint64_t first_frame_io_position() const;\n  inline bool first_frame_is_opaque() const;\n#endif  // __cplusplus\n\n} wuffs_base__image_config;\n\nstatic inline wuffs_base__image_config  //\nwuffs_base__null_image_config() {\n  wuffs_base__image_config ret;\n  ret.pixcfg = wuffs_base__null_pixel_config();\n  ret.private_impl.first_frame_io_position = 0;\n  ret.private_impl.first_frame_is_opaque = false;" +
	"\n  return ret;\n}\n\n// TODO: Should this function return bool? An error type?\nstatic inline void  //\nwuffs_base__image_config__set(wuffs_base__image_config* c,\n                              uint32_t pixfmt_repr,\n                              uint32_t pixsub_repr,\n                              uint32_t width,\n                              uint32_t height,\n                              uint64_t first_frame_io_position,\n                              bool first_frame_is_opaque) {\n  if (!c) {\n    return;\n  }\n  if (pixfmt_repr) {\n    c->pixcfg.private_impl.pixfmt.repr = pixfmt_repr;\n    c->pixcfg.private_impl.pixsub.repr = pixsub_repr;\n    c->pixcfg.private_impl.width = width;\n    c->pixcfg.private_impl.height = height;\n    c->private_impl.first_frame_io_position = first_frame_io_position;\n    c->private_impl.first_frame_is_opaque = first_frame_is_opaque;\n    return;\n  }\n\n  c->pixcfg.private_impl.pixfmt.repr = 0;\n  c->pixcfg.private_impl.pixsub.repr = 0;\n  c->pixcfg.private_impl.width = 0;\n  c->pixcfg.private_impl.he" +
	"ight = 0;\n  c->private_impl.first_frame_io_position = 0;\n  c->private_impl.first_frame_is_opaque = 0;\n}\n\nstatic inline void  //\nwuffs_base__image_config__invalidate(wuffs_base__image_config* c) {\n  if (c) {\n    c->pixcfg.private_impl.pixfmt.repr = 0;\n    c->pixcfg.private_impl.pixsub.repr = 0;\n    c->pixcfg.private_impl.width = 0;\n    c->pixcfg.private_impl.height = 0;\n    c->private_impl.first_frame_io_position = 0;\n    c->private_impl.first_frame_is_opaque = 0;\n  }\n}\n\nstatic inline bool  //\nwuffs_base__image_config__is_valid(const wuffs_base__image_config* c) {\n  return c && wuffs_base__pixel_config__is_valid(&(c->pixcfg));\n}\n\nstatic inline uint64_t  //\nwuffs_base__image_config__first_frame_io_position(\n    const wuffs_base__image_config* c) {\n  return c ? c->private_impl.first_frame_io_position : 0;\n}\n\nstatic inline bool  //\nwuffs_base__image_config__first_frame_is_opaque(\n    const wuffs_base__image_config* c) {\n  return c ? c->private_impl.first_frame_is_opaque : false;\n}\n\n#ifdef __cplusplus\n\ninline void" +
	"  //\nwuffs_base__image_config::set(uint32_t pixfmt_repr,\n                              uint32_t pixsub_repr,\n                              uint32_t width,\n                              uint32_t height,\n                              uint64_t first_frame_io_position,\n                              bool first_frame_is_opaque) {\n  wuffs_base__image_config__set(this, pixfmt_repr, pixsub_repr, width, height,\n                                first_frame_io_position, first_frame_is_opaque);\n}\n\ninline void  //\nwuffs_base__image_config::invalidate() {\n  wuffs_base__image_config__invalidate(this);\n}\n\ninline bool  //\nwuffs_base__image_config::is_valid() const {\n  return wuffs_base__image_config__is_valid(this);\n}\n\ninline uint64_t  //\nwuffs_base__image_config::first_frame_io_position() const {\n  return wuffs_base__image_config__first_frame_io_position(this);\n}\n\ninline bool  //\nwuffs_base__image_config::first_frame_is_opaque() const {\n  return wuffs_base__image_config__first_frame_is_opaque(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\n// Deprecated: use wuffs_base__pixel_blend instead.\n//\n// wuffs_base__animation_blend encodes, for an animated image, how to blend the\n// transparent pixels of this frame with the existing canvas. In Porter-Duff\n// compositing operator terminology:\n//  - 0 means the frame may be transparent, and should be blended \"src over\n//    dst\", also known as just \"over\".\n//  - 1 means the frame may be transparent, and should be blended \"src\".\n//  - 2 means the frame is completely opaque, so that \"src over dst\" and \"src\"\n//    are equivalent.\n//\n// These semantics are conservative. It is valid for a completely opaque frame\n// to have a blend value other than 2.\ntypedef uint8_t wuffs_base__animation_blend;\n\n#define WUFFS_BASE__ANIMATION_BLEND__SRC_OVER_DST \\\n  ((wuffs_base__animation_blend)0)\n#define WUFFS_BASE__ANIMATION_BLEND__SRC ((wuffs_base__animation_blend)1)\n#define WUFFS_BASE__ANIMATION_BLEND__OPAQUE ((wuffs_base__animation_blend)2)\n\n" +
	"" +
	"// --------\n\n// wuffs_base__animation_disposal encodes, for an animated image, how to\n// dispose of a frame after displaying it:\n//  - None means to draw the next frame on top of this one.\n//  - Restore Background means to clear the frame's dirty rectangle to \"the\n//    background color\" (in practice, this means transparent black) before\n//    drawing the next frame.\n//  - Restore Previous means to undo the current frame, so that the next frame\n//    is drawn on top of the previous one.\ntypedef uint8_t wuffs_base__animation_disposal;\n\n#define WUFFS_BASE__ANIMATION_DISPOSAL__NONE ((wuffs_base__animation_disposal)0)\n#define WUFFS_BASE__ANIMATION_DISPOSAL__RESTORE_BACKGROUND \\\n  ((wuffs_base__animation_disposal)1)\n#define WUFFS_BASE__ANIMATION_DISPOSAL__RESTORE_PREVIOUS \\\n  ((wuffs_base__animation_disposal)2)\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    wuffs_base__rect_ie_u32 bounds;\n    wuffs_base__flicks duration;\n    uint64_t index;\n    uint64_t io_position;\n    wuffs_base__animation_disposal disposal;\n    bool opaque_within_bounds;\n    bool overwrite_instead_of_blend;\n    wuffs_base__color_u32_argb_premul background_color;\n  } private_impl;\n\n#ifdef __cplusplus\n  inline void set(wuffs_base__rect_ie_u32 bounds,\n                  wuffs_base__flicks duration,\n                  uint64_t index,\n                  uint64_t io_position,\n                  wuffs_base__animation_disposal disposal,\n                  bool opaque_within_bounds,\n                  bool overwrite_instead_of_blend,\n                  wuffs_base__color_u32_argb_premul background_color);\n  inline wuffs_base__rect_ie_u32 bounds() const;\n  inline uint32_t width() const;\n  inline uint32_t height() const;\n  inline wuffs_base_" +
	"_flicks duration() const;\n  inline uint64_t index() const;\n  inline uint64_t io_position() const;\n  inline wuffs_base__animation_disposal disposal() const;\n  inline bool opaque_within_bounds() const;\n  inline bool overwrite_instead_of_blend() const;\n  inline wuffs_base__color_u32_argb_premul background_color() const;\n#endif  // __cplusplus\n\n} wuffs_base__frame_config;\n\nstatic inline wuffs_base__frame_config  //\nwuffs_base__null_frame_config() {\n  wuffs_base__frame_config ret;\n  ret.private_impl.bounds = wuffs_base__make_rect_ie_u32(0, 0, 0, 0);\n  ret.private_impl.duration = 0;\n  ret.private_impl.index = 0;\n  ret.private_impl.io_position = 0;\n  ret.private_impl.disposal = 0;\n  ret.private_impl.opaque_within_bounds = false;\n  ret.private_impl.overwrite_instead_of_blend = false;\n  return ret;\n}\n\nstatic inline void  //\nwuffs_base__frame_config__set(\n    wuffs_base__frame_config* c,\n    wuffs_base__rect_ie_u32 bounds,\n    wuffs_base__flicks duration,\n    uint64_t index,\n    uint64_t io_position,\n    wuffs_base__an" +
	"imation_disposal disposal,\n    bool opaque_within_bounds,\n    bool overwrite_instead_of_blend,\n    wuffs_base__color_u32_argb_premul background_color) {\n  if (!c) {\n    return;\n  }\n\n  c->private_impl.bounds = bounds;\n  c->private_impl.duration = duration;\n  c->private_impl.index = index;\n  c->private_impl.io_position = io_position;\n  c->private_impl.disposal = disposal;\n  c->private_impl.opaque_within_bounds = opaque_within_bounds;\n  c->private_impl.overwrite_instead_of_blend = overwrite_instead_of_blend;\n  c->private_impl.background_color = background_color;\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__frame_config__bounds(const wuffs_base__frame_config* c) {\n  if (c) {\n    return c->private_impl.bounds;\n  }\n\n  wuffs_base__rect_ie_u32 ret;\n  ret.min_incl_x = 0;\n  ret.min_incl_y = 0;\n  ret.max_excl_x = 0;\n  ret.max_excl_y = 0;\n  return ret;\n}\n\nstatic inline uint32_t  //\nwuffs_base__frame_config__width(const wuffs_base__frame_config* c) {\n  return c ? wuffs_base__rect_ie_u32__width(&c->private_impl" +
	".bounds) : 0;\n}\n\nstatic inline uint32_t  //\nwuffs_base__frame_config__height(const wuffs_base__frame_config* c) {\n  return c ? wuffs_base__rect_ie_u32__height(&c->private_impl.bounds) : 0;\n}\n\n// wuffs_base__frame_config__duration returns the amount of time to display\n// this frame. Zero means to display forever - a still (non-animated) image.\nstatic inline wuffs_base__flicks  //\nwuffs_base__frame_config__duration(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.duration : 0;\n}\n\n// wuffs_base__frame_config__index returns the index of this frame. The first\n// frame in an image has index 0, the second frame has index 1, and so on.\nstatic inline uint64_t  //\nwuffs_base__frame_config__index(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.index : 0;\n}\n\n// wuffs_base__frame_config__io_position returns the I/O stream position before\n// the frame config.\nstatic inline uint64_t  //\nwuffs_base__frame_config__io_position(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl." +
	"io_position : 0;\n}\n\n// wuffs_base__frame_config__disposal returns, for an animated image, how to\n// dispose of this frame after displaying it.\nstatic inline wuffs_base__animation_disposal  //\nwuffs_base__frame_config__disposal(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.disposal : 0;\n}\n\n// wuffs_base__frame_config__opaque_within_bounds returns whether all pixels\n// within the frame's bounds are fully opaque. It makes no claim about pixels\n// outside the frame bounds but still inside the overall image. The two\n// bounding rectangles can differ for animated images.\n//\n// Its semantics are conservative. It is valid for a fully opaque frame to have\n// this value be false: a false negative.\n//\n// If true, drawing the frame with WUFFS_BASE__PIXEL_BLEND__SRC and\n// WUFFS_BASE__PIXEL_BLEND__SRC_OVER should be equivalent, in terms of\n// resultant pixels, but the former may be faster.\nstatic inline bool  //\nwuffs_base__frame_config__opaque_within_bounds(\n    const wuffs_base__frame_config* c) {\n  " +
	"return c && c->private_impl.opaque_within_bounds;\n}\n\n// wuffs_base__frame_config__overwrite_instead_of_blend returns, for an\n// animated image, whether to ignore the previous image state (within the frame\n// bounds) when drawing this incremental frame. Equivalently, whether to use\n// WUFFS_BASE__PIXEL_BLEND__SRC instead of WUFFS_BASE__PIXEL_BLEND__SRC_OVER.\n//\n// The WebP spec (https://developers.google.com/speed/webp/docs/riff_container)\n// calls this the \"Blending method\" bit. WebP's \"Do not blend\" corresponds to\n// Wuffs' \"overwrite_instead_of_blend\".\nstatic inline bool  //\nwuffs_base__frame_config__overwrite_instead_of_blend(\n    const wuffs_base__frame_config* c) {\n  return c && c->private_impl.overwrite_instead_of_blend;\n}\n\nstatic inline wuffs_base__color_u32_argb_premul  //\nwuffs_base__frame_config__background_color(const wuffs_base__frame_config* c) {\n  return c ? c->private_impl.background_color : 0;\n}\n\n#ifdef __cplusplus\n\ninline void  //\nwuffs_base__frame_config::set(\n    wuffs_base__rect_ie_u32 bou" +
	"nds,\n    wuffs_base__flicks duration,\n    uint64_t index,\n    uint64_t io_position,\n    wuffs_base__animation_disposal disposal,\n    bool opaque_within_bounds,\n    bool overwrite_instead_of_blend,\n    wuffs_base__color_u32_argb_premul background_color) {\n  wuffs_base__frame_config__set(this, bounds, duration, index, io_position,\n                                disposal, opaque_within_bounds,\n                                overwrite_instead_of_blend, background_color);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_base__frame_config::bounds() const {\n  return wuffs_base__frame_config__bounds(this);\n}\n\ninline uint32_t  //\nwuffs_base__frame_config::width() const {\n  return wuffs_base__frame_config__width(this);\n}\n\ninline uint32_t  //\nwuffs_base__frame_config::height() const {\n  return wuffs_base__frame_config__height(this);\n}\n\ninline wuffs_base__flicks  //\nwuffs_base__frame_config::duration() const {\n  return wuffs_base__frame_config__duration(this);\n}\n\ninline uint64_t  //\nwuffs_base__frame_config::index() const " +
	"{\n  return wuffs_base__frame_config__index(this);\n}\n\ninline uint64_t  //\nwuffs_base__frame_config::io_position() const {\n  return wuffs_base__frame_config__io_position(this);\n}\n\ninline wuffs_base__animation_disposal  //\nwuffs_base__frame_config::disposal() const {\n  return wuffs_base__frame_config__disposal(this);\n}\n\ninline bool  //\nwuffs_base__frame_config::opaque_within_bounds() const {\n  return wuffs_base__frame_config__opaque_within_bounds(this);\n}\n\ninline bool  //\nwuffs_base__frame_config::overwrite_instead_of_blend() const {\n  return wuffs_base__frame_config__overwrite_instead_of_blend(this);\n}\n\ninline wuffs_base__color_u32_argb_premul  //\nwuffs_base__frame_config::background_color() const {\n  return wuffs_base__frame_config__background_color(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  wuffs_base__pixel_config pixcfg;\n\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    wuffs_base__table_u8 planes[WUFFS_BASE__PIXEL_FORMAT__NUM_PLANES_MAX];\n    // TODO: color spaces.\n  } private_impl;\n\n#ifdef __cplusplus\n  inline wuffs_base__status set_from_slice(\n      const wuffs_base__pixel_config* pixcfg,\n      wuffs_base__slice_u8 pixbuf_memory);\n  inline wuffs_base__status set_from_table(\n      const wuffs_base__pixel_config* pixcfg,\n      wuffs_base__table_u8 pixbuf_memory);\n  inline wuffs_base__slice_u8 palette();\n  inline wuffs_base__pixel_format pixel_format() const;\n  inline wuffs_base__table_u8 plane(uint32_t p);\n  inline wuffs_base__color_u32_argb_premul color_u32_at(uint32_t x,\n                                                        uint32_t y) const;\n  inline wuffs_base__status set_color_u32_at(\n      uint32_t x,\n      uint32_t y,\n      wuffs_base__color_u32_argb_premul co" +
	"lor);\n#endif  // __cplusplus\n\n} wuffs_base__pixel_buffer;\n\nstatic inline wuffs_base__pixel_buffer  //\nwuffs_base__null_pixel_buffer() {\n  wuffs_base__pixel_buffer ret;\n  ret.pixcfg = wuffs_base__null_pixel_config();\n  ret.private_impl.planes[0] = wuffs_base__empty_table_u8();\n  ret.private_impl.planes[1] = wuffs_base__empty_table_u8();\n  ret.private_impl.planes[2] = wuffs_base__empty_table_u8();\n  ret.private_impl.planes[3] = wuffs_base__empty_table_u8();\n  return ret;\n}\n\nstatic inline wuffs_base__status  //\nwuffs_base__pixel_buffer__set_from_slice(wuffs_base__pixel_buffer* pb,\n                                         const wuffs_base__pixel_config* pixcfg,\n                                         wuffs_base__slice_u8 pixbuf_memory) {\n  if (!pb) {\n    return wuffs_base__make_status(wuffs_base__error__bad_receiver);\n  }\n  memset(pb, 0, sizeof(*pb));\n  if (!pixcfg) {\n    return wuffs_base__make_status(wuffs_base__error__bad_argument);\n  }\n  if (wuffs_base__pixel_format__is_planar(&pixcfg->private_impl.pixfmt)) " +
	"{\n    // TODO: support planar pixel formats, concious of pixel subsampling.\n    return wuffs_base__make_status(wuffs_base__error__unsupported_option);\n  }\n  uint32_t bits_per_pixel =\n      wuffs_base__pixel_format__bits_per_pixel(&pixcfg->private_impl.pixfmt);\n  if ((bits_per_pixel == 0) || ((bits_per_pixel % 8) != 0)) {\n    // TODO: support fraction-of-byte pixels, e.g. 1 bit per pixel?\n    return wuffs_base__make_status(wuffs_base__error__unsupported_option);\n  }\n  uint64_t bytes_per_pixel = bits_per_pixel / 8;\n\n  uint8_t* ptr = pixbuf_memory.ptr;\n  uint64_t len = pixbuf_memory.len;\n  if (wuffs_base__pixel_format__is_indexed(&pixcfg->private_impl.pixfmt)) {\n    // Split a 1024 byte chunk (256 palette entries × 4 bytes per entry) from\n    // the start of pixbuf_memory. We split from the start, not the end, so\n    // that the both chunks' pointers have the same alignment as the original\n    // pointer, up to an alignment of 1024.\n    if (len < 1024) {\n      return wuffs_base__make_status(\n          wuffs_bas" +
	"e__error__bad_argument_length_too_short);\n    }\n    wuffs_base__table_u8* tab =\n        &pb->private_impl\n             .planes[WUFFS_BASE__PIXEL_FORMAT__INDEXED__COLOR_PLANE];\n    tab->ptr = ptr;\n    tab->width = 1024;\n    tab->height = 1;\n    tab->stride = 1024;\n    ptr += 1024;\n    len -= 1024;\n  }\n\n  uint64_t wh = ((uint64_t)pixcfg->private_impl.width) *\n                ((uint64_t)pixcfg->private_impl.height);\n  size_t width = (size_t)(pixcfg->private_impl.width);\n  if ((wh > (UINT64_MAX / bytes_per_pixel)) ||\n      (width > (SIZE_MAX / bytes_per_pixel))) {\n    return wuffs_base__make_status(wuffs_base__error__bad_argument);\n  }\n  wh *= bytes_per_pixel;\n  width *= bytes_per_pixel;\n  if (wh > len) {\n    return wuffs_base__make_status(\n        wuffs_base__error__bad_argument_length_too_short);\n  }\n\n  pb->pixcfg = *pixcfg;\n  wuffs_base__table_u8* tab = &pb->private_impl.planes[0];\n  tab->ptr = ptr;\n  tab->width = width;\n  tab->height = pixcfg->private_impl.height;\n  tab->stride = width;\n  return wuffs_base__m" +
	"ake_status(NULL);\n}\n\nstatic inline wuffs_base__status  //\nwuffs_base__pixel_buffer__set_from_table(wuffs_base__pixel_buffer* pb,\n                                         const wuffs_base__pixel_config* pixcfg,\n                                         wuffs_base__table_u8 pixbuf_memory) {\n  if (!pb) {\n    return wuffs_base__make_status(wuffs_base__error__bad_receiver);\n  }\n  memset(pb, 0, sizeof(*pb));\n  if (!pixcfg ||\n      wuffs_base__pixel_format__is_planar(&pixcfg->private_impl.pixfmt)) {\n    return wuffs_base__make_status(wuffs_base__error__bad_argument);\n  }\n  uint32_t bits_per_pixel =\n      wuffs_base__pixel_format__bits_per_pixel(&pixcfg->private_impl.pixfmt);\n  if ((bits_per_pixel == 0) || ((bits_per_pixel % 8) != 0)) {\n    // TODO: support fraction-of-byte pixels, e.g. 1 bit per pixel?\n    return wuffs_base__make_status(wuffs_base__error__unsupported_option);\n  }\n  uint64_t bytes_per_pixel = bits_per_pixel / 8;\n\n  uint64_t width_in_bytes =\n      ((uint64_t)pixcfg->private_impl.width) * bytes_per_pixe" +
	"l;\n  if ((width_in_bytes > pixbuf_memory.width) ||\n      (pixcfg->private_impl.height > pixbuf_memory.height)) {\n    return wuffs_base__make_status(wuffs_base__error__bad_argument);\n  }\n\n  pb->pixcfg = *pixcfg;\n  pb->private_impl.planes[0] = pixbuf_memory;\n  return wuffs_base__make_status(NULL);\n}\n\n// wuffs_base__pixel_buffer__palette returns the palette color data. If\n// non-empty, it will have length 1024.\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__pixel_buffer__palette(wuffs_base__pixel_buffer* pb) {\n  if (pb &&\n      wuffs_base__pixel_format__is_indexed(&pb->pixcfg.private_impl.pixfmt)) {\n    wuffs_base__table_u8* tab =\n        &pb->private_impl\n             .planes[WUFFS_BASE__PIXEL_FORMAT__INDEXED__COLOR_PLANE];\n    if ((tab->width == 1024) && (tab->height == 1)) {\n      return wuffs_base__make_slice_u8(tab->ptr, 1024);\n    }\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\nstatic inline wuffs_base__pixel_format  //\nwuffs_base__pixel_buffer__pixel_format(const wuffs_base__pixel_buffer* pb) {\n" +
	"  if (pb) {\n    return pb->pixcfg.private_impl.pixfmt;\n  }\n  return wuffs_base__make_pixel_format(WUFFS_BASE__PIXEL_FORMAT__INVALID);\n}\n\nstatic inline wuffs_base__table_u8  //\nwuffs_base__pixel_buffer__plane(wuffs_base__pixel_buffer* pb, uint32_t p) {\n  if (pb && (p < WUFFS_BASE__PIXEL_FORMAT__NUM_PLANES_MAX)) {\n    return pb->private_impl.planes[p];\n  }\n\n  wuffs_base__table_u8 ret;\n  ret.ptr = NULL;\n  ret.width = 0;\n  ret.height = 0;\n  ret.stride = 0;\n  return ret;\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__color_u32_argb_premul  //\nwuffs_base__pixel_buffer__color_u32_at(const wuffs_base__pixel_buffer* pb,\n                                       uint32_t x,\n                                       uint32_t y);\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__status  //\nwuffs_base__pixel_buffer__set_color_u32_at(\n    wuffs_base__pixel_buffer* pb,\n    uint32_t x,\n    uint32_t y,\n    wuffs_base__color_u32_argb_premul color);\n\n#ifdef __cplusplus\n\ninline wuffs_base__status  //\nwuffs_base__pixel_buffer::set_from_slice(\n    const w" +
	"uffs_base__pixel_config* pixcfg_arg,\n    wuffs_base__slice_u8 pixbuf_memory) {\n  return wuffs_base__pixel_buffer__set_from_slice(this, pixcfg_arg,\n                                                  pixbuf_memory);\n}\n\ninline wuffs_base__status  //\nwuffs_base__pixel_buffer::set_from_table(\n    const wuffs_base__pixel_config* pixcfg_arg,\n    wuffs_base__table_u8 pixbuf_memory) {\n  return wuffs_base__pixel_buffer__set_from_table(this, pixcfg_arg,\n                                                  pixbuf_memory);\n}\n\ninline wuffs_base__slice_u8  //\nwuffs_base__pixel_buffer::palette() {\n  return wuffs_base__pixel_buffer__palette(this);\n}\n\ninline wuffs_base__pixel_format  //\nwuffs_base__pixel_buffer::pixel_format() const {\n  return wuffs_base__pixel_buffer__pixel_format(this);\n}\n\ninline wuffs_base__table_u8  //\nwuffs_base__pixel_buffer::plane(uint32_t p) {\n  return wuffs_base__pixel_buffer__plane(this, p);\n}\n\ninline wuffs_base__color_u32_argb_premul  //\nwuffs_base__pixel_buffer::color_u32_at(uint32_t x, uint32_t y) con" +
	"st {\n  return wuffs_base__pixel_buffer__color_u32_at(this, x, y);\n}\n\ninline wuffs_base__status  //\nwuffs_base__pixel_buffer::set_color_u32_at(\n    uint32_t x,\n    uint32_t y,\n    wuffs_base__color_u32_argb_premul color) {\n  return wuffs_base__pixel_buffer__set_color_u32_at(this, x, y, color);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    uint8_t TODO;\n  } private_impl;\n\n#ifdef __cplusplus\n#endif  // __cplusplus\n\n} wuffs_base__decode_frame_options;\n\n#ifdef __cplusplus\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\n// wuffs_base__pixel_palette__closest_element returns the index of the palette\n// element that minimizes the sum of squared differences of the four ARGB\n// channels, working in premultiplied alpha. Ties favor the smaller index.\n//\n// The palette_slice.len may equal (N*4), for N less than 256, which means that\n// only the first N palette elements are considered. It returns 0 when N is 0.\n//\n// Applying this function on a per-pixel basis will not produce whole-of-image\n// dithering.\nWUFFS_BASE__MAYBE_STATIC uint8_t  //\nwuffs_base__pixel_palette__closest_element(\n    wuffs_base__slice_u8 palette_slice,\n    wuffs_base__pixel_format palette_format,\n    wuffs_base__color_u32_argb_premul c);\n\n" +
	"" +
	"// --------\n\n// TODO: should the func type take restrict pointers?\ntypedef uint64_t (*wuffs_base__pixel_swizzler__func)(uint8_t* dst_ptr,\n                                                     size_t dst_len,\n                                                     uint8_t* dst_palette_ptr,\n                                                     size_t dst_palette_len,\n                                                     const uint8_t* src_ptr,\n                                                     size_t src_len);\n\ntypedef struct {\n  // Do not access the private_impl's fields directly. There is no API/ABI\n  // compatibility or safety guarantee if you do so.\n  struct {\n    wuffs_base__pixel_swizzler__func func;\n    uint32_t src_pixfmt_bytes_per_pixel;\n  } private_impl;\n\n#ifdef __cplusplus\n  inline wuffs_base__status prepare(wuffs_base__pixel_format dst_pixfmt,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_pixfmt,\n                   " +
	"                 wuffs_base__slice_u8 src_palette,\n                                    wuffs_base__pixel_blend blend);\n  inline uint64_t swizzle_interleaved_from_slice(\n      wuffs_base__slice_u8 dst,\n      wuffs_base__slice_u8 dst_palette,\n      wuffs_base__slice_u8 src) const;\n#endif  // __cplusplus\n\n} wuffs_base__pixel_swizzler;\n\n// wuffs_base__pixel_swizzler__prepare readies the pixel swizzler so that its\n// other methods may be called.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__PIXCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__status  //\nwuffs_base__pixel_swizzler__prepare(wuffs_base__pixel_swizzler* p,\n                                    wuffs_base__pixel_format dst_pixfmt,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_pixfmt,\n                                    wuffs_base_" +
	"_slice_u8 src_palette,\n                                    wuffs_base__pixel_blend blend);\n\n// wuffs_base__pixel_swizzler__swizzle_interleaved_from_slice converts pixels\n// from a source format to a destination format.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__PIXCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC uint64_t  //\nwuffs_base__pixel_swizzler__swizzle_interleaved_from_slice(\n    const wuffs_base__pixel_swizzler* p,\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src);\n\n#ifdef __cplusplus\n\ninline wuffs_base__status  //\nwuffs_base__pixel_swizzler::prepare(wuffs_base__pixel_format dst_pixfmt,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_pixfmt,\n                                    wuffs_base__slice_u8 src_palette,\n                             " +
	"       wuffs_base__pixel_blend blend) {\n  return wuffs_base__pixel_swizzler__prepare(this, dst_pixfmt, dst_palette,\n                                             src_pixfmt, src_palette, blend);\n}\n\nuint64_t  //\nwuffs_base__pixel_swizzler::swizzle_interleaved_from_slice(\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src) const {\n  return wuffs_base__pixel_swizzler__swizzle_interleaved_from_slice(\n      this, dst, dst_palette, src);\n}\n\n#endif  // __cplusplus\n" +
	""

const BaseIOPrivateH = "" +
	"// ---------------- I/O\n\nstatic inline uint64_t  //\nwuffs_base__io__count_since(uint64_t mark, uint64_t index) {\n  if (index >= mark) {\n    return index - mark;\n  }\n  return 0;\n}\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__io__since(uint64_t mark, uint64_t index, uint8_t* ptr) {\n  if (index >= mark) {\n    return wuffs_base__make_slice_u8(ptr + mark, index - mark);\n  }\n  return wuffs_base__make_slice_u8(NULL, 0);\n}\n\n" +
	"" +
	"// --------\n\nstatic inline uint32_t  //\nwuffs_base__io_reader__limited_copy_u32_to_slice(const uint8_t** ptr_iop_r,\n                                                 const uint8_t* io2_r,\n                                                 uint32_t length,\n                                                 wuffs_base__slice_u8 dst) {\n  const uint8_t* iop_r = *ptr_iop_r;\n  size_t n = dst.len;\n  if (n > length) {\n    n = length;\n  }\n  if (n > ((size_t)(io2_r - iop_r))) {\n    n = (size_t)(io2_r - iop_r);\n  }\n  if (n > 0) {\n    memmove(dst.ptr, iop_r, n);\n    *ptr_iop_r += n;\n  }\n  return (uint32_t)(n);\n}\n\n// wuffs_base__io_reader__match7 returns whether the io_reader's upcoming bytes\n// start with the given prefix (up to 7 bytes long). It is peek-like, not\n// read-like, in that there are no side-effects.\n//\n// The low 3 bits of a hold the prefix length, n.\n//\n// The high 56 bits of a hold the prefix itself, in little-endian order. The\n// first prefix byte is in bits 8..=15, the second prefix byte is in bits\n// 16..=23" +
	", etc. The high (8 * (7 - n)) bits are ignored.\n//\n// There are three possible return values:\n//  - 0 means success.\n//  - 1 means inconclusive, equivalent to \"$short read\".\n//  - 2 means failure.\nstatic inline uint32_t  //\nwuffs_base__io_reader__match7(const uint8_t* iop_r,\n                              const uint8_t* io2_r,\n                              wuffs_base__io_buffer* r,\n                              uint64_t a) {\n  uint32_t n = a & 7;\n  a >>= 8;\n  if ((io2_r - iop_r) >= 8) {\n    uint64_t x = wuffs_base__load_u64le__no_bounds_check(iop_r);\n    uint32_t shift = 8 * (8 - n);\n    return ((a << shift) == (x << shift)) ? 0 : 2;\n  }\n  for (; n > 0; n--) {\n    if (iop_r >= io2_r) {\n      return (r && r->meta.closed) ? 2 : 1;\n    } else if (*iop_r != ((uint8_t)(a))) {\n      return 2;\n    }\n    iop_r++;\n    a >>= 8;\n  }\n  return 0;\n}\n\nstatic inline wuffs_base__io_buffer*  //\nwuffs_base__io_reader__set(wuffs_base__io_buffer* b,\n                           const uint8_t** ptr_iop_r,\n                           c" +
	"onst uint8_t** ptr_io0_r,\n                           const uint8_t** ptr_io1_r,\n                           const uint8_t** ptr_io2_r,\n                           wuffs_base__slice_u8 data) {\n  b->data = data;\n  b->meta.wi = data.len;\n  b->meta.ri = 0;\n  b->meta.pos = 0;\n  b->meta.closed = false;\n\n  *ptr_iop_r = data.ptr;\n  *ptr_io0_r = data.ptr;\n  *ptr_io1_r = data.ptr;\n  *ptr_io2_r = data.ptr + data.len;\n\n  return b;\n}\n\n" +
	"" +
	"// --------\n\nstatic inline uint64_t  //\nwuffs_base__io_writer__copy_from_slice(uint8_t** ptr_iop_w,\n                                       uint8_t* io2_w,\n                                       wuffs_base__slice_u8 src) {\n  uint8_t* iop_w = *ptr_iop_w;\n  size_t n = src.len;\n  if (n > ((size_t)(io2_w - iop_w))) {\n    n = (size_t)(io2_w - iop_w);\n  }\n  if (n > 0) {\n    memmove(iop_w, src.ptr, n);\n    *ptr_iop_w += n;\n  }\n  return (uint64_t)(n);\n}\n\nstatic inline uint32_t  //\nwuffs_base__io_writer__limited_copy_u32_from_history(uint8_t** ptr_iop_w,\n                                                     uint8_t* io1_w,\n                                                     uint8_t* io2_w,\n                                                     uint32_t length,\n                                                     uint32_t distance) {\n  if (!distance) {\n    return 0;\n  }\n  uint8_t* p = *ptr_iop_w;\n  if ((size_t)(p - io1_w) < (size_t)(distance)) {\n    return 0;\n  }\n  uint8_t* q = p - distance;\n  size_t n = (size_t)(io2_w - " +
	"p);\n  if ((size_t)(length) > n) {\n    length = (uint32_t)(n);\n  } else {\n    n = (size_t)(length);\n  }\n  // TODO: unrolling by 3 seems best for the std/deflate benchmarks, but that\n  // is mostly because 3 is the minimum length for the deflate format. This\n  // function implementation shouldn't overfit to that one format. Perhaps the\n  // limited_copy_u32_from_history Wuffs method should also take an unroll hint\n  // argument, and the cgen can look if that argument is the constant\n  // expression '3'.\n  //\n  // See also wuffs_base__io_writer__limited_copy_u32_from_history_fast below.\n  //\n  // Alternatively or additionally, have a sloppy_limited_copy_u32_from_history\n  // method that copies 8 bytes at a time, which can more than length bytes?\n  for (; n >= 3; n -= 3) {\n    *p++ = *q++;\n    *p++ = *q++;\n    *p++ = *q++;\n  }\n  for (; n; n--) {\n    *p++ = *q++;\n  }\n  *ptr_iop_w = p;\n  return length;\n}\n\n// wuffs_base__io_writer__limited_copy_u32_from_history_fast is like the\n// wuffs_base__io_writer__limited_copy" +
	"_u32_from_history function above, but has\n// stronger pre-conditions. The caller needs to prove that:\n//  - distance >  0\n//  - distance <= (*ptr_iop_w - io1_w)\n//  - length   <= (io2_w      - *ptr_iop_w)\nstatic inline uint32_t  //\nwuffs_base__io_writer__limited_copy_u32_from_history_fast(uint8_t** ptr_iop_w,\n                                                          uint8_t* io1_w,\n                                                          uint8_t* io2_w,\n                                                          uint32_t length,\n                                                          uint32_t distance) {\n  uint8_t* p = *ptr_iop_w;\n  uint8_t* q = p - distance;\n  uint32_t n = length;\n  for (; n >= 3; n -= 3) {\n    *p++ = *q++;\n    *p++ = *q++;\n    *p++ = *q++;\n  }\n  for (; n; n--) {\n    *p++ = *q++;\n  }\n  *ptr_iop_w = p;\n  return length;\n}\n\nstatic inline uint32_t  //\nwuffs_base__io_writer__limited_copy_u32_from_reader(uint8_t** ptr_iop_w,\n                                                    uint8_t* io2_w,\n    " +
	"                                                uint32_t length,\n                                                    const uint8_t** ptr_iop_r,\n                                                    const uint8_t* io2_r) {\n  uint8_t* iop_w = *ptr_iop_w;\n  size_t n = length;\n  if (n > ((size_t)(io2_w - iop_w))) {\n    n = (size_t)(io2_w - iop_w);\n  }\n  const uint8_t* iop_r = *ptr_iop_r;\n  if (n > ((size_t)(io2_r - iop_r))) {\n    n = (size_t)(io2_r - iop_r);\n  }\n  if (n > 0) {\n    memmove(iop_w, iop_r, n);\n    *ptr_iop_w += n;\n    *ptr_iop_r += n;\n  }\n  return (uint32_t)(n);\n}\n\nstatic inline uint32_t  //\nwuffs_base__io_writer__limited_copy_u32_from_slice(uint8_t** ptr_iop_w,\n                                                   uint8_t* io2_w,\n                                                   uint32_t length,\n                                                   wuffs_base__slice_u8 src) {\n  uint8_t* iop_w = *ptr_iop_w;\n  size_t n = src.len;\n  if (n > length) {\n    n = length;\n  }\n  if (n > ((size_t)(io2_w - iop_w))) {\n" +
	"    n = (size_t)(io2_w - iop_w);\n  }\n  if (n > 0) {\n    memmove(iop_w, src.ptr, n);\n    *ptr_iop_w += n;\n  }\n  return (uint32_t)(n);\n}\n\nstatic inline wuffs_base__io_buffer*  //\nwuffs_base__io_writer__set(wuffs_base__io_buffer* b,\n                           uint8_t** ptr_iop_w,\n                           uint8_t** ptr_io0_w,\n                           uint8_t** ptr_io1_w,\n                           uint8_t** ptr_io2_w,\n                           wuffs_base__slice_u8 data) {\n  b->data = data;\n  b->meta.wi = 0;\n  b->meta.ri = 0;\n  b->meta.pos = 0;\n  b->meta.closed = false;\n\n  *ptr_iop_w = data.ptr;\n  *ptr_io0_w = data.ptr;\n  *ptr_io1_w = data.ptr;\n  *ptr_io2_w = data.ptr + data.len;\n\n  return b;\n}\n\n" +
	"" +
	"// ---------------- I/O (Utility)\n\n#define wuffs_base__utility__empty_io_reader wuffs_base__empty_io_reader\n#define wuffs_base__utility__empty_io_writer wuffs_base__empty_io_writer\n" +
	""

const BaseIOPublicH = "" +
	"// ---------------- I/O\n//\n// See (/doc/note/io-input-output.md).\n\n// wuffs_base__io_buffer_meta is the metadata for a wuffs_base__io_buffer's\n// data.\ntypedef struct {\n  size_t wi;     // Write index. Invariant: wi <= len.\n  size_t ri;     // Read  index. Invariant: ri <= wi.\n  uint64_t pos;  // Buffer position (relative to the start of stream).\n  bool closed;   // No further writes are expected.\n} wuffs_base__io_buffer_meta;\n\n// wuffs_base__io_buffer is a 1-dimensional buffer (a pointer and length) plus\n// additional metadata.\n//\n// A value with all fields zero is a valid, empty buffer.\ntypedef struct {\n  wuffs_base__slice_u8 data;\n  wuffs_base__io_buffer_meta meta;\n\n#ifdef __cplusplus\n  inline bool is_valid() const;\n  inline void compact();\n  inline size_t reader_length() const;\n  inline uint8_t* reader_pointer() const;\n  inline uint64_t reader_position() const;\n  inline wuffs_base__slice_u8 reader_slice() const;\n  inline size_t writer_length() const;\n  inline uint8_t* writer_pointer() const;\n  inline uint" +
	"64_t writer_position() const;\n  inline wuffs_base__slice_u8 writer_slice() const;\n\n  // Deprecated: use reader_position.\n  inline uint64_t reader_io_position() const;\n  // Deprecated: use writer_position.\n  inline uint64_t writer_io_position() const;\n#endif  // __cplusplus\n\n} wuffs_base__io_buffer;\n\nstatic inline wuffs_base__io_buffer  //\nwuffs_base__make_io_buffer(wuffs_base__slice_u8 data,\n                           wuffs_base__io_buffer_meta meta) {\n  wuffs_base__io_buffer ret;\n  ret.data = data;\n  ret.meta = meta;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer_meta  //\nwuffs_base__make_io_buffer_meta(size_t wi,\n                                size_t ri,\n                                uint64_t pos,\n                                bool closed) {\n  wuffs_base__io_buffer_meta ret;\n  ret.wi = wi;\n  ret.ri = ri;\n  ret.pos = pos;\n  ret.closed = closed;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer  //\nwuffs_base__ptr_u8__reader(uint8_t* ptr, size_t len, bool closed) {\n  wuffs_base__io_buffer ret;\n " +
	" ret.data.ptr = ptr;\n  ret.data.len = len;\n  ret.meta.wi = len;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = closed;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer  //\nwuffs_base__ptr_u8__writer(uint8_t* ptr, size_t len) {\n  wuffs_base__io_buffer ret;\n  ret.data.ptr = ptr;\n  ret.data.len = len;\n  ret.meta.wi = 0;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = false;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer  //\nwuffs_base__slice_u8__reader(wuffs_base__slice_u8 s, bool closed) {\n  wuffs_base__io_buffer ret;\n  ret.data.ptr = s.ptr;\n  ret.data.len = s.len;\n  ret.meta.wi = s.len;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = closed;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer  //\nwuffs_base__slice_u8__writer(wuffs_base__slice_u8 s) {\n  wuffs_base__io_buffer ret;\n  ret.data.ptr = s.ptr;\n  ret.data.len = s.len;\n  ret.meta.wi = 0;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = false;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer  //\n" +
	"wuffs_base__empty_io_buffer() {\n  wuffs_base__io_buffer ret;\n  ret.data.ptr = NULL;\n  ret.data.len = 0;\n  ret.meta.wi = 0;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = false;\n  return ret;\n}\n\nstatic inline wuffs_base__io_buffer_meta  //\nwuffs_base__empty_io_buffer_meta() {\n  wuffs_base__io_buffer_meta ret;\n  ret.wi = 0;\n  ret.ri = 0;\n  ret.pos = 0;\n  ret.closed = false;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__io_buffer__is_valid(const wuffs_base__io_buffer* buf) {\n  if (buf) {\n    if (buf->data.ptr) {\n      return (buf->meta.ri <= buf->meta.wi) && (buf->meta.wi <= buf->data.len);\n    } else {\n      return (buf->meta.ri == 0) && (buf->meta.wi == 0) && (buf->data.len == 0);\n    }\n  }\n  return false;\n}\n\n// wuffs_base__io_buffer__compact moves any written but unread bytes to the\n// start of the buffer.\nstatic inline void  //\nwuffs_base__io_buffer__compact(wuffs_base__io_buffer* buf) {\n  if (!buf || (buf->meta.ri == 0)) {\n    return;\n  }\n  buf->meta.pos = wuffs_base__u64__sat_add(buf->met" +
	"a.pos, buf->meta.ri);\n  size_t n = buf->meta.wi - buf->meta.ri;\n  if (n != 0) {\n    memmove(buf->data.ptr, buf->data.ptr + buf->meta.ri, n);\n  }\n  buf->meta.wi = n;\n  buf->meta.ri = 0;\n}\n\n// Deprecated. Use wuffs_base__io_buffer__reader_position.\nstatic inline uint64_t  //\nwuffs_base__io_buffer__reader_io_position(const wuffs_base__io_buffer* buf) {\n  return buf ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.ri) : 0;\n}\n\nstatic inline size_t  //\nwuffs_base__io_buffer__reader_length(const wuffs_base__io_buffer* buf) {\n  return buf ? buf->meta.wi - buf->meta.ri : 0;\n}\n\nstatic inline uint8_t*  //\nwuffs_base__io_buffer__reader_pointer(const wuffs_base__io_buffer* buf) {\n  return buf ? (buf->data.ptr + buf->meta.ri) : NULL;\n}\n\nstatic inline uint64_t  //\nwuffs_base__io_buffer__reader_position(const wuffs_base__io_buffer* buf) {\n  return buf ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.ri) : 0;\n}\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__io_buffer__reader_slice(const wuffs_base__io_buffer* buf) " +
	"{\n  return buf ? wuffs_base__make_slice_u8(buf->data.ptr + buf->meta.ri,\n                                         buf->meta.wi - buf->meta.ri)\n             : wuffs_base__empty_slice_u8();\n}\n\n// Deprecated. Use wuffs_base__io_buffer__writer_position.\nstatic inline uint64_t  //\nwuffs_base__io_buffer__writer_io_position(const wuffs_base__io_buffer* buf) {\n  return buf ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.wi) : 0;\n}\n\nstatic inline size_t  //\nwuffs_base__io_buffer__writer_length(const wuffs_base__io_buffer* buf) {\n  return buf ? buf->data.len - buf->meta.wi : 0;\n}\n\nstatic inline uint8_t*  //\nwuffs_base__io_buffer__writer_pointer(const wuffs_base__io_buffer* buf) {\n  return buf ? (buf->data.ptr + buf->meta.wi) : NULL;\n}\n\nstatic inline uint64_t  //\nwuffs_base__io_buffer__writer_position(const wuffs_base__io_buffer* buf) {\n  return buf ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.wi) : 0;\n}\n\nstatic inline wuffs_base__slice_u8  //\nwuffs_base__io_buffer__writer_slice(const wuffs_base__io_buffer* b" +
	"uf) {\n  return buf ? wuffs_base__make_slice_u8(buf->data.ptr + buf->meta.wi,\n                                         buf->data.len - buf->meta.wi)\n             : wuffs_base__empty_slice_u8();\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__io_buffer::is_valid() const {\n  return wuffs_base__io_buffer__is_valid(this);\n}\n\ninline void  //\nwuffs_base__io_buffer::compact() {\n  wuffs_base__io_buffer__compact(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::reader_io_position() const {\n  return wuffs_base__io_buffer__reader_io_position(this);\n}\n\ninline size_t  //\nwuffs_base__io_buffer::reader_length() const {\n  return wuffs_base__io_buffer__reader_length(this);\n}\n\ninline uint8_t*  //\nwuffs_base__io_buffer::reader_pointer() const {\n  return wuffs_base__io_buffer__reader_pointer(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::reader_position() const {\n  return wuffs_base__io_buffer__reader_position(this);\n}\n\ninline wuffs_base__slice_u8  //\nwuffs_base__io_buffer::reader_slice() const {\n  return wuffs_base__" +
	"io_buffer__reader_slice(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::writer_io_position() const {\n  return wuffs_base__io_buffer__writer_io_position(this);\n}\n\ninline size_t  //\nwuffs_base__io_buffer::writer_length() const {\n  return wuffs_base__io_buffer__writer_length(this);\n}\n\ninline uint8_t*  //\nwuffs_base__io_buffer::writer_pointer() const {\n  return wuffs_base__io_buffer__writer_pointer(this);\n}\n\ninline uint64_t  //\nwuffs_base__io_buffer::writer_position() const {\n  return wuffs_base__io_buffer__writer_position(this);\n}\n\ninline wuffs_base__slice_u8  //\nwuffs_base__io_buffer::writer_slice() const {\n  return wuffs_base__io_buffer__writer_slice(this);\n}\n\n#endif  // __cplusplus\n" +
	""

const BaseRangePrivateH = "" +
	"// ---------------- Ranges and Rects\n\nstatic inline uint32_t  //\nwuffs_base__range_ii_u32__get_min_incl(const wuffs_base__range_ii_u32* r) {\n  return r->min_incl;\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ii_u32__get_max_incl(const wuffs_base__range_ii_u32* r) {\n  return r->max_incl;\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ie_u32__get_min_incl(const wuffs_base__range_ie_u32* r) {\n  return r->min_incl;\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ie_u32__get_max_excl(const wuffs_base__range_ie_u32* r) {\n  return r->max_excl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ii_u64__get_min_incl(const wuffs_base__range_ii_u64* r) {\n  return r->min_incl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ii_u64__get_max_incl(const wuffs_base__range_ii_u64* r) {\n  return r->max_incl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ie_u64__get_min_incl(const wuffs_base__range_ie_u64* r) {\n  return r->min_incl;\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ie_u64__get_max_excl(const wuffs_base__range_" +
	"ie_u64* r) {\n  return r->max_excl;\n}\n\n" +
	"" +
	"// ---------------- Ranges and Rects (Utility)\n\n#define wuffs_base__utility__empty_range_ii_u32 wuffs_base__empty_range_ii_u32\n#define wuffs_base__utility__empty_range_ie_u32 wuffs_base__empty_range_ie_u32\n#define wuffs_base__utility__empty_range_ii_u64 wuffs_base__empty_range_ii_u64\n#define wuffs_base__utility__empty_range_ie_u64 wuffs_base__empty_range_ie_u64\n#define wuffs_base__utility__empty_rect_ii_u32 wuffs_base__empty_rect_ii_u32\n#define wuffs_base__utility__empty_rect_ie_u32 wuffs_base__empty_rect_ie_u32\n#define wuffs_base__utility__make_range_ii_u32 wuffs_base__make_range_ii_u32\n#define wuffs_base__utility__make_range_ie_u32 wuffs_base__make_range_ie_u32\n#define wuffs_base__utility__make_range_ii_u64 wuffs_base__make_range_ii_u64\n#define wuffs_base__utility__make_range_ie_u64 wuffs_base__make_range_ie_u64\n#define wuffs_base__utility__make_rect_ii_u32 wuffs_base__make_rect_ii_u32\n#define wuffs_base__utility__make_rect_ie_u32 wuffs_base__make_rect_ie_u32\n" +
	""

const BaseRangePublicH = "" +
	"// ---------------- Ranges and Rects\n\n// See https://github.com/google/wuffs/blob/master/doc/note/ranges-and-rects.md\n\ntypedef struct wuffs_base__range_ii_u32__struct {\n  uint32_t min_incl;\n  uint32_t max_incl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ii_u32__struct s) const;\n  inline wuffs_base__range_ii_u32__struct intersect(\n      wuffs_base__range_ii_u32__struct s) const;\n  inline wuffs_base__range_ii_u32__struct unite(\n      wuffs_base__range_ii_u32__struct s) const;\n  inline bool contains(uint32_t x) const;\n  inline bool contains_range(wuffs_base__range_ii_u32__struct s) const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ii_u32;\n\nstatic inline wuffs_base__range_ii_u32  //\nwuffs_base__empty_range_ii_u32() {\n  wuffs_base__range_ii_u32 ret;\n  ret.min_incl = 0;\n  ret.max_incl = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__range_ii_u32  //\nwuffs_base__make_range_ii_u32(uint32_t min_incl, uint32_t max_incl) {\n  wuffs_base__range_ii_u32 ret;\n  ret.min_incl = m" +
	"in_incl;\n  ret.max_incl = max_incl;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__is_empty(const wuffs_base__range_ii_u32* r) {\n  return r->min_incl > r->max_incl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__equals(const wuffs_base__range_ii_u32* r,\n                                 wuffs_base__range_ii_u32 s) {\n  return (r->min_incl == s.min_incl && r->max_incl == s.max_incl) ||\n         (wuffs_base__range_ii_u32__is_empty(r) &&\n          wuffs_base__range_ii_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32__intersect(const wuffs_base__range_ii_u32* r,\n                                    wuffs_base__range_ii_u32 s) {\n  wuffs_base__range_ii_u32 t;\n  t.min_incl = wuffs_base__u32__max(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u32__min(r->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32__unite(const wuffs_base__range_ii_u32* r,\n                                wuffs_base__range_" +
	"ii_u32 s) {\n  if (wuffs_base__range_ii_u32__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__range_ii_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ii_u32 t;\n  t.min_incl = wuffs_base__u32__min(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u32__max(r->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__contains(const wuffs_base__range_ii_u32* r,\n                                   uint32_t x) {\n  return (r->min_incl <= x) && (x <= r->max_incl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u32__contains_range(const wuffs_base__range_ii_u32* r,\n                                         wuffs_base__range_ii_u32 s) {\n  return wuffs_base__range_ii_u32__equals(\n      &s, wuffs_base__range_ii_u32__intersect(r, s));\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ii_u32::is_empty() const {\n  return wuffs_base__range_ii_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__range_ii_u32::equals(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__rang" +
	"e_ii_u32__equals(this, s);\n}\n\ninline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32::intersect(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__range_ii_u32__intersect(this, s);\n}\n\ninline wuffs_base__range_ii_u32  //\nwuffs_base__range_ii_u32::unite(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__range_ii_u32__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ii_u32::contains(uint32_t x) const {\n  return wuffs_base__range_ii_u32__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ii_u32::contains_range(wuffs_base__range_ii_u32 s) const {\n  return wuffs_base__range_ii_u32__contains_range(this, s);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__range_ie_u32__struct {\n  uint32_t min_incl;\n  uint32_t max_excl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ie_u32__struct s) const;\n  inline wuffs_base__range_ie_u32__struct intersect(\n      wuffs_base__range_ie_u32__struct s) const;\n  inline wuffs_base__range_ie_u32__struct unite(\n      wuffs_base__range_ie_u32__struct s) const;\n  inline bool contains(uint32_t x) const;\n  inline bool contains_range(wuffs_base__range_ie_u32__struct s) const;\n  inline uint32_t length() const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ie_u32;\n\nstatic inline wuffs_base__range_ie_u32  //\nwuffs_base__empty_range_ie_u32() {\n  wuffs_base__range_ie_u32 ret;\n  ret.min_incl = 0;\n  ret.max_excl = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__range_ie_u32  //\nwuffs_base__make_range_ie_u32(uint32_t min_incl, uint32_t max_excl) {\n  wuffs_base__range_ie_u32 ret;\n  ret.min_incl = min_incl;\n  ret.max_excl = max_excl;\n  return ret;\n}\n\nstatic inline bool " +
	" //\nwuffs_base__range_ie_u32__is_empty(const wuffs_base__range_ie_u32* r) {\n  return r->min_incl >= r->max_excl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u32__equals(const wuffs_base__range_ie_u32* r,\n                                 wuffs_base__range_ie_u32 s) {\n  return (r->min_incl == s.min_incl && r->max_excl == s.max_excl) ||\n         (wuffs_base__range_ie_u32__is_empty(r) &&\n          wuffs_base__range_ie_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ie_u32  //\nwuffs_base__range_ie_u32__intersect(const wuffs_base__range_ie_u32* r,\n                                    wuffs_base__range_ie_u32 s) {\n  wuffs_base__range_ie_u32 t;\n  t.min_incl = wuffs_base__u32__max(r->min_incl, s.min_incl);\n  t.max_excl = wuffs_base__u32__min(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ie_u32  //\nwuffs_base__range_ie_u32__unite(const wuffs_base__range_ie_u32* r,\n                                wuffs_base__range_ie_u32 s) {\n  if (wuffs_base__range_ie_u32__is_empty(r)) {\n    return s" +
	";\n  }\n  if (wuffs_base__range_ie_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ie_u32 t;\n  t.min_incl = wuffs_base__u32__min(r->min_incl, s.min_incl);\n  t.max_excl = wuffs_base__u32__max(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u32__contains(const wuffs_base__range_ie_u32* r,\n                                   uint32_t x) {\n  return (r->min_incl <= x) && (x < r->max_excl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u32__contains_range(const wuffs_base__range_ie_u32* r,\n                                         wuffs_base__range_ie_u32 s) {\n  return wuffs_base__range_ie_u32__equals(\n      &s, wuffs_base__range_ie_u32__intersect(r, s));\n}\n\nstatic inline uint32_t  //\nwuffs_base__range_ie_u32__length(const wuffs_base__range_ie_u32* r) {\n  return wuffs_base__u32__sat_sub(r->max_excl, r->min_incl);\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ie_u32::is_empty() const {\n  return wuffs_base__range_ie_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs" +
	"_base__range_ie_u32::equals(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__equals(this, s);\n}\n\ninline wuffs_base__range_ie_u32  //\nwuffs_base__range_ie_u32::intersect(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__intersect(this, s);\n}\n\ninline wuffs_base__range_ie_u32  //\nwuffs_base__range_ie_u32::unite(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ie_u32::contains(uint32_t x) const {\n  return wuffs_base__range_ie_u32__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ie_u32::contains_range(wuffs_base__range_ie_u32 s) const {\n  return wuffs_base__range_ie_u32__contains_range(this, s);\n}\n\ninline uint32_t  //\nwuffs_base__range_ie_u32::length() const {\n  return wuffs_base__range_ie_u32__length(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__range_ii_u64__struct {\n  uint64_t min_incl;\n  uint64_t max_incl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ii_u64__struct s) const;\n  inline wuffs_base__range_ii_u64__struct intersect(\n      wuffs_base__range_ii_u64__struct s) const;\n  inline wuffs_base__range_ii_u64__struct unite(\n      wuffs_base__range_ii_u64__struct s) const;\n  inline bool contains(uint64_t x) const;\n  inline bool contains_range(wuffs_base__range_ii_u64__struct s) const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ii_u64;\n\nstatic inline wuffs_base__range_ii_u64  //\nwuffs_base__empty_range_ii_u64() {\n  wuffs_base__range_ii_u64 ret;\n  ret.min_incl = 0;\n  ret.max_incl = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__range_ii_u64  //\nwuffs_base__make_range_ii_u64(uint64_t min_incl, uint64_t max_incl) {\n  wuffs_base__range_ii_u64 ret;\n  ret.min_incl = min_incl;\n  ret.max_incl = max_incl;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__is_e" +
	"mpty(const wuffs_base__range_ii_u64* r) {\n  return r->min_incl > r->max_incl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__equals(const wuffs_base__range_ii_u64* r,\n                                 wuffs_base__range_ii_u64 s) {\n  return (r->min_incl == s.min_incl && r->max_incl == s.max_incl) ||\n         (wuffs_base__range_ii_u64__is_empty(r) &&\n          wuffs_base__range_ii_u64__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64__intersect(const wuffs_base__range_ii_u64* r,\n                                    wuffs_base__range_ii_u64 s) {\n  wuffs_base__range_ii_u64 t;\n  t.min_incl = wuffs_base__u64__max(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u64__min(r->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64__unite(const wuffs_base__range_ii_u64* r,\n                                wuffs_base__range_ii_u64 s) {\n  if (wuffs_base__range_ii_u64__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__range_ii_u6" +
	"4__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ii_u64 t;\n  t.min_incl = wuffs_base__u64__min(r->min_incl, s.min_incl);\n  t.max_incl = wuffs_base__u64__max(r->max_incl, s.max_incl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__contains(const wuffs_base__range_ii_u64* r,\n                                   uint64_t x) {\n  return (r->min_incl <= x) && (x <= r->max_incl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ii_u64__contains_range(const wuffs_base__range_ii_u64* r,\n                                         wuffs_base__range_ii_u64 s) {\n  return wuffs_base__range_ii_u64__equals(\n      &s, wuffs_base__range_ii_u64__intersect(r, s));\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ii_u64::is_empty() const {\n  return wuffs_base__range_ii_u64__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__range_ii_u64::equals(wuffs_base__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__equals(this, s);\n}\n\ninline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64::intersect(wuff" +
	"s_base__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__intersect(this, s);\n}\n\ninline wuffs_base__range_ii_u64  //\nwuffs_base__range_ii_u64::unite(wuffs_base__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ii_u64::contains(uint64_t x) const {\n  return wuffs_base__range_ii_u64__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ii_u64::contains_range(wuffs_base__range_ii_u64 s) const {\n  return wuffs_base__range_ii_u64__contains_range(this, s);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__range_ie_u64__struct {\n  uint64_t min_incl;\n  uint64_t max_excl;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__range_ie_u64__struct s) const;\n  inline wuffs_base__range_ie_u64__struct intersect(\n      wuffs_base__range_ie_u64__struct s) const;\n  inline wuffs_base__range_ie_u64__struct unite(\n      wuffs_base__range_ie_u64__struct s) const;\n  inline bool contains(uint64_t x) const;\n  inline bool contains_range(wuffs_base__range_ie_u64__struct s) const;\n  inline uint64_t length() const;\n#endif  // __cplusplus\n\n} wuffs_base__range_ie_u64;\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__empty_range_ie_u64() {\n  wuffs_base__range_ie_u64 ret;\n  ret.min_incl = 0;\n  ret.max_excl = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__make_range_ie_u64(uint64_t min_incl, uint64_t max_excl) {\n  wuffs_base__range_ie_u64 ret;\n  ret.min_incl = min_incl;\n  ret.max_excl = max_excl;\n  return ret;\n}\n\nstatic inline bool " +
	" //\nwuffs_base__range_ie_u64__is_empty(const wuffs_base__range_ie_u64* r) {\n  return r->min_incl >= r->max_excl;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u64__equals(const wuffs_base__range_ie_u64* r,\n                                 wuffs_base__range_ie_u64 s) {\n  return (r->min_incl == s.min_incl && r->max_excl == s.max_excl) ||\n         (wuffs_base__range_ie_u64__is_empty(r) &&\n          wuffs_base__range_ie_u64__is_empty(&s));\n}\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__range_ie_u64__intersect(const wuffs_base__range_ie_u64* r,\n                                    wuffs_base__range_ie_u64 s) {\n  wuffs_base__range_ie_u64 t;\n  t.min_incl = wuffs_base__u64__max(r->min_incl, s.min_incl);\n  t.max_excl = wuffs_base__u64__min(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__range_ie_u64__unite(const wuffs_base__range_ie_u64* r,\n                                wuffs_base__range_ie_u64 s) {\n  if (wuffs_base__range_ie_u64__is_empty(r)) {\n    return s" +
	";\n  }\n  if (wuffs_base__range_ie_u64__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__range_ie_u64 t;\n  t.min_incl = wuffs_base__u64__min(r->min_incl, s.min_incl);\n  t.max_excl = wuffs_base__u64__max(r->max_excl, s.max_excl);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u64__contains(const wuffs_base__range_ie_u64* r,\n                                   uint64_t x) {\n  return (r->min_incl <= x) && (x < r->max_excl);\n}\n\nstatic inline bool  //\nwuffs_base__range_ie_u64__contains_range(const wuffs_base__range_ie_u64* r,\n                                         wuffs_base__range_ie_u64 s) {\n  return wuffs_base__range_ie_u64__equals(\n      &s, wuffs_base__range_ie_u64__intersect(r, s));\n}\n\nstatic inline uint64_t  //\nwuffs_base__range_ie_u64__length(const wuffs_base__range_ie_u64* r) {\n  return wuffs_base__u64__sat_sub(r->max_excl, r->min_incl);\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__range_ie_u64::is_empty() const {\n  return wuffs_base__range_ie_u64__is_empty(this);\n}\n\ninline bool  //\nwuffs" +
	"_base__range_ie_u64::equals(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__equals(this, s);\n}\n\ninline wuffs_base__range_ie_u64  //\nwuffs_base__range_ie_u64::intersect(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__intersect(this, s);\n}\n\ninline wuffs_base__range_ie_u64  //\nwuffs_base__range_ie_u64::unite(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__range_ie_u64::contains(uint64_t x) const {\n  return wuffs_base__range_ie_u64__contains(this, x);\n}\n\ninline bool  //\nwuffs_base__range_ie_u64::contains_range(wuffs_base__range_ie_u64 s) const {\n  return wuffs_base__range_ie_u64__contains_range(this, s);\n}\n\ninline uint64_t  //\nwuffs_base__range_ie_u64::length() const {\n  return wuffs_base__range_ie_u64__length(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__rect_ii_u32__struct {\n  uint32_t min_incl_x;\n  uint32_t min_incl_y;\n  uint32_t max_incl_x;\n  uint32_t max_incl_y;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__rect_ii_u32__struct s) const;\n  inline wuffs_base__rect_ii_u32__struct intersect(\n      wuffs_base__rect_ii_u32__struct s) const;\n  inline wuffs_base__rect_ii_u32__struct unite(\n      wuffs_base__rect_ii_u32__struct s) const;\n  inline bool contains(uint32_t x, uint32_t y) const;\n  inline bool contains_rect(wuffs_base__rect_ii_u32__struct s) const;\n#endif  // __cplusplus\n\n} wuffs_base__rect_ii_u32;\n\nstatic inline wuffs_base__rect_ii_u32  //\nwuffs_base__empty_rect_ii_u32() {\n  wuffs_base__rect_ii_u32 ret;\n  ret.min_incl_x = 0;\n  ret.min_incl_y = 0;\n  ret.max_incl_x = 0;\n  ret.max_incl_y = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__rect_ii_u32  //\nwuffs_base__make_rect_ii_u32(uint32_t min_incl_x,\n                             uint32_t min_incl_y,\n                             " +
	"uint32_t max_incl_x,\n                             uint32_t max_incl_y) {\n  wuffs_base__rect_ii_u32 ret;\n  ret.min_incl_x = min_incl_x;\n  ret.min_incl_y = min_incl_y;\n  ret.max_incl_x = max_incl_x;\n  ret.max_incl_y = max_incl_y;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ii_u32__is_empty(const wuffs_base__rect_ii_u32* r) {\n  return (r->min_incl_x > r->max_incl_x) || (r->min_incl_y > r->max_incl_y);\n}\n\nstatic inline bool  //\nwuffs_base__rect_ii_u32__equals(const wuffs_base__rect_ii_u32* r,\n                                wuffs_base__rect_ii_u32 s) {\n  return (r->min_incl_x == s.min_incl_x && r->min_incl_y == s.min_incl_y &&\n          r->max_incl_x == s.max_incl_x && r->max_incl_y == s.max_incl_y) ||\n         (wuffs_base__rect_ii_u32__is_empty(r) &&\n          wuffs_base__rect_ii_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32__intersect(const wuffs_base__rect_ii_u32* r,\n                                   wuffs_base__rect_ii_u32 s) {\n  wuffs_base__rect_ii_u32" +
	" t;\n  t.min_incl_x = wuffs_base__u32__max(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__max(r->min_incl_y, s.min_incl_y);\n  t.max_incl_x = wuffs_base__u32__min(r->max_incl_x, s.max_incl_x);\n  t.max_incl_y = wuffs_base__u32__min(r->max_incl_y, s.max_incl_y);\n  return t;\n}\n\nstatic inline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32__unite(const wuffs_base__rect_ii_u32* r,\n                               wuffs_base__rect_ii_u32 s) {\n  if (wuffs_base__rect_ii_u32__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__rect_ii_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__rect_ii_u32 t;\n  t.min_incl_x = wuffs_base__u32__min(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__min(r->min_incl_y, s.min_incl_y);\n  t.max_incl_x = wuffs_base__u32__max(r->max_incl_x, s.max_incl_x);\n  t.max_incl_y = wuffs_base__u32__max(r->max_incl_y, s.max_incl_y);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ii_u32__contains(const wuffs_base__rect_ii_u32* r,\n                             " +
	"     uint32_t x,\n                                  uint32_t y) {\n  return (r->min_incl_x <= x) && (x <= r->max_incl_x) && (r->min_incl_y <= y) &&\n         (y <= r->max_incl_y);\n}\n\nstatic inline bool  //\nwuffs_base__rect_ii_u32__contains_rect(const wuffs_base__rect_ii_u32* r,\n                                       wuffs_base__rect_ii_u32 s) {\n  return wuffs_base__rect_ii_u32__equals(\n      &s, wuffs_base__rect_ii_u32__intersect(r, s));\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__rect_ii_u32::is_empty() const {\n  return wuffs_base__rect_ii_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__rect_ii_u32::equals(wuffs_base__rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__equals(this, s);\n}\n\ninline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32::intersect(wuffs_base__rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__intersect(this, s);\n}\n\ninline wuffs_base__rect_ii_u32  //\nwuffs_base__rect_ii_u32::unite(wuffs_base__rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__unite(this, s);" +
	"\n}\n\ninline bool  //\nwuffs_base__rect_ii_u32::contains(uint32_t x, uint32_t y) const {\n  return wuffs_base__rect_ii_u32__contains(this, x, y);\n}\n\ninline bool  //\nwuffs_base__rect_ii_u32::contains_rect(wuffs_base__rect_ii_u32 s) const {\n  return wuffs_base__rect_ii_u32__contains_rect(this, s);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef struct wuffs_base__rect_ie_u32__struct {\n  uint32_t min_incl_x;\n  uint32_t min_incl_y;\n  uint32_t max_excl_x;\n  uint32_t max_excl_y;\n\n#ifdef __cplusplus\n  inline bool is_empty() const;\n  inline bool equals(wuffs_base__rect_ie_u32__struct s) const;\n  inline wuffs_base__rect_ie_u32__struct intersect(\n      wuffs_base__rect_ie_u32__struct s) const;\n  inline wuffs_base__rect_ie_u32__struct unite(\n      wuffs_base__rect_ie_u32__struct s) const;\n  inline bool contains(uint32_t x, uint32_t y) const;\n  inline bool contains_rect(wuffs_base__rect_ie_u32__struct s) const;\n  inline uint32_t width() const;\n  inline uint32_t height() const;\n#endif  // __cplusplus\n\n} wuffs_base__rect_ie_u32;\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__empty_rect_ie_u32() {\n  wuffs_base__rect_ie_u32 ret;\n  ret.min_incl_x = 0;\n  ret.min_incl_y = 0;\n  ret.max_excl_x = 0;\n  ret.max_excl_y = 0;\n  return ret;\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__make_rect_ie_u32(uint32_t min_incl_x,\n            " +
	"                 uint32_t min_incl_y,\n                             uint32_t max_excl_x,\n                             uint32_t max_excl_y) {\n  wuffs_base__rect_ie_u32 ret;\n  ret.min_incl_x = min_incl_x;\n  ret.min_incl_y = min_incl_y;\n  ret.max_excl_x = max_excl_x;\n  ret.max_excl_y = max_excl_y;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__is_empty(const wuffs_base__rect_ie_u32* r) {\n  return (r->min_incl_x >= r->max_excl_x) || (r->min_incl_y >= r->max_excl_y);\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__equals(const wuffs_base__rect_ie_u32* r,\n                                wuffs_base__rect_ie_u32 s) {\n  return (r->min_incl_x == s.min_incl_x && r->min_incl_y == s.min_incl_y &&\n          r->max_excl_x == s.max_excl_x && r->max_excl_y == s.max_excl_y) ||\n         (wuffs_base__rect_ie_u32__is_empty(r) &&\n          wuffs_base__rect_ie_u32__is_empty(&s));\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32__intersect(const wuffs_base__rect_ie_u32* r,\n                    " +
	"               wuffs_base__rect_ie_u32 s) {\n  wuffs_base__rect_ie_u32 t;\n  t.min_incl_x = wuffs_base__u32__max(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__max(r->min_incl_y, s.min_incl_y);\n  t.max_excl_x = wuffs_base__u32__min(r->max_excl_x, s.max_excl_x);\n  t.max_excl_y = wuffs_base__u32__min(r->max_excl_y, s.max_excl_y);\n  return t;\n}\n\nstatic inline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32__unite(const wuffs_base__rect_ie_u32* r,\n                               wuffs_base__rect_ie_u32 s) {\n  if (wuffs_base__rect_ie_u32__is_empty(r)) {\n    return s;\n  }\n  if (wuffs_base__rect_ie_u32__is_empty(&s)) {\n    return *r;\n  }\n  wuffs_base__rect_ie_u32 t;\n  t.min_incl_x = wuffs_base__u32__min(r->min_incl_x, s.min_incl_x);\n  t.min_incl_y = wuffs_base__u32__min(r->min_incl_y, s.min_incl_y);\n  t.max_excl_x = wuffs_base__u32__max(r->max_excl_x, s.max_excl_x);\n  t.max_excl_y = wuffs_base__u32__max(r->max_excl_y, s.max_excl_y);\n  return t;\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__con" +
	"tains(const wuffs_base__rect_ie_u32* r,\n                                  uint32_t x,\n                                  uint32_t y) {\n  return (r->min_incl_x <= x) && (x < r->max_excl_x) && (r->min_incl_y <= y) &&\n         (y < r->max_excl_y);\n}\n\nstatic inline bool  //\nwuffs_base__rect_ie_u32__contains_rect(const wuffs_base__rect_ie_u32* r,\n                                       wuffs_base__rect_ie_u32 s) {\n  return wuffs_base__rect_ie_u32__equals(\n      &s, wuffs_base__rect_ie_u32__intersect(r, s));\n}\n\nstatic inline uint32_t  //\nwuffs_base__rect_ie_u32__width(const wuffs_base__rect_ie_u32* r) {\n  return wuffs_base__u32__sat_sub(r->max_excl_x, r->min_incl_x);\n}\n\nstatic inline uint32_t  //\nwuffs_base__rect_ie_u32__height(const wuffs_base__rect_ie_u32* r) {\n  return wuffs_base__u32__sat_sub(r->max_excl_y, r->min_incl_y);\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__rect_ie_u32::is_empty() const {\n  return wuffs_base__rect_ie_u32__is_empty(this);\n}\n\ninline bool  //\nwuffs_base__rect_ie_u32::equals(wuffs_bas" +
	"e__rect_ie_u32 s) const {\n  return wuffs_base__rect_ie_u32__equals(this, s);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32::intersect(wuffs_base__rect_ie_u32 s) const {\n  return wuffs_base__rect_ie_u32__intersect(this, s);\n}\n\ninline wuffs_base__rect_ie_u32  //\nwuffs_base__rect_ie_u32::unite(wuffs_base__rect_ie_u32 s) const {\n  return wuffs_base__rect_ie_u32__unite(this, s);\n}\n\ninline bool  //\nwuffs_base__rect_ie_u32::contains(uint32_t x, uint32_t y) const {\n  return wuffs_base__rect_ie_u32__contains(this, x, y);\n}\n\ninline bool  //\nwuffs_base__rect_ie_u32::contains_rect(wuffs_base__rect_ie_u32 s) const {\n  return wuffs_base__rect_ie_u32__contains_rect(this, s);\n}\n\ninline uint32_t  //\nwuffs_base__rect_ie_u32::width() const {\n  return wuffs_base__rect_ie_u32__width(this);\n}\n\ninline uint32_t  //\nwuffs_base__rect_ie_u32::height() const {\n  return wuffs_base__rect_ie_u32__height(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// ---------------- More Information\n\n// wuffs_base__more_information holds additional fields, typically when a Wuffs\n// method returns a [note status](/doc/note/statuses.md).\n//\n// The flavor field follows the base38 namespace\n// convention](/doc/note/base38-and-fourcc.md). The other fields' semantics\n// depends on the flavor.\ntypedef struct {\n  uint32_t flavor;\n  uint32_t w;\n  uint64_t x;\n  uint64_t y;\n  uint64_t z;\n\n#ifdef __cplusplus\n  inline void set(uint32_t flavor_arg,\n                  uint32_t w_arg,\n                  uint64_t x_arg,\n                  uint64_t y_arg,\n                  uint64_t z_arg);\n  inline uint32_t io_redirect__fourcc() const;\n  inline wuffs_base__range_ie_u64 io_redirect__range() const;\n  inline uint64_t io_seek__position() const;\n  inline uint32_t metadata__fourcc() const;\n  inline wuffs_base__range_ie_u64 metadata__range() const;\n#endif  // __cplusplus\n\n} wuffs_base__more_information;\n\n#define WUFFS_BASE__MORE_INFORMATION__FLAVOR__IO_REDIRECT 1\n#define WUFFS_BASE__MORE_INFORMA" +
	"TION__FLAVOR__IO_SEEK 2\n#define WUFFS_BASE__MORE_INFORMATION__FLAVOR__METADATA 3\n\nstatic inline wuffs_base__more_information  //\nwuffs_base__empty_more_information() {\n  wuffs_base__more_information ret;\n  ret.flavor = 0;\n  ret.w = 0;\n  ret.x = 0;\n  ret.y = 0;\n  ret.z = 0;\n  return ret;\n}\n\nstatic inline void  //\nwuffs_base__more_information__set(wuffs_base__more_information* m,\n                                  uint32_t flavor,\n                                  uint32_t w,\n                                  uint64_t x,\n                                  uint64_t y,\n                                  uint64_t z) {\n  if (!m) {\n    return;\n  }\n  m->flavor = flavor;\n  m->w = w;\n  m->x = x;\n  m->y = y;\n  m->z = z;\n}\n\nstatic inline uint32_t  //\nwuffs_base__more_information__io_redirect__fourcc(\n    const wuffs_base__more_information* m) {\n  return m->w;\n}\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__more_information__io_redirect__range(\n    const wuffs_base__more_information* m) {\n  wuffs_base__range_ie_u64" +
	" ret;\n  ret.min_incl = m->y;\n  ret.max_excl = m->z;\n  return ret;\n}\n\nstatic inline uint64_t  //\nwuffs_base__more_information__io_seek__position(\n    const wuffs_base__more_information* m) {\n  return m->x;\n}\n\nstatic inline uint32_t  //\nwuffs_base__more_information__metadata__fourcc(\n    const wuffs_base__more_information* m) {\n  return m->w;\n}\n\nstatic inline wuffs_base__range_ie_u64  //\nwuffs_base__more_information__metadata__range(\n    const wuffs_base__more_information* m) {\n  wuffs_base__range_ie_u64 ret;\n  ret.min_incl = m->y;\n  ret.max_excl = m->z;\n  return ret;\n}\n\n#ifdef __cplusplus\n\ninline void  //\nwuffs_base__more_information::set(uint32_t flavor_arg,\n                                  uint32_t w_arg,\n                                  uint64_t x_arg,\n                                  uint64_t y_arg,\n                                  uint64_t z_arg) {\n  wuffs_base__more_information__set(this, flavor_arg, w_arg, x_arg, y_arg,\n                                    z_arg);\n}\n\ninline uint32_t  //\nwuffs_base__m" +
	"ore_information::io_redirect__fourcc() const {\n  return wuffs_base__more_information__io_redirect__fourcc(this);\n}\n\ninline wuffs_base__range_ie_u64  //\nwuffs_base__more_information::io_redirect__range() const {\n  return wuffs_base__more_information__io_redirect__range(this);\n}\n\ninline uint64_t  //\nwuffs_base__more_information::io_seek__position() const {\n  return wuffs_base__more_information__io_seek__position(this);\n}\n\ninline uint32_t  //\nwuffs_base__more_information::metadata__fourcc() const {\n  return wuffs_base__more_information__metadata__fourcc(this);\n}\n\ninline wuffs_base__range_ie_u64  //\nwuffs_base__more_information::metadata__range() const {\n  return wuffs_base__more_information__metadata__range(this);\n}\n\n#endif  // __cplusplus\n" +
	""

const BaseStrConvPrivateH = "" +
	"// ---------------- String Conversions\n\n" +
	"" +
	"// ---------------- Unicode and UTF-8\n" +
	""

const BaseStrConvPublicH = "" +
	"// ---------------- String Conversions\n\n// Options (bitwise or'ed together) for wuffs_base__parse_number_xxx\n// functions. The XXX options apply to both integer and floating point. The FXX\n// options apply only to floating point.\n\n#define WUFFS_BASE__PARSE_NUMBER_XXX__DEFAULT_OPTIONS ((uint32_t)0x00000000)\n\n// WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_MULTIPLE_LEADING_ZEROES means to accept\n// inputs like \"00\", \"0644\" and \"00.7\". By default, they are rejected.\n#define WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_MULTIPLE_LEADING_ZEROES \\\n  ((uint32_t)0x00000001)\n\n// WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES means to accept inputs like\n// \"1__2\" and \"_3.141_592\". By default, they are rejected.\n#define WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES ((uint32_t)0x00000002)\n\n// WUFFS_BASE__PARSE_NUMBER_FXX__DECIMAL_SEPARATOR_IS_A_COMMA means to accept\n// \"1,5\" and not \"1.5\" as one-and-a-half.\n//\n// If the caller wants to accept either, it is responsible for canonicalizing\n// the input before calling wuffs_base__parse_numb" +
	"er_fxx. The caller also has\n// more context on e.g. exactly how to treat something like \"$1,234\".\n#define WUFFS_BASE__PARSE_NUMBER_FXX__DECIMAL_SEPARATOR_IS_A_COMMA \\\n  ((uint32_t)0x00000010)\n\n// WUFFS_BASE__PARSE_NUMBER_FXX__REJECT_INF_AND_NAN means to reject inputs that\n// would lead to infinite or Not-a-Number floating point values. By default,\n// they are accepted.\n//\n// This affects the literal \"inf\" as input, but also affects inputs like\n// \"1e999\" that would overflow double-precision floating point.\n#define WUFFS_BASE__PARSE_NUMBER_FXX__REJECT_INF_AND_NAN ((uint32_t)0x00000020)\n\n" +
	"" +
	"// --------\n\n// Options (bitwise or'ed together) for wuffs_base__render_number_xxx\n// functions. The XXX options apply to both integer and floating point. The FXX\n// options apply only to floating point.\n\n#define WUFFS_BASE__RENDER_NUMBER_XXX__DEFAULT_OPTIONS ((uint32_t)0x00000000)\n\n// WUFFS_BASE__RENDER_NUMBER_XXX__ALIGN_RIGHT means to render to the right side\n// (higher indexes) of the destination slice, leaving any untouched bytes on\n// the left side (lower indexes). The default is vice versa: rendering on the\n// left with slack on the right.\n#define WUFFS_BASE__RENDER_NUMBER_XXX__ALIGN_RIGHT ((uint32_t)0x00000100)\n\n// WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN means to render the leading\n// \"+\" for non-negative numbers: \"+0\" and \"+12.3\" instead of \"0\" and \"12.3\".\n#define WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN ((uint32_t)0x00000200)\n\n// WUFFS_BASE__RENDER_NUMBER_FXX__DECIMAL_SEPARATOR_IS_A_COMMA means to render\n// one-and-a-half as \"1,5\" instead of \"1.5\".\n#define WUFFS_BASE__RENDER_NUMBER_F" +
	"XX__DECIMAL_SEPARATOR_IS_A_COMMA \\\n  ((uint32_t)0x00001000)\n\n// WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_ETC means whether to never\n// (EXPONENT_ABSENT, equivalent to printf's \"%f\") or to always\n// (EXPONENT_PRESENT, equivalent to printf's \"%e\") render a floating point\n// number as \"1.23e+05\" instead of \"123000\".\n//\n// Having both bits set is the same has having neither bit set, where the\n// notation used depends on whether the exponent is sufficiently large: \"0.5\"\n// is preferred over \"5e-01\" but \"5e-09\" is preferred over \"0.000000005\".\n#define WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_ABSENT ((uint32_t)0x00002000)\n#define WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_PRESENT ((uint32_t)0x00004000)\n\n// WUFFS_BASE__RENDER_NUMBER_FXX__JUST_ENOUGH_PRECISION means to render the\n// smallest number of digits so that parsing the resultant string will recover\n// the same double-precision floating point number.\n//\n// For example, double-precision cannot distinguish between 0.3 and\n// 0.2999999999999999888977697537484345957636" +
	"83319091796875, so when this bit\n// is set, rendering the latter will produce \"0.3\" but rendering\n// 0.3000000000000000444089209850062616169452667236328125 will produce\n// \"0.30000000000000004\".\n#define WUFFS_BASE__RENDER_NUMBER_FXX__JUST_ENOUGH_PRECISION \\\n  ((uint32_t)0x00008000)\n\n" +
	"" +
	"// ---------------- IEEE 754 Floating Point\n\n// wuffs_base__ieee_754_bit_representation__etc converts between a double\n// precision numerical value and its IEEE 754 representations:\n//   - 16-bit: 1 sign bit,  5 exponent bits, 10 explicit significand bits.\n//   - 32-bit: 1 sign bit,  8 exponent bits, 23 explicit significand bits.\n//   - 64-bit: 1 sign bit, 11 exponent bits, 52 explicit significand bits.\n//\n// For example, it converts between:\n//  - +1.0 and 0x3C00, 0x3F80_0000 or 0x3FF0_0000_0000_0000.\n//  - +5.5 and 0x4580, 0x40B0_0000 or 0x4016_0000_0000_0000.\n//  - -inf and 0xFC00, 0xFF80_0000 or 0xFFF0_0000_0000_0000.\n//\n// Converting from f64 to shorter formats (f16 or f32, represented in C as\n// uint16_t and uint32_t) may be lossy. Such functions have names that look\n// like etc_truncate, as converting finite numbers produce equal or smaller\n// (closer-to-zero) finite numbers. For example, 1048576.0 is a perfectly valid\n// f64 number, but converting it to a f16 (with truncation) produces 65504.0,\n// the" +
	" largest finite f16 number. Truncating a f64-typed value d to f32 does\n// not always produce the same result as the C-style cast ((float)d), as\n// casting can convert from finite numbers to infinite ones.\n//\n// Converting infinities or NaNs produces infinities or NaNs and always report\n// no loss, even though there a multiple NaN representations so that round-\n// tripping a f64-typed NaN may produce a different 64 bits. Nonetheless, the\n// etc_truncate functions preserve a NaN's \"quiet vs signaling\" bit.\n//\n// See https://en.wikipedia.org/wiki/Double-precision_floating-point_format\n\ntypedef struct {\n  uint16_t value;\n  bool lossy;\n} wuffs_base__lossy_value_u16;\n\ntypedef struct {\n  uint32_t value;\n  bool lossy;\n} wuffs_base__lossy_value_u32;\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__lossy_value_u16  //\nwuffs_base__ieee_754_bit_representation__from_f64_to_u16_truncate(double f);\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__lossy_value_u32  //\nwuffs_base__ieee_754_bit_representation__from_f64_to_u32_truncate(double f);\n\nst" +
	"atic inline uint64_t  //\nwuffs_base__ieee_754_bit_representation__from_f64_to_u64(double f) {\n  uint64_t u = 0;\n  if (sizeof(uint64_t) == sizeof(double)) {\n    memcpy(&u, &f, sizeof(uint64_t));\n  }\n  return u;\n}\n\nstatic inline double  //\nwuffs_base__ieee_754_bit_representation__from_u16_to_f64(uint16_t u) {\n  uint64_t v = ((uint64_t)(u & 0x8000)) << 48;\n\n  do {\n    uint64_t exp = (u >> 10) & 0x1F;\n    uint64_t man = u & 0x3FF;\n    if (exp == 0x1F) {  // Infinity or NaN.\n      exp = 2047;\n    } else if (exp != 0) {  // Normal.\n      exp += 1008;          // 1008 = 1023 - 15, the difference in biases.\n    } else if (man != 0) {  // Subnormal but non-zero.\n      uint32_t clz = wuffs_base__count_leading_zeroes_u64(man);\n      exp = 1062 - clz;  // 1062 = 1008 + 64 - 10.\n      man = 0x3FF & (man << (clz - 53));\n    } else {  // Zero.\n      break;\n    }\n    v |= (exp << 52) | (man << 42);\n  } while (0);\n\n  double f = 0;\n  if (sizeof(uint64_t) == sizeof(double)) {\n    memcpy(&f, &v, sizeof(uint64_t));\n  }\n  return f" +
	";\n}\n\nstatic inline double  //\nwuffs_base__ieee_754_bit_representation__from_u32_to_f64(uint32_t u) {\n  float f = 0;\n  if (sizeof(uint32_t) == sizeof(float)) {\n    memcpy(&f, &u, sizeof(uint32_t));\n  }\n  return (double)f;\n}\n\nstatic inline double  //\nwuffs_base__ieee_754_bit_representation__from_u64_to_f64(uint64_t u) {\n  double f = 0;\n  if (sizeof(uint64_t) == sizeof(double)) {\n    memcpy(&f, &u, sizeof(uint64_t));\n  }\n  return f;\n}\n\n" +
	"" +
	"// ---------------- Parsing and Rendering Numbers\n\n// wuffs_base__parse_number_f64 parses the floating point number in s. For\n// example, if s contains the bytes \"1.5\" then it will return the double 1.5.\n//\n// It returns an error if s does not contain a floating point number.\n//\n// It does not necessarily return an error if the conversion is lossy, e.g. if\n// s is \"0.3\", which double-precision floating point cannot represent exactly.\n//\n// Similarly, the returned value may be infinite (and no error returned) even\n// if s was not \"inf\", when the input is nominally finite but sufficiently\n// larger than DBL_MAX, about 1.8e+308.\n//\n// It is similar to the C standard library's strtod function, but:\n//  - Errors are returned in-band (in a result type), not out-of-band (errno).\n//  - It takes a slice (a pointer and length), not a NUL-terminated C string.\n//  - It does not take an optional endptr argument. It does not allow a partial\n//    parse: it returns an error unless all of s is consumed.\n//  - It does not all" +
	"ow whitespace, leading or otherwise.\n//  - It does not allow hexadecimal floating point numbers.\n//  - It is not affected by i18n / l10n settings such as environment variables.\n//\n// The options argument can change these, but by default, it:\n//  - Allows \"inf\", \"+Infinity\" and \"-NAN\", case insensitive. Similarly,\n//    without an explicit opt-out, it would successfully parse \"1e999\" as\n//    infinity, even though it overflows double-precision floating point.\n//  - Rejects underscores. With an explicit opt-in, \"_3.141_592\" would\n//    successfully parse as an approximation to π.\n//  - Rejects unnecessary leading zeroes: \"00\", \"0644\" and \"00.7\".\n//  - Uses a dot '1.5' instead of a comma '1,5' for the decimal separator.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__FLOATCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__result_f64  //\nwuffs_base__parse_number_f64(wuffs_base__" +
	"slice_u8 s, uint32_t options);\n\n// wuffs_base__parse_number_i64 parses the ASCII integer in s. For example, if\n// s contains the bytes \"-123\" then it will return the int64_t -123.\n//\n// It returns an error if s does not contain an integer or if the integer\n// within would overflow an int64_t.\n//\n// It is similar to wuffs_base__parse_number_u64 but it returns a signed\n// integer, not an unsigned integer. It also allows a leading '+' or '-'.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__result_i64  //\nwuffs_base__parse_number_i64(wuffs_base__slice_u8 s, uint32_t options);\n\n// wuffs_base__parse_number_u64 parses the ASCII integer in s. For example, if\n// s contains the bytes \"123\" then it will return the uint64_t 123.\n//\n// It returns an error if s does not contain an integer or if the integer\n// within would overflow a uin" +
	"t64_t.\n//\n// It is similar to the C standard library's strtoull function, but:\n//  - Errors are returned in-band (in a result type), not out-of-band (errno).\n//  - It takes a slice (a pointer and length), not a NUL-terminated C string.\n//  - It does not take an optional endptr argument. It does not allow a partial\n//    parse: it returns an error unless all of s is consumed.\n//  - It does not allow whitespace, leading or otherwise.\n//  - It does not allow a leading '+' or '-'.\n//  - It does not take a base argument (e.g. base 10 vs base 16). Instead, it\n//    always accepts both decimal (e.g \"1234\", \"0d5678\") and hexadecimal (e.g.\n//    \"0x9aBC\"). The caller is responsible for prior filtering of e.g. hex\n//    numbers if they are unwanted. For example, Wuffs' JSON decoder will only\n//    produce a wuffs_base__token for decimal numbers, not hexadecimal.\n//  - It is not affected by i18n / l10n settings such as environment variables.\n//\n// The options argument can change these, but by default, it:\n//  - Rejects " +
	"underscores. With an explicit opt-in, \"__0D_1_002\" would\n//    successfully parse as \"one thousand and two\". Underscores are still\n//    rejected inside the optional 2-byte opening \"0d\" or \"0X\" that denotes\n//    base-10 or base-16.\n//  - Rejects unnecessary leading zeroes: \"00\" and \"0644\".\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__result_u64  //\nwuffs_base__parse_number_u64(wuffs_base__slice_u8 s, uint32_t options);\n\n" +
	"" +
	"// --------\n\n// WUFFS_BASE__I64__BYTE_LENGTH__MAX_INCL is the string length of\n// \"-9223372036854775808\" and \"+9223372036854775807\", INT64_MIN and INT64_MAX.\n#define WUFFS_BASE__I64__BYTE_LENGTH__MAX_INCL 20\n\n// WUFFS_BASE__U64__BYTE_LENGTH__MAX_INCL is the string length of\n// \"+18446744073709551615\", UINT64_MAX.\n#define WUFFS_BASE__U64__BYTE_LENGTH__MAX_INCL 21\n\n// wuffs_base__render_number_f64 writes the decimal encoding of x to dst and\n// returns the number of bytes written. If dst is shorter than the entire\n// encoding, it returns 0 (and no bytes are written).\n//\n// For those familiar with C's printf or Go's fmt.Printf functions:\n//  - \"%e\" means the WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_PRESENT option.\n//  - \"%f\" means the WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_ABSENT  option.\n//  - \"%g\" means neither or both bits are set.\n//\n// The precision argument controls the number of digits rendered, excluding the\n// exponent (the \"e+05\" in \"1.23e+05\"):\n//  - for \"%e\" and \"%f\" it is the number of digits after t" +
	"he decimal separator,\n//  - for \"%g\" it is the number of significant digits (and trailing zeroes are\n//    removed).\n//\n// A precision of 6 gives similar output to printf's defaults.\n//\n// A precision greater than 4095 is equivalent to 4095.\n//\n// The precision argument is ignored when the\n// WUFFS_BASE__RENDER_NUMBER_FXX__JUST_ENOUGH_PRECISION option is set. This is\n// similar to Go's strconv.FormatFloat with a negative (i.e. non-sensical)\n// precision, but there is no corresponding feature in C's printf.\n//\n// Extreme values of x will be rendered as \"NaN\", \"Inf\" (or \"+Inf\" if the\n// WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN option is set) or \"-Inf\".\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__FLOATCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__render_number_f64(wuffs_base__slice_u8 dst,\n                              double x,\n                      " +
	"        uint32_t precision,\n                              uint32_t options);\n\n// wuffs_base__render_number_i64 writes the decimal encoding of x to dst and\n// returns the number of bytes written. If dst is shorter than the entire\n// encoding, it returns 0 (and no bytes are written).\n//\n// dst will never be too short if its length is at least 20, also known as\n// WUFFS_BASE__I64__BYTE_LENGTH__MAX_INCL.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__render_number_i64(wuffs_base__slice_u8 dst,\n                              int64_t x,\n                              uint32_t options);\n\n// wuffs_base__render_number_u64 writes the decimal encoding of x to dst and\n// returns the number of bytes written. If dst is shorter than the entire\n// encoding, it returns 0 (and no bytes are written).\n//\n// dst will never be too sho" +
	"rt if its length is at least 21, also known as\n// WUFFS_BASE__U64__BYTE_LENGTH__MAX_INCL.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__render_number_u64(wuffs_base__slice_u8 dst,\n                              uint64_t x,\n                              uint32_t options);\n\n" +
	"" +
	"// ---------------- Base-16\n\n// Options (bitwise or'ed together) for wuffs_base__base_16__xxx functions.\n\n#define WUFFS_BASE__BASE_16__DEFAULT_OPTIONS ((uint32_t)0x00000000)\n\n// wuffs_base__base_16__decode2 converts \"6A6b\" to \"jk\", where e.g. 'j' is\n// U+006A. There are 2 src bytes for every dst byte.\n//\n// It assumes that the src bytes are two hexadecimal digits (0-9, A-F, a-f),\n// repeated. It may write nonsense bytes if not, although it will not read or\n// write out of bounds.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__decode2(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options);\n\n// wuffs_base__base_16__decode4 converts both \"\\\\x6A\\\\x6b\" and \"??6a??6B\" " +
	"to\n// \"jk\", where e.g. 'j' is U+006A. There are 4 src bytes for every dst byte.\n//\n// It assumes that the src bytes are two ignored bytes and then two hexadecimal\n// digits (0-9, A-F, a-f), repeated. It may write nonsense bytes if not,\n// although it will not read or write out of bounds.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__decode4(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options);\n\n// wuffs_base__base_16__encode2 converts \"jk\" to \"6A6B\", where e.g. 'j' is\n// U+006A. There are 2 dst bytes for every src byte.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV" +
	" sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__encode2(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options);\n\n// wuffs_base__base_16__encode4 converts \"jk\" to \"\\\\x6A\\\\x6B\", where e.g. 'j'\n// is U+006A. There are 4 dst bytes for every src byte.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__encode2(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options);\n\n" +
	"" +
	"// ---------------- Base-64\n\n// Options (bitwise or'ed together) for wuffs_base__base_64__xxx functions.\n\n#define WUFFS_BASE__BASE_64__DEFAULT_OPTIONS ((uint32_t)0x00000000)\n\n// WUFFS_BASE__BASE_64__DECODE_ALLOW_PADDING means that, when decoding base-64,\n// the input may (but does not need to) be padded with '=' bytes so that the\n// overall encoded length in bytes is a multiple of 4. A successful decoding\n// will return a num_src that includes those padding bytes.\n//\n// Excess padding (e.g. three final '='s) will be rejected as bad data.\n#define WUFFS_BASE__BASE_64__DECODE_ALLOW_PADDING ((uint32_t)0x00000001)\n\n// WUFFS_BASE__BASE_64__ENCODE_EMIT_PADDING means that, when encoding base-64,\n// the output will be padded with '=' bytes so that the overall encoded length\n// in bytes is a multiple of 4.\n#define WUFFS_BASE__BASE_64__ENCODE_EMIT_PADDING ((uint32_t)0x00000002)\n\n// WUFFS_BASE__BASE_64__URL_ALPHABET means that, for base-64, the URL-friendly\n// and file-name-friendly alphabet be used, as per RFC 4648 sect" +
	"ion 5. When\n// this option bit is off, the standard alphabet from section 4 is used.\n#define WUFFS_BASE__BASE_64__URL_ALPHABET ((uint32_t)0x00000100)\n\n// wuffs_base__base_64__decode transforms base-64 encoded bytes from src to\n// arbitrary bytes in dst.\n//\n// It will not permit line breaks or other whitespace in src. Filtering those\n// out is the responsibility of the caller.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_64__decode(wuffs_base__slice_u8 dst,\n                            wuffs_base__slice_u8 src,\n                            bool src_closed,\n                            uint32_t options);\n\n// wuffs_base__base_64__encode transforms arbitrary bytes from src to base-64\n// encoded bytes in dst.\n//\n// For modular builds that divide the base module into sub-modules, using this" +
	"\n// function requires the WUFFS_CONFIG__MODULE__BASE__INTCONV sub-module, not\n// just WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_64__encode(wuffs_base__slice_u8 dst,\n                            wuffs_base__slice_u8 src,\n                            bool src_closed,\n                            uint32_t options);\n\n" +
	"" +
	"// ---------------- Unicode and UTF-8\n\n#define WUFFS_BASE__UNICODE_CODE_POINT__MIN_INCL 0x00000000\n#define WUFFS_BASE__UNICODE_CODE_POINT__MAX_INCL 0x0010FFFF\n\n#define WUFFS_BASE__UNICODE_REPLACEMENT_CHARACTER 0x0000FFFD\n\n#define WUFFS_BASE__UNICODE_SURROGATE__MIN_INCL 0x0000D800\n#define WUFFS_BASE__UNICODE_SURROGATE__MAX_INCL 0x0000DFFF\n\n#define WUFFS_BASE__ASCII__MIN_INCL 0x00\n#define WUFFS_BASE__ASCII__MAX_INCL 0x7F\n\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH__MIN_INCL 1\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL 4\n\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_1__CODE_POINT__MIN_INCL 0x00000000\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_1__CODE_POINT__MAX_INCL 0x0000007F\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_2__CODE_POINT__MIN_INCL 0x00000080\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_2__CODE_POINT__MAX_INCL 0x000007FF\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_3__CODE_POINT__MIN_INCL 0x00000800\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_3__CODE_POINT__MAX_INCL 0x0000FFFF\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_4__CODE_POINT_" +
	"_MIN_INCL 0x00010000\n#define WUFFS_BASE__UTF_8__BYTE_LENGTH_4__CODE_POINT__MAX_INCL 0x0010FFFF\n\n" +
	"" +
	"// --------\n\n// wuffs_base__utf_8__next__output is the type returned by\n// wuffs_base__utf_8__next.\ntypedef struct {\n  uint32_t code_point;\n  uint32_t byte_length;\n\n#ifdef __cplusplus\n  inline bool is_valid() const;\n#endif  // __cplusplus\n\n} wuffs_base__utf_8__next__output;\n\nstatic inline wuffs_base__utf_8__next__output  //\nwuffs_base__make_utf_8__next__output(uint32_t code_point,\n                                     uint32_t byte_length) {\n  wuffs_base__utf_8__next__output ret;\n  ret.code_point = code_point;\n  ret.byte_length = byte_length;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__utf_8__next__output__is_valid(\n    const wuffs_base__utf_8__next__output* o) {\n  if (o) {\n    uint32_t cp = o->code_point;\n    switch (o->byte_length) {\n      case 1:\n        return (cp <= 0x7F);\n      case 2:\n        return (0x080 <= cp) && (cp <= 0x7FF);\n      case 3:\n        // Avoid the 0xD800 ..= 0xDFFF surrogate range.\n        return ((0x0800 <= cp) && (cp <= 0xD7FF)) ||\n               ((0xE000 <= cp) && (cp <= 0xF" +
	"FFF));\n      case 4:\n        return (0x00010000 <= cp) && (cp <= 0x0010FFFF);\n    }\n  }\n  return false;\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__utf_8__next__output::is_valid() const {\n  return wuffs_base__utf_8__next__output__is_valid(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\n// wuffs_base__utf_8__encode writes the UTF-8 encoding of code_point to s and\n// returns the number of bytes written. If code_point is invalid, or if s is\n// shorter than the entire encoding, it returns 0 (and no bytes are written).\n//\n// s will never be too short if its length is at least 4, also known as\n// WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__UTF8 sub-module, not just\n// WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__utf_8__encode(wuffs_base__slice_u8 dst, uint32_t code_point);\n\n// wuffs_base__utf_8__next returns the next UTF-8 code point (and that code\n// point's byte length) at the start of the read-only slice (s_ptr, s_len).\n//\n// There are exactly two cases in which this function returns something where\n// wuffs_base__utf_8__next__output__is_valid is false:\n//  - If s is empty then it returns {.code_point=0, .byte_len" +
	"gth=0}.\n//  - If s is non-empty and starts with invalid UTF-8 then it returns\n//    {.code_point=WUFFS_BASE__UNICODE_REPLACEMENT_CHARACTER, .byte_length=1}.\n//\n// Otherwise, it returns something where\n// wuffs_base__utf_8__next__output__is_valid is true.\n//\n// In any case, it always returns an output that satisfies both of:\n//  - (output.code_point  <= WUFFS_BASE__UNICODE_CODE_POINT__MAX_INCL).\n//  - (output.byte_length <= s_len).\n//\n// If s is a sub-slice of a larger slice of valid UTF-8, but that sub-slice\n// boundary occurs in the middle of a multi-byte UTF-8 encoding of a single\n// code point, then this function may return something invalid. It is the\n// caller's responsibility to split on or otherwise manage UTF-8 boundaries.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__UTF8 sub-module, not just\n// WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__utf_8__next__output  //\nwuffs_base__utf_8__next(" +
	"const uint8_t* s_ptr, size_t s_len);\n\n// wuffs_base__utf_8__next_from_end is like wuffs_base__utf_8__next except that\n// it looks at the end of (s_ptr, s_len) instead of the start.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__UTF8 sub-module, not just\n// WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC wuffs_base__utf_8__next__output  //\nwuffs_base__utf_8__next_from_end(const uint8_t* s_ptr, size_t s_len);\n\n// wuffs_base__utf_8__longest_valid_prefix returns the largest n such that the\n// sub-slice s[..n] is valid UTF-8, where s is the read-only slice (s_ptr,\n// s_len).\n//\n// In particular, it returns s_len if and only if all of s is valid UTF-8.\n//\n// If s is a sub-slice of a larger slice of valid UTF-8, but that sub-slice\n// boundary occurs in the middle of a multi-byte UTF-8 encoding of a single\n// code point, then this function will return less than s_len. It is the\n// caller's responsibility to split on or " +
	"otherwise manage UTF-8 boundaries.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__UTF8 sub-module, not just\n// WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__utf_8__longest_valid_prefix(const uint8_t* s_ptr, size_t s_len);\n\n// wuffs_base__ascii__longest_valid_prefix returns the largest n such that the\n// sub-slice s[..n] is valid ASCII, where s is the read-only slice (s_ptr,\n// s_len).\n//\n// In particular, it returns s_len if and only if all of s is valid ASCII.\n// Equivalently, when none of the bytes in s have the 0x80 high bit set.\n//\n// For modular builds that divide the base module into sub-modules, using this\n// function requires the WUFFS_CONFIG__MODULE__BASE__UTF8 sub-module, not just\n// WUFFS_CONFIG__MODULE__BASE__CORE.\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__ascii__longest_valid_prefix(const uint8_t* s_ptr, size_t s_len);\n" +
	""

const BaseTokenPrivateH = "" +
	"// ---------------- Tokens\n\n" +
	"" +
	"// ---------------- Tokens (Utility)\n" +
	""

const BaseTokenPublicH = "" +
	"// ---------------- Tokens\n\n// wuffs_base__token is an element of a byte stream's tokenization.\n//\n// See https://github.com/google/wuffs/blob/master/doc/note/tokens.md\ntypedef struct {\n  uint64_t repr;\n\n#ifdef __cplusplus\n  inline int64_t value() const;\n  inline int64_t value_extension() const;\n  inline int64_t value_major() const;\n  inline int64_t value_base_category() const;\n  inline uint64_t value_minor() const;\n  inline uint64_t value_base_detail() const;\n  inline int64_t value_base_detail__sign_extended() const;\n  inline bool continued() const;\n  inline uint64_t length() const;\n#endif  // __cplusplus\n\n} wuffs_base__token;\n\nstatic inline wuffs_base__token  //\nwuffs_base__make_token(uint64_t repr) {\n  wuffs_base__token ret;\n  ret.repr = repr;\n  return ret;\n}\n\n" +
	"" +
	"// --------\n\n#define WUFFS_BASE__TOKEN__LENGTH__MAX_INCL 0xFFFF\n\n#define WUFFS_BASE__TOKEN__VALUE__SHIFT 17\n#define WUFFS_BASE__TOKEN__VALUE_EXTENSION__SHIFT 17\n#define WUFFS_BASE__TOKEN__VALUE_MAJOR__SHIFT 42\n#define WUFFS_BASE__TOKEN__VALUE_MINOR__SHIFT 17\n#define WUFFS_BASE__TOKEN__VALUE_BASE_CATEGORY__SHIFT 38\n#define WUFFS_BASE__TOKEN__VALUE_BASE_DETAIL__SHIFT 17\n#define WUFFS_BASE__TOKEN__CONTINUED__SHIFT 16\n#define WUFFS_BASE__TOKEN__LENGTH__SHIFT 0\n\n#define WUFFS_BASE__TOKEN__VALUE_EXTENSION__NUM_BITS 46\n\n" +
	"" +
	"// --------\n\n#define WUFFS_BASE__TOKEN__VBC__FILLER 0\n#define WUFFS_BASE__TOKEN__VBC__STRUCTURE 1\n#define WUFFS_BASE__TOKEN__VBC__STRING 2\n#define WUFFS_BASE__TOKEN__VBC__UNICODE_CODE_POINT 3\n#define WUFFS_BASE__TOKEN__VBC__LITERAL 4\n#define WUFFS_BASE__TOKEN__VBC__NUMBER 5\n#define WUFFS_BASE__TOKEN__VBC__INLINE_INTEGER_SIGNED 6\n#define WUFFS_BASE__TOKEN__VBC__INLINE_INTEGER_UNSIGNED 7\n\n" +
	"" +
	"// --------\n\n#define WUFFS_BASE__TOKEN__VBD__FILLER__PUNCTUATION 0x00001\n#define WUFFS_BASE__TOKEN__VBD__FILLER__COMMENT_BLOCK 0x00002\n#define WUFFS_BASE__TOKEN__VBD__FILLER__COMMENT_LINE 0x00004\n\n// COMMENT_ANY is a bit-wise or of COMMENT_BLOCK AND COMMENT_LINE.\n#define WUFFS_BASE__TOKEN__VBD__FILLER__COMMENT_ANY 0x00006\n\n" +
	"" +
	"// --------\n\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__PUSH 0x00001\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__POP 0x00002\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_NONE 0x00010\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_LIST 0x00020\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_DICT 0x00040\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_NONE 0x01000\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_LIST 0x02000\n#define WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_DICT 0x04000\n\n" +
	"" +
	"// --------\n\n// DEFINITELY_FOO means that the destination bytes (and also the source bytes,\n// for 1_DST_1_SRC_COPY) are in the FOO format. Definitely means that the lack\n// of the bit means \"maybe FOO\". It does not necessarily mean \"not FOO\".\n//\n// CHAIN_ETC means that decoding the entire token chain forms a UTF-8 or ASCII\n// string, not just this current token. CHAIN_ETC_UTF_8 therefore distinguishes\n// Unicode (UTF-8) strings from byte strings. MUST means that the the token\n// producer (e.g. parser) must verify this. SHOULD means that the token\n// consumer (e.g. renderer) should verify this.\n//\n// When a CHAIN_ETC_UTF_8 bit is set, the parser must ensure that non-ASCII\n// code points (with multi-byte UTF-8 encodings) do not straddle token\n// boundaries. Checking UTF-8 validity can inspect each token separately.\n//\n// The lack of any particular bit is conservative: it is valid for all-ASCII\n// strings, in a single- or multi-token chain, to have none of these bits set.\n#define WUFFS_BASE__TOKEN__VBD__STRING_" +
	"_DEFINITELY_UTF_8 0x00001\n#define WUFFS_BASE__TOKEN__VBD__STRING__CHAIN_MUST_BE_UTF_8 0x00002\n#define WUFFS_BASE__TOKEN__VBD__STRING__CHAIN_SHOULD_BE_UTF_8 0x00004\n#define WUFFS_BASE__TOKEN__VBD__STRING__DEFINITELY_ASCII 0x00010\n#define WUFFS_BASE__TOKEN__VBD__STRING__CHAIN_MUST_BE_ASCII 0x00020\n#define WUFFS_BASE__TOKEN__VBD__STRING__CHAIN_SHOULD_BE_ASCII 0x00040\n\n// CONVERT_D_DST_S_SRC means that multiples of S source bytes (possibly padded)\n// produces multiples of D destination bytes. For example,\n// CONVERT_1_DST_4_SRC_BACKSLASH_X means a source like \"\\\\x23\\\\x67\\\\xAB\", where\n// 12 src bytes encode 3 dst bytes.\n//\n// Post-processing may further transform those D destination bytes (e.g. treat\n// \"\\\\xFF\" as the Unicode code point U+00FF instead of the byte 0xFF), but that\n// is out of scope of this VBD's semantics.\n//\n// When src is the empty string, multiple conversion algorithms are applicable\n// (so these bits are not necessarily mutually exclusive), all producing the\n// same empty dst string.\n#define WU" +
	"FFS_BASE__TOKEN__VBD__STRING__CONVERT_0_DST_1_SRC_DROP 0x00100\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_1_DST_1_SRC_COPY 0x00200\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_1_DST_2_SRC_HEXADECIMAL 0x00400\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_1_DST_4_SRC_BACKSLASH_X 0x00800\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_3_DST_4_SRC_BASE_64_STD 0x01000\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_3_DST_4_SRC_BASE_64_URL 0x02000\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_4_DST_5_SRC_ASCII_85 0x04000\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_5_DST_8_SRC_BASE_32_HEX 0x08000\n#define WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_5_DST_8_SRC_BASE_32_STD 0x10000\n\n" +
	"" +
	"// --------\n\n#define WUFFS_BASE__TOKEN__VBD__LITERAL__UNDEFINED 0x00001\n#define WUFFS_BASE__TOKEN__VBD__LITERAL__NULL 0x00002\n#define WUFFS_BASE__TOKEN__VBD__LITERAL__FALSE 0x00004\n#define WUFFS_BASE__TOKEN__VBD__LITERAL__TRUE 0x00008\n\n" +
	"" +
	"// --------\n\n// For a source string of \"123\" or \"0x9A\", it is valid for a tokenizer to\n// return any combination of:\n//  - WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_FLOATING_POINT.\n//  - WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_INTEGER_SIGNED.\n//  - WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_INTEGER_UNSIGNED.\n//\n// For a source string of \"+123\" or \"-0x9A\", only the first two are valid.\n//\n// For a source string of \"123.\", only the first one is valid.\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_FLOATING_POINT 0x00001\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_INTEGER_SIGNED 0x00002\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_INTEGER_UNSIGNED 0x00004\n\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_NEG_INF 0x00010\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_POS_INF 0x00020\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_NEG_NAN 0x00040\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_POS_NAN 0x00080\n\n// The number 300 might be represented as \"\\x01\\x2C\", \"\\x2C\\x01\\x00\\x00\" or\n// \"300\", which are big-en" +
	"dian, little-endian or text. For binary formats, the\n// token length (after adjusting for FORMAT_IGNORE_ETC) discriminates\n// e.g. u16 little-endian vs u32 little-endian.\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__FORMAT_BINARY_BIG_ENDIAN 0x00100\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__FORMAT_BINARY_LITTLE_ENDIAN 0x00200\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__FORMAT_TEXT 0x00400\n\n#define WUFFS_BASE__TOKEN__VBD__NUMBER__FORMAT_IGNORE_FIRST_BYTE 0x01000\n\n" +
	"" +
	"// --------\n\n// wuffs_base__token__value returns the token's high 46 bits, sign-extended. A\n// negative value means an extended token, non-negative means a simple token.\nstatic inline int64_t  //\nwuffs_base__token__value(const wuffs_base__token* t) {\n  return ((int64_t)(t->repr)) >> WUFFS_BASE__TOKEN__VALUE__SHIFT;\n}\n\n// wuffs_base__token__value_extension returns a negative value if the token was\n// not an extended token.\nstatic inline int64_t  //\nwuffs_base__token__value_extension(const wuffs_base__token* t) {\n  return (~(int64_t)(t->repr)) >> WUFFS_BASE__TOKEN__VALUE_EXTENSION__SHIFT;\n}\n\n// wuffs_base__token__value_major returns a negative value if the token was not\n// a simple token.\nstatic inline int64_t  //\nwuffs_base__token__value_major(const wuffs_base__token* t) {\n  return ((int64_t)(t->repr)) >> WUFFS_BASE__TOKEN__VALUE_MAJOR__SHIFT;\n}\n\n// wuffs_base__token__value_base_category returns a negative value if the token\n// was not a simple token.\nstatic inline int64_t  //\nwuffs_base__token__value_base_cat" +
	"egory(const wuffs_base__token* t) {\n  return ((int64_t)(t->repr)) >> WUFFS_BASE__TOKEN__VALUE_BASE_CATEGORY__SHIFT;\n}\n\nstatic inline uint64_t  //\nwuffs_base__token__value_minor(const wuffs_base__token* t) {\n  return (t->repr >> WUFFS_BASE__TOKEN__VALUE_MINOR__SHIFT) & 0x1FFFFFF;\n}\n\nstatic inline uint64_t  //\nwuffs_base__token__value_base_detail(const wuffs_base__token* t) {\n  return (t->repr >> WUFFS_BASE__TOKEN__VALUE_BASE_DETAIL__SHIFT) & 0x1FFFFF;\n}\n\nstatic inline int64_t  //\nwuffs_base__token__value_base_detail__sign_extended(\n    const wuffs_base__token* t) {\n  // The VBD is 21 bits in the middle of t->repr. Left shift the high (64 - 21\n  // - ETC__SHIFT) bits off, then right shift (sign-extending) back down.\n  uint64_t u = t->repr << (43 - WUFFS_BASE__TOKEN__VALUE_BASE_DETAIL__SHIFT);\n  return ((int64_t)u) >> 43;\n}\n\nstatic inline bool  //\nwuffs_base__token__continued(const wuffs_base__token* t) {\n  return t->repr & 0x10000;\n}\n\nstatic inline uint64_t  //\nwuffs_base__token__length(const wuffs_base__token*" +
	" t) {\n  return (t->repr >> WUFFS_BASE__TOKEN__LENGTH__SHIFT) & 0xFFFF;\n}\n\n#ifdef __cplusplus\n\ninline int64_t  //\nwuffs_base__token::value() const {\n  return wuffs_base__token__value(this);\n}\n\ninline int64_t  //\nwuffs_base__token::value_extension() const {\n  return wuffs_base__token__value_extension(this);\n}\n\ninline int64_t  //\nwuffs_base__token::value_major() const {\n  return wuffs_base__token__value_major(this);\n}\n\ninline int64_t  //\nwuffs_base__token::value_base_category() const {\n  return wuffs_base__token__value_base_category(this);\n}\n\ninline uint64_t  //\nwuffs_base__token::value_minor() const {\n  return wuffs_base__token__value_minor(this);\n}\n\ninline uint64_t  //\nwuffs_base__token::value_base_detail() const {\n  return wuffs_base__token__value_base_detail(this);\n}\n\ninline int64_t  //\nwuffs_base__token::value_base_detail__sign_extended() const {\n  return wuffs_base__token__value_base_detail__sign_extended(this);\n}\n\ninline bool  //\nwuffs_base__token::continued() const {\n  return wuffs_base__token__continued" +
	"(this);\n}\n\ninline uint64_t  //\nwuffs_base__token::length() const {\n  return wuffs_base__token__length(this);\n}\n\n#endif  // __cplusplus\n\n" +
	"" +
	"// --------\n\ntypedef WUFFS_BASE__SLICE(wuffs_base__token) wuffs_base__slice_token;\n\nstatic inline wuffs_base__slice_token  //\nwuffs_base__make_slice_token(wuffs_base__token* ptr, size_t len) {\n  wuffs_base__slice_token ret;\n  ret.ptr = ptr;\n  ret.len = len;\n  return ret;\n}\n\nstatic inline wuffs_base__slice_token  //\nwuffs_base__empty_slice_token() {\n  wuffs_base__slice_token ret;\n  ret.ptr = NULL;\n  ret.len = 0;\n  return ret;\n}\n\n" +
	"" +
	"// --------\n\n// wuffs_base__token_buffer_meta is the metadata for a\n// wuffs_base__token_buffer's data.\ntypedef struct {\n  size_t wi;     // Write index. Invariant: wi <= len.\n  size_t ri;     // Read  index. Invariant: ri <= wi.\n  uint64_t pos;  // Position of the buffer start relative to the stream start.\n  bool closed;   // No further writes are expected.\n} wuffs_base__token_buffer_meta;\n\n// wuffs_base__token_buffer is a 1-dimensional buffer (a pointer and length)\n// plus additional metadata.\n//\n// A value with all fields zero is a valid, empty buffer.\ntypedef struct {\n  wuffs_base__slice_token data;\n  wuffs_base__token_buffer_meta meta;\n\n#ifdef __cplusplus\n  inline bool is_valid() const;\n  inline void compact();\n  inline uint64_t reader_length() const;\n  inline wuffs_base__token* reader_pointer() const;\n  inline wuffs_base__slice_token reader_slice() const;\n  inline uint64_t reader_token_position() const;\n  inline uint64_t writer_length() const;\n  inline uint64_t writer_token_position() const;\n  inline wu" +
	"ffs_base__token* writer_pointer() const;\n  inline wuffs_base__slice_token writer_slice() const;\n#endif  // __cplusplus\n\n} wuffs_base__token_buffer;\n\nstatic inline wuffs_base__token_buffer  //\nwuffs_base__make_token_buffer(wuffs_base__slice_token data,\n                              wuffs_base__token_buffer_meta meta) {\n  wuffs_base__token_buffer ret;\n  ret.data = data;\n  ret.meta = meta;\n  return ret;\n}\n\nstatic inline wuffs_base__token_buffer_meta  //\nwuffs_base__make_token_buffer_meta(size_t wi,\n                                   size_t ri,\n                                   uint64_t pos,\n                                   bool closed) {\n  wuffs_base__token_buffer_meta ret;\n  ret.wi = wi;\n  ret.ri = ri;\n  ret.pos = pos;\n  ret.closed = closed;\n  return ret;\n}\n\nstatic inline wuffs_base__token_buffer  //\nwuffs_base__slice_token__reader(wuffs_base__slice_token s, bool closed) {\n  wuffs_base__token_buffer ret;\n  ret.data.ptr = s.ptr;\n  ret.data.len = s.len;\n  ret.meta.wi = s.len;\n  ret.meta.ri = 0;\n  ret.meta.pos " +
	"= 0;\n  ret.meta.closed = closed;\n  return ret;\n}\n\nstatic inline wuffs_base__token_buffer  //\nwuffs_base__slice_token__writer(wuffs_base__slice_token s) {\n  wuffs_base__token_buffer ret;\n  ret.data.ptr = s.ptr;\n  ret.data.len = s.len;\n  ret.meta.wi = 0;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = false;\n  return ret;\n}\n\nstatic inline wuffs_base__token_buffer  //\nwuffs_base__empty_token_buffer() {\n  wuffs_base__token_buffer ret;\n  ret.data.ptr = NULL;\n  ret.data.len = 0;\n  ret.meta.wi = 0;\n  ret.meta.ri = 0;\n  ret.meta.pos = 0;\n  ret.meta.closed = false;\n  return ret;\n}\n\nstatic inline wuffs_base__token_buffer_meta  //\nwuffs_base__empty_token_buffer_meta() {\n  wuffs_base__token_buffer_meta ret;\n  ret.wi = 0;\n  ret.ri = 0;\n  ret.pos = 0;\n  ret.closed = false;\n  return ret;\n}\n\nstatic inline bool  //\nwuffs_base__token_buffer__is_valid(const wuffs_base__token_buffer* buf) {\n  if (buf) {\n    if (buf->data.ptr) {\n      return (buf->meta.ri <= buf->meta.wi) && (buf->meta.wi <= buf->data.len);\n    } else " +
	"{\n      return (buf->meta.ri == 0) && (buf->meta.wi == 0) && (buf->data.len == 0);\n    }\n  }\n  return false;\n}\n\n// wuffs_base__token_buffer__compact moves any written but unread tokens to the\n// start of the buffer.\nstatic inline void  //\nwuffs_base__token_buffer__compact(wuffs_base__token_buffer* buf) {\n  if (!buf || (buf->meta.ri == 0)) {\n    return;\n  }\n  buf->meta.pos = wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.ri);\n  size_t n = buf->meta.wi - buf->meta.ri;\n  if (n != 0) {\n    memmove(buf->data.ptr, buf->data.ptr + buf->meta.ri,\n            n * sizeof(wuffs_base__token));\n  }\n  buf->meta.wi = n;\n  buf->meta.ri = 0;\n}\n\nstatic inline uint64_t  //\nwuffs_base__token_buffer__reader_length(const wuffs_base__token_buffer* buf) {\n  return buf ? buf->meta.wi - buf->meta.ri : 0;\n}\n\nstatic inline wuffs_base__token*  //\nwuffs_base__token_buffer__reader_pointer(const wuffs_base__token_buffer* buf) {\n  return buf ? (buf->data.ptr + buf->meta.ri) : NULL;\n}\n\nstatic inline wuffs_base__slice_token  //\nwuffs_base__t" +
	"oken_buffer__reader_slice(const wuffs_base__token_buffer* buf) {\n  return buf ? wuffs_base__make_slice_token(buf->data.ptr + buf->meta.ri,\n                                            buf->meta.wi - buf->meta.ri)\n             : wuffs_base__empty_slice_token();\n}\n\nstatic inline uint64_t  //\nwuffs_base__token_buffer__reader_token_position(\n    const wuffs_base__token_buffer* buf) {\n  return buf ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.ri) : 0;\n}\n\nstatic inline uint64_t  //\nwuffs_base__token_buffer__writer_length(const wuffs_base__token_buffer* buf) {\n  return buf ? buf->data.len - buf->meta.wi : 0;\n}\n\nstatic inline wuffs_base__token*  //\nwuffs_base__token_buffer__writer_pointer(const wuffs_base__token_buffer* buf) {\n  return buf ? (buf->data.ptr + buf->meta.wi) : NULL;\n}\n\nstatic inline wuffs_base__slice_token  //\nwuffs_base__token_buffer__writer_slice(const wuffs_base__token_buffer* buf) {\n  return buf ? wuffs_base__make_slice_token(buf->data.ptr + buf->meta.wi,\n                                       " +
	"     buf->data.len - buf->meta.wi)\n             : wuffs_base__empty_slice_token();\n}\n\nstatic inline uint64_t  //\nwuffs_base__token_buffer__writer_token_position(\n    const wuffs_base__token_buffer* buf) {\n  return buf ? wuffs_base__u64__sat_add(buf->meta.pos, buf->meta.wi) : 0;\n}\n\n#ifdef __cplusplus\n\ninline bool  //\nwuffs_base__token_buffer::is_valid() const {\n  return wuffs_base__token_buffer__is_valid(this);\n}\n\ninline void  //\nwuffs_base__token_buffer::compact() {\n  wuffs_base__token_buffer__compact(this);\n}\n\ninline uint64_t  //\nwuffs_base__token_buffer::reader_length() const {\n  return wuffs_base__token_buffer__reader_length(this);\n}\n\ninline wuffs_base__token*  //\nwuffs_base__token_buffer::reader_pointer() const {\n  return wuffs_base__token_buffer__reader_pointer(this);\n}\n\ninline wuffs_base__slice_token  //\nwuffs_base__token_buffer::reader_slice() const {\n  return wuffs_base__token_buffer__reader_slice(this);\n}\n\ninline uint64_t  //\nwuffs_base__token_buffer::reader_token_position() const {\n  return wuffs_ba" +
	"se__token_buffer__reader_token_position(this);\n}\n\ninline uint64_t  //\nwuffs_base__token_buffer::writer_length() const {\n  return wuffs_base__token_buffer__writer_length(this);\n}\n\ninline wuffs_base__token*  //\nwuffs_base__token_buffer::writer_pointer() const {\n  return wuffs_base__token_buffer__writer_pointer(this);\n}\n\ninline wuffs_base__slice_token  //\nwuffs_base__token_buffer::writer_slice() const {\n  return wuffs_base__token_buffer__writer_slice(this);\n}\n\ninline uint64_t  //\nwuffs_base__token_buffer::writer_token_position() const {\n  return wuffs_base__token_buffer__writer_token_position(this);\n}\n\n#endif  // __cplusplus\n" +
	""

const BaseFloatConvSubmoduleCodeC = "" +
	"// ---------------- IEEE 754 Floating Point\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__lossy_value_u16  //\nwuffs_base__ieee_754_bit_representation__from_f64_to_u16_truncate(double f) {\n  uint64_t u = 0;\n  if (sizeof(uint64_t) == sizeof(double)) {\n    memcpy(&u, &f, sizeof(uint64_t));\n  }\n  uint16_t neg = ((uint16_t)((u >> 63) << 15));\n  u &= 0x7FFFFFFFFFFFFFFF;\n  uint64_t exp = u >> 52;\n  uint64_t man = u & 0x000FFFFFFFFFFFFF;\n\n  if (exp == 0x7FF) {\n    if (man == 0) {  // Infinity.\n      wuffs_base__lossy_value_u16 ret;\n      ret.value = neg | 0x7C00;\n      ret.lossy = false;\n      return ret;\n    }\n    // NaN. Shift the 52 mantissa bits to 10 mantissa bits, keeping the most\n    // significant mantissa bit (quiet vs signaling NaNs). Also set the low 9\n    // bits of ret.value so that the 10-bit mantissa is non-zero.\n    wuffs_base__lossy_value_u16 ret;\n    ret.value = neg | 0x7DFF | ((uint16_t)(man >> 42));\n    ret.lossy = false;\n    return ret;\n\n  } else if (exp > 0x40E) {  // Truncate to the largest finite f16." +
	"\n    wuffs_base__lossy_value_u16 ret;\n    ret.value = neg | 0x7BFF;\n    ret.lossy = true;\n    return ret;\n\n  } else if (exp <= 0x3E6) {  // Truncate to zero.\n    wuffs_base__lossy_value_u16 ret;\n    ret.value = neg;\n    ret.lossy = (u != 0);\n    return ret;\n\n  } else if (exp <= 0x3F0) {  // Normal f64, subnormal f16.\n    // Convert from a 53-bit mantissa (after realizing the implicit bit) to a\n    // 10-bit mantissa and then adjust for the exponent.\n    man |= 0x0010000000000000;\n    uint32_t shift = ((uint32_t)(1051 - exp));  // 1051 = 0x3F0 + 53 - 10.\n    uint64_t shifted_man = man >> shift;\n    wuffs_base__lossy_value_u16 ret;\n    ret.value = neg | ((uint16_t)shifted_man);\n    ret.lossy = (shifted_man << shift) != man;\n    return ret;\n  }\n\n  // Normal f64, normal f16.\n\n  // Re-bias from 1023 to 15 and shift above f16's 10 mantissa bits.\n  exp = (exp - 1008) << 10;  // 1008 = 1023 - 15 = 0x3FF - 0xF.\n\n  // Convert from a 52-bit mantissa (excluding the implicit bit) to a 10-bit\n  // mantissa (again excluding" +
	" the implicit bit). We lose some information if\n  // any of the bottom 42 bits are non-zero.\n  wuffs_base__lossy_value_u16 ret;\n  ret.value = neg | ((uint16_t)exp) | ((uint16_t)(man >> 42));\n  ret.lossy = (man << 22) != 0;\n  return ret;\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__lossy_value_u32  //\nwuffs_base__ieee_754_bit_representation__from_f64_to_u32_truncate(double f) {\n  uint64_t u = 0;\n  if (sizeof(uint64_t) == sizeof(double)) {\n    memcpy(&u, &f, sizeof(uint64_t));\n  }\n  uint32_t neg = ((uint32_t)(u >> 63)) << 31;\n  u &= 0x7FFFFFFFFFFFFFFF;\n  uint64_t exp = u >> 52;\n  uint64_t man = u & 0x000FFFFFFFFFFFFF;\n\n  if (exp == 0x7FF) {\n    if (man == 0) {  // Infinity.\n      wuffs_base__lossy_value_u32 ret;\n      ret.value = neg | 0x7F800000;\n      ret.lossy = false;\n      return ret;\n    }\n    // NaN. Shift the 52 mantissa bits to 23 mantissa bits, keeping the most\n    // significant mantissa bit (quiet vs signaling NaNs). Also set the low 22\n    // bits of ret.value so that the 23-bit mantissa is non-zero.\n  " +
	"  wuffs_base__lossy_value_u32 ret;\n    ret.value = neg | 0x7FBFFFFF | ((uint32_t)(man >> 29));\n    ret.lossy = false;\n    return ret;\n\n  } else if (exp > 0x47E) {  // Truncate to the largest finite f32.\n    wuffs_base__lossy_value_u32 ret;\n    ret.value = neg | 0x7F7FFFFF;\n    ret.lossy = true;\n    return ret;\n\n  } else if (exp <= 0x369) {  // Truncate to zero.\n    wuffs_base__lossy_value_u32 ret;\n    ret.value = neg;\n    ret.lossy = (u != 0);\n    return ret;\n\n  } else if (exp <= 0x380) {  // Normal f64, subnormal f32.\n    // Convert from a 53-bit mantissa (after realizing the implicit bit) to a\n    // 23-bit mantissa and then adjust for the exponent.\n    man |= 0x0010000000000000;\n    uint32_t shift = ((uint32_t)(926 - exp));  // 926 = 0x380 + 53 - 23.\n    uint64_t shifted_man = man >> shift;\n    wuffs_base__lossy_value_u32 ret;\n    ret.value = neg | ((uint32_t)shifted_man);\n    ret.lossy = (shifted_man << shift) != man;\n    return ret;\n  }\n\n  // Normal f64, normal f32.\n\n  // Re-bias from 1023 to 127 and shi" +
	"ft above f32's 23 mantissa bits.\n  exp = (exp - 896) << 23;  // 896 = 1023 - 127 = 0x3FF - 0x7F.\n\n  // Convert from a 52-bit mantissa (excluding the implicit bit) to a 23-bit\n  // mantissa (again excluding the implicit bit). We lose some information if\n  // any of the bottom 29 bits are non-zero.\n  wuffs_base__lossy_value_u32 ret;\n  ret.value = neg | ((uint32_t)exp) | ((uint32_t)(man >> 29));\n  ret.lossy = (man << 35) != 0;\n  return ret;\n}\n\n" +
	"" +
	"// --------\n\n#define WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE 2047\n#define WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION 800\n\n// WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL is the largest N\n// such that ((10 << N) < (1 << 64)).\n#define WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL 60\n\n// wuffs_base__private_implementation__high_prec_dec (abbreviated as HPD) is a\n// fixed precision floating point decimal number, augmented with ±infinity\n// values, but it cannot represent NaN (Not a Number).\n//\n// \"High precision\" means that the mantissa holds 800 decimal digits. 800 is\n// WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION.\n//\n// An HPD isn't for general purpose arithmetic, only for conversions to and\n// from IEEE 754 double-precision floating point, where the largest and\n// smallest positive, finite values are approximately 1.8e+308 and 4.9e-324.\n// HPD exponents above +2047 mean infinity, below -2047 mean zero. The ±2047\n// bounds are further a" +
	"way from zero than ±(324 + 800), where 800 and 2047 is\n// WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION and\n// WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE.\n//\n// digits[.. num_digits] are the number's digits in big-endian order. The\n// uint8_t values are in the range [0 ..= 9], not ['0' ..= '9'], where e.g. '7'\n// is the ASCII value 0x37.\n//\n// decimal_point is the index (within digits) of the decimal point. It may be\n// negative or be larger than num_digits, in which case the explicit digits are\n// padded with implicit zeroes.\n//\n// For example, if num_digits is 3 and digits is \"\\x07\\x08\\x09\":\n//   - A decimal_point of -2 means \".00789\"\n//   - A decimal_point of -1 means \".0789\"\n//   - A decimal_point of +0 means \".789\"\n//   - A decimal_point of +1 means \"7.89\"\n//   - A decimal_point of +2 means \"78.9\"\n//   - A decimal_point of +3 means \"789.\"\n//   - A decimal_point of +4 means \"7890.\"\n//   - A decimal_point of +5 means \"78900.\"\n//\n// As above, a decimal_point higher than +2047" +
	" means that the overall value is\n// infinity, lower than -2047 means zero.\n//\n// negative is a sign bit. An HPD can distinguish positive and negative zero.\n//\n// truncated is whether there are more than\n// WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION digits, and at\n// least one of those extra digits are non-zero. The existence of long-tail\n// digits can affect rounding.\n//\n// The \"all fields are zero\" value is valid, and represents the number +0.\ntypedef struct {\n  uint32_t num_digits;\n  int32_t decimal_point;\n  bool negative;\n  bool truncated;\n  uint8_t digits[WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION];\n} wuffs_base__private_implementation__high_prec_dec;\n\n// wuffs_base__private_implementation__high_prec_dec__trim trims trailing\n// zeroes from the h->digits[.. h->num_digits] slice. They have no benefit,\n// since we explicitly track h->decimal_point.\n//\n// Preconditions:\n//  - h is non-NULL.\nstatic inline void  //\nwuffs_base__private_implementation__high_prec_dec__trim(\n    wuffs_" +
	"base__private_implementation__high_prec_dec* h) {\n  while ((h->num_digits > 0) && (h->digits[h->num_digits - 1] == 0)) {\n    h->num_digits--;\n  }\n}\n\n// wuffs_base__private_implementation__high_prec_dec__assign sets h to\n// represent the number x.\n//\n// Preconditions:\n//  - h is non-NULL.\nstatic void  //\nwuffs_base__private_implementation__high_prec_dec__assign(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    uint64_t x,\n    bool negative) {\n  uint32_t n = 0;\n\n  // Set h->digits.\n  if (x > 0) {\n    // Calculate the digits, working right-to-left. After we determine n (how\n    // many digits there are), copy from buf to h->digits.\n    //\n    // UINT64_MAX, 18446744073709551615, is 20 digits long. It can be faster to\n    // copy a constant number of bytes than a variable number (20 instead of\n    // n). Make buf large enough (and start writing to it from the middle) so\n    // that can we always copy 20 bytes: the slice buf[(20-n) .. (40-n)].\n    uint8_t buf[40] = {0};\n    uint8_t* ptr = &buf[20];\n  " +
	"  do {\n      uint64_t remaining = x / 10;\n      x -= remaining * 10;\n      ptr--;\n      *ptr = (uint8_t)x;\n      n++;\n      x = remaining;\n    } while (x > 0);\n    memcpy(h->digits, ptr, 20);\n  }\n\n  // Set h's other fields.\n  h->num_digits = n;\n  h->decimal_point = (int32_t)n;\n  h->negative = negative;\n  h->truncated = false;\n  wuffs_base__private_implementation__high_prec_dec__trim(h);\n}\n\nstatic wuffs_base__status  //\nwuffs_base__private_implementation__high_prec_dec__parse(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    wuffs_base__slice_u8 s,\n    uint32_t options) {\n  if (!h) {\n    return wuffs_base__make_status(wuffs_base__error__bad_receiver);\n  }\n  h->num_digits = 0;\n  h->decimal_point = 0;\n  h->negative = false;\n  h->truncated = false;\n\n  uint8_t* p = s.ptr;\n  uint8_t* q = s.ptr + s.len;\n\n  if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n    for (;; p++) {\n      if (p >= q) {\n        return wuffs_base__make_status(wuffs_base__error__bad_argument);\n      } else if (*p != " +
	"'_') {\n        break;\n      }\n    }\n  }\n\n  // Parse sign.\n  do {\n    if (*p == '+') {\n      p++;\n    } else if (*p == '-') {\n      h->negative = true;\n      p++;\n    } else {\n      break;\n    }\n    if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n      for (;; p++) {\n        if (p >= q) {\n          return wuffs_base__make_status(wuffs_base__error__bad_argument);\n        } else if (*p != '_') {\n          break;\n        }\n      }\n    }\n  } while (0);\n\n  // Parse digits, up to (and including) a '.', 'E' or 'e'. Examples for each\n  // limb in this if-else chain:\n  //  - \"0.789\"\n  //  - \"1002.789\"\n  //  - \".789\"\n  //  - Other (invalid input).\n  uint32_t nd = 0;\n  int32_t dp = 0;\n  bool no_digits_before_separator = false;\n  if (('0' == *p) &&\n      !(options &\n        WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_MULTIPLE_LEADING_ZEROES)) {\n    p++;\n    for (;; p++) {\n      if (p >= q) {\n        goto after_all;\n      } else if (*p ==\n                 ((options &\n                   WUFFS_BASE__PARSE_NUMBER_FXX" +
	"__DECIMAL_SEPARATOR_IS_A_COMMA)\n                      ? ','\n                      : '.')) {\n        p++;\n        goto after_sep;\n      } else if ((*p == 'E') || (*p == 'e')) {\n        p++;\n        goto after_exp;\n      } else if ((*p != '_') ||\n                 !(options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES)) {\n        return wuffs_base__make_status(wuffs_base__error__bad_argument);\n      }\n    }\n\n  } else if (('0' <= *p) && (*p <= '9')) {\n    if (*p == '0') {\n      for (; (p < q) && (*p == '0'); p++) {\n      }\n    } else {\n      h->digits[nd++] = (uint8_t)(*p - '0');\n      dp = (int32_t)nd;\n      p++;\n    }\n\n    for (;; p++) {\n      if (p >= q) {\n        goto after_all;\n      } else if (('0' <= *p) && (*p <= '9')) {\n        if (nd < WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION) {\n          h->digits[nd++] = (uint8_t)(*p - '0');\n          dp = (int32_t)nd;\n        } else if ('0' != *p) {\n          // Long-tail non-zeroes set the truncated bit.\n          h->truncated = true;\n        }" +
	"\n      } else if (*p ==\n                 ((options &\n                   WUFFS_BASE__PARSE_NUMBER_FXX__DECIMAL_SEPARATOR_IS_A_COMMA)\n                      ? ','\n                      : '.')) {\n        p++;\n        goto after_sep;\n      } else if ((*p == 'E') || (*p == 'e')) {\n        p++;\n        goto after_exp;\n      } else if ((*p != '_') ||\n                 !(options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES)) {\n        return wuffs_base__make_status(wuffs_base__error__bad_argument);\n      }\n    }\n\n  } else if (*p == ((options &\n                     WUFFS_BASE__PARSE_NUMBER_FXX__DECIMAL_SEPARATOR_IS_A_COMMA)\n                        ? ','\n                        : '.')) {\n    p++;\n    no_digits_before_separator = true;\n\n  } else {\n    return wuffs_base__make_status(wuffs_base__error__bad_argument);\n  }\n\nafter_sep:\n  for (;; p++) {\n    if (p >= q) {\n      goto after_all;\n    } else if ('0' == *p) {\n      if (nd == 0) {\n        // Track leading zeroes implicitly.\n        dp--;\n      } else if (nd <\n   " +
	"              WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION) {\n        h->digits[nd++] = (uint8_t)(*p - '0');\n      }\n    } else if (('0' < *p) && (*p <= '9')) {\n      if (nd < WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION) {\n        h->digits[nd++] = (uint8_t)(*p - '0');\n      } else {\n        // Long-tail non-zeroes set the truncated bit.\n        h->truncated = true;\n      }\n    } else if ((*p == 'E') || (*p == 'e')) {\n      p++;\n      goto after_exp;\n    } else if ((*p != '_') ||\n               !(options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES)) {\n      return wuffs_base__make_status(wuffs_base__error__bad_argument);\n    }\n  }\n\nafter_exp:\n  do {\n    if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n      for (;; p++) {\n        if (p >= q) {\n          return wuffs_base__make_status(wuffs_base__error__bad_argument);\n        } else if (*p != '_') {\n          break;\n        }\n      }\n    }\n\n    int32_t exp_sign = +1;\n    if (*p == '+') {\n      p++;\n    } else if" +
	" (*p == '-') {\n      exp_sign = -1;\n      p++;\n    }\n\n    int32_t exp = 0;\n    const int32_t exp_large =\n        WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE +\n        WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION;\n    bool saw_exp_digits = false;\n    for (; p < q; p++) {\n      if ((*p == '_') &&\n          (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES)) {\n        // No-op.\n      } else if (('0' <= *p) && (*p <= '9')) {\n        saw_exp_digits = true;\n        if (exp < exp_large) {\n          exp = (10 * exp) + ((int32_t)(*p - '0'));\n        }\n      } else {\n        break;\n      }\n    }\n    if (!saw_exp_digits) {\n      return wuffs_base__make_status(wuffs_base__error__bad_argument);\n    }\n    dp += exp_sign * exp;\n  } while (0);\n\nafter_all:\n  if (p != q) {\n    return wuffs_base__make_status(wuffs_base__error__bad_argument);\n  }\n  h->num_digits = nd;\n  if (nd == 0) {\n    if (no_digits_before_separator) {\n      return wuffs_base__make_status(wuffs_base__error__bad_argument" +
	");\n    }\n    h->decimal_point = 0;\n  } else if (dp <\n             -WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE) {\n    h->decimal_point =\n        -WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE - 1;\n  } else if (dp >\n             +WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE) {\n    h->decimal_point =\n        +WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE + 1;\n  } else {\n    h->decimal_point = dp;\n  }\n  wuffs_base__private_implementation__high_prec_dec__trim(h);\n  return wuffs_base__make_status(NULL);\n}\n\n" +
	"" +
	"// --------\n\n// wuffs_base__private_implementation__high_prec_dec__lshift_num_new_digits\n// returns the number of additional decimal digits when left-shifting by shift.\n//\n// See below for preconditions.\nstatic uint32_t  //\nwuffs_base__private_implementation__high_prec_dec__lshift_num_new_digits(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    uint32_t shift) {\n  // Masking with 0x3F should be unnecessary (assuming the preconditions) but\n  // it's cheap and ensures that we don't overflow the\n  // wuffs_base__private_implementation__hpd_left_shift array.\n  shift &= 63;\n\n  uint32_t x_a = wuffs_base__private_implementation__hpd_left_shift[shift];\n  uint32_t x_b = wuffs_base__private_implementation__hpd_left_shift[shift + 1];\n  uint32_t num_new_digits = x_a >> 11;\n  uint32_t pow5_a = 0x7FF & x_a;\n  uint32_t pow5_b = 0x7FF & x_b;\n\n  const uint8_t* pow5 =\n      &wuffs_base__private_implementation__powers_of_5[pow5_a];\n  uint32_t i = 0;\n  uint32_t n = pow5_b - pow5_a;\n  for (; i < n; i++) {\n    if (i >" +
	"= h->num_digits) {\n      return num_new_digits - 1;\n    } else if (h->digits[i] == pow5[i]) {\n      continue;\n    } else if (h->digits[i] < pow5[i]) {\n      return num_new_digits - 1;\n    } else {\n      return num_new_digits;\n    }\n  }\n  return num_new_digits;\n}\n\n" +
	"" +
	"// --------\n\n// wuffs_base__private_implementation__high_prec_dec__rounded_integer returns\n// the integral (non-fractional) part of h, provided that it is 18 or fewer\n// decimal digits. For 19 or more digits, it returns UINT64_MAX. Note that:\n//   - (1 << 53) is    9007199254740992, which has 16 decimal digits.\n//   - (1 << 56) is   72057594037927936, which has 17 decimal digits.\n//   - (1 << 59) is  576460752303423488, which has 18 decimal digits.\n//   - (1 << 63) is 9223372036854775808, which has 19 decimal digits.\n// and that IEEE 754 double precision has 52 mantissa bits.\n//\n// That integral part is rounded-to-even: rounding 7.5 or 8.5 both give 8.\n//\n// h's negative bit is ignored: rounding -8.6 returns 9.\n//\n// See below for preconditions.\nstatic uint64_t  //\nwuffs_base__private_implementation__high_prec_dec__rounded_integer(\n    wuffs_base__private_implementation__high_prec_dec* h) {\n  if ((h->num_digits == 0) || (h->decimal_point < 0)) {\n    return 0;\n  } else if (h->decimal_point > 18) {\n    return U" +
	"INT64_MAX;\n  }\n\n  uint32_t dp = (uint32_t)(h->decimal_point);\n  uint64_t n = 0;\n  uint32_t i = 0;\n  for (; i < dp; i++) {\n    n = (10 * n) + ((i < h->num_digits) ? h->digits[i] : 0);\n  }\n\n  bool round_up = false;\n  if (dp < h->num_digits) {\n    round_up = h->digits[dp] >= 5;\n    if ((h->digits[dp] == 5) && (dp + 1 == h->num_digits)) {\n      // We are exactly halfway. If we're truncated, round up, otherwise round\n      // to even.\n      round_up = h->truncated ||  //\n                 ((dp > 0) && (1 & h->digits[dp - 1]));\n    }\n  }\n  if (round_up) {\n    n++;\n  }\n\n  return n;\n}\n\n// wuffs_base__private_implementation__high_prec_dec__small_xshift shifts h's\n// number (where 'x' is 'l' or 'r' for left or right) by a small shift value.\n//\n// Preconditions:\n//  - h is non-NULL.\n//  - h->decimal_point is \"not extreme\".\n//  - shift is non-zero.\n//  - shift is \"a small shift\".\n//\n// \"Not extreme\" means within\n// ±WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE.\n//\n// \"A small shift\" means not more than\n/" +
	"/ WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL.\n//\n// wuffs_base__private_implementation__high_prec_dec__rounded_integer and\n// wuffs_base__private_implementation__high_prec_dec__lshift_num_new_digits\n// have the same preconditions.\n//\n// wuffs_base__private_implementation__high_prec_dec__lshift keeps the first\n// two preconditions but not the last two. Its shift argument is signed and\n// does not need to be \"small\": zero is a no-op, positive means left shift and\n// negative means right shift.\n\nstatic void  //\nwuffs_base__private_implementation__high_prec_dec__small_lshift(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    uint32_t shift) {\n  if (h->num_digits == 0) {\n    return;\n  }\n  uint32_t num_new_digits =\n      wuffs_base__private_implementation__high_prec_dec__lshift_num_new_digits(\n          h, shift);\n  uint32_t rx = h->num_digits - 1;                   // Read  index.\n  uint32_t wx = h->num_digits - 1 + num_new_digits;  // Write index.\n  uint64_t n = 0;\n\n  // Repeat: pick up " +
	"a digit, put down a digit, right to left.\n  while (((int32_t)rx) >= 0) {\n    n += ((uint64_t)(h->digits[rx])) << shift;\n    uint64_t quo = n / 10;\n    uint64_t rem = n - (10 * quo);\n    if (wx < WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION) {\n      h->digits[wx] = (uint8_t)rem;\n    } else if (rem > 0) {\n      h->truncated = true;\n    }\n    n = quo;\n    wx--;\n    rx--;\n  }\n\n  // Put down leading digits, right to left.\n  while (n > 0) {\n    uint64_t quo = n / 10;\n    uint64_t rem = n - (10 * quo);\n    if (wx < WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION) {\n      h->digits[wx] = (uint8_t)rem;\n    } else if (rem > 0) {\n      h->truncated = true;\n    }\n    n = quo;\n    wx--;\n  }\n\n  // Finish.\n  h->num_digits += num_new_digits;\n  if (h->num_digits >\n      WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION) {\n    h->num_digits = WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION;\n  }\n  h->decimal_point += (int32_t)num_new_digits;\n  wuffs_base__private_implementation__high_pre" +
	"c_dec__trim(h);\n}\n\nstatic void  //\nwuffs_base__private_implementation__high_prec_dec__small_rshift(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    uint32_t shift) {\n  uint32_t rx = 0;  // Read  index.\n  uint32_t wx = 0;  // Write index.\n  uint64_t n = 0;\n\n  // Pick up enough leading digits to cover the first shift.\n  while ((n >> shift) == 0) {\n    if (rx < h->num_digits) {\n      // Read a digit.\n      n = (10 * n) + h->digits[rx++];\n    } else if (n == 0) {\n      // h's number used to be zero and remains zero.\n      return;\n    } else {\n      // Read sufficient implicit trailing zeroes.\n      while ((n >> shift) == 0) {\n        n = 10 * n;\n        rx++;\n      }\n      break;\n    }\n  }\n  h->decimal_point -= ((int32_t)(rx - 1));\n  if (h->decimal_point <\n      -WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE) {\n    // After the shift, h's number is effectively zero.\n    h->num_digits = 0;\n    h->decimal_point = 0;\n    h->negative = false;\n    h->truncated = false;\n    return;\n  }\n\n  " +
	"// Repeat: pick up a digit, put down a digit, left to right.\n  uint64_t mask = (((uint64_t)(1)) << shift) - 1;\n  while (rx < h->num_digits) {\n    uint8_t new_digit = ((uint8_t)(n >> shift));\n    n = (10 * (n & mask)) + h->digits[rx++];\n    h->digits[wx++] = new_digit;\n  }\n\n  // Put down trailing digits, left to right.\n  while (n > 0) {\n    uint8_t new_digit = ((uint8_t)(n >> shift));\n    n = 10 * (n & mask);\n    if (wx < WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DIGITS_PRECISION) {\n      h->digits[wx++] = new_digit;\n    } else if (new_digit > 0) {\n      h->truncated = true;\n    }\n  }\n\n  // Finish.\n  h->num_digits = wx;\n  wuffs_base__private_implementation__high_prec_dec__trim(h);\n}\n\nstatic void  //\nwuffs_base__private_implementation__high_prec_dec__lshift(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    int32_t shift) {\n  if (shift > 0) {\n    while (shift > +WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL) {\n      wuffs_base__private_implementation__high_prec_dec__small_lshift(\n         " +
	" h, WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL);\n      shift -= WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL;\n    }\n    wuffs_base__private_implementation__high_prec_dec__small_lshift(\n        h, ((uint32_t)(+shift)));\n  } else if (shift < 0) {\n    while (shift < -WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL) {\n      wuffs_base__private_implementation__high_prec_dec__small_rshift(\n          h, WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL);\n      shift += WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL;\n    }\n    wuffs_base__private_implementation__high_prec_dec__small_rshift(\n        h, ((uint32_t)(-shift)));\n  }\n}\n\n" +
	"" +
	"// --------\n\n// wuffs_base__private_implementation__high_prec_dec__round_etc rounds h's\n// number. For those functions that take an n argument, rounding produces at\n// most n digits (which is not necessarily at most n decimal places). Negative\n// n values are ignored, as well as any n greater than or equal to h's number\n// of digits. The etc__round_just_enough function implicitly chooses an n to\n// implement WUFFS_BASE__RENDER_NUMBER_FXX__JUST_ENOUGH_PRECISION.\n//\n// Preconditions:\n//  - h is non-NULL.\n//  - h->decimal_point is \"not extreme\".\n//\n// \"Not extreme\" means within\n// ±WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE.\n\nstatic void  //\nwuffs_base__private_implementation__high_prec_dec__round_down(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    int32_t n) {\n  if ((n < 0) || (h->num_digits <= (uint32_t)n)) {\n    return;\n  }\n  h->num_digits = (uint32_t)(n);\n  wuffs_base__private_implementation__high_prec_dec__trim(h);\n}\n\nstatic void  //\nwuffs_base__private_implementation__hi" +
	"gh_prec_dec__round_up(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    int32_t n) {\n  if ((n < 0) || (h->num_digits <= (uint32_t)n)) {\n    return;\n  }\n\n  for (n--; n >= 0; n--) {\n    if (h->digits[n] < 9) {\n      h->digits[n]++;\n      h->num_digits = (uint32_t)(n + 1);\n      return;\n    }\n  }\n\n  // The number is all 9s. Change to a single 1 and adjust the decimal point.\n  h->digits[0] = 1;\n  h->num_digits = 1;\n  h->decimal_point++;\n}\n\nstatic void  //\nwuffs_base__private_implementation__high_prec_dec__round_nearest(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    int32_t n) {\n  if ((n < 0) || (h->num_digits <= (uint32_t)n)) {\n    return;\n  }\n  bool up = h->digits[n] >= 5;\n  if ((h->digits[n] == 5) && ((n + 1) == ((int32_t)(h->num_digits)))) {\n    up = h->truncated ||  //\n         ((n > 0) && ((h->digits[n - 1] & 1) != 0));\n  }\n\n  if (up) {\n    wuffs_base__private_implementation__high_prec_dec__round_up(h, n);\n  } else {\n    wuffs_base__private_implementation__high_prec_dec__round_do" +
	"wn(h, n);\n  }\n}\n\nstatic void  //\nwuffs_base__private_implementation__high_prec_dec__round_just_enough(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    int32_t exp2,\n    uint64_t mantissa) {\n  // The magic numbers 52 and 53 in this function are because IEEE 754 double\n  // precision has 52 mantissa bits.\n  //\n  // Let f be the floating point number represented by exp2 and mantissa (and\n  // also the number in h): the number (mantissa * (2 ** (exp2 - 52))).\n  //\n  // If f is zero or a small integer, we can return early.\n  if ((mantissa == 0) ||\n      ((exp2 < 53) && (h->decimal_point >= ((int32_t)(h->num_digits))))) {\n    return;\n  }\n\n  // The smallest normal f has an exp2 of -1022 and a mantissa of (1 << 52).\n  // Subnormal numbers have the same exp2 but a smaller mantissa.\n  static const int32_t min_incl_normal_exp2 = -1022;\n  static const uint64_t min_incl_normal_mantissa = 0x0010000000000000ul;\n\n  // Compute lower and upper bounds such that any number between them (possibly\n  // inclusive) wil" +
	"l round to f. First, the lower bound. Our number f is:\n  //   ((mantissa + 0)         * (2 ** (  exp2 - 52)))\n  //\n  // The next lowest floating point number is:\n  //   ((mantissa - 1)         * (2 ** (  exp2 - 52)))\n  // unless (mantissa - 1) drops the (1 << 52) bit and exp2 is not the\n  // min_incl_normal_exp2. Either way, call it:\n  //   ((l_mantissa)           * (2 ** (l_exp2 - 52)))\n  //\n  // The lower bound is halfway between them (noting that 52 became 53):\n  //   (((2 * l_mantissa) + 1) * (2 ** (l_exp2 - 53)))\n  int32_t l_exp2 = exp2;\n  uint64_t l_mantissa = mantissa - 1;\n  if ((exp2 > min_incl_normal_exp2) && (mantissa <= min_incl_normal_mantissa)) {\n    l_exp2 = exp2 - 1;\n    l_mantissa = (2 * mantissa) - 1;\n  }\n  wuffs_base__private_implementation__high_prec_dec lower;\n  wuffs_base__private_implementation__high_prec_dec__assign(\n      &lower, (2 * l_mantissa) + 1, false);\n  wuffs_base__private_implementation__high_prec_dec__lshift(&lower,\n                                                            " +
	"l_exp2 - 53);\n\n  // Next, the upper bound. Our number f is:\n  //   ((mantissa + 0)       * (2 ** (exp2 - 52)))\n  //\n  // The next highest floating point number is:\n  //   ((mantissa + 1)       * (2 ** (exp2 - 52)))\n  //\n  // The upper bound is halfway between them (noting that 52 became 53):\n  //   (((2 * mantissa) + 1) * (2 ** (exp2 - 53)))\n  wuffs_base__private_implementation__high_prec_dec upper;\n  wuffs_base__private_implementation__high_prec_dec__assign(\n      &upper, (2 * mantissa) + 1, false);\n  wuffs_base__private_implementation__high_prec_dec__lshift(&upper, exp2 - 53);\n\n  // The lower and upper bounds are possible outputs only if the original\n  // mantissa is even, so that IEEE round-to-even would round to the original\n  // mantissa and not its neighbors.\n  bool inclusive = (mantissa & 1) == 0;\n\n  // As we walk the digits, we want to know whether rounding up would fall\n  // within the upper bound. This is tracked by upper_delta:\n  //  - When -1, the digits of h and upper are the same so far.\n  //  -" +
	" When +0, we saw a difference of 1 between h and upper on a previous\n  //    digit and subsequently only 9s for h and 0s for upper. Thus, rounding\n  //    up may fall outside of the bound if !inclusive.\n  //  - When +1, the difference is greater than 1 and we know that rounding up\n  //    falls within the bound.\n  //\n  // This is a state machine with three states. The numerical value for each\n  // state (-1, +0 or +1) isn't important, other than their order.\n  int upper_delta = -1;\n\n  // We can now figure out the shortest number of digits required. Walk the\n  // digits until h has distinguished itself from lower or upper.\n  //\n  // The zi and zd variables are indexes and digits, for z in l (lower), h (the\n  // number) and u (upper).\n  //\n  // The lower, h and upper numbers may have their decimal points at different\n  // places. In this case, upper is the longest, so we iterate ui starting from\n  // 0 and iterate li and hi starting from either 0 or -1.\n  int32_t ui = 0;\n  for (;; ui++) {\n    // Calculate hd, t" +
	"he middle number's digit.\n    int32_t hi = ui - upper.decimal_point + h->decimal_point;\n    if (hi >= ((int32_t)(h->num_digits))) {\n      break;\n    }\n    uint8_t hd = (((uint32_t)hi) < h->num_digits) ? h->digits[hi] : 0;\n\n    // Calculate ld, the lower bound's digit.\n    int32_t li = ui - upper.decimal_point + lower.decimal_point;\n    uint8_t ld = (((uint32_t)li) < lower.num_digits) ? lower.digits[li] : 0;\n\n    // We can round down (truncate) if lower has a different digit than h or if\n    // lower is inclusive and is exactly the result of rounding down (i.e. we\n    // have reached the final digit of lower).\n    bool can_round_down =\n        (ld != hd) ||  //\n        (inclusive && ((li + 1) == ((int32_t)(lower.num_digits))));\n\n    // Calculate ud, the upper bound's digit, and update upper_delta.\n    uint8_t ud = (((uint32_t)ui) < upper.num_digits) ? upper.digits[ui] : 0;\n    if (upper_delta < 0) {\n      if ((hd + 1) < ud) {\n        // For example:\n        // h     = 12345???\n        // upper = 12347???\n     " +
	"   upper_delta = +1;\n      } else if (hd != ud) {\n        // For example:\n        // h     = 12345???\n        // upper = 12346???\n        upper_delta = +0;\n      }\n    } else if (upper_delta == 0) {\n      if ((hd != 9) || (ud != 0)) {\n        // For example:\n        // h     = 1234598?\n        // upper = 1234600?\n        upper_delta = +1;\n      }\n    }\n\n    // We can round up if upper has a different digit than h and either upper\n    // is inclusive or upper is bigger than the result of rounding up.\n    bool can_round_up =\n        (upper_delta > 0) ||    //\n        ((upper_delta == 0) &&  //\n         (inclusive || ((ui + 1) < ((int32_t)(upper.num_digits)))));\n\n    // If we can round either way, round to nearest. If we can round only one\n    // way, do it. If we can't round, continue the loop.\n    if (can_round_down) {\n      if (can_round_up) {\n        wuffs_base__private_implementation__high_prec_dec__round_nearest(\n            h, hi + 1);\n        return;\n      } else {\n        wuffs_base__private_implementat" +
	"ion__high_prec_dec__round_down(h,\n                                                                      hi + 1);\n        return;\n      }\n    } else {\n      if (can_round_up) {\n        wuffs_base__private_implementation__high_prec_dec__round_up(h, hi + 1);\n        return;\n      }\n    }\n  }\n}\n\n" +
	"" +
	"// --------\n\n// wuffs_base__private_implementation__parse_number_f64_eisel_lemire produces\n// the IEEE 754 double-precision value for an exact mantissa and base-10\n// exponent. For example:\n//  - when parsing \"12345.678e+02\", man is 12345678 and exp10 is -1.\n//  - when parsing \"-12\", man is 12 and exp10 is 0. Processing the leading\n//    minus sign is the responsibility of the caller, not this function.\n//\n// On success, it returns a non-negative int64_t such that the low 63 bits hold\n// the 11-bit exponent and 52-bit mantissa.\n//\n// On failure, it returns a negative value.\n//\n// The algorithm is based on an original idea by Michael Eisel that was refined\n// by Daniel Lemire. See\n// https://lemire.me/blog/2020/03/10/fast-float-parsing-in-practice/\n//\n// Preconditions:\n//  - man is non-zero.\n//  - exp10 is in the range [-307 ..= 288], the same range of the\n//    wuffs_base__private_implementation__powers_of_10 array.\n//\n// The exp10 range (and the fact that man is in the range [1 ..= UINT64_MAX],\n// approximat" +
	"ely [1 ..= 1.85e+19]) means that (man * (10 ** exp10)) is in the\n// range [1e-307 ..= 1.85e+307]. This is entirely within the range of normal\n// (neither subnormal nor non-finite) f64 values: DBL_MIN and DBL_MAX are\n// approximately 2.23e–308 and 1.80e+308.\nstatic int64_t  //\nwuffs_base__private_implementation__parse_number_f64_eisel_lemire(\n    uint64_t man,\n    int32_t exp10) {\n  // Look up the (possibly truncated) base-2 representation of (10 ** exp10).\n  // The look-up table was constructed so that it is already normalized: the\n  // table entry's mantissa's MSB (most significant bit) is on.\n  const uint64_t* po10 =\n      &wuffs_base__private_implementation__powers_of_10[exp10 + 307][0];\n\n  // Normalize the man argument. The (man != 0) precondition means that a\n  // non-zero bit exists.\n  uint32_t clz = wuffs_base__count_leading_zeroes_u64(man);\n  man <<= clz;\n\n  // Calculate the return value's base-2 exponent. We might tweak it by ±1\n  // later, but its initial value comes from a linear scaling of exp1" +
	"0,\n  // converting from power-of-10 to power-of-2, and adjusting by clz.\n  //\n  // The magic constants are:\n  //  - 1087 = 1023 + 64. The 1023 is the f64 exponent bias. The 64 is because\n  //    the look-up table uses 64-bit mantissas.\n  //  - 217706 is such that the ratio 217706 / 65536 ≈ 3.321930 is close enough\n  //    (over the practical range of exp10) to log(10) / log(2) ≈ 3.321928.\n  //  - 65536 = 1<<16 is arbitrary but a power of 2, so division is a shift.\n  //\n  // Equality of the linearly-scaled value and the actual power-of-2, over the\n  // range of exp10 arguments that this function accepts, is confirmed by\n  // script/print-mpb-powers-of-10.go\n  uint64_t ret_exp2 =\n      ((uint64_t)(((217706 * exp10) >> 16) + 1087)) - ((uint64_t)clz);\n\n  // Multiply the two mantissas. Normalization means that both mantissas are at\n  // least (1<<63), so the 128-bit product must be at least (1<<126). The high\n  // 64 bits of the product, x_hi, must therefore be at least (1<<62).\n  //\n  // As a consequence, x_h" +
	"i has either 0 or 1 leading zeroes. Shifting x_hi\n  // right by either 9 or 10 bits (depending on x_hi's MSB) will therefore\n  // leave the top 10 MSBs (bits 54 ..= 63) off and the 11th MSB (bit 53) on.\n  wuffs_base__multiply_u64__output x = wuffs_base__multiply_u64(man, po10[1]);\n  uint64_t x_hi = x.hi;\n  uint64_t x_lo = x.lo;\n\n  // Before we shift right by at least 9 bits, recall that the look-up table\n  // entry was possibly truncated. We have so far only calculated a lower bound\n  // for the product (man * e), where e is (10 ** exp10). The upper bound would\n  // add a further (man * 1) to the 128-bit product, which overflows the lower\n  // 64-bit limb if ((x_lo + man) < man).\n  //\n  // If overflow occurs, that adds 1 to x_hi. Since we're about to shift right\n  // by at least 9 bits, that carried 1 can be ignored unless the higher 64-bit\n  // limb's low 9 bits are all on.\n  if (((x_hi & 0x1FF) == 0x1FF) && ((x_lo + man) < man)) {\n    // Refine our calculation of (man * e). Before, our approximation of e us" +
	"ed\n    // a \"low resolution\" 64-bit mantissa. Now use a \"high resolution\" 128-bit\n    // mantissa. We've already calculated x = (man * bits_0_to_63_incl_of_e).\n    // Now calculate y = (man * bits_64_to_127_incl_of_e).\n    wuffs_base__multiply_u64__output y = wuffs_base__multiply_u64(man, po10[0]);\n    uint64_t y_hi = y.hi;\n    uint64_t y_lo = y.lo;\n\n    // Merge the 128-bit x and 128-bit y, which overlap by 64 bits, to\n    // calculate the 192-bit product of the 64-bit man by the 128-bit e.\n    // As we exit this if-block, we only care about the high 128 bits\n    // (merged_hi and merged_lo) of that 192-bit product.\n    uint64_t merged_hi = x_hi;\n    uint64_t merged_lo = x_lo + y_hi;\n    if (merged_lo < x_lo) {\n      merged_hi++;  // Carry the overflow bit.\n    }\n\n    // The \"high resolution\" approximation of e is still a lower bound. Once\n    // again, see if the upper bound is large enough to produce a different\n    // result. This time, if it does, give up instead of reaching for an even\n    // more preci" +
	"se approximation to e.\n    //\n    // This three-part check is similar to the two-part check that guarded the\n    // if block that we're now in, but it has an extra term for the middle 64\n    // bits (checking that adding 1 to merged_lo would overflow).\n    if (((merged_hi & 0x1FF) == 0x1FF) && ((merged_lo + 1) == 0) &&\n        (y_lo + man < man)) {\n      return -1;\n    }\n\n    // Replace the 128-bit x with merged.\n    x_hi = merged_hi;\n    x_lo = merged_lo;\n  }\n\n  // As mentioned above, shifting x_hi right by either 9 or 10 bits will leave\n  // the top 10 MSBs (bits 54 ..= 63) off and the 11th MSB (bit 53) on. If the\n  // MSB (before shifting) was on, adjust ret_exp2 for the larger shift.\n  //\n  // Having bit 53 on (and higher bits off) means that ret_mantissa is a 54-bit\n  // number.\n  uint64_t msb = x_hi >> 63;\n  uint64_t ret_mantissa = x_hi >> (msb + 9);\n  ret_exp2 -= 1 ^ msb;\n\n  // IEEE 754 rounds to-nearest with ties rounded to-even. Rounding to-even can\n  // be tricky. If we're half-way between two exact" +
	"ly representable numbers\n  // (x's low 73 bits are zero and the next 2 bits that matter are \"01\"), give\n  // up instead of trying to pick the winner.\n  //\n  // Technically, we could tighten the condition by changing \"73\" to \"73 or 74,\n  // depending on msb\", but a flat \"73\" is simpler.\n  if ((x_lo == 0) && ((x_hi & 0x1FF) == 0) && ((ret_mantissa & 3) == 1)) {\n    return -1;\n  }\n\n  // If we're not halfway then it's rounding to-nearest. Starting with a 54-bit\n  // number, carry the lowest bit (bit 0) up if it's on. Regardless of whether\n  // it was on or off, shifting right by one then produces a 53-bit number. If\n  // carrying up overflowed, shift again.\n  ret_mantissa += ret_mantissa & 1;\n  ret_mantissa >>= 1;\n  // This if block is equivalent to (but benchmarks slightly faster than) the\n  // following branchless form:\n  //    uint64_t overflow_adjustment = ret_mantissa >> 53;\n  //    ret_mantissa >>= overflow_adjustment;\n  //    ret_exp2 += overflow_adjustment;\n  if ((ret_mantissa >> 53) > 0) {\n    ret_mantis" +
	"sa >>= 1;\n    ret_exp2++;\n  }\n\n  // Starting with a 53-bit number, IEEE 754 double-precision normal numbers\n  // have an implicit mantissa bit. Mask that away and keep the low 52 bits.\n  ret_mantissa &= 0x000FFFFFFFFFFFFF;\n\n  // Pack the bits and return.\n  return ((int64_t)(ret_mantissa | (ret_exp2 << 52)));\n}\n\n" +
	"" +
	"// --------\n\nstatic wuffs_base__result_f64  //\nwuffs_base__private_implementation__parse_number_f64_special(\n    wuffs_base__slice_u8 s,\n    uint32_t options) {\n  do {\n    if (options & WUFFS_BASE__PARSE_NUMBER_FXX__REJECT_INF_AND_NAN) {\n      goto fail;\n    }\n\n    uint8_t* p = s.ptr;\n    uint8_t* q = s.ptr + s.len;\n\n    for (; (p < q) && (*p == '_'); p++) {\n    }\n    if (p >= q) {\n      goto fail;\n    }\n\n    // Parse sign.\n    bool negative = false;\n    do {\n      if (*p == '+') {\n        p++;\n      } else if (*p == '-') {\n        negative = true;\n        p++;\n      } else {\n        break;\n      }\n      for (; (p < q) && (*p == '_'); p++) {\n      }\n    } while (0);\n    if (p >= q) {\n      goto fail;\n    }\n\n    bool nan = false;\n    switch (p[0]) {\n      case 'I':\n      case 'i':\n        if (((q - p) < 3) ||                     //\n            ((p[1] != 'N') && (p[1] != 'n')) ||  //\n            ((p[2] != 'F') && (p[2] != 'f'))) {\n          goto fail;\n        }\n        p += 3;\n\n        if ((p >= q) || (*p == '_" +
	"')) {\n          break;\n        } else if (((q - p) < 5) ||                     //\n                   ((p[0] != 'I') && (p[0] != 'i')) ||  //\n                   ((p[1] != 'N') && (p[1] != 'n')) ||  //\n                   ((p[2] != 'I') && (p[2] != 'i')) ||  //\n                   ((p[3] != 'T') && (p[3] != 't')) ||  //\n                   ((p[4] != 'Y') && (p[4] != 'y'))) {\n          goto fail;\n        }\n        p += 5;\n\n        if ((p >= q) || (*p == '_')) {\n          break;\n        }\n        goto fail;\n\n      case 'N':\n      case 'n':\n        if (((q - p) < 3) ||                     //\n            ((p[1] != 'A') && (p[1] != 'a')) ||  //\n            ((p[2] != 'N') && (p[2] != 'n'))) {\n          goto fail;\n        }\n        p += 3;\n\n        if ((p >= q) || (*p == '_')) {\n          nan = true;\n          break;\n        }\n        goto fail;\n\n      default:\n        goto fail;\n    }\n\n    // Finish.\n    for (; (p < q) && (*p == '_'); p++) {\n    }\n    if (p != q) {\n      goto fail;\n    }\n    wuffs_base__result_f64 ret;\n" +
	"    ret.status.repr = NULL;\n    ret.value = wuffs_base__ieee_754_bit_representation__from_u64_to_f64(\n        (nan ? 0x7FFFFFFFFFFFFFFF : 0x7FF0000000000000) |\n        (negative ? 0x8000000000000000 : 0));\n    return ret;\n  } while (0);\n\nfail:\n  do {\n    wuffs_base__result_f64 ret;\n    ret.status.repr = wuffs_base__error__bad_argument;\n    ret.value = 0;\n    return ret;\n  } while (0);\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__result_f64  //\nwuffs_base__private_implementation__high_prec_dec__to_f64(\n    wuffs_base__private_implementation__high_prec_dec* h,\n    uint32_t options) {\n  do {\n    // powers converts decimal powers of 10 to binary powers of 2. For example,\n    // (10000 >> 13) is 1. It stops before the elements exceed 60, also known\n    // as WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL.\n    static const uint32_t num_powers = 19;\n    static const uint8_t powers[19] = {\n        0,  3,  6,  9,  13, 16, 19, 23, 26, 29,  //\n        33, 36, 39, 43, 46, 49, 53, 56, 59,      //\n    };\n\n    // Handl" +
	"e zero and obvious extremes. The largest and smallest positive\n    // finite f64 values are approximately 1.8e+308 and 4.9e-324.\n    if ((h->num_digits == 0) || (h->decimal_point < -326)) {\n      goto zero;\n    } else if (h->decimal_point > 310) {\n      goto infinity;\n    }\n\n    // Try the fast Eisel-Lemire algorithm again. Calculating the (man, exp10)\n    // pair from the high_prec_dec h is more correct but slower than the\n    // approach taken in wuffs_base__parse_number_f64. The latter is optimized\n    // for the common cases (e.g. assuming no underscores or a leading '+'\n    // sign) rather than the full set of cases allowed by the Wuffs API.\n    if (h->num_digits <= 19) {\n      uint64_t man = 0;\n      uint32_t i;\n      for (i = 0; i < h->num_digits; i++) {\n        man = (10 * man) + h->digits[i];\n      }\n      int32_t exp10 = h->decimal_point - ((int32_t)(h->num_digits));\n      if ((man != 0) && (-307 <= exp10) && (exp10 <= 288)) {\n        int64_t r =\n            wuffs_base__private_implementation__parse" +
	"_number_f64_eisel_lemire(\n                man, exp10);\n        if (r >= 0) {\n          wuffs_base__result_f64 ret;\n          ret.status.repr = NULL;\n          ret.value = wuffs_base__ieee_754_bit_representation__from_u64_to_f64(\n              ((uint64_t)r) | (((uint64_t)(h->negative)) << 63));\n          return ret;\n        }\n      }\n    }\n\n    // Scale by powers of 2 until we're in the range [½ .. 1], which gives us\n    // our exponent (in base-2). First we shift right, possibly a little too\n    // far, ending with a value certainly below 1 and possibly below ½...\n    const int32_t f64_bias = -1023;\n    int32_t exp2 = 0;\n    while (h->decimal_point > 0) {\n      uint32_t n = (uint32_t)(+h->decimal_point);\n      uint32_t shift =\n          (n < num_powers)\n              ? powers[n]\n              : WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL;\n\n      wuffs_base__private_implementation__high_prec_dec__small_rshift(h, shift);\n      if (h->decimal_point <\n          -WUFFS_BASE__PRIVATE_IMPLEMENTATION__" +
	"HPD__DECIMAL_POINT__RANGE) {\n        goto zero;\n      }\n      exp2 += (int32_t)shift;\n    }\n    // ...then we shift left, putting us in [½ .. 1].\n    while (h->decimal_point <= 0) {\n      uint32_t shift;\n      if (h->decimal_point == 0) {\n        if (h->digits[0] >= 5) {\n          break;\n        }\n        shift = (h->digits[0] < 2) ? 2 : 1;\n      } else {\n        uint32_t n = (uint32_t)(-h->decimal_point);\n        shift = (n < num_powers)\n                    ? powers[n]\n                    : WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL;\n      }\n\n      wuffs_base__private_implementation__high_prec_dec__small_lshift(h, shift);\n      if (h->decimal_point >\n          +WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__DECIMAL_POINT__RANGE) {\n        goto infinity;\n      }\n      exp2 -= (int32_t)shift;\n    }\n\n    // We're in the range [½ .. 1] but f64 uses [1 .. 2].\n    exp2--;\n\n    // The minimum normal exponent is (f64_bias + 1).\n    while ((f64_bias + 1) > exp2) {\n      uint32_t n = (uint32_t)((f64_bias + 1" +
	") - exp2);\n      if (n > WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL) {\n        n = WUFFS_BASE__PRIVATE_IMPLEMENTATION__HPD__SHIFT__MAX_INCL;\n      }\n      wuffs_base__private_implementation__high_prec_dec__small_rshift(h, n);\n      exp2 += (int32_t)n;\n    }\n\n    // Check for overflow.\n    if ((exp2 - f64_bias) >= 0x07FF) {  // (1 << 11) - 1.\n      goto infinity;\n    }\n\n    // Extract 53 bits for the mantissa (in base-2).\n    wuffs_base__private_implementation__high_prec_dec__small_lshift(h, 53);\n    uint64_t man2 =\n        wuffs_base__private_implementation__high_prec_dec__rounded_integer(h);\n\n    // Rounding might have added one bit. If so, shift and re-check overflow.\n    if ((man2 >> 53) != 0) {\n      man2 >>= 1;\n      exp2++;\n      if ((exp2 - f64_bias) >= 0x07FF) {  // (1 << 11) - 1.\n        goto infinity;\n      }\n    }\n\n    // Handle subnormal numbers.\n    if ((man2 >> 52) == 0) {\n      exp2 = f64_bias;\n    }\n\n    // Pack the bits and return.\n    uint64_t exp2_bits =\n        (uint64_t)((ex" +
	"p2 - f64_bias) & 0x07FF);              // (1 << 11) - 1.\n    uint64_t bits = (man2 & 0x000FFFFFFFFFFFFF) |            // (1 << 52) - 1.\n                    (exp2_bits << 52) |                      //\n                    (h->negative ? 0x8000000000000000 : 0);  // (1 << 63).\n\n    wuffs_base__result_f64 ret;\n    ret.status.repr = NULL;\n    ret.value = wuffs_base__ieee_754_bit_representation__from_u64_to_f64(bits);\n    return ret;\n  } while (0);\n\nzero:\n  do {\n    uint64_t bits = h->negative ? 0x8000000000000000 : 0;\n\n    wuffs_base__result_f64 ret;\n    ret.status.repr = NULL;\n    ret.value = wuffs_base__ieee_754_bit_representation__from_u64_to_f64(bits);\n    return ret;\n  } while (0);\n\ninfinity:\n  do {\n    if (options & WUFFS_BASE__PARSE_NUMBER_FXX__REJECT_INF_AND_NAN) {\n      wuffs_base__result_f64 ret;\n      ret.status.repr = wuffs_base__error__bad_argument;\n      ret.value = 0;\n      return ret;\n    }\n\n    uint64_t bits = h->negative ? 0xFFF0000000000000 : 0x7FF0000000000000;\n\n    wuffs_base__result_f64 ret;\n" +
	"    ret.status.repr = NULL;\n    ret.value = wuffs_base__ieee_754_bit_representation__from_u64_to_f64(bits);\n    return ret;\n  } while (0);\n}\n\nstatic inline bool  //\nwuffs_base__private_implementation__is_decimal_digit(uint8_t c) {\n  return ('0' <= c) && (c <= '9');\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__result_f64  //\nwuffs_base__parse_number_f64(wuffs_base__slice_u8 s, uint32_t options) {\n  // In practice, almost all \"dd.ddddE±xxx\" numbers can be represented\n  // losslessly by a uint64_t mantissa \"dddddd\" and an int32_t base-10\n  // exponent, adjusting \"xxx\" for the position (if present) of the decimal\n  // separator '.' or ','.\n  //\n  // This (u64 man, i32 exp10) data structure is superficially similar to the\n  // \"Do It Yourself Floating Point\" type from Loitsch (†), but the exponent\n  // here is base-10, not base-2.\n  //\n  // If s's number fits in a (man, exp10), parse that pair with the\n  // Eisel-Lemire algorithm. If not, or if Eisel-Lemire fails, parsing s with\n  // the fallback algorithm is slower" +
	" but comprehensive.\n  //\n  // † \"Printing Floating-Point Numbers Quickly and Accurately with Integers\"\n  // (https://www.cs.tufts.edu/~nr/cs257/archive/florian-loitsch/printf.pdf).\n  // Florian Loitsch is also the primary contributor to\n  // https://github.com/google/double-conversion\n  do {\n    // Calculating that (man, exp10) pair needs to stay within s's bounds.\n    // Provided that s isn't extremely long, work on a NUL-terminated copy of\n    // s's contents. The NUL byte isn't a valid part of \"±dd.ddddE±xxx\".\n    //\n    // As the pointer p walks the contents, it's faster to repeatedly check \"is\n    // *p a valid digit\" than \"is p within bounds and *p a valid digit\".\n    if (s.len >= 256) {\n      goto fallback;\n    }\n    uint8_t z[256];\n    memcpy(&z[0], s.ptr, s.len);\n    z[s.len] = 0;\n    const uint8_t* p = &z[0];\n\n    // Look for a leading minus sign. Technically, we could also look for an\n    // optional plus sign, but the \"script/process-json-numbers.c with -p\"\n    // benchmark is noticably slower" +
	" if we do. It's optional and, in practice,\n    // usually absent. Let the fallback catch it.\n    bool negative = (*p == '-');\n    if (negative) {\n      p++;\n    }\n\n    // After walking \"dd.dddd\", comparing p later with p now will produce the\n    // number of \"d\"s and \".\"s.\n    const uint8_t* const start_of_digits_ptr = p;\n\n    // Walk the \"d\"s before a '.', 'E', NUL byte, etc. If it starts with '0',\n    // it must be a single '0'. If it starts with a non-zero decimal digit, it\n    // can be a sequence of decimal digits.\n    //\n    // Update the man variable during the walk. It's OK if man overflows now.\n    // We'll detect that later.\n    uint64_t man;\n    if (*p == '0') {\n      man = 0;\n      p++;\n      if (wuffs_base__private_implementation__is_decimal_digit(*p)) {\n        goto fallback;\n      }\n    } else if (wuffs_base__private_implementation__is_decimal_digit(*p)) {\n      man = ((uint8_t)(*p - '0'));\n      p++;\n      for (; wuffs_base__private_implementation__is_decimal_digit(*p); p++) {\n        man = (1" +
	"0 * man) + ((uint8_t)(*p - '0'));\n      }\n    } else {\n      goto fallback;\n    }\n\n    // Walk the \"d\"s after the optional decimal separator ('.' or ','),\n    // updating the man and exp10 variables.\n    int32_t exp10 = 0;\n    if (*p ==\n        ((options & WUFFS_BASE__PARSE_NUMBER_FXX__DECIMAL_SEPARATOR_IS_A_COMMA)\n             ? ','\n             : '.')) {\n      p++;\n      const uint8_t* first_after_separator_ptr = p;\n      if (!wuffs_base__private_implementation__is_decimal_digit(*p)) {\n        goto fallback;\n      }\n      man = (10 * man) + ((uint8_t)(*p - '0'));\n      p++;\n      for (; wuffs_base__private_implementation__is_decimal_digit(*p); p++) {\n        man = (10 * man) + ((uint8_t)(*p - '0'));\n      }\n      exp10 = ((int32_t)(first_after_separator_ptr - p));\n    }\n\n    // Count the number of digits:\n    //  - for an input of \"314159\",  digit_count is 6.\n    //  - for an input of \"3.14159\", digit_count is 7.\n    //\n    // This is off-by-one if there is a decimal separator. That's OK for now.\n    // We'" +
	"ll correct for that later. The \"script/process-json-numbers.c with\n    // -p\" benchmark is noticably slower if we try to correct for that now.\n    uint32_t digit_count = (uint32_t)(p - start_of_digits_ptr);\n\n    // Update exp10 for the optional exponent, starting with 'E' or 'e'.\n    if ((*p | 0x20) == 'e') {\n      p++;\n      int32_t exp_sign = +1;\n      if (*p == '-') {\n        p++;\n        exp_sign = -1;\n      } else if (*p == '+') {\n        p++;\n      }\n      if (!wuffs_base__private_implementation__is_decimal_digit(*p)) {\n        goto fallback;\n      }\n      int32_t exp_num = ((uint8_t)(*p - '0'));\n      p++;\n      // The rest of the exp_num walking has a peculiar control flow but, once\n      // again, the \"script/process-json-numbers.c with -p\" benchmark is\n      // sensitive to alternative formulations.\n      if (wuffs_base__private_implementation__is_decimal_digit(*p)) {\n        exp_num = (10 * exp_num) + ((uint8_t)(*p - '0'));\n        p++;\n      }\n      if (wuffs_base__private_implementation__is_decim" +
	"al_digit(*p)) {\n        exp_num = (10 * exp_num) + ((uint8_t)(*p - '0'));\n        p++;\n      }\n      while (wuffs_base__private_implementation__is_decimal_digit(*p)) {\n        if (exp_num > 0x1000000) {\n          goto fallback;\n        }\n        exp_num = (10 * exp_num) + ((uint8_t)(*p - '0'));\n        p++;\n      }\n      exp10 += exp_sign * exp_num;\n    }\n\n    // The Wuffs API is that the original slice has no trailing data. It also\n    // allows underscores, which we don't catch here but the fallback should.\n    if (p != &z[s.len]) {\n      goto fallback;\n    }\n\n    // Check that the uint64_t typed man variable has not overflowed, based on\n    // digit_count.\n    //\n    // For reference:\n    //   - (1 << 63) is  9223372036854775808, which has 19 decimal digits.\n    //   - (1 << 64) is 18446744073709551616, which has 20 decimal digits.\n    //   - 19 nines,  9999999999999999999, is  0x8AC7230489E7FFFF, which has 64\n    //     bits and 16 hexadecimal digits.\n    //   - 20 nines, 99999999999999999999, is 0x56BC75" +
	"E2D630FFFFF, which has 67\n    //     bits and 17 hexadecimal digits.\n    if (digit_count > 19) {\n      // Even if we have more than 19 pseudo-digits, it's not yet definitely an\n      // overflow. Recall that digit_count might be off-by-one (too large) if\n      // there's a decimal separator. It will also over-report the number of\n      // meaningful digits if the input looks something like \"0.000dddExxx\".\n      //\n      // We adjust by the number of leading '0's and '.'s and re-compare to 19.\n      // Once again, technically, we could skip ','s too, but that perturbs the\n      // \"script/process-json-numbers.c with -p\" benchmark.\n      const uint8_t* q = start_of_digits_ptr;\n      for (; (*q == '0') || (*q == '.'); q++) {\n      }\n      digit_count -= (uint32_t)(q - start_of_digits_ptr);\n      if (digit_count > 19) {\n        goto fallback;\n      }\n    }\n\n    // The wuffs_base__private_implementation__parse_number_f64_eisel_lemire\n    // preconditions include that exp10 is in the range [-307 ..= 288].\n    if ((" +
	"exp10 < -307) || (288 < exp10)) {\n      goto fallback;\n    }\n\n    // If both man and (10 ** exp10) are exactly representable by a double, we\n    // don't need to run the Eisel-Lemire algorithm.\n    if ((-22 <= exp10) && (exp10 <= 22) && ((man >> 53) == 0)) {\n      double d = (double)man;\n      if (exp10 >= 0) {\n        d *= wuffs_base__private_implementation__f64_powers_of_10[+exp10];\n      } else {\n        d /= wuffs_base__private_implementation__f64_powers_of_10[-exp10];\n      }\n      wuffs_base__result_f64 ret;\n      ret.status.repr = NULL;\n      ret.value = negative ? -d : +d;\n      return ret;\n    }\n\n    // The wuffs_base__private_implementation__parse_number_f64_eisel_lemire\n    // preconditions include that man is non-zero. Parsing \"0\" should be caught\n    // by the \"If both man and (10 ** exp10)\" above, but \"0e99\" might not.\n    if (man == 0) {\n      goto fallback;\n    }\n\n    // Our man and exp10 are in range. Run the Eisel-Lemire algorithm.\n    int64_t r =\n        wuffs_base__private_implementation__" +
	"parse_number_f64_eisel_lemire(\n            man, exp10);\n    if (r < 0) {\n      goto fallback;\n    }\n    wuffs_base__result_f64 ret;\n    ret.status.repr = NULL;\n    ret.value = wuffs_base__ieee_754_bit_representation__from_u64_to_f64(\n        ((uint64_t)r) | (((uint64_t)negative) << 63));\n    return ret;\n  } while (0);\n\nfallback:\n  do {\n    wuffs_base__private_implementation__high_prec_dec h;\n    wuffs_base__status status =\n        wuffs_base__private_implementation__high_prec_dec__parse(&h, s,\n                                                                 options);\n    if (status.repr) {\n      return wuffs_base__private_implementation__parse_number_f64_special(\n          s, options);\n    }\n    return wuffs_base__private_implementation__high_prec_dec__to_f64(&h,\n                                                                     options);\n  } while (0);\n}\n\n" +
	"" +
	"// --------\n\nstatic inline size_t  //\nwuffs_base__private_implementation__render_inf(wuffs_base__slice_u8 dst,\n                                               bool neg,\n                                               uint32_t options) {\n  if (neg) {\n    if (dst.len < 4) {\n      return 0;\n    }\n    wuffs_base__store_u32le__no_bounds_check(dst.ptr, 0x666E492D);  // '-Inf'le.\n    return 4;\n  }\n\n  if (options & WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN) {\n    if (dst.len < 4) {\n      return 0;\n    }\n    wuffs_base__store_u32le__no_bounds_check(dst.ptr, 0x666E492B);  // '+Inf'le.\n    return 4;\n  }\n\n  if (dst.len < 3) {\n    return 0;\n  }\n  wuffs_base__store_u24le__no_bounds_check(dst.ptr, 0x666E49);  // 'Inf'le.\n  return 3;\n}\n\nstatic inline size_t  //\nwuffs_base__private_implementation__render_nan(wuffs_base__slice_u8 dst) {\n  if (dst.len < 3) {\n    return 0;\n  }\n  wuffs_base__store_u24le__no_bounds_check(dst.ptr, 0x4E614E);  // 'NaN'le.\n  return 3;\n}\n\nstatic size_t  //\nwuffs_base__private_implementation__high" +
	"_prec_dec__render_exponent_absent(\n    wuffs_base__slice_u8 dst,\n    wuffs_base__private_implementation__high_prec_dec* h,\n    uint32_t precision,\n    uint32_t options) {\n  size_t n = (h->negative ||\n              (options & WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN))\n                 ? 1\n                 : 0;\n  if (h->decimal_point <= 0) {\n    n += 1;\n  } else {\n    n += (size_t)(h->decimal_point);\n  }\n  if (precision > 0) {\n    n += precision + 1;  // +1 for the '.'.\n  }\n\n  // Don't modify dst if the formatted number won't fit.\n  if (n > dst.len) {\n    return 0;\n  }\n\n  // Align-left or align-right.\n  uint8_t* ptr = (options & WUFFS_BASE__RENDER_NUMBER_XXX__ALIGN_RIGHT)\n                     ? &dst.ptr[dst.len - n]\n                     : &dst.ptr[0];\n\n  // Leading \"±\".\n  if (h->negative) {\n    *ptr++ = '-';\n  } else if (options & WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN) {\n    *ptr++ = '+';\n  }\n\n  // Integral digits.\n  if (h->decimal_point <= 0) {\n    *ptr++ = '0';\n  } else {\n    uint32_t m =\n" +
	"        wuffs_base__u32__min(h->num_digits, (uint32_t)(h->decimal_point));\n    uint32_t i = 0;\n    for (; i < m; i++) {\n      *ptr++ = (uint8_t)('0' | h->digits[i]);\n    }\n    for (; i < (uint32_t)(h->decimal_point); i++) {\n      *ptr++ = '0';\n    }\n  }\n\n  // Separator and then fractional digits.\n  if (precision > 0) {\n    *ptr++ =\n        (options & WUFFS_BASE__RENDER_NUMBER_FXX__DECIMAL_SEPARATOR_IS_A_COMMA)\n            ? ','\n            : '.';\n    uint32_t i = 0;\n    for (; i < precision; i++) {\n      uint32_t j = ((uint32_t)(h->decimal_point)) + i;\n      *ptr++ = (uint8_t)('0' | ((j < h->num_digits) ? h->digits[j] : 0));\n    }\n  }\n\n  return n;\n}\n\nstatic size_t  //\nwuffs_base__private_implementation__high_prec_dec__render_exponent_present(\n    wuffs_base__slice_u8 dst,\n    wuffs_base__private_implementation__high_prec_dec* h,\n    uint32_t precision,\n    uint32_t options) {\n  int32_t exp = 0;\n  if (h->num_digits > 0) {\n    exp = h->decimal_point - 1;\n  }\n  bool negative_exp = exp < 0;\n  if (negative_exp) {\n" +
	"    exp = -exp;\n  }\n\n  size_t n = (h->negative ||\n              (options & WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN))\n                 ? 4\n                 : 3;  // Mininum 3 bytes: first digit and then \"e±\".\n  if (precision > 0) {\n    n += precision + 1;  // +1 for the '.'.\n  }\n  n += (exp < 100) ? 2 : 3;\n\n  // Don't modify dst if the formatted number won't fit.\n  if (n > dst.len) {\n    return 0;\n  }\n\n  // Align-left or align-right.\n  uint8_t* ptr = (options & WUFFS_BASE__RENDER_NUMBER_XXX__ALIGN_RIGHT)\n                     ? &dst.ptr[dst.len - n]\n                     : &dst.ptr[0];\n\n  // Leading \"±\".\n  if (h->negative) {\n    *ptr++ = '-';\n  } else if (options & WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN) {\n    *ptr++ = '+';\n  }\n\n  // Integral digit.\n  if (h->num_digits > 0) {\n    *ptr++ = (uint8_t)('0' | h->digits[0]);\n  } else {\n    *ptr++ = '0';\n  }\n\n  // Separator and then fractional digits.\n  if (precision > 0) {\n    *ptr++ =\n        (options & WUFFS_BASE__RENDER_NUMBER_FXX__DECIMAL_SEPA" +
	"RATOR_IS_A_COMMA)\n            ? ','\n            : '.';\n    uint32_t i = 1;\n    uint32_t j = wuffs_base__u32__min(h->num_digits, precision + 1);\n    for (; i < j; i++) {\n      *ptr++ = (uint8_t)('0' | h->digits[i]);\n    }\n    for (; i <= precision; i++) {\n      *ptr++ = '0';\n    }\n  }\n\n  // Exponent: \"e±\" and then 2 or 3 digits.\n  *ptr++ = 'e';\n  *ptr++ = negative_exp ? '-' : '+';\n  if (exp < 10) {\n    *ptr++ = '0';\n    *ptr++ = (uint8_t)('0' | exp);\n  } else if (exp < 100) {\n    *ptr++ = (uint8_t)('0' | (exp / 10));\n    *ptr++ = (uint8_t)('0' | (exp % 10));\n  } else {\n    int32_t e = exp / 100;\n    exp -= e * 100;\n    *ptr++ = (uint8_t)('0' | e);\n    *ptr++ = (uint8_t)('0' | (exp / 10));\n    *ptr++ = (uint8_t)('0' | (exp % 10));\n  }\n\n  return n;\n}\n\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__render_number_f64(wuffs_base__slice_u8 dst,\n                              double x,\n                              uint32_t precision,\n                              uint32_t options) {\n  // Decompose x (64 bits) into " +
	"negativity (1 bit), base-2 exponent (11 bits\n  // with a -1023 bias) and mantissa (52 bits).\n  uint64_t bits = wuffs_base__ieee_754_bit_representation__from_f64_to_u64(x);\n  bool neg = (bits >> 63) != 0;\n  int32_t exp2 = ((int32_t)(bits >> 52)) & 0x7FF;\n  uint64_t man = bits & 0x000FFFFFFFFFFFFFul;\n\n  // Apply the exponent bias and set the implicit top bit of the mantissa,\n  // unless x is subnormal. Also take care of Inf and NaN.\n  if (exp2 == 0x7FF) {\n    if (man != 0) {\n      return wuffs_base__private_implementation__render_nan(dst);\n    }\n    return wuffs_base__private_implementation__render_inf(dst, neg, options);\n  } else if (exp2 == 0) {\n    exp2 = -1022;\n  } else {\n    exp2 -= 1023;\n    man |= 0x0010000000000000ul;\n  }\n\n  // Ensure that precision isn't too large.\n  if (precision > 4095) {\n    precision = 4095;\n  }\n\n  // Convert from the (neg, exp2, man) tuple to an HPD.\n  wuffs_base__private_implementation__high_prec_dec h;\n  wuffs_base__private_implementation__high_prec_dec__assign(&h, man, neg);\n  " +
	"if (h.num_digits > 0) {\n    wuffs_base__private_implementation__high_prec_dec__lshift(\n        &h, exp2 - 52);  // 52 mantissa bits.\n  }\n\n  // Handle the \"%e\" and \"%f\" formats.\n  switch (options & (WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_ABSENT |\n                     WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_PRESENT)) {\n    case WUFFS_BASE__RENDER_NUMBER_FXX__EXPONENT_ABSENT:  // The \"%\"f\" format.\n      if (options & WUFFS_BASE__RENDER_NUMBER_FXX__JUST_ENOUGH_PRECISION) {\n        wuffs_base__private_implementation__high_prec_dec__round_just_enough(\n            &h, exp2, man);\n        int32_t p = ((int32_t)(h.num_digits)) - h.decimal_point;\n        precision = ((uint32_t)(wuffs_base__i32__max(0, p)));\n      } else {\n        wuffs_base__private_implementation__high_prec_dec__round_nearest(\n            &h, ((int32_t)precision) + h.decimal_point);\n      }\n      return wuffs_base__private_implementation__high_prec_dec__render_exponent_absent(\n          dst, &h, precision, options);\n\n    case WUFFS_BASE__RENDER_NUMBE" +
	"R_FXX__EXPONENT_PRESENT:  // The \"%e\" format.\n      if (options & WUFFS_BASE__RENDER_NUMBER_FXX__JUST_ENOUGH_PRECISION) {\n        wuffs_base__private_implementation__high_prec_dec__round_just_enough(\n            &h, exp2, man);\n        precision = (h.num_digits > 0) ? (h.num_digits - 1) : 0;\n      } else {\n        wuffs_base__private_implementation__high_prec_dec__round_nearest(\n            &h, ((int32_t)precision) + 1);\n      }\n      return wuffs_base__private_implementation__high_prec_dec__render_exponent_present(\n          dst, &h, precision, options);\n  }\n\n  // We have the \"%g\" format and so precision means the number of significant\n  // digits, not the number of digits after the decimal separator. Perform\n  // rounding and determine whether to use \"%e\" or \"%f\".\n  int32_t e_threshold = 0;\n  if (options & WUFFS_BASE__RENDER_NUMBER_FXX__JUST_ENOUGH_PRECISION) {\n    wuffs_base__private_implementation__high_prec_dec__round_just_enough(\n        &h, exp2, man);\n    precision = h.num_digits;\n    e_threshold = 6;" +
	"\n  } else {\n    if (precision == 0) {\n      precision = 1;\n    }\n    wuffs_base__private_implementation__high_prec_dec__round_nearest(\n        &h, ((int32_t)precision));\n    e_threshold = ((int32_t)precision);\n    int32_t nd = ((int32_t)(h.num_digits));\n    if ((e_threshold > nd) && (nd >= h.decimal_point)) {\n      e_threshold = nd;\n    }\n  }\n\n  // Use the \"%e\" format if the exponent is large.\n  int32_t e = h.decimal_point - 1;\n  if ((e < -4) || (e_threshold <= e)) {\n    uint32_t p = wuffs_base__u32__min(precision, h.num_digits);\n    return wuffs_base__private_implementation__high_prec_dec__render_exponent_present(\n        dst, &h, (p > 0) ? (p - 1) : 0, options);\n  }\n\n  // Use the \"%f\" format otherwise.\n  int32_t p = ((int32_t)precision);\n  if (p > h.decimal_point) {\n    p = ((int32_t)(h.num_digits));\n  }\n  precision = ((uint32_t)(wuffs_base__i32__max(0, p - h.decimal_point)));\n  return wuffs_base__private_implementation__high_prec_dec__render_exponent_absent(\n      dst, &h, precision, options);\n}\n" +
	""

const BaseFloatConvSubmoduleDataC = "" +
	"// ---------------- IEEE 754 Floating Point\n\n// The etc__hpd_left_shift and etc__powers_of_5 tables were printed by\n// script/print-hpd-left-shift.go. That script has an optional -comments flag,\n// whose output is not copied here, which prints further detail.\n//\n// These tables are used in\n// wuffs_base__private_implementation__high_prec_dec__lshift_num_new_digits.\n\n// wuffs_base__private_implementation__hpd_left_shift[i] encodes the number of\n// new digits created after multiplying a positive integer by (1 << i): the\n// additional length in the decimal representation. For example, shifting \"234\"\n// by 3 (equivalent to multiplying by 8) will produce \"1872\". Going from a\n// 3-length string to a 4-length string means that 1 new digit was added (and\n// existing digits may have changed).\n//\n// Shifting by i can add either N or N-1 new digits, depending on whether the\n// original positive integer compares >= or < to the i'th power of 5 (as 10\n// equals 2 * 5). Comparison is lexicographic, not numerical.\n//\n// For " +
	"example, shifting by 4 (i.e. multiplying by 16) can add 1 or 2 new\n// digits, depending on a lexicographic comparison to (5 ** 4), i.e. \"625\":\n//  - (\"1\"      << 4) is \"16\",       which adds 1 new digit.\n//  - (\"5678\"   << 4) is \"90848\",    which adds 1 new digit.\n//  - (\"624\"    << 4) is \"9984\",     which adds 1 new digit.\n//  - (\"62498\"  << 4) is \"999968\",   which adds 1 new digit.\n//  - (\"625\"    << 4) is \"10000\",    which adds 2 new digits.\n//  - (\"625001\" << 4) is \"10000016\", which adds 2 new digits.\n//  - (\"7008\"   << 4) is \"112128\",   which adds 2 new digits.\n//  - (\"99\"     << 4) is \"1584\",     which adds 2 new digits.\n//\n// Thus, when i is 4, N is 2 and (5 ** i) is \"625\". This etc__hpd_left_shift\n// array encodes this as:\n//  - etc__hpd_left_shift[4] is 0x1006 = (2 << 11) | 0x0006.\n//  - etc__hpd_left_shift[5] is 0x1009 = (? << 11) | 0x0009.\n// where the ? isn't relevant for i == 4.\n//\n// The high 5 bits of etc__hpd_left_shift[i] is N, the higher of the two\n// possible number of new digits. The low 1" +
	"1 bits are an offset into the\n// etc__powers_of_5 array (of length 0x051C, so offsets fit in 11 bits). When i\n// is 4, its offset and the next one is 6 and 9, and etc__powers_of_5[6 .. 9]\n// is the string \"\\x06\\x02\\x05\", so the relevant power of 5 is \"625\".\n//\n// Thanks to Ken Thompson for the original idea.\nstatic const uint16_t wuffs_base__private_implementation__hpd_left_shift[65] = {\n    0x0000, 0x0800, 0x0801, 0x0803, 0x1006, 0x1009, 0x100D, 0x1812, 0x1817,\n    0x181D, 0x2024, 0x202B, 0x2033, 0x203C, 0x2846, 0x2850, 0x285B, 0x3067,\n    0x3073, 0x3080, 0x388E, 0x389C, 0x38AB, 0x38BB, 0x40CC, 0x40DD, 0x40EF,\n    0x4902, 0x4915, 0x4929, 0x513E, 0x5153, 0x5169, 0x5180, 0x5998, 0x59B0,\n    0x59C9, 0x61E3, 0x61FD, 0x6218, 0x6A34, 0x6A50, 0x6A6D, 0x6A8B, 0x72AA,\n    0x72C9, 0x72E9, 0x7B0A, 0x7B2B, 0x7B4D, 0x8370, 0x8393, 0x83B7, 0x83DC,\n    0x8C02, 0x8C28, 0x8C4F, 0x9477, 0x949F, 0x94C8, 0x9CF2, 0x051C, 0x051C,\n    0x051C, 0x051C,\n};\n\n// wuffs_base__private_implementation__powers_of_5 contains the powers of 5,\n" +
	"// concatenated together: \"5\", \"25\", \"125\", \"625\", \"3125\", etc.\nstatic const uint8_t wuffs_base__private_implementation__powers_of_5[0x051C] = {\n    5, 2, 5, 1, 2, 5, 6, 2, 5, 3, 1, 2, 5, 1, 5, 6, 2, 5, 7, 8, 1, 2, 5, 3, 9,\n    0, 6, 2, 5, 1, 9, 5, 3, 1, 2, 5, 9, 7, 6, 5, 6, 2, 5, 4, 8, 8, 2, 8, 1, 2,\n    5, 2, 4, 4, 1, 4, 0, 6, 2, 5, 1, 2, 2, 0, 7, 0, 3, 1, 2, 5, 6, 1, 0, 3, 5,\n    1, 5, 6, 2, 5, 3, 0, 5, 1, 7, 5, 7, 8, 1, 2, 5, 1, 5, 2, 5, 8, 7, 8, 9, 0,\n    6, 2, 5, 7, 6, 2, 9, 3, 9, 4, 5, 3, 1, 2, 5, 3, 8, 1, 4, 6, 9, 7, 2, 6, 5,\n    6, 2, 5, 1, 9, 0, 7, 3, 4, 8, 6, 3, 2, 8, 1, 2, 5, 9, 5, 3, 6, 7, 4, 3, 1,\n    6, 4, 0, 6, 2, 5, 4, 7, 6, 8, 3, 7, 1, 5, 8, 2, 0, 3, 1, 2, 5, 2, 3, 8, 4,\n    1, 8, 5, 7, 9, 1, 0, 1, 5, 6, 2, 5, 1, 1, 9, 2, 0, 9, 2, 8, 9, 5, 5, 0, 7,\n    8, 1, 2, 5, 5, 9, 6, 0, 4, 6, 4, 4, 7, 7, 5, 3, 9, 0, 6, 2, 5, 2, 9, 8, 0,\n    2, 3, 2, 2, 3, 8, 7, 6, 9, 5, 3, 1, 2, 5, 1, 4, 9, 0, 1, 1, 6, 1, 1, 9, 3,\n    8, 4, 7, 6, 5, 6, 2, 5, 7, 4, 5, 0, 5, 8, 0, 5, 9, 6, 9, 2, 3, 8, 2, 8, 1,\n    2, 5, " +
	"3, 7, 2, 5, 2, 9, 0, 2, 9, 8, 4, 6, 1, 9, 1, 4, 0, 6, 2, 5, 1, 8, 6,\n    2, 6, 4, 5, 1, 4, 9, 2, 3, 0, 9, 5, 7, 0, 3, 1, 2, 5, 9, 3, 1, 3, 2, 2, 5,\n    7, 4, 6, 1, 5, 4, 7, 8, 5, 1, 5, 6, 2, 5, 4, 6, 5, 6, 6, 1, 2, 8, 7, 3, 0,\n    7, 7, 3, 9, 2, 5, 7, 8, 1, 2, 5, 2, 3, 2, 8, 3, 0, 6, 4, 3, 6, 5, 3, 8, 6,\n    9, 6, 2, 8, 9, 0, 6, 2, 5, 1, 1, 6, 4, 1, 5, 3, 2, 1, 8, 2, 6, 9, 3, 4, 8,\n    1, 4, 4, 5, 3, 1, 2, 5, 5, 8, 2, 0, 7, 6, 6, 0, 9, 1, 3, 4, 6, 7, 4, 0, 7,\n    2, 2, 6, 5, 6, 2, 5, 2, 9, 1, 0, 3, 8, 3, 0, 4, 5, 6, 7, 3, 3, 7, 0, 3, 6,\n    1, 3, 2, 8, 1, 2, 5, 1, 4, 5, 5, 1, 9, 1, 5, 2, 2, 8, 3, 6, 6, 8, 5, 1, 8,\n    0, 6, 6, 4, 0, 6, 2, 5, 7, 2, 7, 5, 9, 5, 7, 6, 1, 4, 1, 8, 3, 4, 2, 5, 9,\n    0, 3, 3, 2, 0, 3, 1, 2, 5, 3, 6, 3, 7, 9, 7, 8, 8, 0, 7, 0, 9, 1, 7, 1, 2,\n    9, 5, 1, 6, 6, 0, 1, 5, 6, 2, 5, 1, 8, 1, 8, 9, 8, 9, 4, 0, 3, 5, 4, 5, 8,\n    5, 6, 4, 7, 5, 8, 3, 0, 0, 7, 8, 1, 2, 5, 9, 0, 9, 4, 9, 4, 7, 0, 1, 7, 7,\n    2, 9, 2, 8, 2, 3, 7, 9, 1, 5, 0, 3, 9, 0, 6, 2, 5, 4, 5, 4, 7, 4, 7, 3, 5,\n    0, " +
	"8, 8, 6, 4, 6, 4, 1, 1, 8, 9, 5, 7, 5, 1, 9, 5, 3, 1, 2, 5, 2, 2, 7, 3,\n    7, 3, 6, 7, 5, 4, 4, 3, 2, 3, 2, 0, 5, 9, 4, 7, 8, 7, 5, 9, 7, 6, 5, 6, 2,\n    5, 1, 1, 3, 6, 8, 6, 8, 3, 7, 7, 2, 1, 6, 1, 6, 0, 2, 9, 7, 3, 9, 3, 7, 9,\n    8, 8, 2, 8, 1, 2, 5, 5, 6, 8, 4, 3, 4, 1, 8, 8, 6, 0, 8, 0, 8, 0, 1, 4, 8,\n    6, 9, 6, 8, 9, 9, 4, 1, 4, 0, 6, 2, 5, 2, 8, 4, 2, 1, 7, 0, 9, 4, 3, 0, 4,\n    0, 4, 0, 0, 7, 4, 3, 4, 8, 4, 4, 9, 7, 0, 7, 0, 3, 1, 2, 5, 1, 4, 2, 1, 0,\n    8, 5, 4, 7, 1, 5, 2, 0, 2, 0, 0, 3, 7, 1, 7, 4, 2, 2, 4, 8, 5, 3, 5, 1, 5,\n    6, 2, 5, 7, 1, 0, 5, 4, 2, 7, 3, 5, 7, 6, 0, 1, 0, 0, 1, 8, 5, 8, 7, 1, 1,\n    2, 4, 2, 6, 7, 5, 7, 8, 1, 2, 5, 3, 5, 5, 2, 7, 1, 3, 6, 7, 8, 8, 0, 0, 5,\n    0, 0, 9, 2, 9, 3, 5, 5, 6, 2, 1, 3, 3, 7, 8, 9, 0, 6, 2, 5, 1, 7, 7, 6, 3,\n    5, 6, 8, 3, 9, 4, 0, 0, 2, 5, 0, 4, 6, 4, 6, 7, 7, 8, 1, 0, 6, 6, 8, 9, 4,\n    5, 3, 1, 2, 5, 8, 8, 8, 1, 7, 8, 4, 1, 9, 7, 0, 0, 1, 2, 5, 2, 3, 2, 3, 3,\n    8, 9, 0, 5, 3, 3, 4, 4, 7, 2, 6, 5, 6, 2, 5, 4, 4, 4, 0, 8, 9, 2, 0, 9, 8,\n    " +
	"5, 0, 0, 6, 2, 6, 1, 6, 1, 6, 9, 4, 5, 2, 6, 6, 7, 2, 3, 6, 3, 2, 8, 1, 2,\n    5, 2, 2, 2, 0, 4, 4, 6, 0, 4, 9, 2, 5, 0, 3, 1, 3, 0, 8, 0, 8, 4, 7, 2, 6,\n    3, 3, 3, 6, 1, 8, 1, 6, 4, 0, 6, 2, 5, 1, 1, 1, 0, 2, 2, 3, 0, 2, 4, 6, 2,\n    5, 1, 5, 6, 5, 4, 0, 4, 2, 3, 6, 3, 1, 6, 6, 8, 0, 9, 0, 8, 2, 0, 3, 1, 2,\n    5, 5, 5, 5, 1, 1, 1, 5, 1, 2, 3, 1, 2, 5, 7, 8, 2, 7, 0, 2, 1, 1, 8, 1, 5,\n    8, 3, 4, 0, 4, 5, 4, 1, 0, 1, 5, 6, 2, 5, 2, 7, 7, 5, 5, 5, 7, 5, 6, 1, 5,\n    6, 2, 8, 9, 1, 3, 5, 1, 0, 5, 9, 0, 7, 9, 1, 7, 0, 2, 2, 7, 0, 5, 0, 7, 8,\n    1, 2, 5, 1, 3, 8, 7, 7, 7, 8, 7, 8, 0, 7, 8, 1, 4, 4, 5, 6, 7, 5, 5, 2, 9,\n    5, 3, 9, 5, 8, 5, 1, 1, 3, 5, 2, 5, 3, 9, 0, 6, 2, 5, 6, 9, 3, 8, 8, 9, 3,\n    9, 0, 3, 9, 0, 7, 2, 2, 8, 3, 7, 7, 6, 4, 7, 6, 9, 7, 9, 2, 5, 5, 6, 7, 6,\n    2, 6, 9, 5, 3, 1, 2, 5, 3, 4, 6, 9, 4, 4, 6, 9, 5, 1, 9, 5, 3, 6, 1, 4, 1,\n    8, 8, 8, 2, 3, 8, 4, 8, 9, 6, 2, 7, 8, 3, 8, 1, 3, 4, 7, 6, 5, 6, 2, 5, 1,\n    7, 3, 4, 7, 2, 3, 4, 7, 5, 9, 7, 6, 8, 0, 7, 0, 9, 4, 4, 1, 1, 9, 2, 4, 4,\n " +
	"   8, 1, 3, 9, 1, 9, 0, 6, 7, 3, 8, 2, 8, 1, 2, 5, 8, 6, 7, 3, 6, 1, 7, 3, 7,\n    9, 8, 8, 4, 0, 3, 5, 4, 7, 2, 0, 5, 9, 6, 2, 2, 4, 0, 6, 9, 5, 9, 5, 3, 3,\n    6, 9, 1, 4, 0, 6, 2, 5,\n};\n\n" +
	"" +
	"// --------\n\n// wuffs_base__private_implementation__powers_of_10 contains truncated\n// approximations to the powers of 10, ranging from 1e-307 to 1e+288 inclusive,\n// as 596 pairs of uint64_t values (a 128-bit mantissa).\n//\n// There's also an implicit third column (implied by a linear formula involving\n// the base-10 exponent) that is the base-2 exponent, biased by a magic\n// constant. That constant (1214 or 0x04BE) equals 1023 + 191. 1023 is the bias\n// for IEEE 754 double-precision floating point. 191 is ((3 * 64) - 1) and\n// wuffs_base__private_implementation__parse_number_f64_eisel_lemire works with\n// multiples-of-64-bit mantissas.\n//\n// For example, the third row holds the approximation to 1e-305:\n//   0xE0B62E29_29ABA83C_331ACDAB_FE94DE87 * (2 ** (0x0049 - 0x04BE))\n//\n// Similarly, 1e+4 is approximated by:\n//   0x9C400000_00000000_00000000_00000000 * (2 ** (0x044C - 0x04BE))\n//\n// Similarly, 1e+68 is approximated by:\n//   0xED63A231_D4C4FB27_4CA7AAA8_63EE4BDD * (2 ** (0x0520 - 0x04BE))\n//\n// This table" +
	" was generated by by script/print-mpb-powers-of-10.go\nstatic const uint64_t wuffs_base__private_implementation__powers_of_10[596][2] =\n    {\n        {0xA5D3B6D479F8E056, 0x8FD0C16206306BAB},  // 1e-307\n        {0x8F48A4899877186C, 0xB3C4F1BA87BC8696},  // 1e-306\n        {0x331ACDABFE94DE87, 0xE0B62E2929ABA83C},  // 1e-305\n        {0x9FF0C08B7F1D0B14, 0x8C71DCD9BA0B4925},  // 1e-304\n        {0x07ECF0AE5EE44DD9, 0xAF8E5410288E1B6F},  // 1e-303\n        {0xC9E82CD9F69D6150, 0xDB71E91432B1A24A},  // 1e-302\n        {0xBE311C083A225CD2, 0x892731AC9FAF056E},  // 1e-301\n        {0x6DBD630A48AAF406, 0xAB70FE17C79AC6CA},  // 1e-300\n        {0x092CBBCCDAD5B108, 0xD64D3D9DB981787D},  // 1e-299\n        {0x25BBF56008C58EA5, 0x85F0468293F0EB4E},  // 1e-298\n        {0xAF2AF2B80AF6F24E, 0xA76C582338ED2621},  // 1e-297\n        {0x1AF5AF660DB4AEE1, 0xD1476E2C07286FAA},  // 1e-296\n        {0x50D98D9FC890ED4D, 0x82CCA4DB847945CA},  // 1e-295\n        {0xE50FF107BAB528A0, 0xA37FCE126597973C},  // 1e-294\n        {0x1E53ED49A96272C8, " +
	"0xCC5FC196FEFD7D0C},  // 1e-293\n        {0x25E8E89C13BB0F7A, 0xFF77B1FCBEBCDC4F},  // 1e-292\n        {0x77B191618C54E9AC, 0x9FAACF3DF73609B1},  // 1e-291\n        {0xD59DF5B9EF6A2417, 0xC795830D75038C1D},  // 1e-290\n        {0x4B0573286B44AD1D, 0xF97AE3D0D2446F25},  // 1e-289\n        {0x4EE367F9430AEC32, 0x9BECCE62836AC577},  // 1e-288\n        {0x229C41F793CDA73F, 0xC2E801FB244576D5},  // 1e-287\n        {0x6B43527578C1110F, 0xF3A20279ED56D48A},  // 1e-286\n        {0x830A13896B78AAA9, 0x9845418C345644D6},  // 1e-285\n        {0x23CC986BC656D553, 0xBE5691EF416BD60C},  // 1e-284\n        {0x2CBFBE86B7EC8AA8, 0xEDEC366B11C6CB8F},  // 1e-283\n        {0x7BF7D71432F3D6A9, 0x94B3A202EB1C3F39},  // 1e-282\n        {0xDAF5CCD93FB0CC53, 0xB9E08A83A5E34F07},  // 1e-281\n        {0xD1B3400F8F9CFF68, 0xE858AD248F5C22C9},  // 1e-280\n        {0x23100809B9C21FA1, 0x91376C36D99995BE},  // 1e-279\n        {0xABD40A0C2832A78A, 0xB58547448FFFFB2D},  // 1e-278\n        {0x16C90C8F323F516C, 0xE2E69915B3FFF9F9},  // 1e-277\n        {0xAE3DA" +
	"7D97F6792E3, 0x8DD01FAD907FFC3B},  // 1e-276\n        {0x99CD11CFDF41779C, 0xB1442798F49FFB4A},  // 1e-275\n        {0x40405643D711D583, 0xDD95317F31C7FA1D},  // 1e-274\n        {0x482835EA666B2572, 0x8A7D3EEF7F1CFC52},  // 1e-273\n        {0xDA3243650005EECF, 0xAD1C8EAB5EE43B66},  // 1e-272\n        {0x90BED43E40076A82, 0xD863B256369D4A40},  // 1e-271\n        {0x5A7744A6E804A291, 0x873E4F75E2224E68},  // 1e-270\n        {0x711515D0A205CB36, 0xA90DE3535AAAE202},  // 1e-269\n        {0x0D5A5B44CA873E03, 0xD3515C2831559A83},  // 1e-268\n        {0xE858790AFE9486C2, 0x8412D9991ED58091},  // 1e-267\n        {0x626E974DBE39A872, 0xA5178FFF668AE0B6},  // 1e-266\n        {0xFB0A3D212DC8128F, 0xCE5D73FF402D98E3},  // 1e-265\n        {0x7CE66634BC9D0B99, 0x80FA687F881C7F8E},  // 1e-264\n        {0x1C1FFFC1EBC44E80, 0xA139029F6A239F72},  // 1e-263\n        {0xA327FFB266B56220, 0xC987434744AC874E},  // 1e-262\n        {0x4BF1FF9F0062BAA8, 0xFBE9141915D7A922},  // 1e-261\n        {0x6F773FC3603DB4A9, 0x9D71AC8FADA6C9B5},  // 1e-260\n   " +
	"     {0xCB550FB4384D21D3, 0xC4CE17B399107C22},  // 1e-259\n        {0x7E2A53A146606A48, 0xF6019DA07F549B2B},  // 1e-258\n        {0x2EDA7444CBFC426D, 0x99C102844F94E0FB},  // 1e-257\n        {0xFA911155FEFB5308, 0xC0314325637A1939},  // 1e-256\n        {0x793555AB7EBA27CA, 0xF03D93EEBC589F88},  // 1e-255\n        {0x4BC1558B2F3458DE, 0x96267C7535B763B5},  // 1e-254\n        {0x9EB1AAEDFB016F16, 0xBBB01B9283253CA2},  // 1e-253\n        {0x465E15A979C1CADC, 0xEA9C227723EE8BCB},  // 1e-252\n        {0x0BFACD89EC191EC9, 0x92A1958A7675175F},  // 1e-251\n        {0xCEF980EC671F667B, 0xB749FAED14125D36},  // 1e-250\n        {0x82B7E12780E7401A, 0xE51C79A85916F484},  // 1e-249\n        {0xD1B2ECB8B0908810, 0x8F31CC0937AE58D2},  // 1e-248\n        {0x861FA7E6DCB4AA15, 0xB2FE3F0B8599EF07},  // 1e-247\n        {0x67A791E093E1D49A, 0xDFBDCECE67006AC9},  // 1e-246\n        {0xE0C8BB2C5C6D24E0, 0x8BD6A141006042BD},  // 1e-245\n        {0x58FAE9F773886E18, 0xAECC49914078536D},  // 1e-244\n        {0xAF39A475506A899E, 0xDA7F5BF590966848},  " +
	"// 1e-243\n        {0x6D8406C952429603, 0x888F99797A5E012D},  // 1e-242\n        {0xC8E5087BA6D33B83, 0xAAB37FD7D8F58178},  // 1e-241\n        {0xFB1E4A9A90880A64, 0xD5605FCDCF32E1D6},  // 1e-240\n        {0x5CF2EEA09A55067F, 0x855C3BE0A17FCD26},  // 1e-239\n        {0xF42FAA48C0EA481E, 0xA6B34AD8C9DFC06F},  // 1e-238\n        {0xF13B94DAF124DA26, 0xD0601D8EFC57B08B},  // 1e-237\n        {0x76C53D08D6B70858, 0x823C12795DB6CE57},  // 1e-236\n        {0x54768C4B0C64CA6E, 0xA2CB1717B52481ED},  // 1e-235\n        {0xA9942F5DCF7DFD09, 0xCB7DDCDDA26DA268},  // 1e-234\n        {0xD3F93B35435D7C4C, 0xFE5D54150B090B02},  // 1e-233\n        {0xC47BC5014A1A6DAF, 0x9EFA548D26E5A6E1},  // 1e-232\n        {0x359AB6419CA1091B, 0xC6B8E9B0709F109A},  // 1e-231\n        {0xC30163D203C94B62, 0xF867241C8CC6D4C0},  // 1e-230\n        {0x79E0DE63425DCF1D, 0x9B407691D7FC44F8},  // 1e-229\n        {0x985915FC12F542E4, 0xC21094364DFB5636},  // 1e-228\n        {0x3E6F5B7B17B2939D, 0xF294B943E17A2BC4},  // 1e-227\n        {0xA705992CEECF9C42, 0x979CF3C" +
	"A6CEC5B5A},  // 1e-226\n        {0x50C6FF782A838353, 0xBD8430BD08277231},  // 1e-225\n        {0xA4F8BF5635246428, 0xECE53CEC4A314EBD},  // 1e-224\n        {0x871B7795E136BE99, 0x940F4613AE5ED136},  // 1e-223\n        {0x28E2557B59846E3F, 0xB913179899F68584},  // 1e-222\n        {0x331AEADA2FE589CF, 0xE757DD7EC07426E5},  // 1e-221\n        {0x3FF0D2C85DEF7621, 0x9096EA6F3848984F},  // 1e-220\n        {0x0FED077A756B53A9, 0xB4BCA50B065ABE63},  // 1e-219\n        {0xD3E8495912C62894, 0xE1EBCE4DC7F16DFB},  // 1e-218\n        {0x64712DD7ABBBD95C, 0x8D3360F09CF6E4BD},  // 1e-217\n        {0xBD8D794D96AACFB3, 0xB080392CC4349DEC},  // 1e-216\n        {0xECF0D7A0FC5583A0, 0xDCA04777F541C567},  // 1e-215\n        {0xF41686C49DB57244, 0x89E42CAAF9491B60},  // 1e-214\n        {0x311C2875C522CED5, 0xAC5D37D5B79B6239},  // 1e-213\n        {0x7D633293366B828B, 0xD77485CB25823AC7},  // 1e-212\n        {0xAE5DFF9C02033197, 0x86A8D39EF77164BC},  // 1e-211\n        {0xD9F57F830283FDFC, 0xA8530886B54DBDEB},  // 1e-210\n        {0xD072DF63C324FD" +
	"7B, 0xD267CAA862A12D66},  // 1e-209\n        {0x4247CB9E59F71E6D, 0x8380DEA93DA4BC60},  // 1e-208\n        {0x52D9BE85F074E608, 0xA46116538D0DEB78},  // 1e-207\n        {0x67902E276C921F8B, 0xCD795BE870516656},  // 1e-206\n        {0x00BA1CD8A3DB53B6, 0x806BD9714632DFF6},  // 1e-205\n        {0x80E8A40ECCD228A4, 0xA086CFCD97BF97F3},  // 1e-204\n        {0x6122CD128006B2CD, 0xC8A883C0FDAF7DF0},  // 1e-203\n        {0x796B805720085F81, 0xFAD2A4B13D1B5D6C},  // 1e-202\n        {0xCBE3303674053BB0, 0x9CC3A6EEC6311A63},  // 1e-201\n        {0xBEDBFC4411068A9C, 0xC3F490AA77BD60FC},  // 1e-200\n        {0xEE92FB5515482D44, 0xF4F1B4D515ACB93B},  // 1e-199\n        {0x751BDD152D4D1C4A, 0x991711052D8BF3C5},  // 1e-198\n        {0xD262D45A78A0635D, 0xBF5CD54678EEF0B6},  // 1e-197\n        {0x86FB897116C87C34, 0xEF340A98172AACE4},  // 1e-196\n        {0xD45D35E6AE3D4DA0, 0x9580869F0E7AAC0E},  // 1e-195\n        {0x8974836059CCA109, 0xBAE0A846D2195712},  // 1e-194\n        {0x2BD1A438703FC94B, 0xE998D258869FACD7},  // 1e-193\n        {0x7" +
	"B6306A34627DDCF, 0x91FF83775423CC06},  // 1e-192\n        {0x1A3BC84C17B1D542, 0xB67F6455292CBF08},  // 1e-191\n        {0x20CABA5F1D9E4A93, 0xE41F3D6A7377EECA},  // 1e-190\n        {0x547EB47B7282EE9C, 0x8E938662882AF53E},  // 1e-189\n        {0xE99E619A4F23AA43, 0xB23867FB2A35B28D},  // 1e-188\n        {0x6405FA00E2EC94D4, 0xDEC681F9F4C31F31},  // 1e-187\n        {0xDE83BC408DD3DD04, 0x8B3C113C38F9F37E},  // 1e-186\n        {0x9624AB50B148D445, 0xAE0B158B4738705E},  // 1e-185\n        {0x3BADD624DD9B0957, 0xD98DDAEE19068C76},  // 1e-184\n        {0xE54CA5D70A80E5D6, 0x87F8A8D4CFA417C9},  // 1e-183\n        {0x5E9FCF4CCD211F4C, 0xA9F6D30A038D1DBC},  // 1e-182\n        {0x7647C3200069671F, 0xD47487CC8470652B},  // 1e-181\n        {0x29ECD9F40041E073, 0x84C8D4DFD2C63F3B},  // 1e-180\n        {0xF468107100525890, 0xA5FB0A17C777CF09},  // 1e-179\n        {0x7182148D4066EEB4, 0xCF79CC9DB955C2CC},  // 1e-178\n        {0xC6F14CD848405530, 0x81AC1FE293D599BF},  // 1e-177\n        {0xB8ADA00E5A506A7C, 0xA21727DB38CB002F},  // 1e-176" +
	"\n        {0xA6D90811F0E4851C, 0xCA9CF1D206FDC03B},  // 1e-175\n        {0x908F4A166D1DA663, 0xFD442E4688BD304A},  // 1e-174\n        {0x9A598E4E043287FE, 0x9E4A9CEC15763E2E},  // 1e-173\n        {0x40EFF1E1853F29FD, 0xC5DD44271AD3CDBA},  // 1e-172\n        {0xD12BEE59E68EF47C, 0xF7549530E188C128},  // 1e-171\n        {0x82BB74F8301958CE, 0x9A94DD3E8CF578B9},  // 1e-170\n        {0xE36A52363C1FAF01, 0xC13A148E3032D6E7},  // 1e-169\n        {0xDC44E6C3CB279AC1, 0xF18899B1BC3F8CA1},  // 1e-168\n        {0x29AB103A5EF8C0B9, 0x96F5600F15A7B7E5},  // 1e-167\n        {0x7415D448F6B6F0E7, 0xBCB2B812DB11A5DE},  // 1e-166\n        {0x111B495B3464AD21, 0xEBDF661791D60F56},  // 1e-165\n        {0xCAB10DD900BEEC34, 0x936B9FCEBB25C995},  // 1e-164\n        {0x3D5D514F40EEA742, 0xB84687C269EF3BFB},  // 1e-163\n        {0x0CB4A5A3112A5112, 0xE65829B3046B0AFA},  // 1e-162\n        {0x47F0E785EABA72AB, 0x8FF71A0FE2C2E6DC},  // 1e-161\n        {0x59ED216765690F56, 0xB3F4E093DB73A093},  // 1e-160\n        {0x306869C13EC3532C, 0xE0F218B8D25088B8" +
	"},  // 1e-159\n        {0x1E414218C73A13FB, 0x8C974F7383725573},  // 1e-158\n        {0xE5D1929EF90898FA, 0xAFBD2350644EEACF},  // 1e-157\n        {0xDF45F746B74ABF39, 0xDBAC6C247D62A583},  // 1e-156\n        {0x6B8BBA8C328EB783, 0x894BC396CE5DA772},  // 1e-155\n        {0x066EA92F3F326564, 0xAB9EB47C81F5114F},  // 1e-154\n        {0xC80A537B0EFEFEBD, 0xD686619BA27255A2},  // 1e-153\n        {0xBD06742CE95F5F36, 0x8613FD0145877585},  // 1e-152\n        {0x2C48113823B73704, 0xA798FC4196E952E7},  // 1e-151\n        {0xF75A15862CA504C5, 0xD17F3B51FCA3A7A0},  // 1e-150\n        {0x9A984D73DBE722FB, 0x82EF85133DE648C4},  // 1e-149\n        {0xC13E60D0D2E0EBBA, 0xA3AB66580D5FDAF5},  // 1e-148\n        {0x318DF905079926A8, 0xCC963FEE10B7D1B3},  // 1e-147\n        {0xFDF17746497F7052, 0xFFBBCFE994E5C61F},  // 1e-146\n        {0xFEB6EA8BEDEFA633, 0x9FD561F1FD0F9BD3},  // 1e-145\n        {0xFE64A52EE96B8FC0, 0xC7CABA6E7C5382C8},  // 1e-144\n        {0x3DFDCE7AA3C673B0, 0xF9BD690A1B68637B},  // 1e-143\n        {0x06BEA10CA65C084E, 0x9C1" +
	"661A651213E2D},  // 1e-142\n        {0x486E494FCFF30A62, 0xC31BFA0FE5698DB8},  // 1e-141\n        {0x5A89DBA3C3EFCCFA, 0xF3E2F893DEC3F126},  // 1e-140\n        {0xF89629465A75E01C, 0x986DDB5C6B3A76B7},  // 1e-139\n        {0xF6BBB397F1135823, 0xBE89523386091465},  // 1e-138\n        {0x746AA07DED582E2C, 0xEE2BA6C0678B597F},  // 1e-137\n        {0xA8C2A44EB4571CDC, 0x94DB483840B717EF},  // 1e-136\n        {0x92F34D62616CE413, 0xBA121A4650E4DDEB},  // 1e-135\n        {0x77B020BAF9C81D17, 0xE896A0D7E51E1566},  // 1e-134\n        {0x0ACE1474DC1D122E, 0x915E2486EF32CD60},  // 1e-133\n        {0x0D819992132456BA, 0xB5B5ADA8AAFF80B8},  // 1e-132\n        {0x10E1FFF697ED6C69, 0xE3231912D5BF60E6},  // 1e-131\n        {0xCA8D3FFA1EF463C1, 0x8DF5EFABC5979C8F},  // 1e-130\n        {0xBD308FF8A6B17CB2, 0xB1736B96B6FD83B3},  // 1e-129\n        {0xAC7CB3F6D05DDBDE, 0xDDD0467C64BCE4A0},  // 1e-128\n        {0x6BCDF07A423AA96B, 0x8AA22C0DBEF60EE4},  // 1e-127\n        {0x86C16C98D2C953C6, 0xAD4AB7112EB3929D},  // 1e-126\n        {0xE871C7BF07" +
	"7BA8B7, 0xD89D64D57A607744},  // 1e-125\n        {0x11471CD764AD4972, 0x87625F056C7C4A8B},  // 1e-124\n        {0xD598E40D3DD89BCF, 0xA93AF6C6C79B5D2D},  // 1e-123\n        {0x4AFF1D108D4EC2C3, 0xD389B47879823479},  // 1e-122\n        {0xCEDF722A585139BA, 0x843610CB4BF160CB},  // 1e-121\n        {0xC2974EB4EE658828, 0xA54394FE1EEDB8FE},  // 1e-120\n        {0x733D226229FEEA32, 0xCE947A3DA6A9273E},  // 1e-119\n        {0x0806357D5A3F525F, 0x811CCC668829B887},  // 1e-118\n        {0xCA07C2DCB0CF26F7, 0xA163FF802A3426A8},  // 1e-117\n        {0xFC89B393DD02F0B5, 0xC9BCFF6034C13052},  // 1e-116\n        {0xBBAC2078D443ACE2, 0xFC2C3F3841F17C67},  // 1e-115\n        {0xD54B944B84AA4C0D, 0x9D9BA7832936EDC0},  // 1e-114\n        {0x0A9E795E65D4DF11, 0xC5029163F384A931},  // 1e-113\n        {0x4D4617B5FF4A16D5, 0xF64335BCF065D37D},  // 1e-112\n        {0x504BCED1BF8E4E45, 0x99EA0196163FA42E},  // 1e-111\n        {0xE45EC2862F71E1D6, 0xC06481FB9BCF8D39},  // 1e-110\n        {0x5D767327BB4E5A4C, 0xF07DA27A82C37088},  // 1e-109\n        " +
	"{0x3A6A07F8D510F86F, 0x964E858C91BA2655},  // 1e-108\n        {0x890489F70A55368B, 0xBBE226EFB628AFEA},  // 1e-107\n        {0x2B45AC74CCEA842E, 0xEADAB0ABA3B2DBE5},  // 1e-106\n        {0x3B0B8BC90012929D, 0x92C8AE6B464FC96F},  // 1e-105\n        {0x09CE6EBB40173744, 0xB77ADA0617E3BBCB},  // 1e-104\n        {0xCC420A6A101D0515, 0xE55990879DDCAABD},  // 1e-103\n        {0x9FA946824A12232D, 0x8F57FA54C2A9EAB6},  // 1e-102\n        {0x47939822DC96ABF9, 0xB32DF8E9F3546564},  // 1e-101\n        {0x59787E2B93BC56F7, 0xDFF9772470297EBD},  // 1e-100\n        {0x57EB4EDB3C55B65A, 0x8BFBEA76C619EF36},  // 1e-99\n        {0xEDE622920B6B23F1, 0xAEFAE51477A06B03},  // 1e-98\n        {0xE95FAB368E45ECED, 0xDAB99E59958885C4},  // 1e-97\n        {0x11DBCB0218EBB414, 0x88B402F7FD75539B},  // 1e-96\n        {0xD652BDC29F26A119, 0xAAE103B5FCD2A881},  // 1e-95\n        {0x4BE76D3346F0495F, 0xD59944A37C0752A2},  // 1e-94\n        {0x6F70A4400C562DDB, 0x857FCAE62D8493A5},  // 1e-93\n        {0xCB4CCD500F6BB952, 0xA6DFBD9FB8E5B88E},  // 1e-92\n   " +
	"     {0x7E2000A41346A7A7, 0xD097AD07A71F26B2},  // 1e-91\n        {0x8ED400668C0C28C8, 0x825ECC24C873782F},  // 1e-90\n        {0x728900802F0F32FA, 0xA2F67F2DFA90563B},  // 1e-89\n        {0x4F2B40A03AD2FFB9, 0xCBB41EF979346BCA},  // 1e-88\n        {0xE2F610C84987BFA8, 0xFEA126B7D78186BC},  // 1e-87\n        {0x0DD9CA7D2DF4D7C9, 0x9F24B832E6B0F436},  // 1e-86\n        {0x91503D1C79720DBB, 0xC6EDE63FA05D3143},  // 1e-85\n        {0x75A44C6397CE912A, 0xF8A95FCF88747D94},  // 1e-84\n        {0xC986AFBE3EE11ABA, 0x9B69DBE1B548CE7C},  // 1e-83\n        {0xFBE85BADCE996168, 0xC24452DA229B021B},  // 1e-82\n        {0xFAE27299423FB9C3, 0xF2D56790AB41C2A2},  // 1e-81\n        {0xDCCD879FC967D41A, 0x97C560BA6B0919A5},  // 1e-80\n        {0x5400E987BBC1C920, 0xBDB6B8E905CB600F},  // 1e-79\n        {0x290123E9AAB23B68, 0xED246723473E3813},  // 1e-78\n        {0xF9A0B6720AAF6521, 0x9436C0760C86E30B},  // 1e-77\n        {0xF808E40E8D5B3E69, 0xB94470938FA89BCE},  // 1e-76\n        {0xB60B1D1230B20E04, 0xE7958CB87392C2C2},  // 1e-75\n       " +
	" {0xB1C6F22B5E6F48C2, 0x90BD77F3483BB9B9},  // 1e-74\n        {0x1E38AEB6360B1AF3, 0xB4ECD5F01A4AA828},  // 1e-73\n        {0x25C6DA63C38DE1B0, 0xE2280B6C20DD5232},  // 1e-72\n        {0x579C487E5A38AD0E, 0x8D590723948A535F},  // 1e-71\n        {0x2D835A9DF0C6D851, 0xB0AF48EC79ACE837},  // 1e-70\n        {0xF8E431456CF88E65, 0xDCDB1B2798182244},  // 1e-69\n        {0x1B8E9ECB641B58FF, 0x8A08F0F8BF0F156B},  // 1e-68\n        {0xE272467E3D222F3F, 0xAC8B2D36EED2DAC5},  // 1e-67\n        {0x5B0ED81DCC6ABB0F, 0xD7ADF884AA879177},  // 1e-66\n        {0x98E947129FC2B4E9, 0x86CCBB52EA94BAEA},  // 1e-65\n        {0x3F2398D747B36224, 0xA87FEA27A539E9A5},  // 1e-64\n        {0x8EEC7F0D19A03AAD, 0xD29FE4B18E88640E},  // 1e-63\n        {0x1953CF68300424AC, 0x83A3EEEEF9153E89},  // 1e-62\n        {0x5FA8C3423C052DD7, 0xA48CEAAAB75A8E2B},  // 1e-61\n        {0x3792F412CB06794D, 0xCDB02555653131B6},  // 1e-60\n        {0xE2BBD88BBEE40BD0, 0x808E17555F3EBF11},  // 1e-59\n        {0x5B6ACEAEAE9D0EC4, 0xA0B19D2AB70E6ED6},  // 1e-58\n        {0x" +
	"F245825A5A445275, 0xC8DE047564D20A8B},  // 1e-57\n        {0xEED6E2F0F0D56712, 0xFB158592BE068D2E},  // 1e-56\n        {0x55464DD69685606B, 0x9CED737BB6C4183D},  // 1e-55\n        {0xAA97E14C3C26B886, 0xC428D05AA4751E4C},  // 1e-54\n        {0xD53DD99F4B3066A8, 0xF53304714D9265DF},  // 1e-53\n        {0xE546A8038EFE4029, 0x993FE2C6D07B7FAB},  // 1e-52\n        {0xDE98520472BDD033, 0xBF8FDB78849A5F96},  // 1e-51\n        {0x963E66858F6D4440, 0xEF73D256A5C0F77C},  // 1e-50\n        {0xDDE7001379A44AA8, 0x95A8637627989AAD},  // 1e-49\n        {0x5560C018580D5D52, 0xBB127C53B17EC159},  // 1e-48\n        {0xAAB8F01E6E10B4A6, 0xE9D71B689DDE71AF},  // 1e-47\n        {0xCAB3961304CA70E8, 0x9226712162AB070D},  // 1e-46\n        {0x3D607B97C5FD0D22, 0xB6B00D69BB55C8D1},  // 1e-45\n        {0x8CB89A7DB77C506A, 0xE45C10C42A2B3B05},  // 1e-44\n        {0x77F3608E92ADB242, 0x8EB98A7A9A5B04E3},  // 1e-43\n        {0x55F038B237591ED3, 0xB267ED1940F1C61C},  // 1e-42\n        {0x6B6C46DEC52F6688, 0xDF01E85F912E37A3},  // 1e-41\n        {0x2323" +
	"AC4B3B3DA015, 0x8B61313BBABCE2C6},  // 1e-40\n        {0xABEC975E0A0D081A, 0xAE397D8AA96C1B77},  // 1e-39\n        {0x96E7BD358C904A21, 0xD9C7DCED53C72255},  // 1e-38\n        {0x7E50D64177DA2E54, 0x881CEA14545C7575},  // 1e-37\n        {0xDDE50BD1D5D0B9E9, 0xAA242499697392D2},  // 1e-36\n        {0x955E4EC64B44E864, 0xD4AD2DBFC3D07787},  // 1e-35\n        {0xBD5AF13BEF0B113E, 0x84EC3C97DA624AB4},  // 1e-34\n        {0xECB1AD8AEACDD58E, 0xA6274BBDD0FADD61},  // 1e-33\n        {0x67DE18EDA5814AF2, 0xCFB11EAD453994BA},  // 1e-32\n        {0x80EACF948770CED7, 0x81CEB32C4B43FCF4},  // 1e-31\n        {0xA1258379A94D028D, 0xA2425FF75E14FC31},  // 1e-30\n        {0x096EE45813A04330, 0xCAD2F7F5359A3B3E},  // 1e-29\n        {0x8BCA9D6E188853FC, 0xFD87B5F28300CA0D},  // 1e-28\n        {0x775EA264CF55347D, 0x9E74D1B791E07E48},  // 1e-27\n        {0x95364AFE032A819D, 0xC612062576589DDA},  // 1e-26\n        {0x3A83DDBD83F52204, 0xF79687AED3EEC551},  // 1e-25\n        {0xC4926A9672793542, 0x9ABE14CD44753B52},  // 1e-24\n        {0x75B7053C" +
	"0F178293, 0xC16D9A0095928A27},  // 1e-23\n        {0x5324C68B12DD6338, 0xF1C90080BAF72CB1},  // 1e-22\n        {0xD3F6FC16EBCA5E03, 0x971DA05074DA7BEE},  // 1e-21\n        {0x88F4BB1CA6BCF584, 0xBCE5086492111AEA},  // 1e-20\n        {0x2B31E9E3D06C32E5, 0xEC1E4A7DB69561A5},  // 1e-19\n        {0x3AFF322E62439FCF, 0x9392EE8E921D5D07},  // 1e-18\n        {0x09BEFEB9FAD487C2, 0xB877AA3236A4B449},  // 1e-17\n        {0x4C2EBE687989A9B3, 0xE69594BEC44DE15B},  // 1e-16\n        {0x0F9D37014BF60A10, 0x901D7CF73AB0ACD9},  // 1e-15\n        {0x538484C19EF38C94, 0xB424DC35095CD80F},  // 1e-14\n        {0x2865A5F206B06FB9, 0xE12E13424BB40E13},  // 1e-13\n        {0xF93F87B7442E45D3, 0x8CBCCC096F5088CB},  // 1e-12\n        {0xF78F69A51539D748, 0xAFEBFF0BCB24AAFE},  // 1e-11\n        {0xB573440E5A884D1B, 0xDBE6FECEBDEDD5BE},  // 1e-10\n        {0x31680A88F8953030, 0x89705F4136B4A597},  // 1e-9\n        {0xFDC20D2B36BA7C3D, 0xABCC77118461CEFC},  // 1e-8\n        {0x3D32907604691B4C, 0xD6BF94D5E57A42BC},  // 1e-7\n        {0xA63F9A49C2C1B10" +
	"F, 0x8637BD05AF6C69B5},  // 1e-6\n        {0x0FCF80DC33721D53, 0xA7C5AC471B478423},  // 1e-5\n        {0xD3C36113404EA4A8, 0xD1B71758E219652B},  // 1e-4\n        {0x645A1CAC083126E9, 0x83126E978D4FDF3B},  // 1e-3\n        {0x3D70A3D70A3D70A3, 0xA3D70A3D70A3D70A},  // 1e-2\n        {0xCCCCCCCCCCCCCCCC, 0xCCCCCCCCCCCCCCCC},  // 1e-1\n        {0x0000000000000000, 0x8000000000000000},  // 1e0\n        {0x0000000000000000, 0xA000000000000000},  // 1e1\n        {0x0000000000000000, 0xC800000000000000},  // 1e2\n        {0x0000000000000000, 0xFA00000000000000},  // 1e3\n        {0x0000000000000000, 0x9C40000000000000},  // 1e4\n        {0x0000000000000000, 0xC350000000000000},  // 1e5\n        {0x0000000000000000, 0xF424000000000000},  // 1e6\n        {0x0000000000000000, 0x9896800000000000},  // 1e7\n        {0x0000000000000000, 0xBEBC200000000000},  // 1e8\n        {0x0000000000000000, 0xEE6B280000000000},  // 1e9\n        {0x0000000000000000, 0x9502F90000000000},  // 1e10\n        {0x0000000000000000, 0xBA43B74000000000},  // 1e1" +
	"1\n        {0x0000000000000000, 0xE8D4A51000000000},  // 1e12\n        {0x0000000000000000, 0x9184E72A00000000},  // 1e13\n        {0x0000000000000000, 0xB5E620F480000000},  // 1e14\n        {0x0000000000000000, 0xE35FA931A0000000},  // 1e15\n        {0x0000000000000000, 0x8E1BC9BF04000000},  // 1e16\n        {0x0000000000000000, 0xB1A2BC2EC5000000},  // 1e17\n        {0x0000000000000000, 0xDE0B6B3A76400000},  // 1e18\n        {0x0000000000000000, 0x8AC7230489E80000},  // 1e19\n        {0x0000000000000000, 0xAD78EBC5AC620000},  // 1e20\n        {0x0000000000000000, 0xD8D726B7177A8000},  // 1e21\n        {0x0000000000000000, 0x878678326EAC9000},  // 1e22\n        {0x0000000000000000, 0xA968163F0A57B400},  // 1e23\n        {0x0000000000000000, 0xD3C21BCECCEDA100},  // 1e24\n        {0x0000000000000000, 0x84595161401484A0},  // 1e25\n        {0x0000000000000000, 0xA56FA5B99019A5C8},  // 1e26\n        {0x0000000000000000, 0xCECB8F27F4200F3A},  // 1e27\n        {0x4000000000000000, 0x813F3978F8940984},  // 1e28\n        {0x50000000" +
	"00000000, 0xA18F07D736B90BE5},  // 1e29\n        {0xA400000000000000, 0xC9F2C9CD04674EDE},  // 1e30\n        {0x4D00000000000000, 0xFC6F7C4045812296},  // 1e31\n        {0xF020000000000000, 0x9DC5ADA82B70B59D},  // 1e32\n        {0x6C28000000000000, 0xC5371912364CE305},  // 1e33\n        {0xC732000000000000, 0xF684DF56C3E01BC6},  // 1e34\n        {0x3C7F400000000000, 0x9A130B963A6C115C},  // 1e35\n        {0x4B9F100000000000, 0xC097CE7BC90715B3},  // 1e36\n        {0x1E86D40000000000, 0xF0BDC21ABB48DB20},  // 1e37\n        {0x1314448000000000, 0x96769950B50D88F4},  // 1e38\n        {0x17D955A000000000, 0xBC143FA4E250EB31},  // 1e39\n        {0x5DCFAB0800000000, 0xEB194F8E1AE525FD},  // 1e40\n        {0x5AA1CAE500000000, 0x92EFD1B8D0CF37BE},  // 1e41\n        {0xF14A3D9E40000000, 0xB7ABC627050305AD},  // 1e42\n        {0x6D9CCD05D0000000, 0xE596B7B0C643C719},  // 1e43\n        {0xE4820023A2000000, 0x8F7E32CE7BEA5C6F},  // 1e44\n        {0xDDA2802C8A800000, 0xB35DBF821AE4F38B},  // 1e45\n        {0xD50B2037AD200000, 0xE0352F62A" +
	"19E306E},  // 1e46\n        {0x4526F422CC340000, 0x8C213D9DA502DE45},  // 1e47\n        {0x9670B12B7F410000, 0xAF298D050E4395D6},  // 1e48\n        {0x3C0CDD765F114000, 0xDAF3F04651D47B4C},  // 1e49\n        {0xA5880A69FB6AC800, 0x88D8762BF324CD0F},  // 1e50\n        {0x8EEA0D047A457A00, 0xAB0E93B6EFEE0053},  // 1e51\n        {0x72A4904598D6D880, 0xD5D238A4ABE98068},  // 1e52\n        {0x47A6DA2B7F864750, 0x85A36366EB71F041},  // 1e53\n        {0x999090B65F67D924, 0xA70C3C40A64E6C51},  // 1e54\n        {0xFFF4B4E3F741CF6D, 0xD0CF4B50CFE20765},  // 1e55\n        {0xBFF8F10E7A8921A4, 0x82818F1281ED449F},  // 1e56\n        {0xAFF72D52192B6A0D, 0xA321F2D7226895C7},  // 1e57\n        {0x9BF4F8A69F764490, 0xCBEA6F8CEB02BB39},  // 1e58\n        {0x02F236D04753D5B4, 0xFEE50B7025C36A08},  // 1e59\n        {0x01D762422C946590, 0x9F4F2726179A2245},  // 1e60\n        {0x424D3AD2B7B97EF5, 0xC722F0EF9D80AAD6},  // 1e61\n        {0xD2E0898765A7DEB2, 0xF8EBAD2B84E0D58B},  // 1e62\n        {0x63CC55F49F88EB2F, 0x9B934C3B330C8577},  // 1e63\n  " +
	"      {0x3CBF6B71C76B25FB, 0xC2781F49FFCFA6D5},  // 1e64\n        {0x8BEF464E3945EF7A, 0xF316271C7FC3908A},  // 1e65\n        {0x97758BF0E3CBB5AC, 0x97EDD871CFDA3A56},  // 1e66\n        {0x3D52EEED1CBEA317, 0xBDE94E8E43D0C8EC},  // 1e67\n        {0x4CA7AAA863EE4BDD, 0xED63A231D4C4FB27},  // 1e68\n        {0x8FE8CAA93E74EF6A, 0x945E455F24FB1CF8},  // 1e69\n        {0xB3E2FD538E122B44, 0xB975D6B6EE39E436},  // 1e70\n        {0x60DBBCA87196B616, 0xE7D34C64A9C85D44},  // 1e71\n        {0xBC8955E946FE31CD, 0x90E40FBEEA1D3A4A},  // 1e72\n        {0x6BABAB6398BDBE41, 0xB51D13AEA4A488DD},  // 1e73\n        {0xC696963C7EED2DD1, 0xE264589A4DCDAB14},  // 1e74\n        {0xFC1E1DE5CF543CA2, 0x8D7EB76070A08AEC},  // 1e75\n        {0x3B25A55F43294BCB, 0xB0DE65388CC8ADA8},  // 1e76\n        {0x49EF0EB713F39EBE, 0xDD15FE86AFFAD912},  // 1e77\n        {0x6E3569326C784337, 0x8A2DBF142DFCC7AB},  // 1e78\n        {0x49C2C37F07965404, 0xACB92ED9397BF996},  // 1e79\n        {0xDC33745EC97BE906, 0xD7E77A8F87DAF7FB},  // 1e80\n        {0x69A028BB3DED" +
	"71A3, 0x86F0AC99B4E8DAFD},  // 1e81\n        {0xC40832EA0D68CE0C, 0xA8ACD7C0222311BC},  // 1e82\n        {0xF50A3FA490C30190, 0xD2D80DB02AABD62B},  // 1e83\n        {0x792667C6DA79E0FA, 0x83C7088E1AAB65DB},  // 1e84\n        {0x577001B891185938, 0xA4B8CAB1A1563F52},  // 1e85\n        {0xED4C0226B55E6F86, 0xCDE6FD5E09ABCF26},  // 1e86\n        {0x544F8158315B05B4, 0x80B05E5AC60B6178},  // 1e87\n        {0x696361AE3DB1C721, 0xA0DC75F1778E39D6},  // 1e88\n        {0x03BC3A19CD1E38E9, 0xC913936DD571C84C},  // 1e89\n        {0x04AB48A04065C723, 0xFB5878494ACE3A5F},  // 1e90\n        {0x62EB0D64283F9C76, 0x9D174B2DCEC0E47B},  // 1e91\n        {0x3BA5D0BD324F8394, 0xC45D1DF942711D9A},  // 1e92\n        {0xCA8F44EC7EE36479, 0xF5746577930D6500},  // 1e93\n        {0x7E998B13CF4E1ECB, 0x9968BF6ABBE85F20},  // 1e94\n        {0x9E3FEDD8C321A67E, 0xBFC2EF456AE276E8},  // 1e95\n        {0xC5CFE94EF3EA101E, 0xEFB3AB16C59B14A2},  // 1e96\n        {0xBBA1F1D158724A12, 0x95D04AEE3B80ECE5},  // 1e97\n        {0x2A8A6E45AE8EDC97, 0xBB445DA9CA612" +
	"81F},  // 1e98\n        {0xF52D09D71A3293BD, 0xEA1575143CF97226},  // 1e99\n        {0x593C2626705F9C56, 0x924D692CA61BE758},  // 1e100\n        {0x6F8B2FB00C77836C, 0xB6E0C377CFA2E12E},  // 1e101\n        {0x0B6DFB9C0F956447, 0xE498F455C38B997A},  // 1e102\n        {0x4724BD4189BD5EAC, 0x8EDF98B59A373FEC},  // 1e103\n        {0x58EDEC91EC2CB657, 0xB2977EE300C50FE7},  // 1e104\n        {0x2F2967B66737E3ED, 0xDF3D5E9BC0F653E1},  // 1e105\n        {0xBD79E0D20082EE74, 0x8B865B215899F46C},  // 1e106\n        {0xECD8590680A3AA11, 0xAE67F1E9AEC07187},  // 1e107\n        {0xE80E6F4820CC9495, 0xDA01EE641A708DE9},  // 1e108\n        {0x3109058D147FDCDD, 0x884134FE908658B2},  // 1e109\n        {0xBD4B46F0599FD415, 0xAA51823E34A7EEDE},  // 1e110\n        {0x6C9E18AC7007C91A, 0xD4E5E2CDC1D1EA96},  // 1e111\n        {0x03E2CF6BC604DDB0, 0x850FADC09923329E},  // 1e112\n        {0x84DB8346B786151C, 0xA6539930BF6BFF45},  // 1e113\n        {0xE612641865679A63, 0xCFE87F7CEF46FF16},  // 1e114\n        {0x4FCB7E8F3F60C07E, 0x81F14FAE158C5F6E}, " +
	" // 1e115\n        {0xE3BE5E330F38F09D, 0xA26DA3999AEF7749},  // 1e116\n        {0x5CADF5BFD3072CC5, 0xCB090C8001AB551C},  // 1e117\n        {0x73D9732FC7C8F7F6, 0xFDCB4FA002162A63},  // 1e118\n        {0x2867E7FDDCDD9AFA, 0x9E9F11C4014DDA7E},  // 1e119\n        {0xB281E1FD541501B8, 0xC646D63501A1511D},  // 1e120\n        {0x1F225A7CA91A4226, 0xF7D88BC24209A565},  // 1e121\n        {0x3375788DE9B06958, 0x9AE757596946075F},  // 1e122\n        {0x0052D6B1641C83AE, 0xC1A12D2FC3978937},  // 1e123\n        {0xC0678C5DBD23A49A, 0xF209787BB47D6B84},  // 1e124\n        {0xF840B7BA963646E0, 0x9745EB4D50CE6332},  // 1e125\n        {0xB650E5A93BC3D898, 0xBD176620A501FBFF},  // 1e126\n        {0xA3E51F138AB4CEBE, 0xEC5D3FA8CE427AFF},  // 1e127\n        {0xC66F336C36B10137, 0x93BA47C980E98CDF},  // 1e128\n        {0xB80B0047445D4184, 0xB8A8D9BBE123F017},  // 1e129\n        {0xA60DC059157491E5, 0xE6D3102AD96CEC1D},  // 1e130\n        {0x87C89837AD68DB2F, 0x9043EA1AC7E41392},  // 1e131\n        {0x29BABE4598C311FB, 0xB454E4A179DD1877},  // " +
	"1e132\n        {0xF4296DD6FEF3D67A, 0xE16A1DC9D8545E94},  // 1e133\n        {0x1899E4A65F58660C, 0x8CE2529E2734BB1D},  // 1e134\n        {0x5EC05DCFF72E7F8F, 0xB01AE745B101E9E4},  // 1e135\n        {0x76707543F4FA1F73, 0xDC21A1171D42645D},  // 1e136\n        {0x6A06494A791C53A8, 0x899504AE72497EBA},  // 1e137\n        {0x0487DB9D17636892, 0xABFA45DA0EDBDE69},  // 1e138\n        {0x45A9D2845D3C42B6, 0xD6F8D7509292D603},  // 1e139\n        {0x0B8A2392BA45A9B2, 0x865B86925B9BC5C2},  // 1e140\n        {0x8E6CAC7768D7141E, 0xA7F26836F282B732},  // 1e141\n        {0x3207D795430CD926, 0xD1EF0244AF2364FF},  // 1e142\n        {0x7F44E6BD49E807B8, 0x8335616AED761F1F},  // 1e143\n        {0x5F16206C9C6209A6, 0xA402B9C5A8D3A6E7},  // 1e144\n        {0x36DBA887C37A8C0F, 0xCD036837130890A1},  // 1e145\n        {0xC2494954DA2C9789, 0x802221226BE55A64},  // 1e146\n        {0xF2DB9BAA10B7BD6C, 0xA02AA96B06DEB0FD},  // 1e147\n        {0x6F92829494E5ACC7, 0xC83553C5C8965D3D},  // 1e148\n        {0xCB772339BA1F17F9, 0xFA42A8B73ABBF48C},  // 1e14" +
	"9\n        {0xFF2A760414536EFB, 0x9C69A97284B578D7},  // 1e150\n        {0xFEF5138519684ABA, 0xC38413CF25E2D70D},  // 1e151\n        {0x7EB258665FC25D69, 0xF46518C2EF5B8CD1},  // 1e152\n        {0xEF2F773FFBD97A61, 0x98BF2F79D5993802},  // 1e153\n        {0xAAFB550FFACFD8FA, 0xBEEEFB584AFF8603},  // 1e154\n        {0x95BA2A53F983CF38, 0xEEAABA2E5DBF6784},  // 1e155\n        {0xDD945A747BF26183, 0x952AB45CFA97A0B2},  // 1e156\n        {0x94F971119AEEF9E4, 0xBA756174393D88DF},  // 1e157\n        {0x7A37CD5601AAB85D, 0xE912B9D1478CEB17},  // 1e158\n        {0xAC62E055C10AB33A, 0x91ABB422CCB812EE},  // 1e159\n        {0x577B986B314D6009, 0xB616A12B7FE617AA},  // 1e160\n        {0xED5A7E85FDA0B80B, 0xE39C49765FDF9D94},  // 1e161\n        {0x14588F13BE847307, 0x8E41ADE9FBEBC27D},  // 1e162\n        {0x596EB2D8AE258FC8, 0xB1D219647AE6B31C},  // 1e163\n        {0x6FCA5F8ED9AEF3BB, 0xDE469FBD99A05FE3},  // 1e164\n        {0x25DE7BB9480D5854, 0x8AEC23D680043BEE},  // 1e165\n        {0xAF561AA79A10AE6A, 0xADA72CCC20054AE9},  // 1e166\n  " +
	"      {0x1B2BA1518094DA04, 0xD910F7FF28069DA4},  // 1e167\n        {0x90FB44D2F05D0842, 0x87AA9AFF79042286},  // 1e168\n        {0x353A1607AC744A53, 0xA99541BF57452B28},  // 1e169\n        {0x42889B8997915CE8, 0xD3FA922F2D1675F2},  // 1e170\n        {0x69956135FEBADA11, 0x847C9B5D7C2E09B7},  // 1e171\n        {0x43FAB9837E699095, 0xA59BC234DB398C25},  // 1e172\n        {0x94F967E45E03F4BB, 0xCF02B2C21207EF2E},  // 1e173\n        {0x1D1BE0EEBAC278F5, 0x8161AFB94B44F57D},  // 1e174\n        {0x6462D92A69731732, 0xA1BA1BA79E1632DC},  // 1e175\n        {0x7D7B8F7503CFDCFE, 0xCA28A291859BBF93},  // 1e176\n        {0x5CDA735244C3D43E, 0xFCB2CB35E702AF78},  // 1e177\n        {0x3A0888136AFA64A7, 0x9DEFBF01B061ADAB},  // 1e178\n        {0x088AAA1845B8FDD0, 0xC56BAEC21C7A1916},  // 1e179\n        {0x8AAD549E57273D45, 0xF6C69A72A3989F5B},  // 1e180\n        {0x36AC54E2F678864B, 0x9A3C2087A63F6399},  // 1e181\n        {0x84576A1BB416A7DD, 0xC0CB28A98FCF3C7F},  // 1e182\n        {0x656D44A2A11C51D5, 0xF0FDF2D3F3C30B9F},  // 1e183\n      " +
	"  {0x9F644AE5A4B1B325, 0x969EB7C47859E743},  // 1e184\n        {0x873D5D9F0DDE1FEE, 0xBC4665B596706114},  // 1e185\n        {0xA90CB506D155A7EA, 0xEB57FF22FC0C7959},  // 1e186\n        {0x09A7F12442D588F2, 0x9316FF75DD87CBD8},  // 1e187\n        {0x0C11ED6D538AEB2F, 0xB7DCBF5354E9BECE},  // 1e188\n        {0x8F1668C8A86DA5FA, 0xE5D3EF282A242E81},  // 1e189\n        {0xF96E017D694487BC, 0x8FA475791A569D10},  // 1e190\n        {0x37C981DCC395A9AC, 0xB38D92D760EC4455},  // 1e191\n        {0x85BBE253F47B1417, 0xE070F78D3927556A},  // 1e192\n        {0x93956D7478CCEC8E, 0x8C469AB843B89562},  // 1e193\n        {0x387AC8D1970027B2, 0xAF58416654A6BABB},  // 1e194\n        {0x06997B05FCC0319E, 0xDB2E51BFE9D0696A},  // 1e195\n        {0x441FECE3BDF81F03, 0x88FCF317F22241E2},  // 1e196\n        {0xD527E81CAD7626C3, 0xAB3C2FDDEEAAD25A},  // 1e197\n        {0x8A71E223D8D3B074, 0xD60B3BD56A5586F1},  // 1e198\n        {0xF6872D5667844E49, 0x85C7056562757456},  // 1e199\n        {0xB428F8AC016561DB, 0xA738C6BEBB12D16C},  // 1e200\n        {0" +
	"xE13336D701BEBA52, 0xD106F86E69D785C7},  // 1e201\n        {0xECC0024661173473, 0x82A45B450226B39C},  // 1e202\n        {0x27F002D7F95D0190, 0xA34D721642B06084},  // 1e203\n        {0x31EC038DF7B441F4, 0xCC20CE9BD35C78A5},  // 1e204\n        {0x7E67047175A15271, 0xFF290242C83396CE},  // 1e205\n        {0x0F0062C6E984D386, 0x9F79A169BD203E41},  // 1e206\n        {0x52C07B78A3E60868, 0xC75809C42C684DD1},  // 1e207\n        {0xA7709A56CCDF8A82, 0xF92E0C3537826145},  // 1e208\n        {0x88A66076400BB691, 0x9BBCC7A142B17CCB},  // 1e209\n        {0x6ACFF893D00EA435, 0xC2ABF989935DDBFE},  // 1e210\n        {0x0583F6B8C4124D43, 0xF356F7EBF83552FE},  // 1e211\n        {0xC3727A337A8B704A, 0x98165AF37B2153DE},  // 1e212\n        {0x744F18C0592E4C5C, 0xBE1BF1B059E9A8D6},  // 1e213\n        {0x1162DEF06F79DF73, 0xEDA2EE1C7064130C},  // 1e214\n        {0x8ADDCB5645AC2BA8, 0x9485D4D1C63E8BE7},  // 1e215\n        {0x6D953E2BD7173692, 0xB9A74A0637CE2EE1},  // 1e216\n        {0xC8FA8DB6CCDD0437, 0xE8111C87C5C1BA99},  // 1e217\n        {0x1D9" +
	"C9892400A22A2, 0x910AB1D4DB9914A0},  // 1e218\n        {0x2503BEB6D00CAB4B, 0xB54D5E4A127F59C8},  // 1e219\n        {0x2E44AE64840FD61D, 0xE2A0B5DC971F303A},  // 1e220\n        {0x5CEAECFED289E5D2, 0x8DA471A9DE737E24},  // 1e221\n        {0x7425A83E872C5F47, 0xB10D8E1456105DAD},  // 1e222\n        {0xD12F124E28F77719, 0xDD50F1996B947518},  // 1e223\n        {0x82BD6B70D99AAA6F, 0x8A5296FFE33CC92F},  // 1e224\n        {0x636CC64D1001550B, 0xACE73CBFDC0BFB7B},  // 1e225\n        {0x3C47F7E05401AA4E, 0xD8210BEFD30EFA5A},  // 1e226\n        {0x65ACFAEC34810A71, 0x8714A775E3E95C78},  // 1e227\n        {0x7F1839A741A14D0D, 0xA8D9D1535CE3B396},  // 1e228\n        {0x1EDE48111209A050, 0xD31045A8341CA07C},  // 1e229\n        {0x934AED0AAB460432, 0x83EA2B892091E44D},  // 1e230\n        {0xF81DA84D5617853F, 0xA4E4B66B68B65D60},  // 1e231\n        {0x36251260AB9D668E, 0xCE1DE40642E3F4B9},  // 1e232\n        {0xC1D72B7C6B426019, 0x80D2AE83E9CE78F3},  // 1e233\n        {0xB24CF65B8612F81F, 0xA1075A24E4421730},  // 1e234\n        {0xDEE033F" +
	"26797B627, 0xC94930AE1D529CFC},  // 1e235\n        {0x169840EF017DA3B1, 0xFB9B7CD9A4A7443C},  // 1e236\n        {0x8E1F289560EE864E, 0x9D412E0806E88AA5},  // 1e237\n        {0xF1A6F2BAB92A27E2, 0xC491798A08A2AD4E},  // 1e238\n        {0xAE10AF696774B1DB, 0xF5B5D7EC8ACB58A2},  // 1e239\n        {0xACCA6DA1E0A8EF29, 0x9991A6F3D6BF1765},  // 1e240\n        {0x17FD090A58D32AF3, 0xBFF610B0CC6EDD3F},  // 1e241\n        {0xDDFC4B4CEF07F5B0, 0xEFF394DCFF8A948E},  // 1e242\n        {0x4ABDAF101564F98E, 0x95F83D0A1FB69CD9},  // 1e243\n        {0x9D6D1AD41ABE37F1, 0xBB764C4CA7A4440F},  // 1e244\n        {0x84C86189216DC5ED, 0xEA53DF5FD18D5513},  // 1e245\n        {0x32FD3CF5B4E49BB4, 0x92746B9BE2F8552C},  // 1e246\n        {0x3FBC8C33221DC2A1, 0xB7118682DBB66A77},  // 1e247\n        {0x0FABAF3FEAA5334A, 0xE4D5E82392A40515},  // 1e248\n        {0x29CB4D87F2A7400E, 0x8F05B1163BA6832D},  // 1e249\n        {0x743E20E9EF511012, 0xB2C71D5BCA9023F8},  // 1e250\n        {0x914DA9246B255416, 0xDF78E4B2BD342CF6},  // 1e251\n        {0x1AD089B6C2F" +
	"7548E, 0x8BAB8EEFB6409C1A},  // 1e252\n        {0xA184AC2473B529B1, 0xAE9672ABA3D0C320},  // 1e253\n        {0xC9E5D72D90A2741E, 0xDA3C0F568CC4F3E8},  // 1e254\n        {0x7E2FA67C7A658892, 0x8865899617FB1871},  // 1e255\n        {0xDDBB901B98FEEAB7, 0xAA7EEBFB9DF9DE8D},  // 1e256\n        {0x552A74227F3EA565, 0xD51EA6FA85785631},  // 1e257\n        {0xD53A88958F87275F, 0x8533285C936B35DE},  // 1e258\n        {0x8A892ABAF368F137, 0xA67FF273B8460356},  // 1e259\n        {0x2D2B7569B0432D85, 0xD01FEF10A657842C},  // 1e260\n        {0x9C3B29620E29FC73, 0x8213F56A67F6B29B},  // 1e261\n        {0x8349F3BA91B47B8F, 0xA298F2C501F45F42},  // 1e262\n        {0x241C70A936219A73, 0xCB3F2F7642717713},  // 1e263\n        {0xED238CD383AA0110, 0xFE0EFB53D30DD4D7},  // 1e264\n        {0xF4363804324A40AA, 0x9EC95D1463E8A506},  // 1e265\n        {0xB143C6053EDCD0D5, 0xC67BB4597CE2CE48},  // 1e266\n        {0xDD94B7868E94050A, 0xF81AA16FDC1B81DA},  // 1e267\n        {0xCA7CF2B4191C8326, 0x9B10A4E5E9913128},  // 1e268\n        {0xFD1C2F611F63A3F" +
	"0, 0xC1D4CE1F63F57D72},  // 1e269\n        {0xBC633B39673C8CEC, 0xF24A01A73CF2DCCF},  // 1e270\n        {0xD5BE0503E085D813, 0x976E41088617CA01},  // 1e271\n        {0x4B2D8644D8A74E18, 0xBD49D14AA79DBC82},  // 1e272\n        {0xDDF8E7D60ED1219E, 0xEC9C459D51852BA2},  // 1e273\n        {0xCABB90E5C942B503, 0x93E1AB8252F33B45},  // 1e274\n        {0x3D6A751F3B936243, 0xB8DA1662E7B00A17},  // 1e275\n        {0x0CC512670A783AD4, 0xE7109BFBA19C0C9D},  // 1e276\n        {0x27FB2B80668B24C5, 0x906A617D450187E2},  // 1e277\n        {0xB1F9F660802DEDF6, 0xB484F9DC9641E9DA},  // 1e278\n        {0x5E7873F8A0396973, 0xE1A63853BBD26451},  // 1e279\n        {0xDB0B487B6423E1E8, 0x8D07E33455637EB2},  // 1e280\n        {0x91CE1A9A3D2CDA62, 0xB049DC016ABC5E5F},  // 1e281\n        {0x7641A140CC7810FB, 0xDC5C5301C56B75F7},  // 1e282\n        {0xA9E904C87FCB0A9D, 0x89B9B3E11B6329BA},  // 1e283\n        {0x546345FA9FBDCD44, 0xAC2820D9623BF429},  // 1e284\n        {0xA97C177947AD4095, 0xD732290FBACAF133},  // 1e285\n        {0x49ED8EABCCCC485D, 0" +
	"x867F59A9D4BED6C0},  // 1e286\n        {0x5C68F256BFFF5A74, 0xA81F301449EE8C70},  // 1e287\n        {0x73832EEC6FFF3111, 0xD226FC195C6A2F8C},  // 1e288\n};\n\n// wuffs_base__private_implementation__f64_powers_of_10 holds powers of 10 that\n// can be exactly represented by a float64 (what C calls a double).\nstatic const double wuffs_base__private_implementation__f64_powers_of_10[23] = {\n    1e0,  1e1,  1e2,  1e3,  1e4,  1e5,  1e6,  1e7,  1e8,  1e9,  1e10, 1e11,\n    1e12, 1e13, 1e14, 1e15, 1e16, 1e17, 1e18, 1e19, 1e20, 1e21, 1e22,\n};\n" +
	""

const BaseIntConvSubmoduleC = "" +
	"// ---------------- Integer\n\n// wuffs_base__parse_number__foo_digits entries are 0x00 for invalid digits,\n// and (0x80 | v) for valid digits, where v is the 4 bit value.\n\nstatic const uint8_t wuffs_base__parse_number__decimal_digits[256] = {\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x00 ..= 0x07.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x08 ..= 0x0F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x10 ..= 0x17.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x18 ..= 0x1F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x20 ..= 0x27.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x28 ..= 0x2F.\n    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,  // 0x30 ..= 0x37. '0'-'7'.\n    0x88, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x38 ..= 0x3F. '8'-'9'.\n\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x40 ..= 0x47.\n    0x00, 0x00, 0x00, " +
	"0x00, 0x00, 0x00, 0x00, 0x00,  // 0x48 ..= 0x4F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x50 ..= 0x57.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x58 ..= 0x5F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x60 ..= 0x67.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x68 ..= 0x6F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x70 ..= 0x77.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x78 ..= 0x7F.\n\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x80 ..= 0x87.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x88 ..= 0x8F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x90 ..= 0x97.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x98 ..= 0x9F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xA0 ..= 0xA7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xA8 ..= 0xAF.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xB0 ..= 0xB7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00," +
	"  // 0xB8 ..= 0xBF.\n\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xC0 ..= 0xC7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xC8 ..= 0xCF.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xD0 ..= 0xD7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xD8 ..= 0xDF.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xE0 ..= 0xE7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xE8 ..= 0xEF.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xF0 ..= 0xF7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xF8 ..= 0xFF.\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n};\n\nstatic const uint8_t wuffs_base__parse_number__hexadecimal_digits[256] = {\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x00 ..= 0x07.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x08 ..= 0x0F.\n    0x00, " +
	"0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x10 ..= 0x17.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x18 ..= 0x1F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x20 ..= 0x27.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x28 ..= 0x2F.\n    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,  // 0x30 ..= 0x37. '0'-'7'.\n    0x88, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x38 ..= 0x3F. '8'-'9'.\n\n    0x00, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x00,  // 0x40 ..= 0x47. 'A'-'F'.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x48 ..= 0x4F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x50 ..= 0x57.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x58 ..= 0x5F.\n    0x00, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x00,  // 0x60 ..= 0x67. 'a'-'f'.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x68 ..= 0x6F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x70 ..= 0x77.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x78 ..= 0x7F.\n\n  " +
	"  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x80 ..= 0x87.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x88 ..= 0x8F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x90 ..= 0x97.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x98 ..= 0x9F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xA0 ..= 0xA7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xA8 ..= 0xAF.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xB0 ..= 0xB7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xB8 ..= 0xBF.\n\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xC0 ..= 0xC7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xC8 ..= 0xCF.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xD0 ..= 0xD7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xD8 ..= 0xDF.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xE0 ..= 0xE7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xE8 ..= 0xEF.\n    0x00, 0x00, 0x00, 0x00, 0x0" +
	"0, 0x00, 0x00, 0x00,  // 0xF0 ..= 0xF7.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0xF8 ..= 0xFF.\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n};\n\nstatic const uint8_t wuffs_base__private_implementation__encode_base16[16] = {\n    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,  // 0x00 ..= 0x07.\n    0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,  // 0x08 ..= 0x0F.\n};\n\n" +
	"" +
	"// --------\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__result_i64  //\nwuffs_base__parse_number_i64(wuffs_base__slice_u8 s, uint32_t options) {\n  uint8_t* p = s.ptr;\n  uint8_t* q = s.ptr + s.len;\n\n  if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n    for (; (p < q) && (*p == '_'); p++) {\n    }\n  }\n\n  bool negative = false;\n  if (p >= q) {\n    goto fail_bad_argument;\n  } else if (*p == '-') {\n    p++;\n    negative = true;\n  } else if (*p == '+') {\n    p++;\n  }\n\n  do {\n    wuffs_base__result_u64 r = wuffs_base__parse_number_u64(\n        wuffs_base__make_slice_u8(p, (size_t)(q - p)), options);\n    if (r.status.repr != NULL) {\n      wuffs_base__result_i64 ret;\n      ret.status.repr = r.status.repr;\n      ret.value = 0;\n      return ret;\n    } else if (negative) {\n      if (r.value > 0x8000000000000000) {\n        goto fail_out_of_bounds;\n      }\n      wuffs_base__result_i64 ret;\n      ret.status.repr = NULL;\n      ret.value = -(int64_t)(r.value);\n      return ret;\n    } else if (r.value > 0x7FFFFFFFFFFF" +
	"FFFF) {\n      goto fail_out_of_bounds;\n    } else {\n      wuffs_base__result_i64 ret;\n      ret.status.repr = NULL;\n      ret.value = +(int64_t)(r.value);\n      return ret;\n    }\n  } while (0);\n\nfail_bad_argument:\n  do {\n    wuffs_base__result_i64 ret;\n    ret.status.repr = wuffs_base__error__bad_argument;\n    ret.value = 0;\n    return ret;\n  } while (0);\n\nfail_out_of_bounds:\n  do {\n    wuffs_base__result_i64 ret;\n    ret.status.repr = wuffs_base__error__out_of_bounds;\n    ret.value = 0;\n    return ret;\n  } while (0);\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__result_u64  //\nwuffs_base__parse_number_u64(wuffs_base__slice_u8 s, uint32_t options) {\n  uint8_t* p = s.ptr;\n  uint8_t* q = s.ptr + s.len;\n\n  if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n    for (; (p < q) && (*p == '_'); p++) {\n    }\n  }\n\n  if (p >= q) {\n    goto fail_bad_argument;\n\n  } else if (*p == '0') {\n    p++;\n    if (p >= q) {\n      goto ok_zero;\n    }\n    if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n      " +
	"if (*p == '_') {\n        p++;\n        for (; p < q; p++) {\n          if (*p != '_') {\n            if (options &\n                WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_MULTIPLE_LEADING_ZEROES) {\n              goto decimal;\n            }\n            goto fail_bad_argument;\n          }\n        }\n        goto ok_zero;\n      }\n    }\n\n    if ((*p == 'x') || (*p == 'X')) {\n      p++;\n      if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n        for (; (p < q) && (*p == '_'); p++) {\n        }\n      }\n      if (p < q) {\n        goto hexadecimal;\n      }\n\n    } else if ((*p == 'd') || (*p == 'D')) {\n      p++;\n      if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES) {\n        for (; (p < q) && (*p == '_'); p++) {\n        }\n      }\n      if (p < q) {\n        goto decimal;\n      }\n    }\n\n    if (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_MULTIPLE_LEADING_ZEROES) {\n      goto decimal;\n    }\n    goto fail_bad_argument;\n  }\n\ndecimal:\n  do {\n    uint64_t v = wuffs_base__parse_number__decimal_digi" +
	"ts[*p++];\n    if (v == 0) {\n      goto fail_bad_argument;\n    }\n    v &= 0x0F;\n\n    // UINT64_MAX is 18446744073709551615, which is ((10 * max10) + max1).\n    const uint64_t max10 = 1844674407370955161u;\n    const uint8_t max1 = 5;\n\n    for (; p < q; p++) {\n      if ((*p == '_') &&\n          (options & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES)) {\n        continue;\n      }\n      uint8_t digit = wuffs_base__parse_number__decimal_digits[*p];\n      if (digit == 0) {\n        goto fail_bad_argument;\n      }\n      digit &= 0x0F;\n      if ((v > max10) || ((v == max10) && (digit > max1))) {\n        goto fail_out_of_bounds;\n      }\n      v = (10 * v) + ((uint64_t)(digit));\n    }\n\n    wuffs_base__result_u64 ret;\n    ret.status.repr = NULL;\n    ret.value = v;\n    return ret;\n  } while (0);\n\nhexadecimal:\n  do {\n    uint64_t v = wuffs_base__parse_number__hexadecimal_digits[*p++];\n    if (v == 0) {\n      goto fail_bad_argument;\n    }\n    v &= 0x0F;\n\n    for (; p < q; p++) {\n      if ((*p == '_') &&\n          (options" +
	" & WUFFS_BASE__PARSE_NUMBER_XXX__ALLOW_UNDERSCORES)) {\n        continue;\n      }\n      uint8_t digit = wuffs_base__parse_number__hexadecimal_digits[*p];\n      if (digit == 0) {\n        goto fail_bad_argument;\n      }\n      digit &= 0x0F;\n      if ((v >> 60) != 0) {\n        goto fail_out_of_bounds;\n      }\n      v = (v << 4) | ((uint64_t)(digit));\n    }\n\n    wuffs_base__result_u64 ret;\n    ret.status.repr = NULL;\n    ret.value = v;\n    return ret;\n  } while (0);\n\nok_zero:\n  do {\n    wuffs_base__result_u64 ret;\n    ret.status.repr = NULL;\n    ret.value = 0;\n    return ret;\n  } while (0);\n\nfail_bad_argument:\n  do {\n    wuffs_base__result_u64 ret;\n    ret.status.repr = wuffs_base__error__bad_argument;\n    ret.value = 0;\n    return ret;\n  } while (0);\n\nfail_out_of_bounds:\n  do {\n    wuffs_base__result_u64 ret;\n    ret.status.repr = wuffs_base__error__out_of_bounds;\n    ret.value = 0;\n    return ret;\n  } while (0);\n}\n\n" +
	"" +
	"// --------\n\n// wuffs_base__render_number__first_hundred contains the decimal encodings of\n// the first one hundred numbers [0 ..= 99].\nstatic const uint8_t wuffs_base__render_number__first_hundred[200] = {\n    '0', '0', '0', '1', '0', '2', '0', '3', '0', '4',  //\n    '0', '5', '0', '6', '0', '7', '0', '8', '0', '9',  //\n    '1', '0', '1', '1', '1', '2', '1', '3', '1', '4',  //\n    '1', '5', '1', '6', '1', '7', '1', '8', '1', '9',  //\n    '2', '0', '2', '1', '2', '2', '2', '3', '2', '4',  //\n    '2', '5', '2', '6', '2', '7', '2', '8', '2', '9',  //\n    '3', '0', '3', '1', '3', '2', '3', '3', '3', '4',  //\n    '3', '5', '3', '6', '3', '7', '3', '8', '3', '9',  //\n    '4', '0', '4', '1', '4', '2', '4', '3', '4', '4',  //\n    '4', '5', '4', '6', '4', '7', '4', '8', '4', '9',  //\n    '5', '0', '5', '1', '5', '2', '5', '3', '5', '4',  //\n    '5', '5', '5', '6', '5', '7', '5', '8', '5', '9',  //\n    '6', '0', '6', '1', '6', '2', '6', '3', '6', '4',  //\n    '6', '5', '6', '6', '6', '7', '6', '8', '6', '9',  //\n    '" +
	"7', '0', '7', '1', '7', '2', '7', '3', '7', '4',  //\n    '7', '5', '7', '6', '7', '7', '7', '8', '7', '9',  //\n    '8', '0', '8', '1', '8', '2', '8', '3', '8', '4',  //\n    '8', '5', '8', '6', '8', '7', '8', '8', '8', '9',  //\n    '9', '0', '9', '1', '9', '2', '9', '3', '9', '4',  //\n    '9', '5', '9', '6', '9', '7', '9', '8', '9', '9',  //\n};\n\nstatic size_t  //\nwuffs_base__private_implementation__render_number_u64(wuffs_base__slice_u8 dst,\n                                                      uint64_t x,\n                                                      uint32_t options,\n                                                      bool neg) {\n  uint8_t buf[WUFFS_BASE__U64__BYTE_LENGTH__MAX_INCL];\n  uint8_t* ptr = &buf[0] + sizeof(buf);\n\n  while (x >= 100) {\n    size_t index = (x % 100) * 2;\n    x /= 100;\n    uint8_t s0 = wuffs_base__render_number__first_hundred[index + 0];\n    uint8_t s1 = wuffs_base__render_number__first_hundred[index + 1];\n    ptr -= 2;\n    ptr[0] = s0;\n    ptr[1] = s1;\n  }\n\n  if (x < 10) {\n " +
	"   ptr -= 1;\n    ptr[0] = (uint8_t)('0' + x);\n  } else {\n    size_t index = x * 2;\n    uint8_t s0 = wuffs_base__render_number__first_hundred[index + 0];\n    uint8_t s1 = wuffs_base__render_number__first_hundred[index + 1];\n    ptr -= 2;\n    ptr[0] = s0;\n    ptr[1] = s1;\n  }\n\n  if (neg) {\n    ptr -= 1;\n    ptr[0] = '-';\n  } else if (options & WUFFS_BASE__RENDER_NUMBER_XXX__LEADING_PLUS_SIGN) {\n    ptr -= 1;\n    ptr[0] = '+';\n  }\n\n  size_t n = sizeof(buf) - ((size_t)(ptr - &buf[0]));\n  if (n > dst.len) {\n    return 0;\n  }\n  memcpy(dst.ptr + ((options & WUFFS_BASE__RENDER_NUMBER_XXX__ALIGN_RIGHT)\n                        ? (dst.len - n)\n                        : 0),\n         ptr, n);\n  return n;\n}\n\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__render_number_i64(wuffs_base__slice_u8 dst,\n                              int64_t x,\n                              uint32_t options) {\n  uint64_t u = (uint64_t)x;\n  bool neg = x < 0;\n  if (neg) {\n    u = 1 + ~u;\n  }\n  return wuffs_base__private_implementation__render_numb" +
	"er_u64(dst, u, options,\n                                                               neg);\n}\n\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__render_number_u64(wuffs_base__slice_u8 dst,\n                              uint64_t x,\n                              uint32_t options) {\n  return wuffs_base__private_implementation__render_number_u64(dst, x, options,\n                                                               false);\n}\n\n" +
	"" +
	"// ---------------- Base-16\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__decode2(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options) {\n  wuffs_base__transform__output o;\n  size_t src_len2 = src.len / 2;\n  size_t len;\n  if (dst.len < src_len2) {\n    len = dst.len;\n    o.status.repr = wuffs_base__suspension__short_write;\n  } else {\n    len = src_len2;\n    if (!src_closed) {\n      o.status.repr = wuffs_base__suspension__short_read;\n    } else if (src.len & 1) {\n      o.status.repr = wuffs_base__error__bad_data;\n    } else {\n      o.status.repr = NULL;\n    }\n  }\n\n  uint8_t* d = dst.ptr;\n  uint8_t* s = src.ptr;\n  size_t n = len;\n\n  while (n--) {\n    *d = (uint8_t)((wuffs_base__parse_number__hexadecimal_digits[s[0]] << 4) |\n                   (wuffs_base__parse_number__hexadecimal_digits[s[1]] & 0x0F));\n    d += 1;\n    s += 2;\n  }\n\n  o.num_dst = len;\n  o.num_s" +
	"rc = len * 2;\n  return o;\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__decode4(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options) {\n  wuffs_base__transform__output o;\n  size_t src_len4 = src.len / 4;\n  size_t len = dst.len < src_len4 ? dst.len : src_len4;\n  if (dst.len < src_len4) {\n    len = dst.len;\n    o.status.repr = wuffs_base__suspension__short_write;\n  } else {\n    len = src_len4;\n    if (!src_closed) {\n      o.status.repr = wuffs_base__suspension__short_read;\n    } else if (src.len & 1) {\n      o.status.repr = wuffs_base__error__bad_data;\n    } else {\n      o.status.repr = NULL;\n    }\n  }\n\n  uint8_t* d = dst.ptr;\n  uint8_t* s = src.ptr;\n  size_t n = len;\n\n  while (n--) {\n    *d = (uint8_t)((wuffs_base__parse_number__hexadecimal_digits[s[2]] << 4) |\n                   (wuffs_base__parse_number__hexadecimal_digits[s[3]] & 0x0F));\n    d += 1;\n   " +
	" s += 4;\n  }\n\n  o.num_dst = len;\n  o.num_src = len * 4;\n  return o;\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__encode2(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options) {\n  wuffs_base__transform__output o;\n  size_t dst_len2 = dst.len / 2;\n  size_t len;\n  if (dst_len2 < src.len) {\n    len = dst_len2;\n    o.status.repr = wuffs_base__suspension__short_write;\n  } else {\n    len = src.len;\n    if (!src_closed) {\n      o.status.repr = wuffs_base__suspension__short_read;\n    } else {\n      o.status.repr = NULL;\n    }\n  }\n\n  uint8_t* d = dst.ptr;\n  uint8_t* s = src.ptr;\n  size_t n = len;\n\n  while (n--) {\n    uint8_t c = *s;\n    d[0] = wuffs_base__private_implementation__encode_base16[c >> 4];\n    d[1] = wuffs_base__private_implementation__encode_base16[c & 0x0F];\n    d += 2;\n    s += 1;\n  }\n\n  o.num_dst = len * 2;\n  o.num_src = len;\n  return o;\n}\n\nWUFFS_BA" +
	"SE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_16__encode4(wuffs_base__slice_u8 dst,\n                             wuffs_base__slice_u8 src,\n                             bool src_closed,\n                             uint32_t options) {\n  wuffs_base__transform__output o;\n  size_t dst_len4 = dst.len / 4;\n  size_t len;\n  if (dst_len4 < src.len) {\n    len = dst_len4;\n    o.status.repr = wuffs_base__suspension__short_write;\n  } else {\n    len = src.len;\n    if (!src_closed) {\n      o.status.repr = wuffs_base__suspension__short_read;\n    } else {\n      o.status.repr = NULL;\n    }\n  }\n\n  uint8_t* d = dst.ptr;\n  uint8_t* s = src.ptr;\n  size_t n = len;\n\n  while (n--) {\n    uint8_t c = *s;\n    d[0] = '\\\\';\n    d[1] = 'x';\n    d[2] = wuffs_base__private_implementation__encode_base16[c >> 4];\n    d[3] = wuffs_base__private_implementation__encode_base16[c & 0x0F];\n    d += 4;\n    s += 1;\n  }\n\n  o.num_dst = len * 4;\n  o.num_src = len;\n  return o;\n}\n\n" +
	"" +
	"// ---------------- Base-64\n\n// The two base-64 alphabets, std and url, differ only in the last two codes.\n//  - std: \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\"\n//  - url: \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_\"\n\nstatic const uint8_t wuffs_base__base_64__decode_std[256] = {\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x00 ..= 0x07.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x08 ..= 0x0F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x10 ..= 0x17.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x18 ..= 0x1F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x20 ..= 0x27.\n    0x80, 0x80, 0x80, 0x3E, 0x80, 0x80, 0x80, 0x3F,  // 0x28 ..= 0x2F.\n    0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B,  // 0x30 ..= 0x37.\n    0x3C, 0x3D, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x38 ..= 0x3F.\n\n    0x80, 0x00, 0x01, 0x02," +
	" 0x03, 0x04, 0x05, 0x06,  // 0x40 ..= 0x47.\n    0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,  // 0x48 ..= 0x4F.\n    0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,  // 0x50 ..= 0x57.\n    0x17, 0x18, 0x19, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x58 ..= 0x5F.\n    0x80, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,  // 0x60 ..= 0x67.\n    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,  // 0x68 ..= 0x6F.\n    0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30,  // 0x70 ..= 0x77.\n    0x31, 0x32, 0x33, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x78 ..= 0x7F.\n\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x80 ..= 0x87.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x88 ..= 0x8F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x90 ..= 0x97.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x98 ..= 0x9F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xA0 ..= 0xA7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xA8 ..= 0xAF.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // " +
	"0xB0 ..= 0xB7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xB8 ..= 0xBF.\n\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xC0 ..= 0xC7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xC8 ..= 0xCF.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xD0 ..= 0xD7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xD8 ..= 0xDF.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xE0 ..= 0xE7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xE8 ..= 0xEF.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xF0 ..= 0xF7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xF8 ..= 0xFF.\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n};\n\nstatic const uint8_t wuffs_base__base_64__decode_url[256] = {\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x00 ..= 0x07.\n    0x80, 0x80, 0x80, 0x80, " +
	"0x80, 0x80, 0x80, 0x80,  // 0x08 ..= 0x0F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x10 ..= 0x17.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x18 ..= 0x1F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x20 ..= 0x27.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x3E, 0x80, 0x80,  // 0x28 ..= 0x2F.\n    0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B,  // 0x30 ..= 0x37.\n    0x3C, 0x3D, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x38 ..= 0x3F.\n\n    0x80, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,  // 0x40 ..= 0x47.\n    0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,  // 0x48 ..= 0x4F.\n    0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,  // 0x50 ..= 0x57.\n    0x17, 0x18, 0x19, 0x80, 0x80, 0x80, 0x80, 0x3F,  // 0x58 ..= 0x5F.\n    0x80, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,  // 0x60 ..= 0x67.\n    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,  // 0x68 ..= 0x6F.\n    0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30,  // 0x70 ..= 0x77.\n    0x31, 0x32, 0x33, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0" +
	"x78 ..= 0x7F.\n\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x80 ..= 0x87.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x88 ..= 0x8F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x90 ..= 0x97.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0x98 ..= 0x9F.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xA0 ..= 0xA7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xA8 ..= 0xAF.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xB0 ..= 0xB7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xB8 ..= 0xBF.\n\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xC0 ..= 0xC7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xC8 ..= 0xCF.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xD0 ..= 0xD7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xD8 ..= 0xDF.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xE0 ..= 0xE7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xE8 ..= 0xEF.\n    0x80, 0x80" +
	", 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xF0 ..= 0xF7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xF8 ..= 0xFF.\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n};\n\nstatic const uint8_t wuffs_base__base_64__encode_std[64] = {\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,  // 0x00 ..= 0x07.\n    0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,  // 0x08 ..= 0x0F.\n    0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,  // 0x10 ..= 0x17.\n    0x59, 0x5A, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,  // 0x18 ..= 0x1F.\n    0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E,  // 0x20 ..= 0x27.\n    0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,  // 0x28 ..= 0x2F.\n    0x77, 0x78, 0x79, 0x7A, 0x30, 0x31, 0x32, 0x33,  // 0x30 ..= 0x37.\n    0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x2B, 0x2F,  // 0x38 ..= 0x3F.\n};\n\nstatic const uint8_t wuffs_base__base_64__encode_url[64" +
	"] = {\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,  // 0x00 ..= 0x07.\n    0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,  // 0x08 ..= 0x0F.\n    0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,  // 0x10 ..= 0x17.\n    0x59, 0x5A, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,  // 0x18 ..= 0x1F.\n    0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E,  // 0x20 ..= 0x27.\n    0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,  // 0x28 ..= 0x2F.\n    0x77, 0x78, 0x79, 0x7A, 0x30, 0x31, 0x32, 0x33,  // 0x30 ..= 0x37.\n    0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x2D, 0x5F,  // 0x38 ..= 0x3F.\n};\n\n" +
	"" +
	"// --------\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_64__decode(wuffs_base__slice_u8 dst,\n                            wuffs_base__slice_u8 src,\n                            bool src_closed,\n                            uint32_t options) {\n  const uint8_t* alphabet = (options & WUFFS_BASE__BASE_64__URL_ALPHABET)\n                                ? wuffs_base__base_64__decode_url\n                                : wuffs_base__base_64__decode_std;\n  wuffs_base__transform__output o;\n  uint8_t* d_ptr = dst.ptr;\n  size_t d_len = dst.len;\n  const uint8_t* s_ptr = src.ptr;\n  size_t s_len = src.len;\n  bool pad = false;\n\n  while (s_len >= 4) {\n    uint32_t s = wuffs_base__load_u32le__no_bounds_check(s_ptr);\n    uint32_t s0 = alphabet[0xFF & (s >> 0)];\n    uint32_t s1 = alphabet[0xFF & (s >> 8)];\n    uint32_t s2 = alphabet[0xFF & (s >> 16)];\n    uint32_t s3 = alphabet[0xFF & (s >> 24)];\n\n    if (((s0 | s1 | s2 | s3) & 0xC0) != 0) {\n      if (s_len > 4) {\n        o.status.repr = wuffs_base_" +
	"_error__bad_data;\n        goto done;\n      } else if (!src_closed) {\n        o.status.repr = wuffs_base__suspension__short_read;\n        goto done;\n      } else if ((options & WUFFS_BASE__BASE_64__DECODE_ALLOW_PADDING) &&\n                 (s_ptr[3] == '=')) {\n        pad = true;\n        if (s_ptr[2] == '=') {\n          goto src2;\n        }\n        goto src3;\n      }\n      o.status.repr = wuffs_base__error__bad_data;\n      goto done;\n    }\n\n    if (d_len < 3) {\n      o.status.repr = wuffs_base__suspension__short_write;\n      goto done;\n    }\n\n    s_ptr += 4;\n    s_len -= 4;\n    s = (s0 << 18) | (s1 << 12) | (s2 << 6) | (s3 << 0);\n    *d_ptr++ = (uint8_t)(s >> 16);\n    *d_ptr++ = (uint8_t)(s >> 8);\n    *d_ptr++ = (uint8_t)(s >> 0);\n    d_len -= 3;\n  }\n\n  if (!src_closed) {\n    o.status.repr = wuffs_base__suspension__short_read;\n    goto done;\n  }\n\n  if (s_len == 0) {\n    o.status.repr = NULL;\n    goto done;\n  } else if (s_len == 1) {\n    o.status.repr = wuffs_base__error__bad_data;\n    goto done;\n  } else if (s" +
	"_len == 2) {\n    goto src2;\n  }\n\nsrc3:\n  do {\n    uint32_t s = wuffs_base__load_u24le__no_bounds_check(s_ptr);\n    uint32_t s0 = alphabet[0xFF & (s >> 0)];\n    uint32_t s1 = alphabet[0xFF & (s >> 8)];\n    uint32_t s2 = alphabet[0xFF & (s >> 16)];\n    if ((s0 & 0xC0) || (s1 & 0xC0) || (s2 & 0xC3)) {\n      o.status.repr = wuffs_base__error__bad_data;\n      goto done;\n    }\n    if (d_len < 2) {\n      o.status.repr = wuffs_base__suspension__short_write;\n      goto done;\n    }\n    s_ptr += pad ? 4 : 3;\n    s = (s0 << 18) | (s1 << 12) | (s2 << 6);\n    *d_ptr++ = (uint8_t)(s >> 16);\n    *d_ptr++ = (uint8_t)(s >> 8);\n    o.status.repr = NULL;\n    goto done;\n  } while (0);\n\nsrc2:\n  do {\n    uint32_t s = wuffs_base__load_u16le__no_bounds_check(s_ptr);\n    uint32_t s0 = alphabet[0xFF & (s >> 0)];\n    uint32_t s1 = alphabet[0xFF & (s >> 8)];\n    if ((s0 & 0xC0) || (s1 & 0xCF)) {\n      o.status.repr = wuffs_base__error__bad_data;\n      goto done;\n    }\n    if (d_len < 1) {\n      o.status.repr = wuffs_base__suspension__sho" +
	"rt_write;\n      goto done;\n    }\n    s_ptr += pad ? 4 : 2;\n    s = (s0 << 18) | (s1 << 12);\n    *d_ptr++ = (uint8_t)(s >> 16);\n    o.status.repr = NULL;\n    goto done;\n  } while (0);\n\ndone:\n  o.num_dst = (size_t)(d_ptr - dst.ptr);\n  o.num_src = (size_t)(s_ptr - src.ptr);\n  return o;\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__transform__output  //\nwuffs_base__base_64__encode(wuffs_base__slice_u8 dst,\n                            wuffs_base__slice_u8 src,\n                            bool src_closed,\n                            uint32_t options) {\n  const uint8_t* alphabet = (options & WUFFS_BASE__BASE_64__URL_ALPHABET)\n                                ? wuffs_base__base_64__encode_url\n                                : wuffs_base__base_64__encode_std;\n  wuffs_base__transform__output o;\n  uint8_t* d_ptr = dst.ptr;\n  size_t d_len = dst.len;\n  const uint8_t* s_ptr = src.ptr;\n  size_t s_len = src.len;\n\n  do {\n    while (s_len >= 3) {\n      if (d_len < 4) {\n        o.status.repr = wuffs_base__suspension__short_write;\n    " +
	"    goto done;\n      }\n      uint32_t s = wuffs_base__load_u24be__no_bounds_check(s_ptr);\n      s_ptr += 3;\n      s_len -= 3;\n      *d_ptr++ = alphabet[0x3F & (s >> 18)];\n      *d_ptr++ = alphabet[0x3F & (s >> 12)];\n      *d_ptr++ = alphabet[0x3F & (s >> 6)];\n      *d_ptr++ = alphabet[0x3F & (s >> 0)];\n      d_len -= 4;\n    }\n\n    if (!src_closed) {\n      o.status.repr = wuffs_base__suspension__short_read;\n      goto done;\n    }\n\n    if (s_len == 2) {\n      if (d_len <\n          ((options & WUFFS_BASE__BASE_64__ENCODE_EMIT_PADDING) ? 4 : 3)) {\n        o.status.repr = wuffs_base__suspension__short_write;\n        goto done;\n      }\n      uint32_t s = ((uint32_t)(wuffs_base__load_u16be__no_bounds_check(s_ptr)))\n                   << 8;\n      s_ptr += 2;\n      *d_ptr++ = alphabet[0x3F & (s >> 18)];\n      *d_ptr++ = alphabet[0x3F & (s >> 12)];\n      *d_ptr++ = alphabet[0x3F & (s >> 6)];\n      if (options & WUFFS_BASE__BASE_64__ENCODE_EMIT_PADDING) {\n        *d_ptr++ = '=';\n      }\n      o.status.repr = NULL;\n     " +
	" goto done;\n\n    } else if (s_len == 1) {\n      if (d_len <\n          ((options & WUFFS_BASE__BASE_64__ENCODE_EMIT_PADDING) ? 4 : 2)) {\n        o.status.repr = wuffs_base__suspension__short_write;\n        goto done;\n      }\n      uint32_t s = ((uint32_t)(wuffs_base__load_u8__no_bounds_check(s_ptr)))\n                   << 16;\n      s_ptr += 1;\n      *d_ptr++ = alphabet[0x3F & (s >> 18)];\n      *d_ptr++ = alphabet[0x3F & (s >> 12)];\n      if (options & WUFFS_BASE__BASE_64__ENCODE_EMIT_PADDING) {\n        *d_ptr++ = '=';\n        *d_ptr++ = '=';\n      }\n      o.status.repr = NULL;\n      goto done;\n\n    } else {\n      o.status.repr = NULL;\n      goto done;\n    }\n  } while (0);\n\ndone:\n  o.num_dst = (size_t)(d_ptr - dst.ptr);\n  o.num_src = (size_t)(s_ptr - src.ptr);\n  return o;\n}\n" +
	""

const BasePixConvSubmoduleC = "" +
	"// ---------------- Pixel Swizzler\n\nstatic inline uint32_t  //\nwuffs_base__swap_u32_argb_abgr(uint32_t u) {\n  uint32_t o = u & 0xFF00FF00;\n  uint32_t r = u & 0x00FF0000;\n  uint32_t b = u & 0x000000FF;\n  return o | (r >> 16) | (b << 16);\n}\n\n" +
	"" +
	"// --------\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__color_u32_argb_premul  //\nwuffs_base__pixel_buffer__color_u32_at(const wuffs_base__pixel_buffer* pb,\n                                       uint32_t x,\n                                       uint32_t y) {\n  if (!pb || (x >= pb->pixcfg.private_impl.width) ||\n      (y >= pb->pixcfg.private_impl.height)) {\n    return 0;\n  }\n\n  if (wuffs_base__pixel_format__is_planar(&pb->pixcfg.private_impl.pixfmt)) {\n    // TODO: support planar formats.\n    return 0;\n  }\n\n  size_t stride = pb->private_impl.planes[0].stride;\n  const uint8_t* row = pb->private_impl.planes[0].ptr + (stride * ((size_t)y));\n\n  switch (pb->pixcfg.private_impl.pixfmt.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY:\n      return wuffs_base__load_u32le__no_bounds_check(row + (4 * ((size_t)x)));\n\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY: {\n      uint8_t* palette = pb->private_impl" +
	".planes[3].ptr;\n      return wuffs_base__load_u32le__no_bounds_check(palette +\n                                                     (4 * ((size_t)row[x])));\n    }\n\n      // Common formats above. Rarer formats below.\n\n    case WUFFS_BASE__PIXEL_FORMAT__Y:\n      return 0xFF000000 | (0x00010101 * ((uint32_t)(row[x])));\n\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_NONPREMUL: {\n      uint8_t* palette = pb->private_impl.planes[3].ptr;\n      return wuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul(\n          wuffs_base__load_u32le__no_bounds_check(palette +\n                                                  (4 * ((size_t)row[x]))));\n    }\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGR_565:\n      return wuffs_base__color_u16_rgb_565__as__color_u32_argb_premul(\n          wuffs_base__load_u16le__no_bounds_check(row + (2 * ((size_t)x))));\n    case WUFFS_BASE__PIXEL_FORMAT__BGR:\n      return 0xFF000000 |\n             wuffs_base__load_u24le__no_bounds_check(row + (3 * ((size_t)x)));\n    case WUFFS_BASE__PIXEL_F" +
	"ORMAT__BGRA_NONPREMUL:\n      return wuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul(\n          wuffs_base__load_u32le__no_bounds_check(row + (4 * ((size_t)x))));\n    case WUFFS_BASE__PIXEL_FORMAT__BGRX:\n      return 0xFF000000 |\n             wuffs_base__load_u32le__no_bounds_check(row + (4 * ((size_t)x)));\n\n    case WUFFS_BASE__PIXEL_FORMAT__RGB:\n      return wuffs_base__swap_u32_argb_abgr(\n          0xFF000000 |\n          wuffs_base__load_u24le__no_bounds_check(row + (3 * ((size_t)x))));\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL:\n      return wuffs_base__swap_u32_argb_abgr(\n          wuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul(\n              wuffs_base__load_u32le__no_bounds_check(row +\n                                                      (4 * ((size_t)x)))));\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY:\n      return wuffs_base__swap_u32_argb_abgr(\n          wuffs_base__load_u32le__no_bounds_check(row + (4 * ((siz" +
	"e_t)x))));\n    case WUFFS_BASE__PIXEL_FORMAT__RGBX:\n      return wuffs_base__swap_u32_argb_abgr(\n          0xFF000000 |\n          wuffs_base__load_u32le__no_bounds_check(row + (4 * ((size_t)x))));\n\n    default:\n      // TODO: support more formats.\n      break;\n  }\n\n  return 0;\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__status  //\nwuffs_base__pixel_buffer__set_color_u32_at(\n    wuffs_base__pixel_buffer* pb,\n    uint32_t x,\n    uint32_t y,\n    wuffs_base__color_u32_argb_premul color) {\n  if (!pb) {\n    return wuffs_base__make_status(wuffs_base__error__bad_receiver);\n  }\n  if ((x >= pb->pixcfg.private_impl.width) ||\n      (y >= pb->pixcfg.private_impl.height)) {\n    return wuffs_base__make_status(wuffs_base__error__bad_argument);\n  }\n\n  if (wuffs_base__pixel_format__is_planar(&pb->pixcfg.private_impl.pixfmt)) {\n    // TODO: support planar formats.\n    return wuffs_base__make_status(wuffs_base__error__unsupported_option);\n  }\n\n  size_t stride = pb->private_impl.planes[0].stride;\n  uint8_t* row = pb->private_impl.pla" +
	"nes[0].ptr + (stride * ((size_t)y));\n\n  switch (pb->pixcfg.private_impl.pixfmt.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRX:\n      wuffs_base__store_u32le__no_bounds_check(row + (4 * ((size_t)x)), color);\n      break;\n\n      // Common formats above. Rarer formats below.\n\n    case WUFFS_BASE__PIXEL_FORMAT__Y:\n      wuffs_base__store_u8__no_bounds_check(\n          row + ((size_t)x),\n          wuffs_base__color_u32_argb_premul__as__color_u8_gray(color));\n      break;\n\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY:\n      wuffs_base__store_u8__no_bounds_check(\n          row + ((size_t)x), wuffs_base__pixel_palette__closest_element(\n                                 wuffs_base__pixel_buffer__palette(pb),\n                                 pb->pixcfg.private_impl.pixfmt, color));\n      break;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGR_565:\n      wuffs_base__store_u16le__no_bounds_check(\n          row + (2 * ((size_t)x)),\n          wuffs_base__color_u32_argb_prem" +
	"ul__as__color_u16_rgb_565(color));\n      break;\n    case WUFFS_BASE__PIXEL_FORMAT__BGR:\n      wuffs_base__store_u24le__no_bounds_check(row + (3 * ((size_t)x)), color);\n      break;\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL:\n      wuffs_base__store_u32le__no_bounds_check(\n          row + (4 * ((size_t)x)),\n          wuffs_base__color_u32_argb_premul__as__color_u32_argb_nonpremul(\n              color));\n      break;\n\n    case WUFFS_BASE__PIXEL_FORMAT__RGB:\n      wuffs_base__store_u24le__no_bounds_check(\n          row + (3 * ((size_t)x)), wuffs_base__swap_u32_argb_abgr(color));\n      break;\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL:\n      wuffs_base__store_u32le__no_bounds_check(\n          row + (4 * ((size_t)x)),\n          wuffs_base__color_u32_argb_premul__as__color_u32_argb_nonpremul(\n              wuffs_base__swap_u32_argb_abgr(color)));\n      break;\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBX:\n      wuffs_base__store_u32le__no_bounds_check(\n       " +
	"   row + (4 * ((size_t)x)), wuffs_base__swap_u32_argb_abgr(color));\n      break;\n\n    default:\n      // TODO: support more formats.\n      return wuffs_base__make_status(wuffs_base__error__unsupported_option);\n  }\n\n  return wuffs_base__make_status(NULL);\n}\n\n" +
	"" +
	"// --------\n\nWUFFS_BASE__MAYBE_STATIC uint8_t  //\nwuffs_base__pixel_palette__closest_element(\n    wuffs_base__slice_u8 palette_slice,\n    wuffs_base__pixel_format palette_format,\n    wuffs_base__color_u32_argb_premul c) {\n  size_t n = palette_slice.len / 4;\n  if (n > 256) {\n    n = 256;\n  }\n  size_t best_index = 0;\n  uint64_t best_score = 0xFFFFFFFFFFFFFFFF;\n\n  // Work in 16-bit color.\n  uint32_t ca = 0x101 * (0xFF & (c >> 24));\n  uint32_t cr = 0x101 * (0xFF & (c >> 16));\n  uint32_t cg = 0x101 * (0xFF & (c >> 8));\n  uint32_t cb = 0x101 * (0xFF & (c >> 0));\n\n  switch (palette_format.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY: {\n      bool nonpremul = palette_format.repr ==\n                       WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_NONPREMUL;\n\n      size_t i;\n      for (i = 0; i < n; i++) {\n        // Work in 16-bit color.\n        uint32_t pb = 0x101 * ((uint32_t)(palette" +
	"_slice.ptr[(4 * i) + 0]));\n        uint32_t pg = 0x101 * ((uint32_t)(palette_slice.ptr[(4 * i) + 1]));\n        uint32_t pr = 0x101 * ((uint32_t)(palette_slice.ptr[(4 * i) + 2]));\n        uint32_t pa = 0x101 * ((uint32_t)(palette_slice.ptr[(4 * i) + 3]));\n\n        // Convert to premultiplied alpha.\n        if (nonpremul && (pa != 0xFFFF)) {\n          pb = (pb * pa) / 0xFFFF;\n          pg = (pg * pa) / 0xFFFF;\n          pr = (pr * pa) / 0xFFFF;\n        }\n\n        // These deltas are conceptually int32_t (signed) but after squaring,\n        // it's equivalent to work in uint32_t (unsigned).\n        pb -= cb;\n        pg -= cg;\n        pr -= cr;\n        pa -= ca;\n        uint64_t score = ((uint64_t)(pb * pb)) + ((uint64_t)(pg * pg)) +\n                         ((uint64_t)(pr * pr)) + ((uint64_t)(pa * pa));\n        if (best_score > score) {\n          best_score = score;\n          best_index = i;\n        }\n      }\n      break;\n    }\n  }\n\n  return (uint8_t)best_index;\n}\n\n" +
	"" +
	"// --------\n\nstatic inline uint32_t  //\nwuffs_base__composite_nonpremul_nonpremul_u32_axxx(uint32_t dst_nonpremul,\n                                                   uint32_t src_nonpremul) {\n  // Convert from 8-bit color to 16-bit color.\n  uint32_t sa = 0x101 * (0xFF & (src_nonpremul >> 24));\n  uint32_t sr = 0x101 * (0xFF & (src_nonpremul >> 16));\n  uint32_t sg = 0x101 * (0xFF & (src_nonpremul >> 8));\n  uint32_t sb = 0x101 * (0xFF & (src_nonpremul >> 0));\n  uint32_t da = 0x101 * (0xFF & (dst_nonpremul >> 24));\n  uint32_t dr = 0x101 * (0xFF & (dst_nonpremul >> 16));\n  uint32_t dg = 0x101 * (0xFF & (dst_nonpremul >> 8));\n  uint32_t db = 0x101 * (0xFF & (dst_nonpremul >> 0));\n\n  // Convert dst from nonpremul to premul.\n  dr = (dr * da) / 0xFFFF;\n  dg = (dg * da) / 0xFFFF;\n  db = (db * da) / 0xFFFF;\n\n  // Calculate the inverse of the src-alpha: how much of the dst to keep.\n  uint32_t ia = 0xFFFF - sa;\n\n  // Composite src (nonpremul) over dst (premul).\n  da = sa + ((da * ia) / 0xFFFF);\n  dr = ((sr * sa) + (dr * i" +
	"a)) / 0xFFFF;\n  dg = ((sg * sa) + (dg * ia)) / 0xFFFF;\n  db = ((sb * sa) + (db * ia)) / 0xFFFF;\n\n  // Convert dst from premul to nonpremul.\n  if (da != 0) {\n    dr = (dr * 0xFFFF) / da;\n    dg = (dg * 0xFFFF) / da;\n    db = (db * 0xFFFF) / da;\n  }\n\n  // Convert from 16-bit color to 8-bit color and combine the components.\n  da >>= 8;\n  dr >>= 8;\n  dg >>= 8;\n  db >>= 8;\n  return (db << 0) | (dg << 8) | (dr << 16) | (da << 24);\n}\n\nstatic inline uint32_t  //\nwuffs_base__composite_nonpremul_premul_u32_axxx(uint32_t dst_nonpremul,\n                                                uint32_t src_premul) {\n  // Convert from 8-bit color to 16-bit color.\n  uint32_t sa = 0x101 * (0xFF & (src_premul >> 24));\n  uint32_t sr = 0x101 * (0xFF & (src_premul >> 16));\n  uint32_t sg = 0x101 * (0xFF & (src_premul >> 8));\n  uint32_t sb = 0x101 * (0xFF & (src_premul >> 0));\n  uint32_t da = 0x101 * (0xFF & (dst_nonpremul >> 24));\n  uint32_t dr = 0x101 * (0xFF & (dst_nonpremul >> 16));\n  uint32_t dg = 0x101 * (0xFF & (dst_nonpremul >> 8))" +
	";\n  uint32_t db = 0x101 * (0xFF & (dst_nonpremul >> 0));\n\n  // Convert dst from nonpremul to premul.\n  dr = (dr * da) / 0xFFFF;\n  dg = (dg * da) / 0xFFFF;\n  db = (db * da) / 0xFFFF;\n\n  // Calculate the inverse of the src-alpha: how much of the dst to keep.\n  uint32_t ia = 0xFFFF - sa;\n\n  // Composite src (premul) over dst (premul).\n  da = sa + ((da * ia) / 0xFFFF);\n  dr = sr + ((dr * ia) / 0xFFFF);\n  dg = sg + ((dg * ia) / 0xFFFF);\n  db = sb + ((db * ia) / 0xFFFF);\n\n  // Convert dst from premul to nonpremul.\n  if (da != 0) {\n    dr = (dr * 0xFFFF) / da;\n    dg = (dg * 0xFFFF) / da;\n    db = (db * 0xFFFF) / da;\n  }\n\n  // Convert from 16-bit color to 8-bit color and combine the components.\n  da >>= 8;\n  dr >>= 8;\n  dg >>= 8;\n  db >>= 8;\n  return (db << 0) | (dg << 8) | (dr << 16) | (da << 24);\n}\n\nstatic inline uint32_t  //\nwuffs_base__composite_premul_nonpremul_u32_axxx(uint32_t dst_premul,\n                                                uint32_t src_nonpremul) {\n  // Convert from 8-bit color to 16-bit color.\n " +
	" uint32_t sa = 0x101 * (0xFF & (src_nonpremul >> 24));\n  uint32_t sr = 0x101 * (0xFF & (src_nonpremul >> 16));\n  uint32_t sg = 0x101 * (0xFF & (src_nonpremul >> 8));\n  uint32_t sb = 0x101 * (0xFF & (src_nonpremul >> 0));\n  uint32_t da = 0x101 * (0xFF & (dst_premul >> 24));\n  uint32_t dr = 0x101 * (0xFF & (dst_premul >> 16));\n  uint32_t dg = 0x101 * (0xFF & (dst_premul >> 8));\n  uint32_t db = 0x101 * (0xFF & (dst_premul >> 0));\n\n  // Calculate the inverse of the src-alpha: how much of the dst to keep.\n  uint32_t ia = 0xFFFF - sa;\n\n  // Composite src (nonpremul) over dst (premul).\n  da = sa + ((da * ia) / 0xFFFF);\n  dr = ((sr * sa) + (dr * ia)) / 0xFFFF;\n  dg = ((sg * sa) + (dg * ia)) / 0xFFFF;\n  db = ((sb * sa) + (db * ia)) / 0xFFFF;\n\n  // Convert from 16-bit color to 8-bit color and combine the components.\n  da >>= 8;\n  dr >>= 8;\n  dg >>= 8;\n  db >>= 8;\n  return (db << 0) | (dg << 8) | (dr << 16) | (da << 24);\n}\n\nstatic inline uint32_t  //\nwuffs_base__composite_premul_premul_u32_axxx(uint32_t dst_premul,\n    " +
	"                                         uint32_t src_premul) {\n  // Convert from 8-bit color to 16-bit color.\n  uint32_t sa = 0x101 * (0xFF & (src_premul >> 24));\n  uint32_t sr = 0x101 * (0xFF & (src_premul >> 16));\n  uint32_t sg = 0x101 * (0xFF & (src_premul >> 8));\n  uint32_t sb = 0x101 * (0xFF & (src_premul >> 0));\n  uint32_t da = 0x101 * (0xFF & (dst_premul >> 24));\n  uint32_t dr = 0x101 * (0xFF & (dst_premul >> 16));\n  uint32_t dg = 0x101 * (0xFF & (dst_premul >> 8));\n  uint32_t db = 0x101 * (0xFF & (dst_premul >> 0));\n\n  // Calculate the inverse of the src-alpha: how much of the dst to keep.\n  uint32_t ia = 0xFFFF - sa;\n\n  // Composite src (premul) over dst (premul).\n  da = sa + ((da * ia) / 0xFFFF);\n  dr = sr + ((dr * ia) / 0xFFFF);\n  dg = sg + ((dg * ia) / 0xFFFF);\n  db = sb + ((db * ia) / 0xFFFF);\n\n  // Convert from 16-bit color to 8-bit color and combine the components.\n  da >>= 8;\n  dr >>= 8;\n  dg >>= 8;\n  db >>= 8;\n  return (db << 0) | (dg << 8) | (dr << 16) | (da << 24);\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__squash_bgr_565_888(wuffs_base__slice_u8 dst,\n                                               wuffs_base__slice_u8 src) {\n  size_t len4 = (dst.len < src.len ? dst.len : src.len) / 4;\n  uint8_t* d = dst.ptr;\n  const uint8_t* s = src.ptr;\n\n  size_t n = len4;\n  while (n--) {\n    uint32_t argb = wuffs_base__load_u32le__no_bounds_check(s);\n    uint32_t b5 = 0x1F & (argb >> (8 - 5));\n    uint32_t g6 = 0x3F & (argb >> (16 - 6));\n    uint32_t r5 = 0x1F & (argb >> (24 - 5));\n    uint32_t alpha = argb & 0xFF000000;\n    wuffs_base__store_u32le__no_bounds_check(\n        d, alpha | (r5 << 11) | (g6 << 5) | (b5 << 0));\n    s += 4;\n    d += 4;\n  }\n  return len4 * 4;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__swap_rgbx_bgrx(wuffs_base__slice_u8 dst,\n                                           wuffs_base__slice_u8 src) {\n  size_t len4 = (dst.len < src.len ? dst.len : src.len) / 4;\n  uint8_t* d = dst.ptr;\n  const uint8_t* s = src.ptr;\n\n  size_t n = len4;\n  while" +
	" (n--) {\n    uint8_t b0 = s[0];\n    uint8_t b1 = s[1];\n    uint8_t b2 = s[2];\n    uint8_t b3 = s[3];\n    d[0] = b2;\n    d[1] = b1;\n    d[2] = b0;\n    d[3] = b3;\n    s += 4;\n    d += 4;\n  }\n  return len4 * 4;\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__copy_1_1(uint8_t* dst_ptr,\n                                     size_t dst_len,\n                                     uint8_t* dst_palette_ptr,\n                                     size_t dst_palette_len,\n                                     const uint8_t* src_ptr,\n                                     size_t src_len) {\n  size_t len = (dst_len < src_len) ? dst_len : src_len;\n  if (len > 0) {\n    memmove(dst_ptr, src_ptr, len);\n  }\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__copy_3_3(uint8_t* dst_ptr,\n                                     size_t dst_len,\n                                     uint8_t* dst_palette_ptr,\n                                     size_t dst_palette_len,\n                                     const uint8_t* src_ptr,\n                                     size_t src_len) {\n  size_t dst_len3 = dst_len / 3;\n  size_t src_len3 = src_len / 3;\n  size_t len = (dst_len3 < src_len3) ? dst_len3 : src_len3;\n  if (len > 0) {\n  " +
	"  memmove(dst_ptr, src_ptr, len * 3);\n  }\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__copy_4_4(uint8_t* dst_ptr,\n                                     size_t dst_len,\n                                     uint8_t* dst_palette_ptr,\n                                     size_t dst_palette_len,\n                                     const uint8_t* src_ptr,\n                                     size_t src_len) {\n  size_t dst_len4 = dst_len / 4;\n  size_t src_len4 = src_len / 4;\n  size_t len = (dst_len4 < src_len4) ? dst_len4 : src_len4;\n  if (len > 0) {\n    memmove(dst_ptr, src_ptr, len * 4);\n  }\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgr_565__bgr(uint8_t* dst_ptr,\n                                         size_t dst_len,\n                                         uint8_t* dst_palette_ptr,\n                                         size_t dst_palette_len,\n                                         const uint8_t* src_ptr,\n                                         size_t src_len) {\n  size_t dst_len2 = dst_len / 2;\n  size_t src_len3 = src_len / 3;\n  size_t len = (dst_len2 < src_len3) ? dst_len2 : src_len3;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint32_t b5 = s[0] >> 3;\n    uint32_t g6 = s[1] >> 2;\n    uint32_t r5 = s[2] >> 3;\n    uint32_t rgb_565 = (r5 << 11) | (g6 << 5) | (b5 << 0);\n    wuffs_base__store_u16le__no_bounds_check(d + (0 * 2), (uint16_t)rgb_565);\n\n    s += 1 * 3;\n    d += 1 * 2;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgr_565__bgra_nonpremul__src(\n    uint8_t*" +
	" dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  size_t dst_len2 = dst_len / 2;\n  size_t src_len4 = src_len / 4;\n  size_t len = (dst_len2 < src_len4) ? dst_len2 : src_len4;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    wuffs_base__store_u16le__no_bounds_check(\n        d + (0 * 2),\n        wuffs_base__color_u32_argb_premul__as__color_u16_rgb_565(\n            wuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul(\n                wuffs_base__load_u32le__no_bounds_check(s + (0 * 4)))));\n\n    s += 1 * 4;\n    d += 1 * 2;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgr_565__bgra_nonpremul__src_over(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  size_t dst_len2 = dst_len / 2;\n  size_t src_len4 = src_len / 4;" +
	"\n  size_t len = (dst_len2 < src_len4) ? dst_len2 : src_len4;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    // Convert from 8-bit color to 16-bit color.\n    uint32_t sa = 0x101 * ((uint32_t)s[3]);\n    uint32_t sr = 0x101 * ((uint32_t)s[2]);\n    uint32_t sg = 0x101 * ((uint32_t)s[1]);\n    uint32_t sb = 0x101 * ((uint32_t)s[0]);\n\n    // Convert from 565 color to 16-bit color.\n    uint32_t old_rgb_565 = wuffs_base__load_u16le__no_bounds_check(d + (0 * 2));\n    uint32_t old_r5 = 0x1F & (old_rgb_565 >> 11);\n    uint32_t dr = (0x8421 * old_r5) >> 4;\n    uint32_t old_g6 = 0x3F & (old_rgb_565 >> 5);\n    uint32_t dg = (0x1041 * old_g6) >> 2;\n    uint32_t old_b5 = 0x1F & (old_rgb_565 >> 0);\n    uint32_t db = (0x8421 * old_b5) >> 4;\n\n    // Calculate the inverse of the src-alpha: how much of the dst to keep.\n    uint32_t ia = 0xFFFF - sa;\n\n    // Composite src (nonpremul) over dst (premul).\n    dr = ((sr * sa) + (dr * ia)) / 0xFFFF;\n    dg = ((sg * sa)" +
	" + (dg * ia)) / 0xFFFF;\n    db = ((sb * sa) + (db * ia)) / 0xFFFF;\n\n    // Convert from 16-bit color to 565 color and combine the components.\n    uint32_t new_r5 = 0x1F & (dr >> 11);\n    uint32_t new_g6 = 0x3F & (dg >> 10);\n    uint32_t new_b5 = 0x1F & (db >> 11);\n    uint32_t new_rgb_565 = (new_r5 << 11) | (new_g6 << 5) | (new_b5 << 0);\n    wuffs_base__store_u16le__no_bounds_check(d + (0 * 2),\n                                             (uint16_t)new_rgb_565);\n\n    s += 1 * 4;\n    d += 1 * 2;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgr_565__y(uint8_t* dst_ptr,\n                                       size_t dst_len,\n                                       uint8_t* dst_palette_ptr,\n                                       size_t dst_palette_len,\n                                       const uint8_t* src_ptr,\n                                       size_t src_len) {\n  size_t dst_len2 = dst_len / 2;\n  size_t len = (dst_len2 < src_len) ? dst_len2 : src_len;\n  uint8_t* d = dst_" +
	"ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint32_t y5 = s[0] >> 3;\n    uint32_t y6 = s[0] >> 2;\n    uint32_t rgb_565 = (y5 << 11) | (y6 << 5) | (y5 << 0);\n    wuffs_base__store_u16le__no_bounds_check(d + (0 * 2), (uint16_t)rgb_565);\n\n    s += 1 * 1;\n    d += 1 * 2;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgr_565__index__src(uint8_t* dst_ptr,\n                                                size_t dst_len,\n                                                uint8_t* dst_palette_ptr,\n                                                size_t dst_palette_len,\n                                                const uint8_t* src_ptr,\n                                                size_t src_len) {\n  if (dst_palette_len != 1024) {\n    return 0;\n  }\n  size_t dst_len2 = dst_len / 2;\n  size_t len = (dst_len2 < src_len) ? dst_len2 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  const size_t loop_" +
	"unroll_count = 4;\n\n  while (n >= loop_unroll_count) {\n    wuffs_base__store_u16le__no_bounds_check(\n        d + (0 * 2), wuffs_base__load_u16le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[0] * 4)));\n    wuffs_base__store_u16le__no_bounds_check(\n        d + (1 * 2), wuffs_base__load_u16le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[1] * 4)));\n    wuffs_base__store_u16le__no_bounds_check(\n        d + (2 * 2), wuffs_base__load_u16le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[2] * 4)));\n    wuffs_base__store_u16le__no_bounds_check(\n        d + (3 * 2), wuffs_base__load_u16le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[3] * 4)));\n\n    s += loop_unroll_count * 1;\n    d += loop_unroll_count * 2;\n    n -= loop_unroll_count;\n  }\n\n  while (n >= 1) {\n    wuffs_base__store_u16le__no_bounds_check(\n        d + (0 * 2), wuffs_base__load_u16le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s" +
	"[0] * 4)));\n\n    s += 1 * 1;\n    d += 1 * 2;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgr_565__index_binary_alpha__src_over(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  if (dst_palette_len != 1024) {\n    return 0;\n  }\n  size_t dst_len2 = dst_len / 2;\n  size_t len = (dst_len2 < src_len) ? dst_len2 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[0] * 4));\n    if (s0) {\n      wuffs_base__store_u16le__no_bounds_check(d + (0 * 2), (uint16_t)s0);\n    }\n\n    s += 1 * 1;\n    d += 1 * 2;\n    n -= 1;\n  }\n\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgr__bgra_nonpremul__src(uint8_t* dst_ptr,\n                                                     size_t dst_len,\n                                                     uint8_t* dst_palette_ptr,\n                                                     size_t dst_palette_len,\n                                                     const uint8_t* src_ptr,\n                                                     size_t src_len) {\n  size_t dst_len3 = dst_len / 3;\n  size_t src_len4 = src_len / 4;\n  size_t len = (dst_len3 < src_len4) ? dst_len3 : src_len4;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint32_t s0 =\n        wuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul(\n            wuffs_base__load_u32le__no_bounds_check(s + (0 * 4)));\n    wuffs_base__store_u24le__no_bounds_check(d + (0 * 3), s0);\n\n    s += 1 * 4;\n    d += 1 * 3;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nw" +
	"uffs_base__pixel_swizzler__bgr__bgra_nonpremul__src_over(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  size_t dst_len3 = dst_len / 3;\n  size_t src_len4 = src_len / 4;\n  size_t len = (dst_len3 < src_len4) ? dst_len3 : src_len4;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    // Convert from 8-bit color to 16-bit color.\n    uint32_t sa = 0x101 * ((uint32_t)s[3]);\n    uint32_t sr = 0x101 * ((uint32_t)s[2]);\n    uint32_t sg = 0x101 * ((uint32_t)s[1]);\n    uint32_t sb = 0x101 * ((uint32_t)s[0]);\n    uint32_t dr = 0x101 * ((uint32_t)d[2]);\n    uint32_t dg = 0x101 * ((uint32_t)d[1]);\n    uint32_t db = 0x101 * ((uint32_t)d[0]);\n\n    // Calculate the inverse of the src-alpha: how much of the dst to keep.\n    uint32_t ia = 0xFFFF - sa;\n\n    // Composite src (nonpremul) over dst (premul).\n    dr = ((sr * sa) + (dr * ia)) / 0xFFFF;\n    dg = ((sg * s" +
	"a) + (dg * ia)) / 0xFFFF;\n    db = ((sb * sa) + (db * ia)) / 0xFFFF;\n\n    // Convert from 16-bit color to 8-bit color.\n    d[0] = (uint8_t)(db >> 8);\n    d[1] = (uint8_t)(dg >> 8);\n    d[2] = (uint8_t)(dr >> 8);\n\n    s += 1 * 4;\n    d += 1 * 3;\n    n -= 1;\n  }\n\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgra_nonpremul__bgra_nonpremul__src_over(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  size_t dst_len4 = dst_len / 4;\n  size_t src_len4 = src_len / 4;\n  size_t len = (dst_len4 < src_len4) ? dst_len4 : src_len4;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint32_t d0 = wuffs_base__load_u32le__no_bounds_check(d + (0 * 4));\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(s + (0 * 4));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (0 * 4),\n        wuffs_base__composite_nonpremul_nonpremul_u32_axxx(d0, s0));\n\n    s += 1 * 4;\n    d += 1 * 4;\n    n -= 1;\n  }\n\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgra_premul__bgra_nonpremul__src(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  size_t dst_len4 = dst_len / 4;\n  size_t src_len4 = src_len / 4;\n  size_t len = (dst_len4 < src_len4) ? dst_len4 : src_len4;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(s + (0 * 4));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (0 * 4),\n        wuffs_base__color_u32_argb_nonpremul__as__color_u32_argb_premul(s0));\n\n    s += 1 * 4;\n    d += 1 * 4;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__bgra_premul__bgra_nonpremul__src_over(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  size_t dst_len4 = " +
	"dst_len / 4;\n  size_t src_len4 = src_len / 4;\n  size_t len = (dst_len4 < src_len4) ? dst_len4 : src_len4;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint32_t d0 = wuffs_base__load_u32le__no_bounds_check(d + (0 * 4));\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(s + (0 * 4));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (0 * 4), wuffs_base__composite_premul_nonpremul_u32_axxx(d0, s0));\n\n    s += 1 * 4;\n    d += 1 * 4;\n    n -= 1;\n  }\n\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__xxx__index__src(uint8_t* dst_ptr,\n                                            size_t dst_len,\n                                            uint8_t* dst_palette_ptr,\n                                            size_t dst_palette_len,\n                                            const uint8_t* src_ptr,\n                                            size_t src_len) {\n  if (dst_palette_len != 1024) {\n    return 0;\n  }\n  size_t dst_len3 = dst_len / 3;\n  size_t len = (dst_len3 < src_len) ? dst_len3 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  const size_t loop_unroll_count = 4;\n\n  // The comparison in the while condition is \">\", not \">=\", because with\n  // \">=\", the last 4-byte store could write past the end of the dst slice.\n  //\n  // Each 4-byte store writes one too many bytes, but a subsequent store\n  // will overwrite that with the correct byte. There is always another\n  // store, whether a 4-byte store in this loop" +
	" or a 1-byte store in the\n  // next loop.\n  while (n > loop_unroll_count) {\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (0 * 3), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[0] * 4)));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (1 * 3), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[1] * 4)));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (2 * 3), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[2] * 4)));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (3 * 3), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[3] * 4)));\n\n    s += loop_unroll_count * 1;\n    d += loop_unroll_count * 3;\n    n -= loop_unroll_count;\n  }\n\n  while (n >= 1) {\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((siz" +
	"e_t)s[0] * 4));\n    wuffs_base__store_u24le__no_bounds_check(d + (0 * 3), s0);\n\n    s += 1 * 1;\n    d += 1 * 3;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__xxx__index_binary_alpha__src_over(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  if (dst_palette_len != 1024) {\n    return 0;\n  }\n  size_t dst_len3 = dst_len / 3;\n  size_t len = (dst_len3 < src_len) ? dst_len3 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  const size_t loop_unroll_count = 4;\n\n  while (n >= loop_unroll_count) {\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[0] * 4));\n    if (s0) {\n      wuffs_base__store_u24le__no_bounds_check(d + (0 * 3), s0);\n    }\n    uint32_t s1 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                        " +
	"                  ((size_t)s[1] * 4));\n    if (s1) {\n      wuffs_base__store_u24le__no_bounds_check(d + (1 * 3), s1);\n    }\n    uint32_t s2 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[2] * 4));\n    if (s2) {\n      wuffs_base__store_u24le__no_bounds_check(d + (2 * 3), s2);\n    }\n    uint32_t s3 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[3] * 4));\n    if (s3) {\n      wuffs_base__store_u24le__no_bounds_check(d + (3 * 3), s3);\n    }\n\n    s += loop_unroll_count * 1;\n    d += loop_unroll_count * 3;\n    n -= loop_unroll_count;\n  }\n\n  while (n >= 1) {\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[0] * 4));\n    if (s0) {\n      wuffs_base__store_u24le__no_bounds_check(d + (0 * 3), s0);\n    }\n\n    s += 1 * 1;\n    d += 1 * 3;\n    n -= 1;\n  }\n\n  return len;" +
	"\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__xxx__y(uint8_t* dst_ptr,\n                                   size_t dst_len,\n                                   uint8_t* dst_palette_ptr,\n                                   size_t dst_palette_len,\n                                   const uint8_t* src_ptr,\n                                   size_t src_len) {\n  size_t dst_len3 = dst_len / 3;\n  size_t len = (dst_len3 < src_len) ? dst_len3 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    uint8_t s0 = s[0];\n    d[0] = s0;\n    d[1] = s0;\n    d[2] = s0;\n\n    s += 1 * 1;\n    d += 1 * 3;\n    n -= 1;\n  }\n\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__xxxx__index__src(uint8_t* dst_ptr,\n                                             size_t dst_len,\n                                             uint8_t* dst_palette_ptr,\n                                             size_t dst_palette_len,\n                                             const uint8_t* src_ptr,\n                                             size_t src_len) {\n  if (dst_palette_len != 1024) {\n    return 0;\n  }\n  size_t dst_len4 = dst_len / 4;\n  size_t len = (dst_len4 < src_len) ? dst_len4 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  const size_t loop_unroll_count = 4;\n\n  while (n >= loop_unroll_count) {\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (0 * 4), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[0] * 4)));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (1 * 4), wuffs_base__load_u32le__no_bounds_check(\n                         " +
	"dst_palette_ptr + ((size_t)s[1] * 4)));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (2 * 4), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[2] * 4)));\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (3 * 4), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[3] * 4)));\n\n    s += loop_unroll_count * 1;\n    d += loop_unroll_count * 4;\n    n -= loop_unroll_count;\n  }\n\n  while (n >= 1) {\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (0 * 4), wuffs_base__load_u32le__no_bounds_check(\n                         dst_palette_ptr + ((size_t)s[0] * 4)));\n\n    s += 1 * 1;\n    d += 1 * 4;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__xxxx__index_binary_alpha__src_over(\n    uint8_t* dst_ptr,\n    size_t dst_len,\n    uint8_t* dst_palette_ptr,\n    size_t dst_palette_len,\n    const uint8_t* src_ptr,\n    size_t src_len) {\n  if (dst_palette_len != 1024) {\n    return 0;\n" +
	"  }\n  size_t dst_len4 = dst_len / 4;\n  size_t len = (dst_len4 < src_len) ? dst_len4 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  const size_t loop_unroll_count = 4;\n\n  while (n >= loop_unroll_count) {\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[0] * 4));\n    if (s0) {\n      wuffs_base__store_u32le__no_bounds_check(d + (0 * 4), s0);\n    }\n    uint32_t s1 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[1] * 4));\n    if (s1) {\n      wuffs_base__store_u32le__no_bounds_check(d + (1 * 4), s1);\n    }\n    uint32_t s2 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[2] * 4));\n    if (s2) {\n      wuffs_base__store_u32le__no_bounds_check(d + (2 * 4), s2);\n    }\n    uint32_t s3 = wuffs_base__load_u32le__no_bounds_check(dst_" +
	"palette_ptr +\n                                                          ((size_t)s[3] * 4));\n    if (s3) {\n      wuffs_base__store_u32le__no_bounds_check(d + (3 * 4), s3);\n    }\n\n    s += loop_unroll_count * 1;\n    d += loop_unroll_count * 4;\n    n -= loop_unroll_count;\n  }\n\n  while (n >= 1) {\n    uint32_t s0 = wuffs_base__load_u32le__no_bounds_check(dst_palette_ptr +\n                                                          ((size_t)s[0] * 4));\n    if (s0) {\n      wuffs_base__store_u32le__no_bounds_check(d + (0 * 4), s0);\n    }\n\n    s += 1 * 1;\n    d += 1 * 4;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__xxxx__xxx(uint8_t* dst_ptr,\n                                      size_t dst_len,\n                                      uint8_t* dst_palette_ptr,\n                                      size_t dst_palette_len,\n                                      const uint8_t* src_ptr,\n                                      size_t src_len) {\n  size_t dst_len4 = dst_len / 4;\n  size_t src_le" +
	"n3 = src_len / 3;\n  size_t len = (dst_len4 < src_len3) ? dst_len4 : src_len3;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (0 * 4),\n        0xFF000000 | wuffs_base__load_u24le__no_bounds_check(s + (0 * 3)));\n\n    s += 1 * 3;\n    d += 1 * 4;\n    n -= 1;\n  }\n\n  return len;\n}\n\nstatic uint64_t  //\nwuffs_base__pixel_swizzler__xxxx__y(uint8_t* dst_ptr,\n                                    size_t dst_len,\n                                    uint8_t* dst_palette_ptr,\n                                    size_t dst_palette_len,\n                                    const uint8_t* src_ptr,\n                                    size_t src_len) {\n  size_t dst_len4 = dst_len / 4;\n  size_t len = (dst_len4 < src_len) ? dst_len4 : src_len;\n  uint8_t* d = dst_ptr;\n  const uint8_t* s = src_ptr;\n  size_t n = len;\n\n  // TODO: unroll.\n\n  while (n >= 1) {\n    wuffs_base__store_u32le__no_bounds_check(\n        d + (" +
	"0 * 4), 0xFF000000 | (0x010101 * (uint32_t)s[0]));\n\n    s += 1 * 1;\n    d += 1 * 4;\n    n -= 1;\n  }\n\n  return len;\n}\n\n" +
	"" +
	"// --------\n\nstatic wuffs_base__pixel_swizzler__func  //\nwuffs_base__pixel_swizzler__prepare__y(wuffs_base__pixel_swizzler* p,\n                                       wuffs_base__pixel_format dst_pixfmt,\n                                       wuffs_base__slice_u8 dst_palette,\n                                       wuffs_base__slice_u8 src_palette,\n                                       wuffs_base__pixel_blend blend) {\n  switch (dst_pixfmt.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__BGR_565:\n      return wuffs_base__pixel_swizzler__bgr_565__y;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGR:\n    case WUFFS_BASE__PIXEL_FORMAT__RGB:\n      return wuffs_base__pixel_swizzler__xxx__y;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRX:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY:\n    case WU" +
	"FFS_BASE__PIXEL_FORMAT__RGBX:\n      return wuffs_base__pixel_swizzler__xxxx__y;\n  }\n  return NULL;\n}\n\nstatic wuffs_base__pixel_swizzler__func  //\nwuffs_base__pixel_swizzler__prepare__indexed__bgra_binary(\n    wuffs_base__pixel_swizzler* p,\n    wuffs_base__pixel_format dst_pixfmt,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src_palette,\n    wuffs_base__pixel_blend blend) {\n  switch (dst_pixfmt.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY:\n      if (wuffs_base__slice_u8__copy_from_slice(dst_palette, src_palette) !=\n          1024) {\n        return NULL;\n      }\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__copy_1_1;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGR_565:\n      if (wuffs_base__pixel_swizzler__squash_bgr_565_888(dst_palette,\n                                        " +
	"                 src_palette) != 1024) {\n        return NULL;\n      }\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__bgr_565__index__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__bgr_565__index_binary_alpha__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGR:\n      if (wuffs_base__slice_u8__copy_from_slice(dst_palette, src_palette) !=\n          1024) {\n        return NULL;\n      }\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__xxx__index__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__xxx__index_binary_alpha__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY:\n      if (wuffs_base__slice_u8__copy_from_slice(dst_palette, src_pa" +
	"lette) !=\n          1024) {\n        return NULL;\n      }\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__xxxx__index__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__xxxx__index_binary_alpha__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__RGB:\n      if (wuffs_base__pixel_swizzler__swap_rgbx_bgrx(dst_palette,\n                                                     src_palette) != 1024) {\n        return NULL;\n      }\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__xxx__index__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__xxx__index_binary_alpha__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY:\n      if (wuffs_base__pixel_swizzler__" +
	"swap_rgbx_bgrx(dst_palette,\n                                                     src_palette) != 1024) {\n        return NULL;\n      }\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__xxxx__index__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__xxxx__index_binary_alpha__src_over;\n      }\n      return NULL;\n  }\n  return NULL;\n}\n\nstatic wuffs_base__pixel_swizzler__func  //\nwuffs_base__pixel_swizzler__prepare__bgr(wuffs_base__pixel_swizzler* p,\n                                         wuffs_base__pixel_format dst_pixfmt,\n                                         wuffs_base__slice_u8 dst_palette,\n                                         wuffs_base__slice_u8 src_palette,\n                                         wuffs_base__pixel_blend blend) {\n  switch (dst_pixfmt.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__BGR_565:\n      return wuffs_base__pixel_swizzler__bgr_565__bgr;\n\n    case WUFFS_BASE__PIXEL_FORMAT__B" +
	"GR:\n      return wuffs_base__pixel_swizzler__copy_3_3;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRX:\n      return wuffs_base__pixel_swizzler__xxxx__xxx;\n\n    case WUFFS_BASE__PIXEL_FORMAT__RGB:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBX:\n      // TODO.\n      break;\n  }\n  return NULL;\n}\n\nstatic wuffs_base__pixel_swizzler__func  //\nwuffs_base__pixel_swizzler__prepare__bgra_nonpremul(\n    wuffs_base__pixel_swizzler* p,\n    wuffs_base__pixel_format dst_pixfmt,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src_palette,\n    wuffs_base__pixel_blend blend) {\n  switch (dst_pixfmt.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__BGR_565:\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_b" +
	"ase__pixel_swizzler__bgr_565__bgra_nonpremul__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__bgr_565__bgra_nonpremul__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGR:\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__bgr__bgra_nonpremul__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__bgr__bgra_nonpremul__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL:\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swizzler__copy_4_4;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__bgra_nonpremul__bgra_nonpremul__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_PREMUL:\n      switch (blend) {\n        case WUFFS_BASE__PIXEL_BLEND__SRC:\n          return wuffs_base__pixel_swiz" +
	"zler__bgra_premul__bgra_nonpremul__src;\n        case WUFFS_BASE__PIXEL_BLEND__SRC_OVER:\n          return wuffs_base__pixel_swizzler__bgra_premul__bgra_nonpremul__src_over;\n      }\n      return NULL;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_BINARY:\n    case WUFFS_BASE__PIXEL_FORMAT__BGRX:\n      // TODO.\n      break;\n\n    case WUFFS_BASE__PIXEL_FORMAT__RGB:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_NONPREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_PREMUL:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBA_BINARY:\n    case WUFFS_BASE__PIXEL_FORMAT__RGBX:\n      // TODO.\n      break;\n  }\n  return NULL;\n}\n\n" +
	"" +
	"// --------\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__status  //\nwuffs_base__pixel_swizzler__prepare(wuffs_base__pixel_swizzler* p,\n                                    wuffs_base__pixel_format dst_pixfmt,\n                                    wuffs_base__slice_u8 dst_palette,\n                                    wuffs_base__pixel_format src_pixfmt,\n                                    wuffs_base__slice_u8 src_palette,\n                                    wuffs_base__pixel_blend blend) {\n  if (!p) {\n    return wuffs_base__make_status(wuffs_base__error__bad_receiver);\n  }\n  p->private_impl.func = NULL;\n  p->private_impl.src_pixfmt_bytes_per_pixel = 0;\n\n  wuffs_base__pixel_swizzler__func func = NULL;\n  uint32_t src_pixfmt_bits_per_pixel =\n      wuffs_base__pixel_format__bits_per_pixel(&src_pixfmt);\n  if ((src_pixfmt_bits_per_pixel == 0) ||\n      ((src_pixfmt_bits_per_pixel & 7) != 0)) {\n    return wuffs_base__make_status(\n        wuffs_base__error__unsupported_pixel_swizzler_option);\n  }\n\n  // TODO: support many more for" +
	"mats.\n\n  switch (src_pixfmt.repr) {\n    case WUFFS_BASE__PIXEL_FORMAT__Y:\n      func = wuffs_base__pixel_swizzler__prepare__y(p, dst_pixfmt, dst_palette,\n                                                    src_palette, blend);\n      break;\n\n    case WUFFS_BASE__PIXEL_FORMAT__INDEXED__BGRA_BINARY:\n      func = wuffs_base__pixel_swizzler__prepare__indexed__bgra_binary(\n          p, dst_pixfmt, dst_palette, src_palette, blend);\n      break;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGR:\n      func = wuffs_base__pixel_swizzler__prepare__bgr(\n          p, dst_pixfmt, dst_palette, src_palette, blend);\n      break;\n\n    case WUFFS_BASE__PIXEL_FORMAT__BGRA_NONPREMUL:\n      func = wuffs_base__pixel_swizzler__prepare__bgra_nonpremul(\n          p, dst_pixfmt, dst_palette, src_palette, blend);\n      break;\n  }\n\n  p->private_impl.func = func;\n  p->private_impl.src_pixfmt_bytes_per_pixel = src_pixfmt_bits_per_pixel / 8;\n  return wuffs_base__make_status(\n      func ? NULL : wuffs_base__error__unsupported_pixel_swizzler_option);\n}" +
	"\n\nWUFFS_BASE__MAYBE_STATIC uint64_t  //\nwuffs_base__pixel_swizzler__swizzle_interleaved_from_reader(\n    const wuffs_base__pixel_swizzler* p,\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    const uint8_t** ptr_iop_r,\n    const uint8_t* io2_r) {\n  if (p && p->private_impl.func) {\n    const uint8_t* iop_r = *ptr_iop_r;\n    uint64_t n = (*p->private_impl.func)(dst.ptr, dst.len, dst_palette.ptr,\n                                         dst_palette.len, iop_r,\n                                         (size_t)(io2_r - iop_r));\n    *ptr_iop_r += n * p->private_impl.src_pixfmt_bytes_per_pixel;\n    return n;\n  }\n  return 0;\n}\n\nWUFFS_BASE__MAYBE_STATIC uint64_t  //\nwuffs_base__pixel_swizzler__swizzle_interleaved_from_slice(\n    const wuffs_base__pixel_swizzler* p,\n    wuffs_base__slice_u8 dst,\n    wuffs_base__slice_u8 dst_palette,\n    wuffs_base__slice_u8 src) {\n  if (p && p->private_impl.func) {\n    return (*p->private_impl.func)(dst.ptr, dst.len, dst_palette.ptr,\n                              " +
	"     dst_palette.len, src.ptr, src.len);\n  }\n  return 0;\n}\n" +
	""

const BaseUTF8SubmoduleC = "" +
	"// ---------------- Unicode and UTF-8\n\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__utf_8__encode(wuffs_base__slice_u8 dst, uint32_t code_point) {\n  if (code_point <= 0x7F) {\n    if (dst.len >= 1) {\n      dst.ptr[0] = (uint8_t)(code_point);\n      return 1;\n    }\n\n  } else if (code_point <= 0x07FF) {\n    if (dst.len >= 2) {\n      dst.ptr[0] = (uint8_t)(0xC0 | ((code_point >> 6)));\n      dst.ptr[1] = (uint8_t)(0x80 | ((code_point >> 0) & 0x3F));\n      return 2;\n    }\n\n  } else if (code_point <= 0xFFFF) {\n    if ((dst.len >= 3) && ((code_point < 0xD800) || (0xDFFF < code_point))) {\n      dst.ptr[0] = (uint8_t)(0xE0 | ((code_point >> 12)));\n      dst.ptr[1] = (uint8_t)(0x80 | ((code_point >> 6) & 0x3F));\n      dst.ptr[2] = (uint8_t)(0x80 | ((code_point >> 0) & 0x3F));\n      return 3;\n    }\n\n  } else if (code_point <= 0x10FFFF) {\n    if (dst.len >= 4) {\n      dst.ptr[0] = (uint8_t)(0xF0 | ((code_point >> 18)));\n      dst.ptr[1] = (uint8_t)(0x80 | ((code_point >> 12) & 0x3F));\n      dst.ptr[2] = (uint8_t)(0x80 |" +
	" ((code_point >> 6) & 0x3F));\n      dst.ptr[3] = (uint8_t)(0x80 | ((code_point >> 0) & 0x3F));\n      return 4;\n    }\n  }\n\n  return 0;\n}\n\n// wuffs_base__utf_8__byte_length_minus_1 is the byte length (minus 1) of a\n// UTF-8 encoded code point, based on the encoding's initial byte.\n//  - 0x00 is 1-byte UTF-8 (ASCII).\n//  - 0x01 is the start of 2-byte UTF-8.\n//  - 0x02 is the start of 3-byte UTF-8.\n//  - 0x03 is the start of 4-byte UTF-8.\n//  - 0x40 is a UTF-8 tail byte.\n//  - 0x80 is invalid UTF-8.\n//\n// RFC 3629 (UTF-8) gives this grammar for valid UTF-8:\n//    UTF8-1      = %x00-7F\n//    UTF8-2      = %xC2-DF UTF8-tail\n//    UTF8-3      = %xE0 %xA0-BF UTF8-tail / %xE1-EC 2( UTF8-tail ) /\n//                  %xED %x80-9F UTF8-tail / %xEE-EF 2( UTF8-tail )\n//    UTF8-4      = %xF0 %x90-BF 2( UTF8-tail ) / %xF1-F3 3( UTF8-tail ) /\n//                  %xF4 %x80-8F 2( UTF8-tail )\n//    UTF8-tail   = %x80-BF\nstatic const uint8_t wuffs_base__utf_8__byte_length_minus_1[256] = {\n    // 0     1     2     3     4     5  " +
	"   6     7\n    // 8     9     A     B     C     D     E     F\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x00 ..= 0x07.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x08 ..= 0x0F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x10 ..= 0x17.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x18 ..= 0x1F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x20 ..= 0x27.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x28 ..= 0x2F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x30 ..= 0x37.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x38 ..= 0x3F.\n\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x40 ..= 0x47.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x48 ..= 0x4F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x50 ..= 0x57.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x58 ..= 0x5F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x60 ..= 0x67.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00" +
	", 0x00, 0x00,  // 0x68 ..= 0x6F.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x70 ..= 0x77.\n    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0x78 ..= 0x7F.\n\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0x80 ..= 0x87.\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0x88 ..= 0x8F.\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0x90 ..= 0x97.\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0x98 ..= 0x9F.\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0xA0 ..= 0xA7.\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0xA8 ..= 0xAF.\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0xB0 ..= 0xB7.\n    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // 0xB8 ..= 0xBF.\n\n    0x80, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,  // 0xC0 ..= 0xC7.\n    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,  // 0xC8 ..= 0xCF.\n    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,  // 0xD0 ..= 0xD7.\n    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,  // 0xD8 ..= 0" +
	"xDF.\n    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,  // 0xE0 ..= 0xE7.\n    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,  // 0xE8 ..= 0xEF.\n    0x03, 0x03, 0x03, 0x03, 0x03, 0x80, 0x80, 0x80,  // 0xF0 ..= 0xF7.\n    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 0xF8 ..= 0xFF.\n    // 0     1     2     3     4     5     6     7\n    // 8     9     A     B     C     D     E     F\n};\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__utf_8__next__output  //\nwuffs_base__utf_8__next(const uint8_t* s_ptr, size_t s_len) {\n  if (s_len == 0) {\n    return wuffs_base__make_utf_8__next__output(0, 0);\n  }\n  uint32_t c = s_ptr[0];\n  switch (wuffs_base__utf_8__byte_length_minus_1[c & 0xFF]) {\n    case 0:\n      return wuffs_base__make_utf_8__next__output(c, 1);\n\n    case 1:\n      if (s_len < 2) {\n        break;\n      }\n      c = wuffs_base__load_u16le__no_bounds_check(s_ptr);\n      if ((c & 0xC000) != 0x8000) {\n        break;\n      }\n      c = (0x0007C0 & (c << 6)) | (0x00003F & (c >> 8));\n      return wuffs_base__make_utf_8__n" +
	"ext__output(c, 2);\n\n    case 2:\n      if (s_len < 3) {\n        break;\n      }\n      c = wuffs_base__load_u24le__no_bounds_check(s_ptr);\n      if ((c & 0xC0C000) != 0x808000) {\n        break;\n      }\n      c = (0x00F000 & (c << 12)) | (0x000FC0 & (c >> 2)) |\n          (0x00003F & (c >> 16));\n      if ((c <= 0x07FF) || ((0xD800 <= c) && (c <= 0xDFFF))) {\n        break;\n      }\n      return wuffs_base__make_utf_8__next__output(c, 3);\n\n    case 3:\n      if (s_len < 4) {\n        break;\n      }\n      c = wuffs_base__load_u32le__no_bounds_check(s_ptr);\n      if ((c & 0xC0C0C000) != 0x80808000) {\n        break;\n      }\n      c = (0x1C0000 & (c << 18)) | (0x03F000 & (c << 4)) |\n          (0x000FC0 & (c >> 10)) | (0x00003F & (c >> 24));\n      if ((c <= 0xFFFF) || (0x110000 <= c)) {\n        break;\n      }\n      return wuffs_base__make_utf_8__next__output(c, 4);\n  }\n\n  return wuffs_base__make_utf_8__next__output(\n      WUFFS_BASE__UNICODE_REPLACEMENT_CHARACTER, 1);\n}\n\nWUFFS_BASE__MAYBE_STATIC wuffs_base__utf_8__next__out" +
	"put  //\nwuffs_base__utf_8__next_from_end(const uint8_t* s_ptr, size_t s_len) {\n  if (s_len == 0) {\n    return wuffs_base__make_utf_8__next__output(0, 0);\n  }\n  const uint8_t* ptr = &s_ptr[s_len - 1];\n  if (*ptr < 0x80) {\n    return wuffs_base__make_utf_8__next__output(*ptr, 1);\n\n  } else if (*ptr < 0xC0) {\n    const uint8_t* too_far = &s_ptr[(s_len > 4) ? (s_len - 4) : 0];\n    uint32_t n = 1;\n    while (ptr != too_far) {\n      ptr--;\n      n++;\n      if (*ptr < 0x80) {\n        break;\n      } else if (*ptr < 0xC0) {\n        continue;\n      }\n      wuffs_base__utf_8__next__output o = wuffs_base__utf_8__next(ptr, n);\n      if (o.byte_length != n) {\n        break;\n      }\n      return o;\n    }\n  }\n\n  return wuffs_base__make_utf_8__next__output(\n      WUFFS_BASE__UNICODE_REPLACEMENT_CHARACTER, 1);\n}\n\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__utf_8__longest_valid_prefix(const uint8_t* s_ptr, size_t s_len) {\n  // TODO: possibly optimize the all-ASCII case (4 or 8 bytes at a time).\n  //\n  // TODO: possibly opti" +
	"mize this by manually inlining the\n  // wuffs_base__utf_8__next calls.\n  size_t original_len = s_len;\n  while (s_len > 0) {\n    wuffs_base__utf_8__next__output o = wuffs_base__utf_8__next(s_ptr, s_len);\n    if ((o.code_point > 0x7F) && (o.byte_length == 1)) {\n      break;\n    }\n    s_ptr += o.byte_length;\n    s_len -= o.byte_length;\n  }\n  return original_len - s_len;\n}\n\nWUFFS_BASE__MAYBE_STATIC size_t  //\nwuffs_base__ascii__longest_valid_prefix(const uint8_t* s_ptr, size_t s_len) {\n  // TODO: possibly optimize this by checking 4 or 8 bytes at a time.\n  const uint8_t* original_ptr = s_ptr;\n  const uint8_t* p = s_ptr;\n  const uint8_t* q = s_ptr + s_len;\n  for (; (p != q) && ((*p & 0x80) == 0); p++) {\n  }\n  return (size_t)(p - original_ptr);\n}\n" +
	""

const AuxBaseCc = "" +
	"// ---------------- Auxiliary - Base\n\n// Auxiliary code is discussed at\n// https://github.com/google/wuffs/blob/master/doc/note/auxiliary-code.md\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__AUX__BASE)\n\nnamespace wuffs_aux {\n\nnamespace sync_io {\n\n" +
	"" +
	"// --------\n\nIOBuffer*  //\nInput::BringsItsOwnIOBuffer() {\n  return nullptr;\n}\n\n" +
	"" +
	"// --------\n\nFileInput::FileInput(FILE* f) : m_f(f) {}\n\nstd::string  //\nFileInput::CopyIn(IOBuffer* dst) {\n  if (!m_f) {\n    return \"wuffs_aux::sync_io::FileInput: nullptr file\";\n  } else if (dst && !dst->meta.closed) {\n    size_t n = fread(dst->writer_pointer(), 1, dst->writer_length(), m_f);\n    dst->meta.wi += n;\n    dst->meta.closed = feof(m_f);\n    if (ferror(m_f)) {\n      return \"wuffs_aux::sync_io::FileInput: error reading file\";\n    }\n  }\n  return \"\";\n}\n\n" +
	"" +
	"// --------\n\nMemoryInput::MemoryInput(const char* ptr, size_t len)\n    : m_io(wuffs_base__ptr_u8__reader(\n          static_cast<uint8_t*>(static_cast<void*>(const_cast<char*>(ptr))),\n          len,\n          true)) {}\n\nMemoryInput::MemoryInput(const uint8_t* ptr, size_t len)\n    : m_io(wuffs_base__ptr_u8__reader(const_cast<uint8_t*>(ptr), len, true)) {}\n\nIOBuffer*  //\nMemoryInput::BringsItsOwnIOBuffer() {\n  return &m_io;\n}\n\nstd::string  //\nMemoryInput::CopyIn(IOBuffer* dst) {\n  if (dst && !dst->meta.closed && (dst != &m_io)) {\n    size_t nd = dst->writer_length();\n    size_t ns = m_io.reader_length();\n    size_t n = (nd < ns) ? nd : ns;\n    memcpy(dst->writer_pointer(), m_io.reader_pointer(), n);\n    m_io.meta.ri += n;\n    dst->meta.wi += n;\n    dst->meta.closed = m_io.reader_length() == 0;\n  }\n  return \"\";\n}\n\n" +
	"" +
	"// --------\n\n}  // namespace sync_io\n\n}  // namespace wuffs_aux\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__AUX__BASE)\n" +
	""

const AuxBaseHh = "" +
	"// ---------------- Auxiliary - Base\n\n// Auxiliary code is discussed at\n// https://github.com/google/wuffs/blob/master/doc/note/auxiliary-code.md\n\n#include <stdio.h>\n\n#include <string>\n\nnamespace wuffs_aux {\n\nusing IOBuffer = wuffs_base__io_buffer;\n\nnamespace sync_io {\n\n" +
	"" +
	"// --------\n\nclass Input {\n public:\n  virtual IOBuffer* BringsItsOwnIOBuffer();\n  virtual std::string CopyIn(IOBuffer* dst) = 0;\n};\n\n" +
	"" +
	"// --------\n\n// FileInput is an Input that reads from a file source.\n//\n// It does not take responsibility for closing the file when done.\nclass FileInput : public Input {\n public:\n  FileInput(FILE* f);\n\n  virtual std::string CopyIn(IOBuffer* dst);\n\n private:\n  FILE* m_f;\n\n  // Delete the copy and assign constructors.\n  FileInput(const FileInput&) = delete;\n  FileInput& operator=(const FileInput&) = delete;\n};\n\n" +
	"" +
	"// --------\n\n// MemoryInput is an Input that reads from an in-memory source.\n//\n// It does not take responsibility for freeing the memory when done.\nclass MemoryInput : public Input {\n public:\n  MemoryInput(const char* ptr, size_t len);\n  MemoryInput(const uint8_t* ptr, size_t len);\n\n  virtual IOBuffer* BringsItsOwnIOBuffer();\n  virtual std::string CopyIn(IOBuffer* dst);\n\n private:\n  IOBuffer m_io;\n\n  // Delete the copy and assign constructors.\n  MemoryInput(const MemoryInput&) = delete;\n  MemoryInput& operator=(const MemoryInput&) = delete;\n};\n\n" +
	"" +
	"// --------\n\n}  // namespace sync_io\n\n}  // namespace wuffs_aux\n" +
	""

const AuxCborCc = "" +
	"// ---------------- Auxiliary - CBOR\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__AUX__CBOR)\n\n#include <utility>\n\nnamespace wuffs_aux {\n\nDecodeCborResult::DecodeCborResult(std::string&& error_message0,\n                                   uint64_t cursor_position0)\n    : error_message(std::move(error_message0)),\n      cursor_position(cursor_position0) {}\n\nvoid  //\nDecodeCborCallbacks::Done(DecodeCborResult& result,\n                          sync_io::Input& input,\n                          IOBuffer& buffer) {}\n\nDecodeCborResult  //\nDecodeCbor(DecodeCborCallbacks& callbacks,\n           sync_io::Input& input,\n           wuffs_base__slice_u32 quirks) {\n  // Prepare the wuffs_base__io_buffer and the resultant error_message.\n  wuffs_base__io_buffer* io_buf = input.BringsItsOwnIOBuffer();\n  wuffs_base__io_buffer fallback_io_buf = wuffs_base__empty_io_buffer();\n  std::unique_ptr<uint8_t[]> fallback_io_array(nullptr);\n  if (!io_buf) {\n    fallback_io_array = std::unique_ptr<uint8_t[]>(new uint8_" +
	"t[4096]);\n    fallback_io_buf = wuffs_base__ptr_u8__writer(fallback_io_array.get(), 4096);\n    io_buf = &fallback_io_buf;\n  }\n  // cursor_index is discussed at\n  // https://nigeltao.github.io/blog/2020/jsonptr.html#the-cursor-index\n  size_t cursor_index = 0;\n  std::string ret_error_message;\n  std::string io_error_message;\n\n  do {\n    // Prepare the low-level CBOR decoder.\n    wuffs_cbor__decoder::unique_ptr dec = wuffs_cbor__decoder::alloc();\n    if (!dec) {\n      ret_error_message = \"wuffs_aux::CborDecoder: out of memory\";\n      goto done;\n    }\n    for (size_t i = 0; i < quirks.len; i++) {\n      dec->set_quirk_enabled(quirks.ptr[i], true);\n    }\n\n    // Prepare the wuffs_base__tok_buffer. 256 tokens is 2KiB.\n    wuffs_base__token tok_array[256];\n    wuffs_base__token_buffer tok_buf =\n        wuffs_base__slice_token__writer(wuffs_base__make_slice_token(\n            &tok_array[0], (sizeof(tok_array) / sizeof(tok_array[0]))));\n    wuffs_base__status tok_status = wuffs_base__make_status(nullptr);\n\n    // Prepar" +
	"e other state.\n    uint32_t depth = 0;\n    std::string str;\n    int64_t extension_category = 0;\n    uint64_t extension_detail = 0;\n\n    // Valid token's VBCs range in 0 ..= 15. Values over that are for tokens\n    // from outside of the base package, such as the CBOR package.\n    constexpr int64_t EXT_CAT__CBOR_TAG = 16;\n\n    // Loop, doing these two things:\n    //  1. Get the next token.\n    //  2. Process that token.\n    while (true) {\n      // 1. Get the next token.\n\n      while (tok_buf.meta.ri >= tok_buf.meta.wi) {\n        if (tok_status.repr == nullptr) {\n          // No-op.\n        } else if (tok_status.repr == wuffs_base__suspension__short_write) {\n          tok_buf.compact();\n        } else if (tok_status.repr == wuffs_base__suspension__short_read) {\n          // Read from input to io_buf.\n          if (!io_error_message.empty()) {\n            ret_error_message = std::move(io_error_message);\n            goto done;\n          } else if (cursor_index != io_buf->meta.ri) {\n            ret_error_message =\n" +
	"                \"wuffs_aux::CborDecoder: internal error: bad cursor_index\";\n            goto done;\n          } else if (io_buf->meta.closed) {\n            ret_error_message =\n                \"wuffs_aux::CborDecoder: internal error: io_buf is closed\";\n            goto done;\n          }\n          io_buf->compact();\n          if (io_buf->meta.wi >= io_buf->data.len) {\n            ret_error_message =\n                \"wuffs_aux::CborDecoder: internal error: io_buf is full\";\n            goto done;\n          }\n          cursor_index = io_buf->meta.ri;\n          io_error_message = input.CopyIn(io_buf);\n        } else {\n          ret_error_message = tok_status.message();\n          goto done;\n        }\n\n        if (WUFFS_CBOR__DECODER_WORKBUF_LEN_MAX_INCL_WORST_CASE != 0) {\n          ret_error_message =\n              \"wuffs_aux::CborDecoder: internal error: bad WORKBUF_LEN\";\n          goto done;\n        }\n        wuffs_base__slice_u8 work_buf = wuffs_base__empty_slice_u8();\n        tok_status = dec->decode_tokens(&tok_" +
	"buf, io_buf, work_buf);\n      }\n\n      wuffs_base__token token = tok_buf.data.ptr[tok_buf.meta.ri++];\n      uint64_t token_len = token.length();\n      if ((io_buf->meta.ri < cursor_index) ||\n          ((io_buf->meta.ri - cursor_index) < token_len)) {\n        ret_error_message =\n            \"wuffs_aux::CborDecoder: internal error: bad token indexes\";\n        goto done;\n      }\n      uint8_t* token_ptr = io_buf->data.ptr + cursor_index;\n      cursor_index += token_len;\n\n      // 2. Process that token.\n\n      uint64_t vbd = token.value_base_detail();\n\n      if (extension_category != 0) {\n        int64_t ext = token.value_extension();\n        if ((ext >= 0) && !token.continued()) {\n          extension_detail = (extension_detail\n                              << WUFFS_BASE__TOKEN__VALUE_EXTENSION__NUM_BITS) |\n                             static_cast<uint64_t>(ext);\n          switch (extension_category) {\n            case WUFFS_BASE__TOKEN__VBC__INLINE_INTEGER_SIGNED:\n              extension_category = 0;\n          " +
	"    ret_error_message =\n                  callbacks.AppendI64(static_cast<int64_t>(extension_detail));\n              goto parsed_a_value;\n            case WUFFS_BASE__TOKEN__VBC__INLINE_INTEGER_UNSIGNED:\n              extension_category = 0;\n              ret_error_message = callbacks.AppendU64(extension_detail);\n              goto parsed_a_value;\n            case EXT_CAT__CBOR_TAG:\n              extension_category = 0;\n              ret_error_message = callbacks.AppendCborTag(extension_detail);\n              if (!ret_error_message.empty()) {\n                goto done;\n              }\n              continue;\n          }\n        }\n        ret_error_message =\n            \"wuffs_aux::CborDecoder: internal error: bad extended token\";\n        goto done;\n      }\n\n      switch (token.value_base_category()) {\n        case WUFFS_BASE__TOKEN__VBC__FILLER:\n          continue;\n\n        case WUFFS_BASE__TOKEN__VBC__STRUCTURE: {\n          if (vbd & WUFFS_BASE__TOKEN__VBD__STRUCTURE__PUSH) {\n            ret_error_message = " +
	"callbacks.Push(static_cast<uint32_t>(vbd));\n            if (!ret_error_message.empty()) {\n              goto done;\n            }\n            depth++;\n            continue;\n          }\n          ret_error_message = callbacks.Pop(static_cast<uint32_t>(vbd));\n          depth--;\n          goto parsed_a_value;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__STRING: {\n          if (vbd & WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_0_DST_1_SRC_DROP) {\n            // No-op.\n          } else if (vbd &\n                     WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_1_DST_1_SRC_COPY) {\n            const char* ptr =  // Convert from (uint8_t*).\n                static_cast<const char*>(static_cast<void*>(token_ptr));\n            str.append(ptr, token_len);\n          } else {\n            goto fail;\n          }\n          if (token.continued()) {\n            continue;\n          }\n          ret_error_message =\n              (vbd & WUFFS_BASE__TOKEN__VBD__STRING__CHAIN_MUST_BE_UTF_8)\n                  ? callbacks.AppendTextString(std" +
	"::move(str))\n                  : callbacks.AppendByteString(std::move(str));\n          str.clear();\n          goto parsed_a_value;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__UNICODE_CODE_POINT: {\n          uint8_t u[WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL];\n          size_t n = wuffs_base__utf_8__encode(\n              wuffs_base__make_slice_u8(\n                  &u[0], WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL),\n              static_cast<uint32_t>(vbd));\n          const char* ptr =  // Convert from (uint8_t*).\n              static_cast<const char*>(static_cast<void*>(&u[0]));\n          str.append(ptr, n);\n          if (token.continued()) {\n            continue;\n          }\n          goto fail;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__LITERAL: {\n          if (vbd & WUFFS_BASE__TOKEN__VBD__LITERAL__NULL) {\n            ret_error_message = callbacks.AppendNull();\n          } else if (vbd & WUFFS_BASE__TOKEN__VBD__LITERAL__UNDEFINED) {\n            ret_error_message = callbacks.AppendUndefined();\n      " +
	"    } else {\n            ret_error_message = callbacks.AppendBool(\n                vbd & WUFFS_BASE__TOKEN__VBD__LITERAL__TRUE);\n          }\n          goto parsed_a_value;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__NUMBER: {\n          const uint64_t cfp_fbbe_fifb =\n              WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_FLOATING_POINT |\n              WUFFS_BASE__TOKEN__VBD__NUMBER__FORMAT_BINARY_BIG_ENDIAN |\n              WUFFS_BASE__TOKEN__VBD__NUMBER__FORMAT_IGNORE_FIRST_BYTE;\n          if ((vbd & cfp_fbbe_fifb) == cfp_fbbe_fifb) {\n            double f;\n            switch (token_len) {\n              case 3:\n                f = wuffs_base__ieee_754_bit_representation__from_u16_to_f64(\n                    wuffs_base__load_u16be__no_bounds_check(token_ptr + 1));\n                break;\n              case 5:\n                f = wuffs_base__ieee_754_bit_representation__from_u32_to_f64(\n                    wuffs_base__load_u32be__no_bounds_check(token_ptr + 1));\n                break;\n              case 9:\n    " +
	"            f = wuffs_base__ieee_754_bit_representation__from_u64_to_f64(\n                    wuffs_base__load_u64be__no_bounds_check(token_ptr + 1));\n                break;\n              default:\n                goto fail;\n            }\n            ret_error_message = callbacks.AppendF64(f);\n            goto parsed_a_value;\n          }\n          goto fail;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__INLINE_INTEGER_SIGNED: {\n          if (token.continued()) {\n            extension_category = WUFFS_BASE__TOKEN__VBC__INLINE_INTEGER_SIGNED;\n            extension_detail =\n                static_cast<uint64_t>(token.value_base_detail__sign_extended());\n            continue;\n          }\n          ret_error_message =\n              callbacks.AppendI64(token.value_base_detail__sign_extended());\n          goto parsed_a_value;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__INLINE_INTEGER_UNSIGNED: {\n          if (token.continued()) {\n            extension_category =\n                WUFFS_BASE__TOKEN__VBC__INLINE_IN" +
	"TEGER_UNSIGNED;\n            extension_detail = vbd;\n            continue;\n          }\n          ret_error_message = callbacks.AppendU64(vbd);\n          goto parsed_a_value;\n        }\n      }\n\n      if (token.value_major() == WUFFS_CBOR__TOKEN_VALUE_MAJOR) {\n        uint64_t value_minor = token.value_minor();\n        if (value_minor & WUFFS_CBOR__TOKEN_VALUE_MINOR__MINUS_1_MINUS_X) {\n          if (token_len == 9) {\n            ret_error_message = callbacks.AppendMinus1MinusX(\n                wuffs_base__load_u64be__no_bounds_check(token_ptr + 1));\n            goto parsed_a_value;\n          }\n        } else if (value_minor & WUFFS_CBOR__TOKEN_VALUE_MINOR__SIMPLE_VALUE) {\n          ret_error_message =\n              callbacks.AppendCborSimpleValue(static_cast<uint8_t>(\n                  value_minor & WUFFS_CBOR__TOKEN_VALUE_MINOR__DETAIL_MASK));\n          goto parsed_a_value;\n        } else if (value_minor & WUFFS_CBOR__TOKEN_VALUE_MINOR__TAG) {\n          if (token.continued()) {\n            extension_category = " +
	"EXT_CAT__CBOR_TAG;\n            extension_detail =\n                value_minor & WUFFS_CBOR__TOKEN_VALUE_MINOR__DETAIL_MASK;\n            continue;\n          }\n          ret_error_message = callbacks.AppendCborTag(\n              value_minor & WUFFS_CBOR__TOKEN_VALUE_MINOR__DETAIL_MASK);\n          if (!ret_error_message.empty()) {\n            goto done;\n          }\n          continue;\n        }\n      }\n\n    fail:\n      ret_error_message =\n          \"wuffs_aux::CborDecoder: internal error: unexpected token\";\n      goto done;\n\n    parsed_a_value:\n      if (!ret_error_message.empty() || (depth == 0)) {\n        goto done;\n      }\n    }\n  } while (false);\n\ndone:\n  DecodeCborResult result(\n      std::move(ret_error_message),\n      wuffs_base__u64__sat_add(io_buf->meta.pos, cursor_index));\n  callbacks.Done(result, input, *io_buf);\n  return result;\n}\n\n}  // namespace wuffs_aux\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__AUX__CBOR)\n" +
	""

const AuxCborHh = "" +
	"// ---------------- Auxiliary - CBOR\n\nnamespace wuffs_aux {\n\nstruct DecodeCborResult {\n  DecodeCborResult(std::string&& error_message0, uint64_t cursor_position0);\n\n  std::string error_message;\n  uint64_t cursor_position;\n};\n\nclass DecodeCborCallbacks {\n public:\n  // AppendXxx are called for leaf nodes: literals, numbers, strings, etc.\n\n  virtual std::string AppendNull() = 0;\n  virtual std::string AppendUndefined() = 0;\n  virtual std::string AppendBool(bool val) = 0;\n  virtual std::string AppendF64(double val) = 0;\n  virtual std::string AppendI64(int64_t val) = 0;\n  virtual std::string AppendU64(uint64_t val) = 0;\n  virtual std::string AppendByteString(std::string&& val) = 0;\n  virtual std::string AppendTextString(std::string&& val) = 0;\n  virtual std::string AppendMinus1MinusX(uint64_t val) = 0;\n  virtual std::string AppendCborSimpleValue(uint8_t val) = 0;\n  virtual std::string AppendCborTag(uint64_t val) = 0;\n\n  // Push and Pop are called for container nodes: CBOR arrays (lists) and CBOR\n  // maps (dictiona" +
	"ries).\n  //\n  // The flags bits combine exactly one of:\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_NONE\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_LIST\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_DICT\n  // and exactly one of:\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_NONE\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_LIST\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_DICT\n\n  virtual std::string Push(uint32_t flags) = 0;\n  virtual std::string Pop(uint32_t flags) = 0;\n\n  // Done is always the last Callback method called by DecodeCbor, whether or\n  // not parsing the input as CBOR encountered an error. Even when successful,\n  // trailing data may remain in input and buffer.\n  //\n  // Do not keep a reference to buffer or buffer.data.ptr after Done returns,\n  // as DecodeCbor may then de-allocate the backing array.\n  //\n  // The default Done implementation is a no-op.\n  virtual void Done(DecodeCborResult& result,\n                    sync_io::Input& input,\n                    IOBuffer& buffer);\n};" +
	"\n\n// DecodeCbor calls callbacks based on the CBOR-formatted data in input.\n//\n// On success, the returned error_message is empty and cursor_position counts\n// the number of bytes consumed. On failure, error_message is non-empty and\n// cursor_position is the location of the error. That error may be a content\n// error (invalid CBOR) or an input error (e.g. network failure).\nDecodeCborResult DecodeCbor(\n    DecodeCborCallbacks& callbacks,\n    sync_io::Input& input,\n    wuffs_base__slice_u32 quirks = wuffs_base__empty_slice_u32());\n\n}  // namespace wuffs_aux\n" +
	""

const AuxJsonCc = "" +
	"// ---------------- Auxiliary - JSON\n\n#if !defined(WUFFS_CONFIG__MODULES) || defined(WUFFS_CONFIG__MODULE__AUX__JSON)\n\n#include <utility>\n\nnamespace wuffs_aux {\n\nDecodeJsonResult::DecodeJsonResult(std::string&& error_message0,\n                                   uint64_t cursor_position0)\n    : error_message(std::move(error_message0)),\n      cursor_position(cursor_position0) {}\n\nvoid  //\nDecodeJsonCallbacks::Done(DecodeJsonResult& result,\n                          sync_io::Input& input,\n                          IOBuffer& buffer) {}\n\nconst char DecodeJson_BadJsonPointer[] =\n    \"wuffs_aux::DecodeJson: bad JSON Pointer\";\nconst char DecodeJson_NoMatch[] = \"wuffs_aux::DecodeJson: no match\";\n\n" +
	"" +
	"// --------\n\n#define WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN                       \\\n  while (tok_buf.meta.ri >= tok_buf.meta.wi) {                           \\\n    if (tok_status.repr == nullptr) {                                    \\\n    } else if (tok_status.repr == wuffs_base__suspension__short_write) { \\\n      tok_buf.compact();                                                 \\\n    } else if (tok_status.repr == wuffs_base__suspension__short_read) {  \\\n      if (!io_error_message.empty()) {                                   \\\n        ret_error_message = std::move(io_error_message);                 \\\n        goto done;                                                       \\\n      } else if (cursor_index != io_buf->meta.ri) {                      \\\n        ret_error_message =                                              \\\n            \"wuffs_aux::DecodeJson: internal error: bad cursor_index\";   \\\n        goto done;                                                       \\\n      } else if (io_buf->meta.closed" +
	") {                                  \\\n        ret_error_message =                                              \\\n            \"wuffs_aux::DecodeJson: internal error: io_buf is closed\";   \\\n        goto done;                                                       \\\n      }                                                                  \\\n      io_buf->compact();                                                 \\\n      if (io_buf->meta.wi >= io_buf->data.len) {                         \\\n        ret_error_message =                                              \\\n            \"wuffs_aux::DecodeJson: internal error: io_buf is full\";     \\\n        goto done;                                                       \\\n      }                                                                  \\\n      cursor_index = io_buf->meta.ri;                                    \\\n      io_error_message = input.CopyIn(io_buf);                           \\\n    } else {                                                             \\\n      ret_" +
	"error_message = tok_status.message();                          \\\n      goto done;                                                         \\\n    }                                                                    \\\n    if (WUFFS_JSON__DECODER_WORKBUF_LEN_MAX_INCL_WORST_CASE != 0) {      \\\n      ret_error_message =                                                \\\n          \"wuffs_aux::DecodeJson: internal error: bad WORKBUF_LEN\";      \\\n      goto done;                                                         \\\n    }                                                                    \\\n    wuffs_base__slice_u8 work_buf = wuffs_base__empty_slice_u8();        \\\n    tok_status = dec->decode_tokens(&tok_buf, io_buf, work_buf);         \\\n  }                                                                      \\\n  wuffs_base__token token = tok_buf.data.ptr[tok_buf.meta.ri++];         \\\n  uint64_t token_len = token.length();                                   \\\n  if ((io_buf->meta.ri < cursor_index) ||                  " +
	"              \\\n      ((io_buf->meta.ri - cursor_index) < token_len)) {                  \\\n    ret_error_message =                                                  \\\n        \"wuffs_aux::DecodeJson: internal error: bad token indexes\";      \\\n    goto done;                                                           \\\n  }                                                                      \\\n  uint8_t* token_ptr = io_buf->data.ptr + cursor_index;                  \\\n  (void)(token_ptr);                                                     \\\n  cursor_index += token_len\n\n" +
	"" +
	"// --------\n\nnamespace {\n\n// DecodeJson_SplitJsonPointer returns (\"bar\", 8) for (\"/foo/bar/b~1z/qux\", 5,\n// etc). It returns a 0 size_t when s has invalid JSON Pointer syntax.\n//\n// The string returned is unescaped. If calling it again, this time with i=8,\n// the \"b~1z\" substring would be returned as \"b/z\".\nstd::pair<std::string, size_t>  //\nDecodeJson_SplitJsonPointer(std::string& s,\n                            size_t i,\n                            bool allow_tilde_r_tilde_n) {\n  std::string fragment;\n  while (i < s.size()) {\n    char c = s[i];\n    if (c == '/') {\n      break;\n    } else if (c != '~') {\n      fragment.push_back(c);\n      i++;\n      continue;\n    }\n    i++;\n    if (i >= s.size()) {\n      return std::make_pair(std::string(), 0);\n    }\n    c = s[i];\n    if (c == '0') {\n      fragment.push_back('~');\n      i++;\n      continue;\n    } else if (c == '1') {\n      fragment.push_back('/');\n      i++;\n      continue;\n    } else if (allow_tilde_r_tilde_n) {\n      if (c == 'r') {\n        fragment.push_ba" +
	"ck('\\r');\n        i++;\n        continue;\n      } else if (c == 'n') {\n        fragment.push_back('\\n');\n        i++;\n        continue;\n      }\n    }\n    return std::make_pair(std::string(), 0);\n  }\n  return std::make_pair(std::move(fragment), i);\n}\n\n" +
	"" +
	"// --------\n\nstd::string  //\nDecodeJson_WalkJsonPointerFragment(wuffs_base__token_buffer& tok_buf,\n                                   wuffs_base__status& tok_status,\n                                   wuffs_json__decoder::unique_ptr& dec,\n                                   wuffs_base__io_buffer* io_buf,\n                                   std::string& io_error_message,\n                                   size_t& cursor_index,\n                                   sync_io::Input& input,\n                                   std::string& json_pointer_fragment) {\n  std::string ret_error_message;\n  while (true) {\n    WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN;\n\n    int64_t vbc = token.value_base_category();\n    uint64_t vbd = token.value_base_detail();\n    if (vbc == WUFFS_BASE__TOKEN__VBC__FILLER) {\n      continue;\n    } else if ((vbc != WUFFS_BASE__TOKEN__VBC__STRUCTURE) ||\n               !(vbd & WUFFS_BASE__TOKEN__VBD__STRUCTURE__PUSH)) {\n      return DecodeJson_NoMatch;\n    } else if (vbd & WUFFS_BASE__TOKEN__VBD__ST" +
	"RUCTURE__TO_LIST) {\n      goto do_list;\n    }\n    goto do_dict;\n  }\n\ndo_dict:\n  // Alternate between these two things:\n  //  1. Decode the next dict key (a string). If it matches the fragment, we're\n  //    done (success). If we've reached the dict's end (VBD__STRUCTURE__POP)\n  //    so that there was no next dict key, we're done (failure).\n  //  2. Otherwise, skip the next dict value.\n  while (true) {\n    for (std::string str; true;) {\n      WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN;\n\n      int64_t vbc = token.value_base_category();\n      uint64_t vbd = token.value_base_detail();\n      switch (vbc) {\n        case WUFFS_BASE__TOKEN__VBC__FILLER:\n          continue;\n\n        case WUFFS_BASE__TOKEN__VBC__STRUCTURE:\n          if (vbd & WUFFS_BASE__TOKEN__VBD__STRUCTURE__PUSH) {\n            goto fail;\n          }\n          return DecodeJson_NoMatch;\n\n        case WUFFS_BASE__TOKEN__VBC__STRING: {\n          if (vbd & WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_0_DST_1_SRC_DROP) {\n            // No-op.\n          } els" +
	"e if (vbd &\n                     WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_1_DST_1_SRC_COPY) {\n            const char* ptr =  // Convert from (uint8_t*).\n                static_cast<const char*>(static_cast<void*>(token_ptr));\n            str.append(ptr, token_len);\n          } else {\n            goto fail;\n          }\n          break;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__UNICODE_CODE_POINT: {\n          uint8_t u[WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL];\n          size_t n = wuffs_base__utf_8__encode(\n              wuffs_base__make_slice_u8(\n                  &u[0], WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL),\n              static_cast<uint32_t>(vbd));\n          const char* ptr =  // Convert from (uint8_t*).\n              static_cast<const char*>(static_cast<void*>(&u[0]));\n          str.append(ptr, n);\n          break;\n        }\n\n        default:\n          goto fail;\n      }\n\n      if (token.continued()) {\n        continue;\n      }\n      if (str == json_pointer_fragment) {\n        return \"\";\n      }\n" +
	"      goto skip_the_next_dict_value;\n    }\n\n  skip_the_next_dict_value:\n    for (uint32_t skip_depth = 0; true;) {\n      WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN;\n\n      int64_t vbc = token.value_base_category();\n      uint64_t vbd = token.value_base_detail();\n      if (token.continued() || (vbc == WUFFS_BASE__TOKEN__VBC__FILLER)) {\n        continue;\n      } else if (vbc == WUFFS_BASE__TOKEN__VBC__STRUCTURE) {\n        if (vbd & WUFFS_BASE__TOKEN__VBD__STRUCTURE__PUSH) {\n          skip_depth++;\n          continue;\n        }\n        skip_depth--;\n      }\n\n      if (skip_depth == 0) {\n        break;\n      }\n    }  // skip_the_next_dict_value\n  }    // do_dict\n\ndo_list:\n  do {\n    wuffs_base__result_u64 result_u64 = wuffs_base__parse_number_u64(\n        wuffs_base__make_slice_u8(\n            static_cast<uint8_t*>(static_cast<void*>(\n                const_cast<char*>(json_pointer_fragment.data()))),\n            json_pointer_fragment.size()),\n        WUFFS_BASE__PARSE_NUMBER_XXX__DEFAULT_OPTIONS);\n    if (!result" +
	"_u64.status.is_ok()) {\n      return DecodeJson_NoMatch;\n    }\n    uint64_t remaining = result_u64.value;\n    if (remaining == 0) {\n      goto check_that_a_value_follows;\n    }\n    for (uint32_t skip_depth = 0; true;) {\n      WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN;\n\n      int64_t vbc = token.value_base_category();\n      uint64_t vbd = token.value_base_detail();\n      if (token.continued() || (vbc == WUFFS_BASE__TOKEN__VBC__FILLER)) {\n        continue;\n      } else if (vbc == WUFFS_BASE__TOKEN__VBC__STRUCTURE) {\n        if (vbd & WUFFS_BASE__TOKEN__VBD__STRUCTURE__PUSH) {\n          skip_depth++;\n          continue;\n        }\n        if (skip_depth == 0) {\n          return DecodeJson_NoMatch;\n        }\n        skip_depth--;\n      }\n\n      if (skip_depth > 0) {\n        continue;\n      }\n      remaining--;\n      if (remaining == 0) {\n        goto check_that_a_value_follows;\n      }\n    }\n  } while (false);  // do_list\n\ncheck_that_a_value_follows:\n  while (true) {\n    WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN;" +
	"\n\n    int64_t vbc = token.value_base_category();\n    uint64_t vbd = token.value_base_detail();\n    if (vbc == WUFFS_BASE__TOKEN__VBC__FILLER) {\n      continue;\n    }\n\n    // Undo the last part of WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN, so that\n    // we're only peeking at the next token.\n    tok_buf.meta.ri--;\n    cursor_index -= token_len;\n\n    if ((vbc == WUFFS_BASE__TOKEN__VBC__STRUCTURE) &&\n        (vbd & WUFFS_BASE__TOKEN__VBD__STRUCTURE__POP)) {\n      return DecodeJson_NoMatch;\n    }\n    return \"\";\n  }  // check_that_a_value_follows\n\nfail:\n  return \"wuffs_aux::DecodeJson: internal error: unexpected token\";\ndone:\n  return ret_error_message;\n}\n\n}  // namespace\n\n" +
	"" +
	"// --------\n\nDecodeJsonResult  //\nDecodeJson(DecodeJsonCallbacks& callbacks,\n           sync_io::Input& input,\n           wuffs_base__slice_u32 quirks,\n           std::string json_pointer) {\n  // Prepare the wuffs_base__io_buffer and the resultant error_message.\n  wuffs_base__io_buffer* io_buf = input.BringsItsOwnIOBuffer();\n  wuffs_base__io_buffer fallback_io_buf = wuffs_base__empty_io_buffer();\n  std::unique_ptr<uint8_t[]> fallback_io_array(nullptr);\n  if (!io_buf) {\n    fallback_io_array = std::unique_ptr<uint8_t[]>(new uint8_t[4096]);\n    fallback_io_buf = wuffs_base__ptr_u8__writer(fallback_io_array.get(), 4096);\n    io_buf = &fallback_io_buf;\n  }\n  // cursor_index is discussed at\n  // https://nigeltao.github.io/blog/2020/jsonptr.html#the-cursor-index\n  size_t cursor_index = 0;\n  std::string ret_error_message;\n  std::string io_error_message;\n\n  do {\n    // Prepare the low-level JSON decoder.\n    wuffs_json__decoder::unique_ptr dec = wuffs_json__decoder::alloc();\n    if (!dec) {\n      ret_error_message = " +
	"\"wuffs_aux::DecodeJson: out of memory\";\n      goto done;\n    }\n    bool allow_tilde_r_tilde_n = false;\n    for (size_t i = 0; i < quirks.len; i++) {\n      dec->set_quirk_enabled(quirks.ptr[i], true);\n      if (quirks.ptr[i] ==\n          WUFFS_JSON__QUIRK_JSON_POINTER_ALLOW_TILDE_R_TILDE_N) {\n        allow_tilde_r_tilde_n = true;\n      }\n    }\n\n    // Prepare the wuffs_base__tok_buffer. 256 tokens is 2KiB.\n    wuffs_base__token tok_array[256];\n    wuffs_base__token_buffer tok_buf =\n        wuffs_base__slice_token__writer(wuffs_base__make_slice_token(\n            &tok_array[0], (sizeof(tok_array) / sizeof(tok_array[0]))));\n    wuffs_base__status tok_status = wuffs_base__make_status(nullptr);\n\n    // Prepare other state.\n    uint32_t depth = 0;\n    std::string str;\n\n    // Walk the (optional) JSON Pointer.\n    for (size_t i = 0; i < json_pointer.size();) {\n      if (json_pointer[i] != '/') {\n        ret_error_message = DecodeJson_BadJsonPointer;\n        goto done;\n      }\n      std::pair<std::string, size_t> spl" +
	"it = DecodeJson_SplitJsonPointer(\n          json_pointer, i + 1, allow_tilde_r_tilde_n);\n      i = std::move(split.second);\n      if (i == 0) {\n        ret_error_message = DecodeJson_BadJsonPointer;\n        goto done;\n      }\n      ret_error_message = DecodeJson_WalkJsonPointerFragment(\n          tok_buf, tok_status, dec, io_buf, io_error_message, cursor_index,\n          input, split.first);\n      if (!ret_error_message.empty()) {\n        goto done;\n      }\n    }\n\n    // Loop, doing these two things:\n    //  1. Get the next token.\n    //  2. Process that token.\n    while (true) {\n      WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN;\n\n      int64_t vbc = token.value_base_category();\n      uint64_t vbd = token.value_base_detail();\n      switch (vbc) {\n        case WUFFS_BASE__TOKEN__VBC__FILLER:\n          continue;\n\n        case WUFFS_BASE__TOKEN__VBC__STRUCTURE: {\n          if (vbd & WUFFS_BASE__TOKEN__VBD__STRUCTURE__PUSH) {\n            ret_error_message = callbacks.Push(static_cast<uint32_t>(vbd));\n            i" +
	"f (!ret_error_message.empty()) {\n              goto done;\n            }\n            depth++;\n            continue;\n          }\n          ret_error_message = callbacks.Pop(static_cast<uint32_t>(vbd));\n          depth--;\n          goto parsed_a_value;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__STRING: {\n          if (vbd & WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_0_DST_1_SRC_DROP) {\n            // No-op.\n          } else if (vbd &\n                     WUFFS_BASE__TOKEN__VBD__STRING__CONVERT_1_DST_1_SRC_COPY) {\n            const char* ptr =  // Convert from (uint8_t*).\n                static_cast<const char*>(static_cast<void*>(token_ptr));\n            str.append(ptr, token_len);\n          } else {\n            goto fail;\n          }\n          if (token.continued()) {\n            continue;\n          }\n          ret_error_message = callbacks.AppendTextString(std::move(str));\n          str.clear();\n          goto parsed_a_value;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__UNICODE_CODE_POINT: {\n          uin" +
	"t8_t u[WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL];\n          size_t n = wuffs_base__utf_8__encode(\n              wuffs_base__make_slice_u8(\n                  &u[0], WUFFS_BASE__UTF_8__BYTE_LENGTH__MAX_INCL),\n              static_cast<uint32_t>(vbd));\n          const char* ptr =  // Convert from (uint8_t*).\n              static_cast<const char*>(static_cast<void*>(&u[0]));\n          str.append(ptr, n);\n          if (token.continued()) {\n            continue;\n          }\n          goto fail;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__LITERAL: {\n          ret_error_message =\n              (vbd & WUFFS_BASE__TOKEN__VBD__LITERAL__NULL)\n                  ? callbacks.AppendNull()\n                  : callbacks.AppendBool(vbd &\n                                         WUFFS_BASE__TOKEN__VBD__LITERAL__TRUE);\n          goto parsed_a_value;\n        }\n\n        case WUFFS_BASE__TOKEN__VBC__NUMBER: {\n          if (vbd & WUFFS_BASE__TOKEN__VBD__NUMBER__FORMAT_TEXT) {\n            if (vbd & WUFFS_BASE__TOKEN__VBD__NUMBER__" +
	"CONTENT_INTEGER_SIGNED) {\n              wuffs_base__result_i64 r = wuffs_base__parse_number_i64(\n                  wuffs_base__make_slice_u8(token_ptr, token_len),\n                  WUFFS_BASE__PARSE_NUMBER_XXX__DEFAULT_OPTIONS);\n              if (r.status.is_ok()) {\n                ret_error_message = callbacks.AppendI64(r.value);\n                goto parsed_a_value;\n              }\n            }\n            if (vbd & WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_FLOATING_POINT) {\n              wuffs_base__result_f64 r = wuffs_base__parse_number_f64(\n                  wuffs_base__make_slice_u8(token_ptr, token_len),\n                  WUFFS_BASE__PARSE_NUMBER_XXX__DEFAULT_OPTIONS);\n              if (r.status.is_ok()) {\n                ret_error_message = callbacks.AppendF64(r.value);\n                goto parsed_a_value;\n              }\n            }\n          } else if (vbd & WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_NEG_INF) {\n            ret_error_message = callbacks.AppendF64(\n                wuffs_base__ieee_754_" +
	"bit_representation__from_u64_to_f64(\n                    0xFFF0000000000000ul));\n            goto parsed_a_value;\n          } else if (vbd & WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_POS_INF) {\n            ret_error_message = callbacks.AppendF64(\n                wuffs_base__ieee_754_bit_representation__from_u64_to_f64(\n                    0x7FF0000000000000ul));\n            goto parsed_a_value;\n          } else if (vbd & WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_NEG_NAN) {\n            ret_error_message = callbacks.AppendF64(\n                wuffs_base__ieee_754_bit_representation__from_u64_to_f64(\n                    0xFFFFFFFFFFFFFFFFul));\n            goto parsed_a_value;\n          } else if (vbd & WUFFS_BASE__TOKEN__VBD__NUMBER__CONTENT_POS_NAN) {\n            ret_error_message = callbacks.AppendF64(\n                wuffs_base__ieee_754_bit_representation__from_u64_to_f64(\n                    0x7FFFFFFFFFFFFFFFul));\n            goto parsed_a_value;\n          }\n          goto fail;\n        }\n      }\n\n    fail:\n  " +
	"    ret_error_message =\n          \"wuffs_aux::DecodeJson: internal error: unexpected token\";\n      goto done;\n\n    parsed_a_value:\n      if (!ret_error_message.empty() || (depth == 0)) {\n        goto done;\n      }\n    }\n  } while (false);\n\ndone:\n  DecodeJsonResult result(\n      std::move(ret_error_message),\n      wuffs_base__u64__sat_add(io_buf->meta.pos, cursor_index));\n  callbacks.Done(result, input, *io_buf);\n  return result;\n}\n\n#undef WUFFS_AUX__DECODE_JSON__GET_THE_NEXT_TOKEN\n\n}  // namespace wuffs_aux\n\n#endif  // !defined(WUFFS_CONFIG__MODULES) ||\n        // defined(WUFFS_CONFIG__MODULE__AUX__JSON)\n" +
	""

const AuxJsonHh = "" +
	"// ---------------- Auxiliary - JSON\n\nnamespace wuffs_aux {\n\nstruct DecodeJsonResult {\n  DecodeJsonResult(std::string&& error_message0, uint64_t cursor_position0);\n\n  std::string error_message;\n  uint64_t cursor_position;\n};\n\nclass DecodeJsonCallbacks {\n public:\n  // AppendXxx are called for leaf nodes: literals, numbers and strings. For\n  // strings, the Callbacks implementation is responsible for tracking map keys\n  // versus other values.\n\n  virtual std::string AppendNull() = 0;\n  virtual std::string AppendBool(bool val) = 0;\n  virtual std::string AppendF64(double val) = 0;\n  virtual std::string AppendI64(int64_t val) = 0;\n  virtual std::string AppendTextString(std::string&& val) = 0;\n\n  // Push and Pop are called for container nodes: JSON arrays (lists) and JSON\n  // objects (dictionaries).\n  //\n  // The flags bits combine exactly one of:\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_NONE\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_LIST\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__FROM_DICT\n  // and e" +
	"xactly one of:\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_NONE\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_LIST\n  //  - WUFFS_BASE__TOKEN__VBD__STRUCTURE__TO_DICT\n\n  virtual std::string Push(uint32_t flags) = 0;\n  virtual std::string Pop(uint32_t flags) = 0;\n\n  // Done is always the last Callback method called by DecodeJson, whether or\n  // not parsing the input as JSON encountered an error. Even when successful,\n  // trailing data may remain in input and buffer. See \"Unintuitive JSON\n  // Parsing\" (https://nullprogram.com/blog/2019/12/28/) which discusses JSON\n  // parsing and when it stops.\n  //\n  // Do not keep a reference to buffer or buffer.data.ptr after Done returns,\n  // as DecodeJson may then de-allocate the backing array.\n  //\n  // The default Done implementation is a no-op.\n  virtual void Done(DecodeJsonResult& result,\n                    sync_io::Input& input,\n                    IOBuffer& buffer);\n};\n\nextern const char DecodeJson_BadJsonPointer[];\nextern const char DecodeJson_NoMatch[];\n\n// " +
	"DecodeJson calls callbacks based on the JSON-formatted data in input.\n//\n// On success, the returned error_message is empty and cursor_position counts\n// the number of bytes consumed. On failure, error_message is non-empty and\n// cursor_position is the location of the error. That error may be a content\n// error (invalid JSON) or an input error (e.g. network failure).\n//\n// json_pointer is a query in the JSON Pointer (RFC 6901) syntax. The callbacks\n// run for the input's sub-node that matches the query. DecodeJson_NoMatch is\n// returned if no matching sub-node was found. The empty query matches the\n// input's root node, consistent with JSON Pointer semantics.\n//\n// The JSON Pointer implementation is greedy: duplicate keys are not rejected\n// but only the first match for each '/'-separated fragment is followed.\nDecodeJsonResult DecodeJson(\n    DecodeJsonCallbacks& callbacks,\n    sync_io::Input& input,\n    wuffs_base__slice_u32 quirks = wuffs_base__empty_slice_u32(),\n    std::string json_pointer = std::string()" +
	");\n\n}  // namespace wuffs_aux\n" +
	""

var AuxNonBaseCcFiles = []string{
	AuxCborCc,
	AuxJsonCc,
}

var AuxNonBaseHhFiles = []string{
	AuxCborHh,
	AuxJsonHh,
}

const BaseCopyright = "" +
	"// Copyright 2017 The Wuffs Authors.\n//\n// Licensed under the Apache License, Version 2.0 (the \"License\");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//    https://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \"AS IS\" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n" +
	""
