/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright 2019 HabanaLabs, Ltd.
 * All Rights Reserved.
 *
 */

#ifndef INCLUDE_MMU_V2_0_H_
#define INCLUDE_MMU_V2_0_H_

#define HOP0_MASK_4K			0xFE00000000000000ull
#define HOP1_MASK_4K			0x01FF000000000000ull
#define HOP2_MASK_4K			0x0000FF8000000000ull
#define HOP3_MASK_4K			0x0000007FC0000000ull
#define HOP4_MASK_4K			0x000000003FE00000ull
#define HOP5_MASK_4K			0x00000000001FF000ull

#define HOP0_MASK_64K			0xFF00000000000000ull
#define HOP1_MASK_64K			0x00FF000000000000ull
#define HOP2_MASK_64K			0x0000FF0000000000ull
#define HOP3_MASK_64K			0x000000FF00000000ull
#define HOP4_MASK_64K			0x00000000FF000000ull
#define HOP5_MASK_64K			0x0000000000FF0000ull

#define HOP0_SHIFT_4K			57
#define HOP1_SHIFT_4K			48
#define HOP2_SHIFT_4K			39
#define HOP3_SHIFT_4K			30
#define HOP4_SHIFT_4K			21
#define HOP5_SHIFT_4K			12

#define HOP0_SHIFT_64K			56
#define HOP1_SHIFT_64K			48
#define HOP2_SHIFT_64K			40
#define HOP3_SHIFT_64K			32
#define HOP4_SHIFT_64K			24
#define HOP5_SHIFT_64K			16

#define DHOP0_MASK			HOP0_MASK_4K
#define DHOP1_MASK			HOP1_MASK_4K
#define DHOP2_MASK			HOP2_MASK_4K
#define DHOP3_MASK			HOP3_MASK_4K
#define DHOP4_MASK			0x000003C000000ull

#define DHOP0_SHIFT			HOP0_SHIFT_4K
#define DHOP1_SHIFT			HOP1_SHIFT_4K
#define DHOP2_SHIFT			HOP2_SHIFT_4K
#define DHOP3_SHIFT			HOP3_SHIFT_4K
#define DHOP4_SHIFT			26

#endif /* INCLUDE_MMU_V2_0_H_ */
