; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2 | FileCheck %s --check-prefix=CHECK --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=CHECK --check-prefix=SSE41

; A single 16-bit load + a single 16-bit store
define void @load_2_i8(<2 x i8>* %A)  {
; SSE2-LABEL: load_2_i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    paddb {{.*}}(%rip), %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    retq
;
; SSE41-LABEL: load_2_i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    paddb {{.*}}(%rip), %xmm0
; SSE41-NEXT:    pextrw $0, %xmm0, (%rdi)
; SSE41-NEXT:    retq
   %T = load <2 x i8>, <2 x i8>* %A
   %G = add <2 x i8> %T, <i8 9, i8 7>
   store <2 x i8> %G, <2 x i8>* %A
   ret void
}

; Read 32-bits
define void @load_2_i16(<2 x i16>* %A)  {
; CHECK-LABEL: load_2_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    paddw {{.*}}(%rip), %xmm0
; CHECK-NEXT:    movd %xmm0, (%rdi)
; CHECK-NEXT:    retq
   %T = load <2 x i16>, <2 x i16>* %A
   %G = add <2 x i16> %T, <i16 9, i16 7>
   store <2 x i16> %G, <2 x i16>* %A
   ret void
}

define void @load_2_i32(<2 x i32>* %A)  {
; CHECK-LABEL: load_2_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; CHECK-NEXT:    paddd {{.*}}(%rip), %xmm0
; CHECK-NEXT:    movq %xmm0, (%rdi)
; CHECK-NEXT:    retq
   %T = load <2 x i32>, <2 x i32>* %A
   %G = add <2 x i32> %T, <i32 9, i32 7>
   store <2 x i32> %G, <2 x i32>* %A
   ret void
}

define void @load_4_i8(<4 x i8>* %A)  {
; CHECK-LABEL: load_4_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    paddb {{.*}}(%rip), %xmm0
; CHECK-NEXT:    movd %xmm0, (%rdi)
; CHECK-NEXT:    retq
   %T = load <4 x i8>, <4 x i8>* %A
   %G = add <4 x i8> %T, <i8 1, i8 4, i8 9, i8 7>
   store <4 x i8> %G, <4 x i8>* %A
   ret void
}

define void @load_4_i16(<4 x i16>* %A)  {
; CHECK-LABEL: load_4_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; CHECK-NEXT:    paddw {{.*}}(%rip), %xmm0
; CHECK-NEXT:    movq %xmm0, (%rdi)
; CHECK-NEXT:    retq
   %T = load <4 x i16>, <4 x i16>* %A
   %G = add <4 x i16> %T, <i16 1, i16 4, i16 9, i16 7>
   store <4 x i16> %G, <4 x i16>* %A
   ret void
}

define void @load_8_i8(<8 x i8>* %A)  {
; CHECK-LABEL: load_8_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; CHECK-NEXT:    paddb %xmm0, %xmm0
; CHECK-NEXT:    movq %xmm0, (%rdi)
; CHECK-NEXT:    retq
   %T = load <8 x i8>, <8 x i8>* %A
   %G = add <8 x i8> %T, %T
   store <8 x i8> %G, <8 x i8>* %A
   ret void
}
