; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+d,+experimental-zvlsseg,+experimental-zfh \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i16(i16*, <vscale x 16 x i16>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv16i16(i16* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i16(i16* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv16i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv32i16(i16*, <vscale x 32 x i16>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv32i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 32 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv32i16(i16* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v20, v16
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv32i16(i16* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv32i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i32(i16*, <vscale x 4 x i32>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 4 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv4i32(i16* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i32(i16* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i8(i16*, <vscale x 16 x i8>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv16i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv16i8(i16* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i8(i16* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv16i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i64(i16*, <vscale x 1 x i64>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i64(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 1 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv1i64(i16* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i64(i16* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv1i64(i16* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i64(i16* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i64(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 1 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i32(i16*, <vscale x 1 x i32>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 1 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv1i32(i16* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i32(i16* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i16(i16*, <vscale x 8 x i16>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 8 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv8i16(i16* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i16(i16* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i8(i16*, <vscale x 4 x i8>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 4 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv4i8(i16* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i8(i16* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i16(i16*, <vscale x 1 x i16>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 1 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv1i16(i16* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i16(i16* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i32(i16*, <vscale x 2 x i32>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 2 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv2i32(i16* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i32(i16* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i8(i16*, <vscale x 8 x i8>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 8 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv8i8(i16* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i8(i16* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i64(i16*, <vscale x 4 x i64>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i64(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 4 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv4i64(i16* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i64(i16* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv4i64(i16* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i64(i16* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i64(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 4 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv64i8(i16*, <vscale x 64 x i8>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv64i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 64 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv64i8(i16* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v20, v16
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv64i8(i16* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv64i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i16(i16*, <vscale x 4 x i16>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 4 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv4i16(i16* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv4i16(i16* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv4i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i64(i16*, <vscale x 8 x i64>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i64(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 8 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv8i64(i16* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i64(i16* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv8i64(i16* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v20, v16
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i64(i16* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i64(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 8 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i8(i16*, <vscale x 1 x i8>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 1 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv1i8(i16* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv1i8(i16* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv1i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i8(i16*, <vscale x 2 x i8>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 2 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv2i8(i16* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i8(i16* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i32(i16*, <vscale x 8 x i32>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 8 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv8i32(i16* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv8i32(i16* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv8i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv32i8(i16*, <vscale x 32 x i8>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv32i8(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 32 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv32i8(i16* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv32i8(i16* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv32i8(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i32(i16*, <vscale x 16 x i32>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv16i32(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv16i32(i16* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v20, v16
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv16i32(i16* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv16i32(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i16(i16*, <vscale x 2 x i16>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 2 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv2i16(i16* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i16(i16* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i16(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i64(i16*, <vscale x 2 x i64>, i64)
declare {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i64(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, <vscale x 2 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i16> @test_vluxseg2_nxv16i16_nxv2i64(i16* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i64(i16* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 1
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vluxseg2_mask_nxv16i16_nxv2i64(i16* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vsetvli a1, a1, e16,m4,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.nxv16i16.nxv2i64(i16* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %0, 0
  %2 = tail call {<vscale x 16 x i16>,<vscale x 16 x i16>} @llvm.riscv.vluxseg2.mask.nxv16i16.nxv2i64(<vscale x 16 x i16> %1,<vscale x 16 x i16> %1, i16* %base, <vscale x 2 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i16>,<vscale x 16 x i16>} %2, 1
  ret <vscale x 16 x i16> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv16i16(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv16i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv32i16(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 32 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv32i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv16i8(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv16i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i64(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i16(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i16(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i8(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv64i8(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 64 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv64i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv4i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i64(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i8(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv1i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i8(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv8i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv32i8(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 32 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv32i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv16i32(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv16i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i16(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i64(<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg2_nxv4i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv4i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg2_mask_nxv4i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv4i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.nxv4i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg2.mask.nxv4i32.nxv2i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv16i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv16i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv32i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 32 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv32i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv16i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv16i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv64i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 64 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv64i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv4i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv1i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv8i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv32i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 32 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv32i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv16i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv16i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg3_nxv4i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv4i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg3_mask_nxv4i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv4i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.nxv4i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg3.mask.nxv4i32.nxv2i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv16i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv16i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv32i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 32 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv32i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv16i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv16i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv64i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 64 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv64i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv4i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 1 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv1i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 8 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv8i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv32i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 32 x i8>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv32i8(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv16i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 16 x i32>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv16i32(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i16>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i16(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, i32*, <vscale x 2 x i64>, <vscale x 4 x i1>, i64)

define <vscale x 4 x i32> @test_vluxseg4_nxv4i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv4i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 1
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vluxseg4_mask_nxv4i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv4i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e32,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.nxv4i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %0, 0
  %2 = tail call {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} @llvm.riscv.vluxseg4.mask.nxv4i32.nxv2i64(<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1,<vscale x 4 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>} %2, 1
  ret <vscale x 4 x i32> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i16(i8*, <vscale x 16 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv32i16(i8*, <vscale x 32 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv32i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv32i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i32(i8*, <vscale x 4 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i8(i8*, <vscale x 16 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i64(i8*, <vscale x 1 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i64(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i32(i8*, <vscale x 1 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i16(i8*, <vscale x 8 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i8(i8*, <vscale x 4 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i16(i8*, <vscale x 1 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i32(i8*, <vscale x 2 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i8(i8*, <vscale x 8 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i64(i8*, <vscale x 4 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i64(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv64i8(i8*, <vscale x 64 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv64i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 64 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv64i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i16(i8*, <vscale x 4 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv4i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i64(i8*, <vscale x 8 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i64(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i8(i8*, <vscale x 1 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv1i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i8(i8*, <vscale x 2 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i32(i8*, <vscale x 8 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv8i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv32i8(i8*, <vscale x 32 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv32i8(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv32i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i32(i8*, <vscale x 16 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i16(i8*, <vscale x 2 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i16(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i64(i8*, <vscale x 2 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i64(<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg2_nxv16i8_nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv16i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg2_mask_nxv16i8_nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv16i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.nxv16i8.nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg2.mask.nxv16i8.nxv2i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i16(i8*, <vscale x 16 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv32i16(i8*, <vscale x 32 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv32i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv32i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i32(i8*, <vscale x 4 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i8(i8*, <vscale x 16 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i64(i8*, <vscale x 1 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i32(i8*, <vscale x 1 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i16(i8*, <vscale x 8 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i8(i8*, <vscale x 4 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i16(i8*, <vscale x 1 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i32(i8*, <vscale x 2 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i8(i8*, <vscale x 8 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i64(i8*, <vscale x 4 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv64i8(i8*, <vscale x 64 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv64i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 64 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv64i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i16(i8*, <vscale x 4 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv4i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i64(i8*, <vscale x 8 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i8(i8*, <vscale x 1 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv1i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i8(i8*, <vscale x 2 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i32(i8*, <vscale x 8 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv8i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv32i8(i8*, <vscale x 32 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv32i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv32i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i32(i8*, <vscale x 16 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i16(i8*, <vscale x 2 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i64(i8*, <vscale x 2 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg3_nxv16i8_nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv16i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg3_mask_nxv16i8_nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv16i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8
; CHECK-NEXT:    vmv2r.v v4, v2
; CHECK-NEXT:    vmv2r.v v6, v2
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v2, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v4
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.nxv16i8.nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg3.mask.nxv16i8.nxv2i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i16(i8*, <vscale x 16 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i16(i8* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv32i16(i8*, <vscale x 32 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv32i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv32i16(i8* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv32i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i32(i8*, <vscale x 4 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i32(i8* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i8(i8*, <vscale x 16 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i8(i8* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i64(i8*, <vscale x 1 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i64(i8* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i32(i8*, <vscale x 1 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i32(i8* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i16(i8*, <vscale x 8 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i16(i8* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i8(i8*, <vscale x 4 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i8(i8* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i16(i8*, <vscale x 1 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i16(i8* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i32(i8*, <vscale x 2 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i32(i8* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i8(i8*, <vscale x 8 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i8(i8* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i64(i8*, <vscale x 4 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i64(i8* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv64i8(i8*, <vscale x 64 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv64i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 64 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv64i8(i8* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv64i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 64 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i16(i8*, <vscale x 4 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 4 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv4i16(i8* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv4i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 4 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i64(i8*, <vscale x 8 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i64(i8* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i8(i8*, <vscale x 1 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 1 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv1i8(i8* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv1i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 1 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i8(i8*, <vscale x 2 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i8(i8* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i32(i8*, <vscale x 8 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 8 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv8i32(i8* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv8i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 8 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv32i8(i8*, <vscale x 32 x i8>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv32i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 32 x i8>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv32i8(i8* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv32i8(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 32 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i32(i8*, <vscale x 16 x i32>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv16i32(i8* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i16(i8*, <vscale x 2 x i16>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i16>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i16(i8* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i16(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i64(i8*, <vscale x 2 x i64>, i64)
declare {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i64(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, i8*, <vscale x 2 x i64>, <vscale x 16 x i1>, i64)

define <vscale x 16 x i8> @test_vluxseg4_nxv16i8_nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv16i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 1
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vluxseg4_mask_nxv16i8_nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv16i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v14, v10
; CHECK-NEXT:    vmv2r.v v16, v10
; CHECK-NEXT:    vsetvli a1, a1, e8,m2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.nxv16i8.nxv2i64(i8* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %0, 0
  %2 = tail call {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} @llvm.riscv.vluxseg4.mask.nxv16i8.nxv2i64(<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1,<vscale x 16 x i8> %1, i8* %base, <vscale x 2 x i64> %index, <vscale x 16 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>} %2, 1
  ret <vscale x 16 x i8> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i16(i64*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv16i16(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv16i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv32i16(i64*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv32i16(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv32i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i32(i64*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i32(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i8(i64*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv16i8(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv16i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i64(i64*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i32(i64*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i16(i64*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i16(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i8(i64*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i8(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i16(i64*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i32(i64*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i32(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i8(i64*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i8(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i64(i64*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i64(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv64i8(i64*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv64i8(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv64i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i16(i64*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i16(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv4i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i64(i64*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i64(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i8(i64*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i8(i64*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i8(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i32(i64*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i32(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv8i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv32i8(i64*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv32i8(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv32i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i32(i64*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv16i32(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv16i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i16(i64*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i16(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i64(i64*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i64(<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg2_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg2_mask_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg2.mask.nxv1i64.nxv2i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i16(i64*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv16i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv16i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv32i16(i64*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv32i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv32i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i32(i64*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i8(i64*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv16i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv16i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i64(i64*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i32(i64*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i16(i64*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i8(i64*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i16(i64*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i32(i64*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i8(i64*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i64(i64*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv64i8(i64*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv64i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv64i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i16(i64*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv4i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i64(i64*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i8(i64*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i8(i64*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i32(i64*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv8i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv32i8(i64*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv32i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv32i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i32(i64*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv16i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv16i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i16(i64*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i64(i64*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg3_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg3_mask_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg3.mask.nxv1i64.nxv2i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i16(i64*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv16i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv16i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv32i16(i64*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv32i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv32i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i32(i64*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i8(i64*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv16i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv16i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i64(i64*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i32(i64*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i16(i64*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i8(i64*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i16(i64*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i32(i64*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i8(i64*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i64(i64*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv64i8(i64*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv64i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv64i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i16(i64*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv4i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i64(i64*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i8(i64*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i8(i64*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i32(i64*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv8i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv32i8(i64*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv32i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv32i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i32(i64*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv16i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv16i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i16(i64*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i64(i64*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg4_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg4_mask_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg4.mask.nxv1i64.nxv2i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i16(i64*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv16i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv16i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv32i16(i64*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv32i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv32i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i32(i64*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i8(i64*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv16i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv16i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i64(i64*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i32(i64*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i16(i64*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i8(i64*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i16(i64*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i32(i64*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i8(i64*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i64(i64*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv64i8(i64*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv64i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv64i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i16(i64*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv4i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i64(i64*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i8(i64*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i8(i64*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i32(i64*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv8i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv32i8(i64*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv32i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv32i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i32(i64*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv16i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv16i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i16(i64*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i64(i64*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg5_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg5_mask_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg5.mask.nxv1i64.nxv2i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i16(i64*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv16i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv16i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv32i16(i64*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv32i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv32i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i32(i64*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i8(i64*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv16i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv16i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i64(i64*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i32(i64*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i16(i64*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i8(i64*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i16(i64*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i32(i64*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i8(i64*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i64(i64*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv64i8(i64*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv64i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv64i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i16(i64*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv4i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i64(i64*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i8(i64*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i8(i64*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i32(i64*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv8i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv32i8(i64*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv32i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv32i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i32(i64*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv16i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv16i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i16(i64*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i64(i64*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg6_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg6_mask_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg6.mask.nxv1i64.nxv2i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i16(i64*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv16i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv16i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv32i16(i64*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv32i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv32i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i32(i64*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i8(i64*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv16i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv16i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i64(i64*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i32(i64*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i16(i64*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i8(i64*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i16(i64*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i32(i64*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i8(i64*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i64(i64*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv64i8(i64*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv64i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv64i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i16(i64*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv4i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i64(i64*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i8(i64*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i8(i64*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i32(i64*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv8i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv32i8(i64*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv32i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv32i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i32(i64*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv16i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv16i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i16(i64*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i64(i64*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg7_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg7_mask_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg7.mask.nxv1i64.nxv2i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i16(i64*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv16i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i16(i64* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv16i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv32i16(i64*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv32i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv32i16(i64* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv32i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i32(i64*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i32(i64* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i8(i64*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv16i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i8(i64* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv16i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i64(i64*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i64(i64* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i32(i64*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i32(i64* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i16(i64*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i16(i64* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i8(i64*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i8(i64* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i16(i64*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i16(i64* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i32(i64*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i32(i64* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i8(i64*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i8(i64* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i64(i64*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i64(i64* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv64i8(i64*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv64i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei8.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv64i8(i64* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv64i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i16(i64*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv4i16(i64* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv4i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i64(i64*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i64(i64* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i8(i64*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv1i8(i64* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i8(i64*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i8(i64* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i32(i64*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv8i32(i64* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv8i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv32i8(i64*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv32i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv32i8(i64* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv32i8(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i32(i64*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv16i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv16i32(i64* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv16i32(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i16(i64*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v11, v9
; CHECK-NEXT:    vmv1r.v v12, v9
; CHECK-NEXT:    vmv1r.v v13, v9
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmv1r.v v15, v9
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i16(i64* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i16(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i64(i64*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, i64*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i64> @test_vluxseg8_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg8_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 1
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vluxseg8_mask_nxv1i64_nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg8_mask_nxv1i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e64,m1,ta,mu
; CHECK-NEXT:    vluxseg8ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli a1, a1, e64,m1,tu,mu
; CHECK-NEXT:    vluxseg8ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.nxv1i64.nxv2i64(i64* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %0, 0
  %2 = tail call {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} @llvm.riscv.vluxseg8.mask.nxv1i64.nxv2i64(<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1,<vscale x 1 x i64> %1, i64* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>} %2, 1
  ret <vscale x 1 x i64> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv16i16(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv16i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv32i16(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv32i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv16i8(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv16i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i16(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i8(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i8(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i64(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv64i8(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv64i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i16(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv4i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i64(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i8(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv8i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv32i8(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv32i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv16i32(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv16i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i16(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i64(<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg2_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg2_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg2_mask_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg2_mask_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg2ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg2.mask.nxv1i32.nxv2i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv16i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv16i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv32i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv32i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv16i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv16i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv64i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv64i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv4i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv8i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv32i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv32i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv16i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv16i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg3_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg3_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg3_mask_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg3_mask_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg3ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg3.mask.nxv1i32.nxv2i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv16i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv16i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv32i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv32i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv16i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv16i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv64i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv64i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv4i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv8i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv32i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv32i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv16i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv16i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg4_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg4_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg4_mask_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg4_mask_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg4ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg4.mask.nxv1i32.nxv2i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv16i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv16i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv32i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv32i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv16i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv16i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv64i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv64i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv4i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv8i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv32i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv32i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv16i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv16i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg5_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg5_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg5_mask_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg5_mask_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg5ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg5.mask.nxv1i32.nxv2i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv16i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv16i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv32i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv32i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv16i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv16i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i16(i32*, <vscale x 1 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i16(i32* %base, <vscale x 1 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i32(i32*, <vscale x 2 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i32(i32* %base, <vscale x 2 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i8(i32*, <vscale x 8 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i8(i32* %base, <vscale x 8 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i64(i32*, <vscale x 4 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i64(i32* %base, <vscale x 4 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv64i8(i32*, <vscale x 64 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv64i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 64 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv64i8(i32* %base, <vscale x 64 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv64i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 64 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i16(i32*, <vscale x 4 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv4i16(i32* %base, <vscale x 4 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv4i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i64(i32*, <vscale x 8 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i64(i32* %base, <vscale x 8 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i8(i32*, <vscale x 1 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv1i8(i32* %base, <vscale x 1 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i8(i32*, <vscale x 2 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i8(i32* %base, <vscale x 2 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i32(i32*, <vscale x 8 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv8i32(i32* %base, <vscale x 8 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv8i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv32i8(i32*, <vscale x 32 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv32i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv32i8(i32* %base, <vscale x 32 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv32i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i32(i32*, <vscale x 16 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv16i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv16i32(i32* %base, <vscale x 16 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv16i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i16(i32*, <vscale x 2 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i16(i32* %base, <vscale x 2 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i64(i32*, <vscale x 2 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 2 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg6_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg6_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg6_mask_nxv1i32_nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg6_mask_nxv1i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg6ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.nxv1i32.nxv2i64(i32* %base, <vscale x 2 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg6.mask.nxv1i32.nxv2i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 2 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv16i16(i32*, <vscale x 16 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv16i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv16i16(i32* %base, <vscale x 16 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv16i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv32i16(i32*, <vscale x 32 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv32i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 32 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv32i16(i32* %base, <vscale x 32 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv32i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 32 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv4i32(i32*, <vscale x 4 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv4i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv4i32(i32* %base, <vscale x 4 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv4i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 4 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv16i8(i32*, <vscale x 16 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv16i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 16 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv16i8(i32* %base, <vscale x 16 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv16i8(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 16 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv1i64(i32*, <vscale x 1 x i64>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei64.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv1i64(i32* %base, <vscale x 1 x i64> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv1i32(i32*, <vscale x 1 x i32>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei32.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv1i32(i32* %base, <vscale x 1 x i32> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv8i16(i32*, <vscale x 8 x i16>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv8i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 8 x i16>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei16.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv8i16(i32* %base, <vscale x 8 x i16> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv8i16(<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1,<vscale x 1 x i32> %1, i32* %base, <vscale x 8 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  %3 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %2, 1
  ret <vscale x 1 x i32> %3
}

declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv4i8(i32*, <vscale x 4 x i8>, i64)
declare {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv4i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, i32*, <vscale x 4 x i8>, <vscale x 1 x i1>, i64)

define <vscale x 1 x i32> @test_vluxseg7_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vluxseg7_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v0, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 1
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vluxseg7_mask_nxv1i32_nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vluxseg7_mask_nxv1i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a2, a1, e32,mf2,ta,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8
; CHECK-NEXT:    vmv1r.v v2, v1
; CHECK-NEXT:    vmv1r.v v3, v1
; CHECK-NEXT:    vmv1r.v v4, v1
; CHECK-NEXT:    vmv1r.v v5, v1
; CHECK-NEXT:    vmv1r.v v6, v1
; CHECK-NEXT:    vmv1r.v v7, v1
; CHECK-NEXT:    vsetvli a1, a1, e32,mf2,tu,mu
; CHECK-NEXT:    vluxseg7ei8.v v1, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v2
; CHECK-NEXT:    ret
entry:
  %0 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.nxv1i32.nxv4i8(i32* %base, <vscale x 4 x i8> %index, i64 %vl)
  %1 = extractvalue {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} %0, 0
  %2 = tail call {<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>} @llvm.riscv.vluxseg7.mask.nxv1i32.nxv4i8(<vscal