; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; These functions are constructed slightly differently so that they require
; the same output blocks for the values used outside of the region. We are
; checking that two output blocks are created with the same store instructions.

define void @outline_outputs1() #0 {
; CHECK-LABEL: @outline_outputs1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DOTLOC:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[ADD_LOC:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[OUTPUT:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[RESULT:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[ADD_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[DOTLOC]])
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[OUTPUT]], ptr [[ADD_LOC]], ptr [[DOTLOC]])
; CHECK-NEXT:    [[ADD_RELOAD:%.*]] = load i32, ptr [[ADD_LOC]], align 4
; CHECK-NEXT:    [[DOTRELOAD:%.*]] = load i32, ptr [[DOTLOC]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[ADD_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[DOTLOC]])
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[OUTPUT]], align 4
; CHECK-NEXT:    call void @outlined_ir_func_1(i32 [[DOTRELOAD]], i32 [[ADD_RELOAD]], ptr [[RESULT]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %output = alloca i32, align 4
  %result = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  %0 = load i32, ptr %a, align 4
  %1 = load i32, ptr %b, align 4
  %add = add i32 %0, %1
  store i32 %add, ptr %output, align 4
  %2 = load i32, ptr %output, align 4
  %3 = load i32, ptr %output, align 4
  %mul = mul i32 %2, %add
  store i32 %mul, ptr %result, align 4
  ret void
}

define void @outline_outputs2() #0 {
; CHECK-LABEL: @outline_outputs2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DOTLOC:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[ADD_LOC:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[OUTPUT:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[RESULT:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[ADD_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[DOTLOC]])
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[OUTPUT]], ptr [[ADD_LOC]], ptr [[DOTLOC]])
; CHECK-NEXT:    [[ADD_RELOAD:%.*]] = load i32, ptr [[ADD_LOC]], align 4
; CHECK-NEXT:    [[DOTRELOAD:%.*]] = load i32, ptr [[DOTLOC]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[ADD_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[DOTLOC]])
; CHECK-NEXT:    call void @outlined_ir_func_1(i32 [[DOTRELOAD]], i32 [[ADD_RELOAD]], ptr [[RESULT]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %output = alloca i32, align 4
  %result = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  %0 = load i32, ptr %a, align 4
  %1 = load i32, ptr %b, align 4
  %add = add i32 %0, %1
  store i32 %add, ptr %output, align 4
  %2 = load i32, ptr %output, align 4
  %mul = mul i32 %2, %add
  store i32 %mul, ptr %result, align 4
  ret void
}

; CHECK: define internal void @outlined_ir_func_0(ptr [[ARG0:%.*]], ptr [[ARG1:%.*]], ptr [[ARG2:%.*]], ptr [[ARG3:%.*]], ptr [[ARG4:%.*]]) #1 {
; CHECK: entry_to_outline:
; CHECK-NEXT:    store i32 2, ptr [[ARG0]], align 4
; CHECK-NEXT:    store i32 3, ptr [[ARG1]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARG0]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARG1]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    store i32 [[ADD]], ptr [[ARG2]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[ARG2]], align 4

; CHECK: entry_after_outline.exitStub:
; CHECK-NEXT:    store i32 [[ADD]], ptr [[ARG3]], align 4
; CHECK-NEXT:    store i32 [[TMP2]], ptr [[ARG4]], align 4
