"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DualListSelectorTreeItem = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const dual_list_selector_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/DualListSelector/dual-list-selector"));
const react_styles_1 = require("@patternfly/react-styles");
const Badge_1 = require("../Badge");
const angle_right_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/angle-right-icon'));
const treeUtils_1 = require("./treeUtils");
const DualListSelectorContext_1 = require("./DualListSelectorContext");
const helpers_1 = require("../../helpers");
const DualListSelectorTreeItemBase = (_a) => {
    var { onOptionCheck, children, className, id, text, defaultExpanded, hasBadge, isChecked, checkProps, badgeProps, itemData, isDisabled = false, hasAnimations: hasAnimationsProp, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    useMemo } = _a, props = tslib_1.__rest(_a, ["onOptionCheck", "children", "className", "id", "text", "defaultExpanded", "hasBadge", "isChecked", "checkProps", "badgeProps", "itemData", "isDisabled", "hasAnimations", "useMemo"]);
    const ref = (0, react_1.useRef)(null);
    const [isExpanded, setIsExpanded] = (0, react_1.useState)(defaultExpanded || false);
    const { setFocusedOption } = (0, react_1.useContext)(DualListSelectorContext_1.DualListSelectorListContext);
    const hasAnimations = (0, helpers_1.useHasAnimations)(hasAnimationsProp);
    (0, react_1.useEffect)(() => {
        setIsExpanded(defaultExpanded);
    }, [defaultExpanded]);
    const clonedChildren = react_1.Children.map(children, (child) => (0, react_1.isValidElement)(child) &&
        (0, react_1.cloneElement)(child, {
            inert: isExpanded ? undefined : ''
        }));
    return ((0, jsx_runtime_1.jsxs)("li", Object.assign({ className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorListItem, className, children && dual_list_selector_1.default.modifiers.expandable, isExpanded && dual_list_selector_1.default.modifiers.expanded, isDisabled && dual_list_selector_1.default.modifiers.disabled), id: id }, props, { "aria-selected": isChecked, role: "treeitem" }, (isExpanded && { 'aria-expanded': 'true' }), { children: [(0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorListItemRow, isChecked && dual_list_selector_1.default.modifiers.selected, dual_list_selector_1.default.modifiers.check), children: (0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorItem), ref: ref, tabIndex: -1, onClick: isDisabled
                        ? undefined
                        : (evt) => {
                            onOptionCheck && onOptionCheck(evt, !isChecked, itemData);
                            setFocusedOption(id);
                        }, children: (0, jsx_runtime_1.jsxs)("span", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorItemMain), children: [children && ((0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorItemToggle), onClick: (e) => {
                                    if (children) {
                                        setIsExpanded(!isExpanded);
                                    }
                                    e.stopPropagation();
                                }, onKeyDown: (e) => {
                                    if (e.key === ' ' || e.key === 'Enter') {
                                        document.activeElement.click();
                                        e.preventDefault();
                                    }
                                }, tabIndex: -1, children: (0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorItemToggleIcon), children: (0, jsx_runtime_1.jsx)(angle_right_icon_1.default, {}) }) })), (0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorItemCheck), children: (0, jsx_runtime_1.jsx)("input", Object.assign({ type: "checkbox", onChange: (evt) => {
                                        onOptionCheck && onOptionCheck(evt, !isChecked, itemData);
                                        setFocusedOption(id);
                                    }, onClick: (evt) => evt.stopPropagation(), onKeyDown: (e) => {
                                        if (e.key === ' ' || e.key === 'Enter') {
                                            onOptionCheck && onOptionCheck(e, !isChecked, itemData);
                                            setFocusedOption(id);
                                            e.preventDefault();
                                        }
                                    }, ref: (elem) => {
                                        elem && (elem.indeterminate = isChecked === null);
                                    }, checked: isChecked || false, tabIndex: -1 }, checkProps)) }), (0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorItemText), children: text }), hasBadge && children && ((0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorItemCount), children: (0, jsx_runtime_1.jsx)(Badge_1.Badge, Object.assign({}, badgeProps, { children: (0, treeUtils_1.flattenTree)(children.props.data).length })) }))] }) }) }), (isExpanded || hasAnimations) && clonedChildren] })));
};
exports.DualListSelectorTreeItem = (0, react_1.memo)(DualListSelectorTreeItemBase, (prevProps, nextProps) => {
    if (!nextProps.useMemo) {
        return false;
    }
    if (prevProps.className !== nextProps.className ||
        prevProps.text !== nextProps.text ||
        prevProps.id !== nextProps.id ||
        prevProps.defaultExpanded !== nextProps.defaultExpanded ||
        prevProps.checkProps !== nextProps.checkProps ||
        prevProps.hasBadge !== nextProps.hasBadge ||
        prevProps.badgeProps !== nextProps.badgeProps ||
        prevProps.isChecked !== nextProps.isChecked ||
        prevProps.itemData !== nextProps.itemData) {
        return false;
    }
    return true;
});
exports.DualListSelectorTreeItem.displayName = 'DualListSelectorTreeItem';
//# sourceMappingURL=DualListSelectorTreeItem.js.map