// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file extra_unionsCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__EXTRA_UNIONSCDRAUX_IPP
#define FAST_DDS_GENERATED__EXTRA_UNIONSCDRAUX_IPP

#include "extra_unionsCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const UnionScopedDiscriminator& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case MyModule::ScopedEnumHelper::ENUM_VALUE_1:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.first(), current_alignment);
                    break;

                case MyModule::ScopedEnumHelper::ENUM_VALUE_2:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.second(), current_alignment);
                    break;

                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                                data.third(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const UnionScopedDiscriminator& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case MyModule::ScopedEnumHelper::ENUM_VALUE_1:
                    scdr << eprosima::fastcdr::MemberId(1) << data.first();
                    break;

                case MyModule::ScopedEnumHelper::ENUM_VALUE_2:
                    scdr << eprosima::fastcdr::MemberId(2) << data.second();
                    break;

                default:
                    scdr << eprosima::fastcdr::MemberId(3) << data.third();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        UnionScopedDiscriminator& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    MyModule::ScopedEnumHelper discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case MyModule::ScopedEnumHelper::ENUM_VALUE_1:
                                                    {
                                                        int32_t first_value{0};
                                                        data.first(std::move(first_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case MyModule::ScopedEnumHelper::ENUM_VALUE_2:
                                                    {
                                                        int64_t second_value{0};
                                                        data.second(std::move(second_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                default:
                                                    {
                                                        uint8_t third_value{0};
                                                        data.third(std::move(third_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case MyModule::ScopedEnumHelper::ENUM_VALUE_1:
                                                    dcdr >> data.first();
                                                    break;

                                                case MyModule::ScopedEnumHelper::ENUM_VALUE_2:
                                                    dcdr >> data.second();
                                                    break;

                                                default:
                                                    dcdr >> data.third();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__EXTRA_UNIONSCDRAUX_IPP

