/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class NavigationTag
extends TagSupport {
    private String template;

    public void setTemplate(String template) {
        this.template = template;
    }

    public int doStartTag() throws JspException {
        RunData data = (RunData)this.pageContext.getAttribute("rundata", 2);
        data.getTemplateInfo().setNavigationTemplate(this.template);
        String module = null;
        try {
            this.pageContext.getOut().flush();
            module = ((TemplateService)TurbineServices.getInstance().getService("TemplateService")).getNavigationName(this.template);
            NavigationLoader.getInstance().exec(data, module);
        }
        catch (Exception e) {
            String message = "Error processing navigation template:" + this.template + " using module: " + module;
            Log.error(message, e);
            try {
                data.getOut().print("Error processing navigation template: " + this.template + " using module: " + module);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }
}

