---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              TeX, fichier de format, problème d'installation des formats, 
              mise à jour de LaTeX
---

# Que signifie l'erreur : "Fatal format file error; I'm stymied" ?

- **Message** : `Fatal format file error; I'm stymied`
- **Origine** : TeX

TeX et LaTeX affichent souvent cette erreur lorsque vous jouez 
avec la configuration ou que vous venez d'installer une nouvelle version.

Le *fichier de* [format](/1_generalites/glossaire/format) contient 
les commandes qui définissent le système que vous souhaitez utiliser : 
du plus simple [Plain TeX](/1_generalites/glossaire/plain_tex)) 
au plus compliqué, comme [LaTeX](/1_generalites/glossaire/latex) 
ou [ConTeXt](/1_generalites/glossaire/context). À partir de la commande 
que vous exécutez (`tex`, `latex`, etc.), TeX sait quel format vous voulez.

Ce message d'erreur ("erreur fatale de fichier de format, je suis bloqué" 
[^footnote-1]) signifie que TeX ne comprend pas le format demandé. Évidemment,
cela se produit si le fichier de format a été corrompu, mais ce n'est 
généralement pas le cas. La cause la plus courante du message est 
qu'un nouvel exécutable de TeX a été installé dans le système. Or les formats
sont lié aux exécutables. Donc, la nouvelle version de TeX que vous venez 
d'installer ne peut pas comprendre pas le format généré par celle 
que vous aviez installée l'année dernière.

Ce problème se résout donc regénérant le format. Bien sûr, cela dépend 
de la distribution que vous utilisez.


## Cas d'une distribution MiKTeX

Il faut aller chercher le programme `MiKTeX Options` puis lancer 
la mise à jour.


## Cas d'une distribution TeX Live

Il faut ici lancer l'une des deux commandes :

```bash
fmtutil --all
```

ou, en indiquant le *nom du format*,

```bash
fmtutil --byfmt nom_format
```


## Cas d'une distribution teTeX

:::{warning}
La distribution [teTeX](ctanpkg:tetex) est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif.
:::

Il faut ici lancer l'une des deux commandes :

```bash
fmtutil --all
```

ou, en indiquant le *nom du format*,

```bash
fmtutil --byfmt=nom_format
```


:::{sources}
[Fatal format file error; I'm stymied](faquk:FAQ-formatstymy)
:::

[^footnote-1]: Il s'agit bien d'un "fichier de format", et non 
d'un "format de fichier".