---
myst:
  html_meta:
    keywords: LaTeX, programmation, valeur d'une variable, commandes, macros, valeur d'une longueur, unité des longueurs, commande \\the
---
# Comment afficher le contenu de variables ?

## Avec des commandes de base

On a souvent besoin d'imprimer les valeurs des variables dans le fichier `.log` ou sur le terminal. Voici trois façons d'accéder au contenu de la variable `\textheight` :

1. `\showthe\textheight`
2. `\message{La hauteur du texte est de \the\textheight}`
3. `\typeout{La hauteur du texte est de \the\textheight}`

Ces techniques utilisent les primitives TeX :

- `\the`, qui renvoie la valeur d'une variable,
- `\showthe`, qui imprime la valeur d'une variable sur le terminal et dans le journal, sur une ligne rien que pour elle,
- et `\message`, qui imprime quelque chose dans le journal.

La commande `\typeout`, quant à elle, est le mécanisme général de sortie des messages de LaTeX.

## Avec l'extension <ctanpkg:printlen>

Dans chaque cas, la valeur de la variable est exprimée en points (sachant qu'il y a 72,27 point de Knuth par pouce, un point vaut donc 0,35146 mm). Pour convertir les grandeurs en unités plus usuelles, on peut utiliser l'extension <ctanpkg:printlen>, beaucoup plus flexible. Par exemple, on peut écrire :

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page
  \usepackage{printlen}

\begin{document}
\newlength{\foo}
\setlength{\foo}{12pt}
\verb+\foo+ vaut \printlength{\foo}.
\end{document}
```

mais on peut préciser que l'on veut des millimètres :

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page
  \usepackage{printlen}

\begin{document}
\newlength{\foo}
\setlength{\foo}{12pt}
\uselengthunit{mm}
\verb|\foo| vaut \printlength{\foo} (soit \the\foo).
\end{document}
```

La commande `\rndprintlength` permet d'arrondir la valeur :

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page
  \usepackage{printlen}

\begin{document}
\newlength{\foo}
\setlength{\foo}{12pt}
\uselengthunit{mm}
\verb|\foo| vaut \rndprintlength{\foo} (valeur arrondie de \printlength{\foo}).
\end{document}
```

:::{sources}
[How to print contents of variables?](faquk:FAQ-printvar)
:::
